<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  if (go_not_null($action)) {
    switch ($action) {
      case 'insert':
      case 'save':
        if (isset($_GET['mID'])) $producers_id = go_db_producing_input($_GET['mID']);
        $producers_name = go_db_producing_input($_POST['producers_name']);
        $sql_data_array = array('producers_name' => $producers_name);
        if ($action == 'insert') {
          $insert_sql_data = array('date_added' => 'now()');
          $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
          go_db_carry(DB_TBL_PRODUCERS, $sql_data_array);
          $producers_id = go_db_insert_id();
        } elseif ($action == 'save') {
          $update_sql_data = array('last_modified' => 'now()');
          $sql_data_array = array_merge($sql_data_array, $update_sql_data);
          go_db_carry(DB_TBL_PRODUCERS, $sql_data_array, 'update', "producers_id = '" . (int)$producers_id . "'");
        }
        if ($producers_picture = new upload('producers_picture', FOLDER_ABSOLUT_CATALOG_PICTURES)) {
          go_db_query("update " . DB_TBL_PRODUCERS . " set producers_picture = '" . $producers_picture->filename . "' where producers_id = '" . (int)$producers_id . "'");
        }
        $languages = go_get_languages();
        for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
          $producers_url_array = $_POST['producers_url'];
          $language_id = $languages[$i]['id'];
          $sql_data_array = array('producers_url' => go_db_producing_input($producers_url_array[$language_id]));
          $uri = go_get_producer_url($producers_id, $language_id);
          if(!$uri) $action='insert';
          if ($action == 'insert') {
            $insert_sql_data = array('producers_id' => $producers_id,
                                     'languages_id' => $language_id);
            $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
            go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array);
          } elseif ($action == 'save') {
            go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array, 'update', "producers_id = '" . (int)$producers_id . "' and languages_id = '" . (int)$language_id . "'");
          }
        }
        if (USE_CACHE == 'true') {
          go_reset_cache_block('producers');
        }
        
        go_forward(go_href_link(NAME_OF_FILE_PRODUCERS, (isset($_GET['page']) ? 'page=' . $_GET['page'] . '&' : '') . 'mID=' . $producers_id));
        break;
      case 'deleteconfirm':
        $producers_id = go_db_producing_input($_GET['mID']);
        if (isset($_POST['delete_picture']) && ($_POST['delete_picture'] == 'on')) {
          $producer_query = go_db_query("select producers_picture from " . DB_TBL_PRODUCERS . " where producers_id = '" . (int)$producers_id . "'");
          $producer = go_db_fetch_array($producer_query);
          $picture_location = FOLDER_ABSOLUT_DOCUMENT_ROOT . FOLDER_RELATIV_CATALOG_PICTURES . $producer['producers_picture'];
          if (file_exists($picture_location)) @unlink($picture_location);
        }
        go_db_query("delete from " . DB_TBL_PRODUCERS . " where producers_id = '" . (int)$producers_id . "'");
        go_db_query("delete from " . DB_TBL_PRODUCERS_INFO . " where producers_id = '" . (int)$producers_id . "'");
        if (isset($_POST['delete_items']) && ($_POST['delete_items'] == 'on')) {
          $items_query = go_db_query("select items_id from " . DB_TBL_ITEMS . " where producers_id = '" . (int)$producers_id . "'");
          while ($items = go_db_fetch_array($items_query)) {
            go_remove_item($items['items_id']);
          }
        } else {
          go_db_query("update " . DB_TBL_ITEMS . " set producers_id = '' where producers_id = '" . (int)$producers_id . "'");
        }
        if (USE_CACHE == 'true') {
          go_reset_cache_block('producers');
        }
        go_forward(go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page']));
        break;
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF" onload="SetFocus();">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top">
<!-- left_navigation //-->
<!-- left_navigation_eof //-->
</td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_PRODUCERS; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
  $producers_query_raw = "select producers_id, producers_name, producers_picture, date_added, last_modified from " . DB_TBL_PRODUCERS . " order by producers_name";
  $producers_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $producers_query_raw, $producers_query_numrows);
  $producers_query = go_db_query($producers_query_raw);
  while ($producers = go_db_fetch_array($producers_query)) {
    if ((!isset($_GET['mID']) || (isset($_GET['mID']) && ($_GET['mID'] == $producers['producers_id']))) && !isset($mInfo) && (substr($action, 0, 3) != 'new')) {
      $producer_items_query = go_db_query("select count(*) as items_count from " . DB_TBL_ITEMS . " where producers_id = '" . (int)$producers['producers_id'] . "'");
      $producer_items = go_db_fetch_array($producer_items_query);
      $mInfo_array = array_merge($producers, $producer_items);
      $mInfo = new objectInfo($mInfo_array);
    }
    if (isset($mInfo) && is_object($mInfo) && ($producers['producers_id'] == $mInfo->producers_id)) {
      echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $producers['producers_id'] . '&action=change') . '\'">' . "\n";
    } else {
      echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $producers['producers_id']) . '\'">' . "\n";
    }
?>
                <td class="TbInsideData"><?php echo $producers['producers_name']; ?></td>
                <td class="TbInsideData" align="right"><?php if (isset($mInfo) && is_object($mInfo) && ($producers['producers_id'] == $mInfo->producers_id)) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif'); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $producers['producers_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
              <tr>
                <td colspan="2"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td class="smallText" valign="top"><?php echo $producers_split->display_count($producers_query_numrows, MAX_SHOW_SEARCH_RESULTS, $_GET['page'], TEXT_SHOW_NUMBER_OF_PRODUCERS); ?></td>
                    <td class="smallText" align="right"><?php echo $producers_split->display_links($producers_query_numrows, MAX_SHOW_SEARCH_RESULTS, MAX_SHOW_PAGE_LINKS, $_GET['page']); ?></td>
                  </tr>
                </table></td>
              </tr>
<?php
  if (empty($action)) {
?>
              <tr>
                <td align="right" colspan="2" class="smallText"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id . '&action=new') . '">' . go_picture_button('button_insert.gif', PICTURE_INSERT) . '</a>'; ?></td>
              </tr>
<?php
  }
?>
            </table></td>
<?php
  $heading = array();
  $contents = array();
 
  switch ($action) {
    case 'new':
      $heading[] = array('text' => '<b>' . TEXT_ABOVE_NEW_PRODUCER . '</b>');
      $contents = array('form' => go_fetch_form('producers', NAME_OF_FILE_PRODUCERS, 'action=insert', 'post', 'enctype="multipart/form-data"'));
      $contents[] = array('text' => TEXT_NEW_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_NAME . '<br>' . go_fetch_inputfeld('producers_name'));
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_PICTURE . '<br>' . go_fetch_file_field('producers_picture'));
      $producer_inputs_string = '';
      $languages = go_get_languages();
      for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
        $producer_inputs_string .= '<br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('producers_url[' . $languages[$i]['id'] . ']');
      }
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_URL . $producer_inputs_string);
      $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_SAVE) . ' <a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $_GET['mID']) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    case 'change':
      $heading[] = array('text' => '<b>' . TEXT_ABOVE_CHANGE_PRODUCER . '</b>');
      $contents = array('form' => go_fetch_form('producers', NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id . '&action=save', 'post', 'enctype="multipart/form-data"'));
      $contents[] = array('text' => TEXT_CHANGE_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_NAME . '<br>' . go_fetch_inputfeld('producers_name', $mInfo->producers_name));
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_PICTURE . '<br>' . go_fetch_file_field('producers_picture') . '<br>' . $mInfo->producers_picture);
      $producer_inputs_string = '';
      $languages = go_get_languages();
      for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
        $producer_inputs_string .= '<br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('producers_url[' . $languages[$i]['id'] . ']', go_get_producer_url($mInfo->producers_id, $languages[$i]['id']));
      }
      $contents[] = array('text' => '<br>' . TEXT_PRODUCERS_URL . $producer_inputs_string);
      $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_SAVE) . ' <a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    case 'delete':
      $heading[] = array('text' => '<b>' . TEXT_ABOVE_DELETE_PRODUCER . '</b>');
      $contents = array('form' => go_fetch_form('producers', NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id . '&action=deleteconfirm'));
      $contents[] = array('text' => TEXT_DELETE_INTRO);
      $contents[] = array('text' => '<br><b>' . $mInfo->producers_name . '</b>');
      $contents[] = array('text' => '<br>' . go_fetch_checkbox_field('delete_picture', '', true) . ' ' . TEXT_DELETE_PICTURE);
      if ($mInfo->items_count > 0) {
        $contents[] = array('text' => '<br>' . go_fetch_checkbox_field('delete_items') . ' ' . TEXT_DELETE_ITEMS);
        $contents[] = array('text' => '<br>' . sprintf(TEXT_DELETE_WARNING_ITEMS, $mInfo->items_count));
      }
      $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    default:
      if (isset($mInfo) && is_object($mInfo)) {
        $heading[] = array('text' => '<b>' . $mInfo->producers_name . '</b>');
        $contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id . '&action=change') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_PRODUCERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->producers_id . '&action=delete') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a>');
        $contents[] = array('text' => '<br>' . TEXT_DATE_ADDED . ' ' . go_date_short($mInfo->date_added));
        if (go_not_null($mInfo->last_modified)) $contents[] = array('text' => TEXT_LAST_MODIFIED . ' ' . go_date_short($mInfo->last_modified));
        $contents[] = array('text' => '<br>' . go_info_picture($mInfo->producers_picture, $mInfo->producers_name));
        $contents[] = array('text' => '<br>' . TEXT_ITEMS . ' ' . $mInfo->items_count);
      }
      break;
  }
  if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
    echo '            <td width="25%" valign="top"><br>' . "\n";
    $frame = new frame;
    echo $frame->infoBox($heading, $contents);
    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
