<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine gro�e 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
 items_description_in_cat_list 
 ##################################################################################
*/
?>
<?php
require('load_this/load_bigware_11.php');
require('lang_this/en/main_bigware_115.php');

	Class CsvImport {
		public $basic_pricing = null;
		public $settings = null;
		function CsvImport(){
		}
		function set_settings($settings){
			$this->settings = $settings;
		}
		function cate_detector($current_category_id ){
			global $languages_id;
			$cate_chains = array("name_der_warengruppe","name_der_zweiten_warengruppe","name_der_dritten_warengruppe","name_der_vierten_warengruppe","name_der_fuenften_warengruppe");
			foreach($cate_chains as $v){
				$found = false;
				if (!$cate_name = $GLOBALS[$v]) break;
				   $categories_query = go_db_query("select c.categories_id, cd.categories_name, c.parent_id  from " . DB_TBL_CATEGORIES . " c left join  " . DB_TBL_CATEGORIES_DESCRIPTION . " cd  on c.categories_id=cd.categories_id where cd.language_id = '" .(int) $languages_id . "' and cd.categories_name ='". $cate_name."' and c.parent_id = " . $current_category_id  );
					 while ($categories = go_db_fetch_array($categories_query)){
					 	$current_category_id =$categories[ 'categories_id' ];
					 	$found = true;
					 } 
					 if ($found == false){
					 	 $sql = "insert into " . DB_TBL_CATEGORIES . "  (parent_id, sort_order, date_added) values('".$current_category_id."','1',now() ) ";
					 	 $res1 = go_db_query($sql);
					 	 $sql = $current_category_id . $sql;
						$current_category_id = go_db_insert_id();
						$languages = go_get_languages();
						for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
							$languages_id=$languages[$i]['id'];
							$res1 = go_db_query("insert into ". DB_TBL_CATEGORIES_DESCRIPTION." (categories_id, language_id , categories_name, categories_desc) values ('$current_category_id', '$languages_id', '$cate_name','')");
						}
					 }
			}
			return $current_category_id;
		}
		function item_detector( $item){
			global $languages_id;
			if (!empty($item['items_model']))$mode = "model";
			else $mode = "name";
			$found = false;
			$sql = "select  p.syn, p.items_id, p.items_model,  pd.items_name, pd.items_name2,  p.items_quantity,  p2c.categories_id from " . DB_TBL_ITEMS . " p left join  " . DB_TBL_ITEMS_DESCRIPTION . " pd on p.items_id=pd.items_id   left join  " . DB_TBL_ITEMS_TO_CATEGORIES . " p2c  on p.items_id=p2c.items_id ";
			if ($mode == "name"){
		         		$sql .= "where pd.language_id = '" . (int)$languages_id . "' and p2c.categories_id = '".$item['items_category_id']."' and pd.items_name ='" .$item['items_name']  . "'"; //go_db_input($target)
	    		}else if($mode =="model"){
		         		$sql .= "where  p.items_model ='" .$item['items_model']  . "'"; 
	    		}
	    		$items = array();
	    		$items_query = go_db_query($sql);
	    		while ($items_queryed = go_db_fetch_array($items_query)) {
			 	$items = $items_queryed;
			 	$produktnummer =$items[ 'items_model' ];
			 	$found = true;
			}
			if ($found == false){
				$items = array(  
				  "items_model"=>time().rand(1,999)
				);
			}
			return $items;
		}
		function go_get_category_tree(){
			$cat = $this->get_category_tree();
			$cat[0]['text']='/';
			return array_values($cat);
		}
		function get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
		    global $languages_id;
		    if (!is_array($category_tree_array)) $category_tree_array = array();
		    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => '');
		    $categories_query = go_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . DB_TBL_CATEGORIES . " c, " . DB_TBL_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
		    while ($categories = go_db_fetch_array($categories_query)) {
		    	$spacing = $category_tree_array[$categories['parent_id']]['text'] . '/';
		      if ($exclude != $categories['categories_id']) $category_tree_array[$categories['categories_id']] = array('id' => $categories['categories_id'], 'parent_id'=>$categories['parent_id'], 'text' => $spacing.$categories['categories_name']);
		      $category_tree_array = $this->get_category_tree($categories['categories_id'], $spacing , $exclude, $category_tree_array);
		    }
		    return $category_tree_array;
		 }
		function field_options($name, $value=null, $required = false){
			$r = $required? 'class="required field_option"':'class="field_option"';
			$opts ='<select name="'.$name.'" style="color: #000000" '.$r.' >';
			if (empty($value)){
				$opts .= '<option value="">'.TEXT_PLEASE_SELECT.'</option>';
			}
			if (!$required) {
				$s1 = ($value == 'keine')? "selected":"";
				$opts .= '<option value="keine" '.$s1.'>'.TEXT_NO_FIELD.'</option>' ;
			}
			for ($i=1; $i<80; $i++) {
				$selected = ($this->settings && is_numeric($value) && $value == $i-1)? "selected":""; 
				$opts .= sprintf('<option value="%s" %s>%s</option>', $i-1, $selected, $i);
			}
			return $opts."</select>";
		}
		function view_row_output($tr1,$tr2=null){
			if (empty($tr2)){
				$result = "";
				foreach ($tr1 as $v){
					$result .= $this->view_row_output($v[0],$v[1]);
				}
			}else{
				$result = $this->view_setting_row($tr1).$this->view_content_row($tr2);
			}
			return $result;	
		}
		function view_row_basic_pricing(){
		}
		function view_setting_row($tr1){
			$tds = $tr1[1];
			$row = '<tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">';
			$row .= sprintf('<td class="TbInsideData">%s</td>', $tds[0]);
			
    			if (is_array($tds[1])) {
				$attrs = "";
				$attr = array_merge(array("class"=>"TbInsideData","width"=>"30%"), (array)$tds[1][0]);
				foreach($attr as $k=>$v){
					$attrs .= sprintf(' "%s"="%s" ',$k,$v);
				}
				$row .= sprintf('<td %s>%s</td>', $attrs, $tds[1][1]);
			}else{
				$row .= sprintf('<td class="TbInsideData">%s</td>', $tds[1]);
			}
			if ($tds[2]) $row .= 	'<td class="TbInsideData">'.$tds[2].'</td>';			
			$td3 = ($tds[3])?  '<a href="#toggle1" class="toggle">'.go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'). '</a>':'&nbsp;';
			$row .= '<td class="TbInsideData">'.$td3.'</td>';
			$row .= '</tr>';
			return $row;
		}
		function view_content_row($tr2){
			return sprintf(' <tr id="%s" style="display:none;"><td class="infoFrameInside" colspan="4">%s<p align="right"><a href="#toggle2" class="toggle">%s</a></p></td></tr>', $tr2[0],$tr2[1],TEXT_CLOSE);
		}
		function model_create_template($sql_data){
			go_db_carry("uni_import_vorlagen",$sql_data);
			//go_db_query( "insert into uni_import_vorlagen ( ".$fields." ) values ( ".$values." )");
		}
		function model_update_item($csv,$sql_data_array,$sql_data_array2, $items_id){
			if (go_db_carry(DB_TBL_ITEMS,$sql_data_array,'update',"items_id = '".(int)$items_id."'")){
				return go_db_carry(DB_TBL_ITEMS_DESCRIPTION,$sql_data_array2,'update'," items_id=".(int)$items_id);
			}else{
				return false;
			}
		}
		function model_insert_item($csv,$sql_data_array){
			go_db_carry(DB_TBL_ITEMS,$sql_data_array);
			return go_db_insert_id();     

		}
	}
	if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/basic_pricing')) {
		require(FOLDER_ABSOLUT_CATALOG . 'modules/basic_pricing/configmain/main_bigware_115.php');
		$CSV = new CsvImport_Basic_Pricing();
	}else{   
		$CSV = new CsvImport();
	}

$benutzer = DB_SERVER_USERNAME; 
$passwort = DB_SERVER_PASSWORD; 
$dbname = DB_DATABASE; 
$host = DB_SERVER;  
$link = go_db_connect($host, $benutzer, $passwort);
go_db_select_db($dbname, $link);

$uni_id = "1";	
$copybild_temp='no';
$copybild2_temp='no';
/* edit Richy Bilder 3 - 5 */
$copybild3_temp='no';
$copybild4_temp='no';
$copybild5_temp='no';
if ($vorlage == "ON" AND !empty($vorlagennamen)) { 
	$fields = array('ampel','aufschlag','seperierung','bezeichnung','bezeichnung_zwei','anzahl','anzahl_default','items_model','items_model_zufall','buld_url','buld_url_default','buld_url_zweites','buld_url_default_zweites','buld_url_drittes','buld_url_default_drittes','buld_url_viertes','buld_url_default_viertes','buld_url_fuenftes','buld_url_default_fuenftes','preis','uvp','gewicht','gewicht_default','unterkat','unterkat_default','unterkat_zweiten','unterkat_default_zweiten','unterkat_dritten','unterkat_default_dritten','unterkat_vierten','unterkat_default_vierten','unterkat_fuenften','unterkat_default_fuenften','beschreibung','beschreibung_incat','filter1','filter2','lieferbarkeit','lieferbarkeit_default','verfuegbar_wert','oberkat','csv_datei','vorlagenname','pfad_zum_bild','pfad_zum_bild_zweites','pfad_zum_bild_drittes','pfad_zum_bild_viertes','pfad_zum_bild_fuenftes','hochkomma','brutto','bezeichnung1','inhalt1','bezeichnung2','inhalt2','bezeichnung3','inhalt3','bezeichnung4','inhalt4','bezeichnung5','inhalt5','bezeichnung6','inhalt6','hersteller','uni_id','copybild','copybild2','copybild3','copybild4','copybild5','ean','mpn');
	$values =array( $ampel,$preisaufschlag,$separator,$produktnamezahl,$produktnamezahl_zwei,$artikelanzahlzahl,$artikelanzahl2,$produktnummerzahl,$C1,$ganzebildurlzahl,$C2,$ganzebildurlzahl_zweites,$C2_zweites,$ganzebildurlzahl_drittes,$C2_drittes,$ganzebildurlzahl_viertes,$C2_viertes,$ganzebildurlzahl_fuenftes,$C2_fuenftes,$preiszahl,$uvpzahl,$gewichtzahl,$gewicht2,$name_der_warengruppezahl,$name_der_warengruppe2,$name_der_zweiten_warengruppezahl,$name_der_zweiten_warengruppe2,$name_der_dritten_warengruppezahl,$name_der_dritten_warengruppe2,$name_der_vierten_warengruppezahl,$name_der_vierten_warengruppe2,$name_der_fuenften_warengruppezahl,$name_der_fuenften_warengruppe2,$contentunteresframezahl,$contentincatzahl,$htmlbefrei,$urlcodebefrei,$statuslieferbarkeitzahl,$statuslieferbarkeit2,$verfuegbarwert,$namekat,$userfile,$vorlagennamen,$pfad_zum_bild,$pfad_zum_bild_zweites,$pfad_zum_bild_drittes,$pfad_zum_bild_viertes,$pfad_zum_bild_fuenftes,$hochkomma,$brutto,$bezeichnung1,$inhalt1zahl,$bezeichnung2,$inhalt2zahl,$bezeichnung3,$inhalt3zahl,$bezeichnung4,$inhalt4zahl,$bezeichnung5,$inhalt5zahl,$bezeichnung6,$inhalt6zahl,$herstellerzahl,$uni_id,$copybild,$copybild2,$copybild3,$copybild4,$copybild5,$eanzahl,$mpnzahl);
	$CSV->model_create_template(array_combine( $fields,$values) );
	//go_db_query("INSERT INTO uni_import_vorlagen (ampel, aufschlag, seperierung, bezeichnung, bezeichnung_zwei, anzahl, anzahl_default, items_model, items_model_zufall, buld_url, buld_url_default, buld_url_zweites, buld_url_default_zweites, buld_url_drittes, buld_url_default_drittes, buld_url_viertes, buld_url_default_viertes, buld_url_fuenftes, buld_url_default_fuenftes, preis, uvp, gewicht, gewicht_default, unterkat, unterkat_default, unterkat_zweiten, unterkat_default_zweiten, unterkat_dritten, unterkat_default_dritten, unterkat_vierten, unterkat_default_vierten, unterkat_fuenften, unterkat_default_fuenften, beschreibung, beschreibung_incat, filter1, filter2, lieferbarkeit, lieferbarkeit_default, verfuegbar_wert, oberkat, csv_datei, vorlagenname, pfad_zum_bild, pfad_zum_bild_zweites, pfad_zum_bild_drittes, pfad_zum_bild_viertes, pfad_zum_bild_fuenftes, hochkomma, brutto, bezeichnung1, inhalt1, bezeichnung2, inhalt2, bezeichnung3, inhalt3, bezeichnung4, inhalt4, bezeichnung5, inhalt5, bezeichnung6, inhalt6, hersteller, uni_id, copybild, copybild2, copybild3, copybild4, copybild5, ean, mpn) VALUES ('$ampel', '$D1', '$separator', '$produktnamezahl', '$produktnamezahl_zwei', '$artikelanzahlzahl', '$artikelanzahl2', '$produktnummerzahl', '$C1', '$ganzebildurlzahl', '$C2', '$ganzebildurlzahl_zweites', '$C2_zweites', '$ganzebildurlzahl_drittes', '$C2_drittes', '$ganzebildurlzahl_viertes', '$C2_viertes', '$ganzebildurlzahl_fuenftes', '$C2_fuenftes', '$preiszahl', '$uvpzahl', '$gewichtzahl', '$gewicht2', '$name_der_warengruppezahl', '$name_der_warengruppe2', '$name_der_zweiten_warengruppezahl', '$name_der_zweiten_warengruppe2', '$name_der_dritten_warengruppezahl', '$name_der_dritten_warengruppe2', '$name_der_vierten_warengruppezahl', '$name_der_vierten_warengruppe2', '$name_der_fuenften_warengruppezahl', '$name_der_fuenften_warengruppe2', '$contentunteresframezahl', '$contentincatzahl', '$htmlbefrei', '$urlcodebefrei', '$statuslieferbarkeitzahl', '$statuslieferbarkeit2', '$verfuegbarwert', '$namekat', '$userfile', '$vorlagennamen', '$pfad_zum_bild', '$pfad_zum_bild_zweites', '$pfad_zum_bild_drittes', '$pfad_zum_bild_viertes', '$pfad_zum_bild_fuenftes', '$hochkomma', '$brutto', '$bezeichnung1', '$inhalt1zahl', '$bezeichnung2', '$inhalt2zahl', '$bezeichnung3', '$inhalt3zahl', '$bezeichnung4', '$inhalt4zahl', '$bezeichnung5', '$inhalt5zahl', '$bezeichnung6', '$inhalt6zahl', '$herstellerzahl', '$uni_id', '$copybild', '$copybild2', '$copybild3', '$copybild4', '$copybild5', '$eanzahl', '$mpnzahl')") or die("dberror" . go_db_error());
}
/* edit ende Richy */
if (!empty($vorlagenloeschen)) {
	$vorlagenloeschen_result = go_db_query("delete from uni_import_vorlagen where vorlagen_id ='$vorlagenloeschen' AND uni_id='$uni_id'");
}

if (!empty($vorlagenauswahl) AND $vorlagenauswahl != "nein") {
	$id = go_db_query("SELECT * FROM uni_import_vorlagen where vorlagen_id ='$vorlagenauswahl' AND uni_id='$uni_id'");
	$werte = go_db_fetch_array($id);
	$CSV->set_settings($werte);
	$ampel_temp = $werte["ampel"]; 
	$aufschlag_temp = $werte["aufschlag"]; 
	$seperierung_temp = htmlentities($werte["seperierung"]); 
	$bezeichnung_temp = $werte["bezeichnung"]; 
	$bezeichnung_temp_zwei = $werte["bezeichnung_zwei"]; 
	$anzahl_temp = $werte["anzahl"]; 
	$anzahl_default_temp = $werte["anzahl_default"]; 
	$items_model_temp = $werte["items_model"]; 
	$items_model_zufall_temp = $werte["items_model_zufall"]; 
	$buld_url_temp = $werte["buld_url"]; 
	$buld_url_default_temp = $werte["buld_url_default"]; 
	$buld_url_temp_zweites = $werte["buld_url_zweites"]; 
	$buld_url_default_temp_zweites = $werte["buld_url_default_zweites"];
/* edit Richy Bilder 3 - 5 */
	$buld_url_temp_drittes = $werte["buld_url_drittes"]; 
	$buld_url_default_temp_drittes = $werte["buld_url_default_drittes"]; 
	$buld_url_temp_viertes = $werte["buld_url_viertes"]; 
	$buld_url_default_temp_viertes = $werte["buld_url_default_viertes"]; 
	$buld_url_temp_fuenftes = $werte["buld_url_fuenftes"]; 
	$buld_url_default_temp_fuenftes = $werte["buld_url_default_fuenftes"]; 
/* edit ende Richy */ 		
	$preis_temp = $werte["preis"]; 
	$uvp_temp = $werte["uvp"];
	$gewicht_temp = $werte["gewicht"]; 
	$gewicht_default_temp = $werte["gewicht_default"]; 
	$unterkat_temp = $werte["unterkat"]; 
	$unterkat_temp_zweiten = $werte["unterkat_zweiten"]; 
	$unterkat_temp_dritten = $werte["unterkat_dritten"]; 
	$unterkat_temp_vierten = $werte["unterkat_vierten"]; 
	$unterkat_temp_fuenften = $werte["unterkat_fuenften"]; 
	$unterkat_default_temp = $werte["unterkat_default"]; 
	$unterkat_zweiten_default_temp = $werte["unterkat_default_zweiten"]; 
	$unterkat_dritten_default_temp = $werte["unterkat_default_dritten"]; 
	$unterkat_vierten_default_temp = $werte["unterkat_default_vierten"]; 
	$unterkat_fuenften_default_temp = $werte["unterkat_default_fuenften"]; 
	$beschreibung_temp = $werte["beschreibung"]; 
	$beschreibung_incat_temp = $werte["beschreibung_incat"];
	$filter1_temp = $werte["filter1"]; 
	$filter2_temp = $werte["filter2"]; 
	$lieferbarkeit_temp = $werte["lieferbarkeit"]; 
	$lieferbarkeit_default_temp = $werte["lieferbarkeit_default"]; 
	$verfuegbar_wert_temp = $werte["verfuegbar_wert"]; 
	$oberkat_temp = $werte["oberkat"]; 
	$csv_datei_temp = $werte["csv_datei"];
	$pfad_zum_bild_temp = $werte["pfad_zum_bild"];
	$copybild_temp = $werte["copybild"];
	$copybild2_temp = $werte["copybild2"];
	$pfad_zum_bild_temp_zweites = $werte["pfad_zum_bild_zweites"];
/* edit Richy Bilder 3 - 5 */
	$copybild3_temp = $werte["copybild3"];
	$pfad_zum_bild_temp_drittes = $werte["pfad_zum_bild_drittes"];
	$copybild4_temp = $werte["copybild4"];
	$pfad_zum_bild_temp_viertes = $werte["pfad_zum_bild_viertes"];
	$copybild5_temp = $werte["copybild5"];
	$pfad_zum_bild_temp_fuenftes = $werte["pfad_zum_bild_fuenftes"];
/* edit ende Richy */
	$hochkomma_temp = $werte["hochkomma"];
	$brutto_temp = $werte["brutto"];
	$bezeichnung1_temp = $werte["bezeichnung1"];
	$inhalt1_temp = $werte["inhalt1"];
	$bezeichnung2_temp = $werte["bezeichnung2"];
	$inhalt2_temp = $werte["inhalt2"];
	$bezeichnung3_temp = $werte["bezeichnung3"];
	$inhalt3_temp = $werte["inhalt3"];
	$bezeichnung4_temp = $werte["bezeichnung4"];
	$inhalt4_temp = $werte["inhalt4"];
	$bezeichnung5_temp = $werte["bezeichnung5"];
	$inhalt5_temp = $werte["inhalt5"];
	$bezeichnung6_temp = $werte["bezeichnung6"];
	$inhalt6_temp = $werte["inhalt6"];
	$hersteller_temp = $werte["hersteller"];
	$geladen = "ja";
	$ean_temp = $werte["ean"]; 
	$mpn_temp = $werte["mpn"];
}

$script_filename = getenv('PATH_TRANSLATED');
if (empty($script_filename)) {
	$script_filename = getenv('SCRIPT_FILENAME');
}

$script_filename = str_replace('\\', '/', $script_filename);
$script_filename = str_replace('//', '/', $script_filename);
$dir_fs_www_root_array = explode('/', dirname($script_filename));
$dir_fs_www_root = array();

for ($i=0, $n=sizeof($dir_fs_www_root_array)-1; $i<$n; $i++) {
	$dir_fs_www_root[] = $dir_fs_www_root_array[$i];
}
$dir_fs_www_root = implode('/', $dir_fs_www_root) . '/';
if($abgehts == "JA" && $_FILES['userfile']['name']) {   

	$uploaddir = "../picture/";
	$uploadfile = $uploaddir. $_FILES['userfile']['name'];
/*
	if (move_uploaded_file($_FILES['userfile']['tmp_name'], $uploadfile)) {
		chmod ($uploaddir. $_FILES['userfile']['name'], 0777);   
	} else {
		print "Possible file upload attack! Here's some debugging info:\n";
		print_r($_FILES);
		die();
	}
*/	
	if (! is_uploaded_file($_FILES['userfile']['tmp_name'])) {
		print "Possible file upload attack! Here's some debugging info:\n";
		print_r($_FILES);
		die();
	}	
	$row = 1; 
	ini_set('auto_detect_line_endings', true);
	//$handle = fopen ($uploaddir. $_FILES['userfile']['name'],"r"); 
	$handle = fopen ($_FILES['userfile']['tmp_name'],"r"); 
	$db_warengruppenpfad = "alle";	
	$db_bilderpfad = "alle";
	$Verzeichnis="$dir_fs_www_root/picture/alle";	

	while ($data = fgetcsv ($handle, 12000, $separator)) {  
		$num = count ($data);   
		/*
	        for($i = 0; $i < $num; ++$i) {
	            $data[$i] = go_db_real_escape_string($data[$i]);
	        }
	        */
		$row++;   
		if ($row == 2 ) continue;     

		$produktname= $data[$produktnamezahl];
		if ($produktnamezahl_zwei == "keine"){
			$produktname_zwei = "";
		}
		else{
			$produktname_zwei= $data[$produktnamezahl_zwei];
		}
		$preis= $data[$preiszahl];
		$preis = preg_replace("/,/",".", $preis);
		if($urlzahl=="keine")	$uvp = "";
		else {
			$uvp = $data[$uvpzahl];
			$uvp = preg_replace("/,/",".", $uvp);
		}
		$contentunteresframe = $data[$contentunteresframezahl];
		//$contentunteresframe = preg_replace("/'/","", $contentunteresframe);
		$contentunteresframe = preg_replace("/\"\"/","\"", $contentunteresframe);
		
		if ($contentincatzahl == "keine"){
			$contentincat = "";
		}
		else{
			$contentincat= $data[$contentincatzahl];
    }


		if ($artikelanzahlzahl == "keine"){
			$artikelanzahl = $artikelanzahl2;
		}
		else{
			$artikelanzahl= $data[$artikelanzahlzahl];
		}

		if ($ganzebildurlzahl != "keine" && !empty($data[$ganzebildurlzahl])) {
			if ($copybild == 'url' && preg_match('#^http#i', $data[$ganzebildurlzahl])) {
				$ganzebildurl = $data[$ganzebildurlzahl];
			} else {
				$ganzebildurl = $pfad_zum_bild.$data[$ganzebildurlzahl]; 
				$bildname = substr (strrchr ($ganzebildurl, "/"), 1);
				if ($copybild=='yes') {
					$copyto = "../".FOLDER_RELATIV_PICTURES.$db_bilderpfad."/".$bildname;
					if (!file_exists($copyto)){
						if (!copy($data[$ganzebildurlzahl], $copyto)) {
							echo "failed to copy $file...\n";
						}
					}
				}
			}
		} else {
			$ganzebildurl = "";
		}

		if ($ganzebildurlzahl_zweites != "keine" && !empty($data[$ganzebildurlzahl_zweites])){
			if ($copybild2 == 'url' && preg_match('#^http#i', $data[$ganzebildurlzahl_zweites])) {
				$ganzebildurl_zweites = $data[$ganzebildurlzahl_zweites];
			} else {
				$ganzebildurl_zweites= $pfad_zum_bild.$data[$ganzebildurlzahl_zweites]; 
				$bildname_zweites = substr (strrchr ($ganzebildurl_zweites, "/"), 1);
				if ($copybild2=='yes') {
					$copyto = "../".FOLDER_RELATIV_PICTURES.$db_bilderpfad."/".$bildname_zweites;
					if (!file_exists($copyto)){
						if (!copy($data[$ganzebildurlzahl_zweites], $copyto)) {
							echo "failed to copy $file...\n";
						}
					}
				}
			}
		} else {
			$ganzebildurl_zweites = "";
		}
/* edit Richy Bilder 3 - 5 */
		if ($ganzebildurlzahl_drittes != "keine" && !empty($data[$ganzebildurlzahl_drittes])){
			if ($copybild3 == 'url' && preg_match('#^http#i', $data[$ganzebildurlzahl_drittes])) {
				$ganzebildurl_drittes = $data[$ganzebildurlzahl_drittes];
			} else {
				$ganzebildurl_drittes= $pfad_zum_bild.$data[$ganzebildurlzahl_drittes]; 
				$bildname_drittes = substr (strrchr ($ganzebildurl_drittes, "/"), 1);
				if ($copybild3=='yes') {
					$copyto = "../".FOLDER_RELATIV_PICTURES.$db_bilderpfad."/".$bildname_drittes;
					if (!file_exists($copyto)){
						if (!copy($data[$ganzebildurlzahl_drittes], $copyto)) {
							echo "failed to copy $file...\n";
						}
					}
				}
			}
		} else {
			$ganzebildurl_drittes = "";
		}

		if ($ganzebildurlzahl_viertes != "keine" && !empty($data[$ganzebildurlzahl_viertes])){
			if ($copybild4 == 'url' && preg_match('#^http#i', $data[$ganzebildurlzahl_viertes])) {
				$ganzebildurl_viertes = $data[$ganzebildurlzahl_viertes];
			} else {
				$ganzebildurl_viertes= $pfad_zum_bild.$data[$ganzebildurlzahl_viertes]; 
				$bildname_viertes = substr (strrchr ($ganzebildurl_viertes, "/"), 1);
				if ($copybild4=='yes') {
					$copyto = "../".FOLDER_RELATIV_PICTURES.$db_bilderpfad."/".$bildname_viertes;
					if (!file_exists($copyto)){
						if (!copy($data[$ganzebildurlzahl_viertes], $copyto)) {
							echo "failed to copy $file...\n";
						}
					}
				}
			}
		} else {
			$ganzebildurl_viertes = "";
		}

		if ($ganzebildurlzahl_fuenftes != "keine" && !empty($data[$ganzebildurlzahl_fuenftes])){
			if ($copybild5 == 'url' && preg_match('#^http#i', $data[$ganzebildurlzahl_fuenftes])) {
				$ganzebildurl_fuenftes = $data[$ganzebildurlzahl_fuenftes];
			} else {
				$ganzebildurl_fuenftes= $pfad_zum_bild.$data[$ganzebildurlzahl_fuenftes]; 
				$bildname_fuenftes = substr (strrchr ($ganzebildurl_fuenftes, "/"), 1);
				if ($copybild5=='yes') {
					$copyto = "../".FOLDER_RELATIV_PICTURES.$db_bilderpfad."/".$bildname_fuenftes;
					if (!file_exists($copyto)){
						if (!copy($data[$ganzebildurlzahl_fuenftes], $copyto)) {
							echo "failed to copy $file...\n";
						}
					}
				}
			}
		} else {
			$ganzebildurl_fuenftes = "";
		}
/* edit ende Richy */

		if ($gewichtzahl == "keine"){
			$gewicht = $gewicht2;
		}
		else{
			$gewicht= $data[$gewichtzahl];
		}
		$gewicht = preg_replace("/,/",".", $gewicht); 
		if ($name_der_warengruppezahl == "keine"){
			$name_der_warengruppe = $name_der_warengruppe2;
		}
		else{
			$name_der_warengruppe= $data[$name_der_warengruppezahl];
			if (empty($name_der_warengruppe)){
				$name_der_warengruppe = $name_der_warengruppe2;
			}
		} 
		if ($name_der_zweiten_warengruppezahl == "keine"){
			$name_der_zweiten_warengruppe = $name_der_zweiten_warengruppe2;
		}
		else{
			$name_der_zweiten_warengruppe= $data[$name_der_zweiten_warengruppezahl];
			if (empty($name_der_zweiten_warengruppe)){
				$name_der_zweiten_warengruppe = $name_der_zweiten_warengruppe2;
			}
		} 
		if ($name_der_dritten_warengruppezahl == "keine"){
			$name_der_dritten_warengruppe = $name_der_dritten_warengruppe2;
		}
		else{
			$name_der_dritten_warengruppe= $data[$name_der_dritten_warengruppezahl];
			if (empty($name_der_dritten_warengruppe)){
				$name_der_dritten_warengruppe = $name_der_dritten_warengruppe2;
			}
		} 
		if ($name_der_vierten_warengruppezahl == "keine"){
			$name_der_vierten_warengruppe = $name_der_vierten_warengruppe2;
		}
		else{
			$name_der_vierten_warengruppe= $data[$name_der_vierten_warengruppezahl];
			if (empty($name_der_vierten_warengruppe)){
				$name_der_vierten_warengruppe = $name_der_vierten_warengruppe2;
			}
		} 
		if ($name_der_fuenften_warengruppezahl == "keine"){
			$name_der_fuenften_warengruppe = $name_der_fuenften_warengruppe2;
		}
		else{
			$name_der_fuenften_warengruppe= $data[$name_der_fuenften_warengruppezahl];
			if (empty($name_der_fuenften_warengruppe)){
				$name_der_fuenften_warengruppe = $name_der_fuenften_warengruppe2;
			}
		}

		if ($herstellerzahl == "keine"){
			$hersteller = "";
		}
		else{
			$hersteller= $data[$herstellerzahl];
		} 

		if ($inhalt1zahl == "keine"){
			$inhalt1zahl = "";
			$bezeichnung1 = "";
		}
		else{
			$inhalt1 = $data[$inhalt1zahl];
		}

		if ($inhalt2zahl == "keine"){
			$inhalt2zahl = "";
			$bezeichnung2 = "";
		}
		else{
			$inhalt2 = $data[$inhalt2zahl];
		}

		if ($inhalt3zahl == "keine"){
			$inhalt3zahl = "";
			$bezeichnung3 = "";
		}
		else{
			$inhalt3 = $data[$inhalt3zahl];
		}

		if ($inhalt4zahl == "keine"){
			$inhalt4zahl = "";
			$bezeichnung4 = "";
		}
		else{
			$inhalt4 = $data[$inhalt4zahl];
		}

		if ($inhalt5zahl == "keine"){
			$inhalt5zahl = "";
			$bezeichnung5 = "";
		}
		else{
			$inhalt5 = $data[$inhalt5zahl];
		}

		if ($inhalt6zahl == "keine"){
			$inhalt6zahl = "";
			$bezeichnung6 = "";
		}
		else{
			$inhalt6 = $data[$inhalt6zahl];
		}		
		if ($eanzahl == "keine") {
			$ean = $ean;
		}
		else{
			$ean = $data[$eanzahl];
		}
		if ($mpnzahl == "keine"){
			$mpn = $mpn;
		}
		else{
			$mpn = $data[$mpnzahl];
		}

		if ($statuslieferbarkeitzahl == "keine" AND $ampel == TEXT_SMALL_NO){

			if ($statuslieferbarkeit2==TEXT_GREAT_YES){
				$tmpMorgen = mktime(0, 0, 0, date("m"), date("d")-1, date("Y"));
				$statuslieferbarkeit = "1";	
			}
			else{
				$tmpMorgen = mktime(0, 0, 0, date("m"), date("d")+28, date("Y"));
				$statuslieferbarkeit = "0";				
			}
		}
		else{
			$statuslieferbarkeit= $data[$statuslieferbarkeitzahl];
		}
		if ($htmlbefrei == "yes"){
			$contentunteresframe = strip_tags($contentunteresframe);
		}

        //if ($htmlbefrei == TEXT_SMALL_YES){
		//	$contentincat = strip_tags($contentincat);
		//}
###############################################################
		$categorie_for_items =  $CSV->cate_detector( (int)$namekat );
		if ($produktnummerzahl == "keine"){
			$item_found = $CSV->item_detector(array(
				"items_name"=>$produktname,
				"items_category_id"=>$categorie_for_items
			));
			$produktnummer = $item_found['items_model'];
		}else{
			$produktnummer= $data[$produktnummerzahl];
			$produktnummer = preg_replace("/\"/","", $produktnummer);
			$produktnummer = preg_replace("/ /","", $produktnummer);
			$item_found = $CSV->item_detector(array(
				"items_model"=>$produktnummer ,
				"items_category_id"=>$categorie_for_items
			));
		}

			if ($ampel == TEXT_SMALL_YES){

				$tmpMorgen = mktime(0, 0, 0, date("m"), date("d")-1, date("Y"));
				$statuslieferbarkeit = "1";

			}

			elseif ($statuslieferbarkeitzahl != "keine" AND $ampel == TEXT_SMALL_NO){	


				if ($statuslieferbarkeit=="$verfuegbarwert")	{
					$tmpMorgen = mktime(0, 0, 0, date("m"), date("d")-1, date("Y"));
					$statuslieferbarkeit = "1";


				}
				else{

					$tmpMorgen = mktime(0, 0, 0, date("m"), date("d")+28, date("Y"));
					$statuslieferbarkeit = "0";

				}
			}


			$nettopreisplusgewinn = $preis*$preisaufschlag+$preis;
			if ($brutto == "ON"){
				$rates_query_raw = "select r.tax_rates_id, z.geo_zone_id, z.geo_zone_name, tc.tax_class_title, tc.tax_class_id, r.tax_priority, r.tax_rate, r.tax_description, r.date_added, r.last_modified from ((" . DB_TBL_TAX_CLASS . " tc, " . DB_TBL_TAX_RATES . " r) left join " . DB_TBL_GEO_ZONES . " z on r.tax_zone_id = z.geo_zone_id) where r.tax_class_id = $steuersatz";
				$rates_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $rates_query_raw, $rates_query_numrows);
				$rates_query = go_db_query($rates_query_raw);
				while ($rates = go_db_fetch_array($rates_query)) {
					$mwst=$rates['tax_rate'];
				}
				$nettopreisplusgewinn = $nettopreisplusgewinn/(($mwst/100)+1);
			}
			else{						
				$nettopreisplusgewinn=round($nettopreisplusgewinn,2);
			}

			$today = date("Y-m-d G:i:s");						

			if (!empty($item_found['items_id'])) {
				#
				# UPDATE PRODUCT
				#
				//$updatequery="UPDATE items SET items_price='$nettopreisplusgewinn', items_price_uvp='$uvp', items_quantity='$artikelanzahl', items_status='$statuslieferbarkeit', items_tax_class_id='$steuersatz', items_weight='$gewicht', herstellernummer='$mpn', upc_ean_isbn='$ean'";
				$updatequery=array(
					"items_price"=>$nettopreisplusgewinn,
					"items_price_uvp"=>$uvp,
					"items_quantity"=>$artikelanzahl,
					"items_status"=>$statuslieferbarkeit,
					"items_tax_class_id"=>$steuersatz,
					"items_weight"=>$gewicht,
					"herstellernummer"=>$mpn, 
					"upc_ean_isbn"=>$ean
				);
				if (!empty($ganzebildurl)) {
					$items_picture = preg_match('#^http#i', $ganzebildurl) ? $ganzebildurl : "$db_bilderpfad/$bildname";
				} else {
					$items_picture = "$db_bilderpfad/no_picture.gif";
				}
				//$updatequery.= ", items_picture='$items_picture'";
				$updatequery['items_picture'] = $items_picture;
				if (!empty($ganzebildurl_zweites)) {
					$updatequery['items_bpicture'] = preg_match('#^http#i', $ganzebildurl_zweites) ? $ganzebildurl_zweites : "$db_bilderpfad/$bildname_zweites";
					//$updatequery.= ", items_bpicture= '$items_bpicture'";
				}
/* edit Richy Bilder 3 - 5 */
				if (!empty($ganzebildurl_drittes)) {
					$updatequery['items_3picture'] = preg_match('#^http#i', $ganzebildurl_drittes) ? $ganzebildurl_drittes : "$db_bilderpfad/$bildname_drittes";
					//$updatequery.= ", items_3picture= '$items_3picture'";
				}
				if (!empty($ganzebildurl_viertes)) {
					$updatequery['items_4picture'] = preg_match('#^http#i', $ganzebildurl_viertes) ? $ganzebildurl_viertes : "$db_bilderpfad/$bildname_viertes";
					//$updatequery.= ", items_4picture= '$items_4picture'";
				}
				if (!empty($ganzebildurl_fuenftes)) {
					$updatequery['items_5picture'] = preg_match('#^http#i', $ganzebildurl_fuenftes) ? $ganzebildurl_fuenftes : "$db_bilderpfad/$bildname_fuenftes";
					//$updatequery.= ", items_5picture= '$items_5picture'";
				}
/* edit ende Richy */
			//	$updatequery.= " WHERE items_id='".$item_found['itmes_id']."' ";//AND syn='csv_import2'
			//	go_db_query($updatequery);
				$updatequery2 = array(
					'items_name'=>$produktname,
					'items_name2'=>$produktname_zwei,
					'items_description'=>$contentunteresframe,
					'items_description_in_cat_list'=>$contentincat,
					'bezeichnung1'=>$bezeichnung1,
					'inhalt1'=>$inhalt1,
					'bezeichnung2'=>$bezeichnung2,
					'inhalt2'=>$inhalt2,
					'bezeichnung3'=>$bezeichnung3,
					'inhalt3'=>$inhalt3,
					'bezeichnung4'=>$bezeichnung4,
					'inhalt4'=>$inhalt4,
					'bezeichnung5'=>$bezeichnung5,
					'inhalt5'=>$inhalt5,
					'bezeichnung6'=>$bezeichnung6, 
					'inhalt6'=>$inhalt6
				);
				$CSV->model_update_item($data,$updatequery,$updatequery2, $item_found['items_id']);

			} else {
				#
				# NEW PRODUCT
				#
				if (empty($herstellerlink)){
					$herstellerlink = "$wenn_hersteller_leer";	
				}
				$morgen=date('Y-m-d',$tmpMorgen);
				$hersteller = trim($hersteller);
				$action_hersteller = '';
				unset($mID);

				if (!empty($hersteller)) {
					$count_cat_id_query = go_db_query("select count(*) as total from producers where producers_name = '$hersteller'");
					$count_cat_id = go_db_fetch_array($count_cat_id_query);
					if ($count_cat_id['total'] != 0){
						$action_hersteller = "save";
						$count_cat_id_query = go_db_query("select producers_id from producers where producers_name = '$hersteller'");
						$count_cat_id = go_db_fetch_array($count_cat_id_query);    		
						$mID = $count_cat_id['producers_id'];
					} else {
						$action_hersteller = "insert";
					}
				} else {
					$producers_id = 0;
				}

				if (!empty($action_hersteller)) {
					if (isset($mID)) $producers_id = go_db_producing_input($mID);
					$producers_name = go_db_producing_input($hersteller);

					$sql_data_array = array('producers_name' => $producers_name);

					if ($action_hersteller == 'insert') {
						$insert_sql_data = array('date_added' => 'now()');

						$sql_data_array = array_merge($sql_data_array, $insert_sql_data);

						go_db_carry(DB_TBL_PRODUCERS, $sql_data_array);
						$producers_id = go_db_insert_id();
					} elseif ($action_hersteller == 'save') {
						$update_sql_data = array('last_modified' => 'now()');

						$sql_data_array = array_merge($sql_data_array, $update_sql_data);

						go_db_carry(DB_TBL_PRODUCERS, $sql_data_array, 'update', "producers_id = '" . (int)$producers_id . "'");
					}   

					$languages = go_get_languages();
					for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
						$producers_url_array = $_POST['producers_url'];
						$language_id = $languages[$i]['id'];

						$sql_data_array = array('producers_url' => go_db_producing_input($producers_url_array[$language_id]));

						if ($action_hersteller == 'insert') {
							$insert_sql_data = array('producers_id' => $producers_id,
									'languages_id' => $language_id);

							$sql_data_array = array_merge($sql_data_array, $insert_sql_data);

							go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array);
						} elseif ($action_hersteller == 'save') {
							go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array, 'update', "producers_id = '" . (int)$producers_id . "' and languages_id = '" . (int)$language_id . "'");
						}
					}

					if (USE_CACHE == 'true') {
						go_reset_cache_block('producers');
					} 
				}
				if (!empty($ganzebildurl)) {
					$items_picture = preg_match('#^http#i', $ganzebildurl) ? $ganzebildurl : "$db_bilderpfad/$bildname";
				} else {
					$items_picture = "$db_bilderpfad/no_picture.gif";
				}
				if (!empty($ganzebildurl_zweites)) {
					$items_bpicture = preg_match('#^http#i', $ganzebildurl_zweites) ? $ganzebildurl_zweites : "$db_bilderpfad/$bildname_zweites";
				} else {
					$items_bpicture = "";
				}
/* edit Richy Bilder 3 - 5 */
				if (!empty($ganzebildurl_drittes)) {
					$items_3picture = preg_match('#^http#i', $ganzebildurl_drittes) ? $ganzebildurl_drittes : "$db_bilderpfad/$bildname_drittes";
				} else {
					$items_3picture = "";
				}
				if (!empty($ganzebildurl_viertes)) {
					$items_4picture = preg_match('#^http#i', $ganzebildurl_viertes) ? $ganzebildurl_viertes : "$db_bilderpfad/$bildname_viertes";
				} else {
					$items_4picture = "";
				}
				if (!empty($ganzebildurl_fuenftes)) {
					$items_5picture = preg_match('#^http#i', $ganzebildurl_fuenftes) ? $ganzebildurl_fuenftes : "$db_bilderpfad/$bildname_fuenftes";
				} else {
					$items_5picture = "";
				}

				//$items =go_db_query("insert into items (items_quantity, items_model, items_picture, items_bpicture, items_3picture, items_4picture, items_5picture, items_price, items_price_uvp, items_date_added, items_date_available, items_weight, items_status, items_tax_class_id, producers_id, syn, herstellernummer, upc_ean_isbn) values ('$artikelanzahl', '$produktnummer', '$items_picture', '$items_bpicture', '$items_3picture', '$items_4picture', '$items_5picture', '$nettopreisplusgewinn', '$uvp', now(), '$tmpMorgen 00:00:00', '$gewicht', '$statuslieferbarkeit', '$steuersatz', '$producers_id', 'csv_import2', '$mpn', '$ean')");
				$fields = array('items_quantity','items_model','items_picture','items_bpicture','items_3picture','items_4picture','items_5picture','items_price','items_price_uvp','items_date_added','items_date_available','items_weight','items_status','items_tax_class_id','producers_id','syn','herstellernummer','upc_ean_isbn');
				$values = array($artikelanzahl,$produktnummer,$items_picture,$items_bpicture,$items_3picture,$items_4picture,$items_5picture,$nettopreisplusgewinn,$uvp, 'now()', $morgen.' 00:00:00',$gewicht,$statuslieferbarkeit,$steuersatz,$producers_id,csv_import2,$mpn,$ean);
				$items_id =  $CSV->model_insert_item($data, array_combine($fields,$values));
/* edit ende Richy */
				$items_to_categories = go_db_query("INSERT INTO items_to_categories (items_id, categories_id) VALUES ('$items_id', '$categorie_for_items')");
				$languages = go_get_languages();
				for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
					$languages_id=$languages[$i]['id'];
					$fields = array( 'items_id','language_id','items_name','items_name2','items_description','items_description_in_cat_list','items_url ','items_viewed','bezeichnung1','inhalt1','bezeichnung2','inhalt2','bezeichnung3','inhalt3','bezeichnung4','inhalt4','bezeichnung5','inhalt5','bezeichnung6','inhalt6');
					$values = array( $items_id,$languages_id,$produktname,$produktname_zwei,$contentunteresframe,$contentincat,$herstellerlink,0,$bezeichnung1,$inhalt1,$bezeichnung2,$inhalt2,$bezeichnung3,$inhalt3,$bezeichnung4,$inhalt4,$bezeichnung5,$inhalt5,$bezeichnung6,$inhalt6 );
					$en_items_description = go_db_carry('items_description', array_combine($fields,$values));
				}
			} 

############################################################### 	
		$categorie_for_items = "";
		$produktnummer = "";
		$produktname = "";
		$name_der_warengruppe = "";
		$hersteller = "";
		$statuslieferbarkeit = "";
		$herstellernummer = "";
		$uvp = "";
		$preis = "";
		$ganzebildurl = "";
		$herstellerlink = "";
		$gewicht = "";
		$contentunteresframe = "";
		$contentincat = "";
		$i_categories_id = "";
		$j_categories_id = "";
		$k_categories_id = "";
		$items_da = "";
		$haupt_categories_id = "";
		$bildname = "";
		$bildname_zweites = "";
/* edit Richy Bilder 3 - 5 */
		$bildname_drittes = "";
		$bildname_viertes = "";
		$bildname_fuenftes = "";
/* edit ende Richy */
		$ean = "";
		$mpn = "";

		unset ($data);
	}
//	unlink($uploaddir. $_FILES['userfile']['name']);
	unlink( $_FILES['userfile']['tmp_name'] );

}  

  $cate_tree = $CSV->go_get_category_tree();
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
<script src="http://code.jquery.com/jquery-1.11.0.min.js"></script>	
<script type="text/javascript" language="JavaScript">
<!--//

function applyOnLoad() {
	toggleDisplay("ampelfunktion");
	toggleDisplay("preisaufschlage");
	toggleDisplay("steuersatz2");
	toggleDisplay("separiert");
	toggleDisplay("artikelbezeichnung");
	toggleDisplay("untertitel");
	toggleDisplay("ean");
	toggleDisplay("mpn");
	toggleDisplay("hersteller");
	toggleDisplay("anzahl");
	toggleDisplay("artikelnummer");
	toggleDisplay("urlbild1");
	toggleDisplay("urlbild2");
/* edit Richy Bilder 3 - 5 */
	toggleDisplay("urlbild3");
	toggleDisplay("urlbild4");
	toggleDisplay("urlbild5");
/* edit ende Richy */
	toggleDisplay("preis");
	toggleDisplay("uvp");
	toggleDisplay("gewicht");
	toggleDisplay("kategorie1");
	toggleDisplay("kategorie2");
	toggleDisplay("kategorie3");
	toggleDisplay("kategorie4");
	toggleDisplay("kategorie5");
	toggleDisplay("beschreibung");
	toggleDisplay("beschreibung_incat");
	toggleDisplay("lieferbarkeit");
	toggleDisplay("wunschfeld");
	toggleDisplay("hauptkategorie");
}

function validateFenster() {
	  var win = window.open("einlesen_fenster_unten.php","Progress","toolbar=no,width=650,height=100,directories=no,status=no,scrollbars=no,resize=no,menubar=no");
}

//-->
</script>
<script language="javascript" type="text/javascript"><!--
var form = "";
var submitted = false;
var error = false;
var error_message = "";
function check_input(field_name, field_size, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var field_value = form.elements[field_name].value;
    if (field_value == '' || field_value.length < field_size) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}
function check_radio(field_name, message) {
  var isChecked = false;
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var radio = form.elements[field_name];
    for (var i=0; i<radio.length; i++) {
      if (radio[i].checked == true) {
        isChecked = true;
        break;
      }
    }
    if (isChecked == false) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}
function check_select(field_name, field_default, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var field_value = form.elements[field_name].value;
    if (field_value == field_default) {
      error_message = error_message + "* " + message + "\n";
      error = true;
      console.log(field_name,field_value,field_default, message);
    }
  }
}
function check_form(form_name) {
  if (submitted == true) {
    alert("<?php echo TEXT_ALERT_AGAIN; ?>");
    return false;
  }
  error = false;
  form = form_name;
  error_message = "<?php echo GIVE_ME_INPUT; ?>\n<?php echo MAKE_FULL; ?>\n\n";
  check_select("produktnamezahl", "", "<?php echo SELECT_POSITION_A; ?>");
  check_select("produktnamezahl", "", "<?php echo SELECT_POSITION_B; ?>");
  check_select("steuersatz", "", "<?php echo SELECT_POSITION_C; ?>");
  check_input("name_der_warengruppe2", "4", "<?php echo SELECT_POSITION_D; ?>");
  check_select("produktnummerzahl", "", "<?php echo SELECT_POSITION_F; ?>");
  check_select("ganzebildurlzahl", "", "<?php echo SELECT_POSITION_F; ?>");
  check_select("ganzebildurlzahl_zweites", "", "<?php echo SELECT_POSITION_G; ?>");
 /* edit Richy Bilder 3 - 5 */
  check_select("ganzebildurlzahl_drittes", "", "<?php echo SELECT_POSITION_G3; ?>");
  check_select("ganzebildurlzahl_viertes", "", "<?php echo SELECT_POSITION_G4; ?>");
  check_select("ganzebildurlzahl_fuenftes", "", "<?php echo SELECT_POSITION_G5; ?>"); 
 /* edit ende Richy */
  check_select("preiszahl", "", "<?php echo SELECT_POSITION_H; ?>");
  check_select("gewichtzahl", "", "<?php echo SELECT_POSITION_J; ?>");
  check_select("produktnamezahl_zwei", "", "<?php echo SELECT_POSITION_K; ?>");
  check_select("eanzahl", "", "<?php echo SELECT_POSITION_EAN; ?>");
  check_select("mpnzahl", "", "<?php echo SELECT_POSITION_MPN; ?>");
  check_select("herstellerzahl", "", "<?php echo SELECT_POSITION_M; ?>");
  check_select("artikelanzahlzahl", "", "<?php echo SELECT_POSITION_M; ?>");  
  check_select("name_der_warengruppezahl", "", "<?php echo SELECT_POSITION_N; ?>");
  check_select("name_der_zweiten_warengruppezahl", "", "<?php echo SELECT_POSITION_O; ?>");
  check_select("name_der_dritten_warengruppezahl", "", "<?php echo SELECT_POSITION_P; ?>");
  check_select("name_der_vierten_warengruppezahl", "", "<?php echo SELECT_POSITION_Q; ?>");
  check_select("name_der_fuenften_warengruppezahl", "", "<?php echo SELECT_POSITION_R; ?>");
  check_select("contentunteresframezahl", "", "<?php echo SELECT_POSITION_S; ?>");
  check_select("contentincatzahl", "", "<?php echo SELECT_POSITION_S2; ?>");
  check_select("statuslieferbarkeitzahl", "", "<?php echo SELECT_POSITION_U; ?>");
  check_select("inhalt1zahl", "", "<?php echo SELECT_POSITION_V; ?>");
  check_select("inhalt2zahl", "", "<?php echo SELECT_POSITION_W; ?>");
  check_select("inhalt3zahl", "", "<?php echo SELECT_POSITION_X; ?>");
  check_select("inhalt4zahl", "", "<?php echo SELECT_POSITION_Y; ?>");
  check_select("inhalt5zahl", "", "<?php echo SELECT_POSITION_ZA; ?>");
  check_select("inhalt6zahl", "", "<?php echo SELECT_POSITION_ZB; ?>");
  
  if (error == true) {
    alert(error_message);
    return false;
  } else {
    submitted = true;
    return true;
  }
}
//-->
</script>
</head>
<body onload="applyOnLoad()" marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?><br>
            
<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="5" STYLE="border-collapse: collapse">
  <TR>
    <TD class="smallText">
 		<?php echo TEXT_EXPLAIN_MAIN; ?>
    
    </TD>
  </TR>
</TABLE>            
              
              <p>
              
<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="5" STYLE="border-collapse: collapse">
  <TR>
    <TD WIDTH="50%">
    
<?php
	$count_cat_id_query = go_db_query("select count(*) as total from uni_import_vorlagen where uni_id='$uni_id'");
    	$count_cat_id = go_db_fetch_array($count_cat_id_query);
    	if ($count_cat_id['total'] != 0) {
?>
<form method="POST" action="main_bigware_115.php">
<select size="1" name="vorlagenauswahl">
<option value="nein"><?php echo TEXT_PLEASE_SELECT; ?></option> 
<?php
		$id = go_db_query("SELECT * FROM uni_import_vorlagen where uni_id='$uni_id'");
		while ($werte = go_db_fetch_array($id))
			{
   		$vorlagen_id = $werte["vorlagen_id"]; 
   		$vorlagenname = $werte["vorlagenname"];
		echo "<option value=\"$vorlagen_id\">$vorlagenname</option>";
	}
?>
	</select>
	<?php echo go_picture_submit('vorlage.gif', PICTURE_TEMPLATE_OPEN); ?>
	
              </p>
            </form>    
    
    </TD>
    <TD WIDTH="50%">
    
    
<form method="POST" action="main_bigware_115.php">
<select size="1" name="vorlagenloeschen">
<option value="nein"><?php echo TEXT_PLEASE_SELECT; ?></option> 
<?php
		$id = go_db_query("SELECT * FROM uni_import_vorlagen where uni_id='$uni_id'");
		while ($werte = go_db_fetch_array($id))
			{
   		$vorlagen_id = $werte["vorlagen_id"]; 
   		$vorlagenname = $werte["vorlagenname"];
		echo "<option value=\"$vorlagen_id\">$vorlagenname</option>";
	}
?>
	</select>
	<?php echo go_picture_submit('vorlage_loeschen.gif', PICTURE_TEMPLATE_DELETE); ?>
              </p>
            </form>
<?php
}
?>    
    
    
    
    </TD>
  </TR>
</TABLE>      
           
            
</td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
            <td>	 
	
<body>
	<form name="upload" method="POST" action="main_bigware_115.php" onSubmit="return check_form(upload);" enctype="multipart/form-data">
	<table style="BORDER-COLLAPSE: collapse" cellSpacing="1" cellPadding="0" width="100%" border="1">
	  <tr>
	      <td style="font-family: arial, helvetica, geneva, sans-serif; font-size: small" valign="top" bgcolor="#E1E1E1">			
			
<table style="BORDER-COLLAPSE: collapse" cellSpacing="1" cellPadding="5" width="100%" border="0">
  <tr class="tbUPCountData">
    <td class="tbUPDataInside"><?php echo TEXT_DESCR; ?></td>
    <td class="tbUPDataInside" width="30%"><?php echo TEXT_POSITION_IN_CSV; ?></td>
    <td class="tbUPDataInside"><?php echo TEXT_MUST_OR_NOT; ?></td>
    <td class="tbUPDataInside"></td>
  </tr>
  <tr class="tbCountDataSelected" id="defaultSelected" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_AMPEL; ?></td>
    <td class="TbInsideData" width="30%">
<select name="ampel" style="color: #000000">
<?php if ($geladen == "ja") { ?><option><?php echo $ampel_temp; ?></option><?php } ?>
<option><?php echo TEXT_SMALL_YES; ?></option>
<option><?php echo TEXT_SMALL_NO; ?></option>
</select> </font></td>
    <td class="TbInsideData">&nbsp;</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;ampelfunktion&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  <tr id="ampelfunktion">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_A; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;ampelfunktion&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
 
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_MORE_PRICE; ?></td>
    <td class="TbInsideData" width="30%">
<select size="1" name="preisaufschlag">
<?php if ($geladen == "ja"){?><option selected value="<?php echo $aufschlag_temp; ?>"><?php echo $aufschlag_temp*100; ?> %</option><?php } ?>
	  <option value="0.00">0 %</option>  
	  <option value="1.50">150%</option>
	  <option value="1.25">125 %</option>
	  <option value="1.00">100 %</option>
	  <option value="0.75">75 %</option>	  
	  <option value="0.50">50%</option>
	  <option value="0.40">40 %</option>
	  <option value="0.35">35 %</option>
	  <option value="0.30">30 %</option>
	  <option value="0.25">25%</option>
	  <option value="0.20">20 %</option>
	  <option value="0.19">19 %</option>
	  <option value="0.18">18 %</option>
	  <option value="0.17">17 %</option>
	  <option value="0.16">16%</option>
	  <option value="0.15">15 %</option>
	  <option value="0.14">14 %</option>
	  <option value="0.13">13 %</option>
	  <option value="0.12">12 %</option>
	  <option value="0.11">11 %</option>
	  <option value="0.10">10 %</option>
	  <option value="0.09">9 %</option>
	  <option value="0.08">8 %</option>
	  <option value="0.07">7 %</option>
	  <option value="0.06">6 %</option>
	  <option value="0.05">5 %</option>
	  <option value="0.04">4 %</option>
	  <option value="0.03">3 %</option>
	  <option value="0.02">2 %</option>
	  <option value="0.01">1 %</option>
	  
	  </select> </td>
    <td class="TbInsideData">&nbsp;</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;preisaufschlage&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="preisaufschlage">
    <td class="infoFrameInside" colspan="4">
<?php echo CONTENT_B; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;preisaufschlage&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_TAX_IN_CSV; ?></td>
    <td class="TbInsideData" width="30%">
<select size="1" name="steuersatz">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php
  $rates_query_raw = "select r.tax_rates_id, z.geo_zone_id, z.geo_zone_name, tc.tax_class_title, tc.tax_class_id, r.tax_priority, r.tax_rate, r.tax_description, r.date_added, r.last_modified from ((" . DB_TBL_TAX_CLASS . " tc, " . DB_TBL_TAX_RATES . " r) left join " . DB_TBL_GEO_ZONES . " z on r.tax_zone_id = z.geo_zone_id) where r.tax_class_id = tc.tax_class_id";
  $rates_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $rates_query_raw, $rates_query_numrows);
  $rates_query = go_db_query($rates_query_raw);
  while ($rates = go_db_fetch_array($rates_query)) {
echo '<option value="' . $rates['tax_class_id'] . '">' . $rates['tax_class_title'] . '</option>';
  }
?>
	  
	  </select> </td>
    <td class="TbInsideData">&nbsp;</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;steuersatz2&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="steuersatz2">
    <td class="infoFrameInside" colspan="4">
<?php echo CONTENT_C; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;steuersatz2&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
   
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_HOW_SEPERATE; ?></td>
    <td class="TbInsideData" width="30%">
<input type="text" name="separator" size="2" value="<?php if ($geladen == "ja"){echo $seperierung_temp;}else{echo ';';}?>"> 
<?php echo TEXT_ALERT_NO_KOMMA; ?>
</td>
    <td class="TbInsideData">&nbsp;</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;separiert&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="separiert">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_F; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;separiert&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>    
  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_ITEMSNAME; ?></td>
    <td class="TbInsideData" width="30%"><select name="produktnamezahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $bezeichnung_temp; ?>"><?php echo $bezeichnung_temp+1; ?></option><?php } ?>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_MUST_TO; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;artikelbezeichnung&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="artikelbezeichnung">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_G; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;artikelbezeichnung&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>    
  
 
  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_UNDERTITLE; ?></td>
    <td class="TbInsideData" width="30%"><select name="produktnamezahl_zwei" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $bezeichnung_temp_zwei; ?>"><?php if ($bezeichnung_temp_zwei != "keine"){echo $bezeichnung_temp_zwei+1;}else{echo $bezeichnung_temp_zwei;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>

</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_OPTIONAL; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;untertitel&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="untertitel">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_H; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;untertitel&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>    
  
 
 <!-- EAN -->
   <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_UPC_EAN_ISPN; ?></td>
    <td class="TbInsideData" width="30%"><select name="eanzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $ean_temp; ?>"><?php if ($ean_temp != "keine"){echo $ean_temp+1;}else{echo $ean_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>

</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_OPTIONAL; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;ean&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="ean">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_EAN; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;ean&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr> 
 
 <!-- EAN -->
 
  <!-- Herstellerartikelnummer (MPN) -->
   <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_MPN; ?></td>
    <td class="TbInsideData" width="30%"><select name="mpnzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $mpn_temp; ?>"><?php if ($mpn_temp != "keine"){echo $mpn_temp+1;}else{echo $mpn_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>

</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_OPTIONAL; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;mpn&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="mpn">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_MPN; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;mpn&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr> 
 
 <!-- Herstellerartikelnummer (MPN) -->
 
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_PRODUCER; ?></td>
    <td class="TbInsideData" width="30%"><select name="herstellerzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $hersteller_temp; ?>"><?php if ($hersteller_temp != "keine"){echo $hersteller_temp+1;}else{echo $hersteller_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_OPTIONAL; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;hersteller&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="hersteller">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_I; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;hersteller&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_COUNT_ITEM; ?></td>
    <td class="TbInsideData" width="30%"><select name="artikelanzahlzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $anzahl_temp; ?>"><?php if ($anzahl_temp != "keine"){echo $anzahl_temp+1;}else{echo $anzahl_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_COUNT_ITEM; ?>:
<select name="artikelanzahl2" style="color: #000000">
<?php if ($geladen == "ja"){?><option selected value="<?php echo $anzahl_default_temp; ?>"><?php echo $anzahl_default_temp; ?></option><?php } ?>
<?php
for ($i=1; $i<20; $i++) {
$value = $i-1;
echo "<option>$i</option>\n";
}
?>
</select> </td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;anzahl&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="anzahl">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_J; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;anzahl&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_ITEMS_MODEL; ?></td>
    <td class="TbInsideData" width="30%"><select name="produktnummerzahl" style="color: #000000">
<?php
	 if ($geladen == "ja"){
	 	 $selected = (empty($items_model_temp) ||  $items_model_temp == "keine")? 'selected':'';
	 	 $ops = '<option value="keine"  '.$selected.'>'. TEXT_NO_FIELD.'</option>';
 	 }else{
	 	 $ops = '<option value="keine" >'. TEXT_NO_FIELD.'</option>';
 	 	 $ops .= '<option value="" selected>'. TEXT_PLEASE_SELECT.'</option>';
 	 }
	  for($i=1;$i<80;$i++){
	  	$selected =  ($i ==   $items_model_temp)? "selected":""; 
	  	$ops  .= sprintf('<option value="%s" %s>%s</option>', $i-1,$selected,$i);
	  }
 	echo $ops;
?>
</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_RANDOMNUMBER; ?> <input type="checkbox" name="C1" value="ON"<?php if ($geladen == "ja"){if ($items_model_zufall_temp == "ON"){ echo " checked";}}?>></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;artikelnummer&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="artikelnummer">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_K; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;artikelnummer&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>   
  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_URL_TO_PIC; ?><br>
(<?php echo TEXT_URL_TO_PIC_EXAMPLE; ?>)
<br><br><?php echo TEXT_URL_ONLY_PIC; ?> ( <?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?> ).
</td>
    <td class="TbInsideData" width="30%"><select name="ganzebildurlzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $buld_url_temp; ?>"><?php if ($buld_url_temp != "keine"){echo $buld_url_temp+1;}else{echo $buld_url_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; 
<br>
<input type="radio" name="copybild" value="yes" <?php if ($copybild_temp=='yes') {echo "checked";} ?>><?php echo TEXT_PIC_COPY; ?>
<br>
<input type="radio" name="copybild" value="no" <?php if ($copybild_temp=='no') {echo "checked";} ?>><?php echo TEXT_ONLY_PICNAME_CHANGE; ?>
<br>
<input type="radio" name="copybild" value="url" <?php if ($copybild_temp=='url') {echo "checked";} ?>><?php echo TEXT_PIC_URL; ?>
<br><br>
<input type="text" name="pfad_zum_bild" size="13" value="<?php if ($geladen == "ja"){echo $pfad_zum_bild_temp;}else{echo '';}?>">
</td>
    <td class="TbInsideData"><?php echo TEXT_NO_PIC; ?> <input type="checkbox" name="C2" value="ON"<?php if ($geladen == "ja"){if ($buld_url_default_temp == "ON"){ echo " checked";}}?>> <br>
(<?php echo TEXT_NOT_RECOM; ?>)</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;urlbild1&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="urlbild1">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_L; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;urlbild1&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>    
  
  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_URL_PIC; ?><br>
(<?php echo TEXT_URL_TO_PIC_EXAMPLE; ?>)
<br><br><?php echo TEXT_URL_ONLY_PIC; ?> ( <?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?> ).
</td>
    <td class="TbInsideData" width="30%"><select name="ganzebildurlzahl_zweites" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $buld_url_temp_zweites; ?>"><?php if ($buld_url_temp_zweites != "keine"){echo $buld_url_temp_zweites+1;}else{echo $buld_url_temp_zweites;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; 
<br>
<input type="radio" name="copybild2" value="yes" <?php if ($copybild2_temp=='yes') {echo "checked";} ?>><?php echo TEXT_PIC_COPY; ?>
<br>
<input type="radio" name="copybild2" value="no" <?php if ($copybild2_temp=='no') {echo "checked";} ?>><?php echo TEXT_ONLY_PICNAME_CHANGE; ?>
<br>
<input type="radio" name="copybild2" value="url" <?php if ($copybild2_temp=='url') {echo "checked";} ?>><?php echo TEXT_PIC_URL; ?>
<br><br>
<input type="text" name="pfad_zum_bild_zweites" size="13" value="<?php if ($geladen == "ja"){echo $pfad_zum_bild_temp_zweites;}else{echo '';}?>">
</td>
    <td class="TbInsideData"><?php echo TEXT_NO_BIG_PIC; ?> <input type="checkbox" name="C2_zweites" value="ON"<?php if ($geladen == "ja"){if ($buld_url_default_temp_zweites == "ON"){ echo " checked";}}?>> <br>
</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;urlbild2&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="urlbild2">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_M; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;urlbild2&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
 
<!-- edit Richy Bilder 3 - 5 -->
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_URL_PIC3; ?><br>
(<?php echo TEXT_URL_TO_PIC_EXAMPLE; ?>)
<br><br><?php echo TEXT_URL_ONLY_PIC; ?> ( <?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?> ).
</td>
    <td class="TbInsideData" width="30%"><select name="ganzebildurlzahl_drittes" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $buld_url_temp_drittes; ?>"><?php if ($buld_url_temp_drittes != "keine"){echo $buld_url_temp_drittes+1;}else{echo $buld_url_temp_drittes;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; 
<br>
<input type="radio" name="copybild3" value="yes" <?php if ($copybild3_temp=='yes') {echo "checked";} ?>><?php echo TEXT_PIC_COPY; ?>
<br>
<input type="radio" name="copybild3" value="no" <?php if ($copybild3_temp=='no') {echo "checked";} ?>><?php echo TEXT_ONLY_PICNAME_CHANGE; ?>
<br>
<input type="radio" name="copybild3" value="url" <?php if ($copybild3_temp=='url') {echo "checked";} ?>><?php echo TEXT_PIC_URL; ?>
<br><br>
<input type="text" name="pfad_zum_bild_drittes" size="13" value="<?php if ($geladen == "ja"){echo $pfad_zum_bild_temp_drittes;}else{echo '';}?>">
</td>
    <td class="TbInsideData"><?php echo TEXT_NO_BIG_PIC3; ?> <input type="checkbox" name="C2_drittes" value="ON"<?php if ($geladen == "ja"){if ($buld_url_default_temp_drittes == "ON"){ echo " checked";}}?>> <br>
</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;urlbild3&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  <tr id="urlbild3">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_M3; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;urlbild3&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>

   <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_URL_PIC4; ?><br>
(<?php echo TEXT_URL_TO_PIC_EXAMPLE; ?>)
<br><br><?php echo TEXT_URL_ONLY_PIC; ?> ( <?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?> ).
</td>
    <td class="TbInsideData" width="30%"><select name="ganzebildurlzahl_viertes" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $buld_url_temp_viertes; ?>"><?php if ($buld_url_temp_viertes != "keine"){echo $buld_url_temp_viertes+1;}else{echo $buld_url_temp_viertes;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; 
<br>
<input type="radio" name="copybild4" value="yes" <?php if ($copybild4_temp=='yes') {echo "checked";} ?>><?php echo TEXT_PIC_COPY; ?>
<br>
<input type="radio" name="copybild4" value="no" <?php if ($copybild4_temp=='no') {echo "checked";} ?>><?php echo TEXT_ONLY_PICNAME_CHANGE; ?>
<br>
<input type="radio" name="copybild4" value="url" <?php if ($copybild4_temp=='url') {echo "checked";} ?>><?php echo TEXT_PIC_URL; ?>
<br><br>
<input type="text" name="pfad_zum_bild_viertes" size="13" value="<?php if ($geladen == "ja"){echo $pfad_zum_bild_temp_viertes;}else{echo '';}?>">
</td>
    <td class="TbInsideData"><?php echo TEXT_NO_BIG_PIC4; ?> <input type="checkbox" name="C2_viertes" value="ON"<?php if ($geladen == "ja"){if ($buld_url_default_temp_viertes == "ON"){ echo " checked";}}?>> <br>
</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;urlbild4&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  <tr id="urlbild4">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_M4; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;urlbild4&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  
    <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_URL_PIC5; ?><br>
(<?php echo TEXT_URL_TO_PIC_EXAMPLE; ?>)
<br><br><?php echo TEXT_URL_ONLY_PIC; ?> ( <?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?> ).
</td>
    <td class="TbInsideData" width="30%"><select name="ganzebildurlzahl_fuenftes" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $buld_url_temp_fuenftes; ?>"><?php if ($buld_url_temp_fuenftes != "keine"){echo $buld_url_temp_fuenftes+1;}else{echo $buld_url_temp_funeftes;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; 
<br>
<input type="radio" name="copybild5" value="yes" <?php if ($copybild5_temp=='yes') {echo "checked";} ?>><?php echo TEXT_PIC_COPY; ?>
<br>
<input type="radio" name="copybild5" value="no" <?php if ($copybild5_temp=='no') {echo "checked";} ?>><?php echo TEXT_ONLY_PICNAME_CHANGE; ?>
<br>
<input type="radio" name="copybild5" value="url" <?php if ($copybild5_temp=='url') {echo "checked";} ?>><?php echo TEXT_PIC_URL; ?>
<br><br>
<input type="text" name="pfad_zum_bild_funftes" size="13" value="<?php if ($geladen == "ja"){echo $pfad_zum_bild_temp_fuenftes;}else{echo '';}?>">
</td>
    <td class="TbInsideData"><?php echo TEXT_NO_BIG_PIC5; ?> <input type="checkbox" name="C2_fuenftes" value="ON"<?php if ($geladen == "ja"){if ($buld_url_default_temp_fuenftes == "ON"){ echo " checked";}}?>> <br>
</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;urlbild5&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  <tr id="urlbild5">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_M5; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;urlbild5&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
<!-- edit ende Richy -->  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_PRICE_NET; ?></td>
    <td class="TbInsideData" width="30%"><select name="preiszahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $preis_temp; ?>"><?php echo $preis_temp+1; ?></option><?php } ?>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp;&nbsp; <INPUT TYPE="checkbox" VALUE="ON" NAME="brutto"<?php if ($geladen == "ja"){if ($brutto_temp == "ON"){ echo " checked";}}?>> <?php echo TEXT_IF_PRICE_BRUTTO; ?> </td>
    <td class="TbInsideData"><?php echo TEXT_MUST_TO; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;preis&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="preis">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_N; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;preis&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
 
 
<?php 
 ?>
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_UVP; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<select name="uvpzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $uvp_temp; ?>"><?php if ($uvp_temp != "keine"){echo $uvp_temp+1;}else{echo $uvp_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;uvp&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
</tr>
<tr id="uvp">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_O; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;uvp&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
<?php
 ?>	
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WEIGHT; ?></td>
    <td class="TbInsideData" width="30%"><select name="gewichtzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $gewicht_temp; ?>"><?php if ($gewicht_temp != "keine"){echo $gewicht_temp+1;}else{echo $gewicht_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp; </td>
    <td class="TbInsideData"><?php echo TEXT_DEFAULT_WEIGHT; ?>
<select name="gewicht2" style="color: #000000">
<?php if ($geladen == "ja"){?><option selected value="<?php echo $gewicht_default_temp; ?>"><?php echo $gewicht_default_temp; ?></option><?php } ?>
<option>1</option>
<option>2</option>
<option>3</option>
<option>4</option>
<option>5</option>
<option>6</option>
<option>7</option>
<option>8</option>
<option>9</option>
<option>10</option>
<option>11</option>
<option>12</option>
<option>13</option>
<option>14</option>
<option>15</option>
<option>16</option>
<option>17</option>
<option>18</option>
<option>19</option>
<option>20</option>
<option>21</option>
<option>22</option>
<option>23</option>
<option>24</option>
<option>25</option>
<option>26</option>
<option>27</option>
<option>28</option>
<option>29</option>
<option>30</option>
</select> KG</td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;gewicht&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  <tr id="gewicht">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_P; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;gewicht&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
   
  <?php
  	echo $CSV->view_row_basic_pricing(); 
  ?>
  

  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_CAT; ?></td>
    <td class="TbInsideData" width="30%"><select name="name_der_warengruppezahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $unterkat_temp; ?>"><?php if ($unterkat_temp != "keine"){echo $unterkat_temp+1;}else{echo $unterkat_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>
&nbsp; 
</td>
    <td class="TbInsideData"><?php echo TEXT_DEFAULT_CAT; ?><br>
<input type="text" name="name_der_warengruppe2" size="13" value="<?php if ($geladen == "ja"){echo $unterkat_default_temp;}else{echo TEXT_EXAMPLE_CAT;}?>"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;kategorie1&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="kategorie1">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_Q; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;kategorie1&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
 
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_CAT_TWO; ?></td>
    <td class="TbInsideData" width="30%"><select name="name_der_zweiten_warengruppezahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $unterkat_temp_zweiten; ?>"><?php if ($unterkat_temp_zweiten != "keine"){echo $unterkat_temp_zweiten+1;}else{echo $unterkat_temp_zweiten;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>
&nbsp; 
</td>
    <td class="TbInsideData"><?php echo TEXT_SECOND_DEFAULT_CAT; ?><br>
<input type="text" name="name_der_zweiten_warengruppe2" size="13" value="<?php if ($geladen == "ja"){echo $unterkat_default_temp_zweiten;}else{echo '';}?>"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;kategorie2&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="kategorie2">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_R; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;kategorie2&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
<?php
 ?>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_CAT_THREE; ?></td>
    <td class="TbInsideData" width="30%">
			<select name="name_der_dritten_warengruppezahl" style="color: #000000">
				<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $unterkat_temp_dritten; ?>"><?php if ($unterkat_temp_dritten != "keine"){echo $unterkat_temp_dritten+1;}else{echo $unterkat_temp_dritten;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>
&nbsp; 
</td>
    <td class="TbInsideData"><?php echo TEXT_THIRD_DEFAULT_CAT; ?><br>
<input type="text" name="name_der_dritten_warengruppe2" size="13" value="<?php if ($geladen == "ja"){echo $unterkat_default_temp_dritten;}else{echo '';}?>"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;kategorie3&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="kategorie3">
    <td class="infoFrameInside" colspan="4">
     <?php echo CONTENT_R; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;kategorie3&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
  
<?php
 ?>
  
	
	
<?php
 ?>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_CAT_FOUR; ?></td>
    <td class="TbInsideData" width="30%">
			<select name="name_der_vierten_warengruppezahl" style="color: #000000">
				<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $unterkat_temp_vierten; ?>"><?php if ($unterkat_temp_vierten != "keine"){echo $unterkat_temp_vierten+1;}else{echo $unterkat_temp_vierten;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>
&nbsp; 
</td>
    <td class="TbInsideData"><?php echo TEXT_FOURTH_DEFAULT_CAT; ?><br>
<input type="text" name="name_der_vierten_warengruppe2" size="13" value="<?php if ($geladen == "ja"){echo $unterkat_default_temp_vierten;}else{echo '';}?>"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;kategorie4&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
	<tr id="kategorie4">
    <td class="infoFrameInside" colspan="4">
     <?php echo CONTENT_R; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;kategorie4&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
<?php
  ?>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_CAT_FIVE; ?></td>
    <td class="TbInsideData" width="30%">
			<select name="name_der_fuenften_warengruppezahl" style="color: #000000">
				<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $unterkat_temp_fuenften; ?>"><?php if ($unterkat_temp_fuenften != "keine"){echo $unterkat_temp_fuenften+1;}else{echo $unterkat_temp_fuenften;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>
&nbsp; 
</td>
    <td class="TbInsideData"><?php echo TEXT_FIVTH_DEFAULT_CAT; ?><br>
<input type="text" name="name_der_fuenften_warengruppe2" size="13" value="<?php if ($geladen == "ja"){echo $unterkat_default_temp_fuenften;}else{echo '';}?>"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;kategorie5&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="kategorie5">
    <td class="infoFrameInside" colspan="4">
     <?php echo CONTENT_R; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;kategorie5&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>  
<?php
 ?>
	
	
	
	
	
	
	
  
  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_DESC; ?><br>
<?php echo TEXT_FILTER; ?></td>
    <td class="TbInsideData" width="30%">
<select name="contentunteresframezahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $beschreibung_temp; ?>"><?php echo $beschreibung_temp+1; ?></option><?php } ?>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp;&nbsp; <br>
<select name="htmlbefrei" style="color: #000000"> 
<!-- edit Richy filter --> <?php if ($geladen == "ja"){?><option selected value="<?php echo TEXT_SMALL_YES; ?>"><?php echo $filter1_temp; ?></option><?php } ?>
<option value="<?php echo TEXT_SMALL_YES; ?>"><?php echo TEXT_SMALL_YES; ?></option>
<option><?php echo TEXT_SMALL_NO; ?></option><!-- ende edit Richy filter -->
</select></td>
    <td class="TbInsideData"><?php echo TEXT_MUST_TO; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;beschreibung&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="beschreibung">
    <td class="infoFrameInside" colspan="4">
   <?php echo CONTENT_S; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;beschreibung&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  
  
  
  
  
<tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_FULL_DESC_IN_CAT; ?><br>
<?php echo TEXT_FILTER; ?></td>
    <td class="TbInsideData" width="30%">
<select name="contentincatzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $beschreibung_incat_temp; ?>"><?php if ($beschreibung_incat_temp != "keine"){echo $beschreibung_incat_temp+1;}else{echo $beschreibung_incat_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp;&nbsp; <br>
<select name="htmlbefrei_category" style="color: #000000">
<?php if ($geladen == "ja"){?><option selected value="<?php echo TEXT_SMALL_YES; ?>"><?php echo $filter1_temp; ?></option><?php } ?>
<option value="<?php echo TEXT_SMALL_YES; ?>"><?php echo TEXT_SMALL_YES; ?></option>
<option><?php echo TEXT_SMALL_NO; ?></option>
</select></td>
    <td class="TbInsideData"><?php echo TEXT_OPTIONAL; ?></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;beschreibung_incat&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="beschreibung_incat">
    <td class="infoFrameInside" colspan="4">
   <?php echo CONTENT_S2; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;beschreibung_incat&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  


  
  
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_GO_SHIPPING; ?><br>
<br>
<?php echo TEXT_THERE_VALUE; ?></td>
    <td class="TbInsideData" width="30%">
<select name="statuslieferbarkeitzahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $lieferbarkeit_temp; ?>"><?php if ($lieferbarkeit_temp != "keine"){echo $lieferbarkeit_temp+1;}else{echo $lieferbarkeit_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select>&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="verfuegbarwert" size="11" value="<?php if ($geladen == "ja"){echo $verfuegbar_wert_temp;}?>"> </td>
    <td class="TbInsideData"><?php echo TEXT_DEFAULT_FOR_SHIP; ?><br>
<select name="statuslieferbarkeit2" style="color: #000000">
<?php if ($geladen == "ja"){?><option selected value="<?php echo $lieferbarkeit_default_temp; ?>"><?php echo $lieferbarkeit_default_temp; ?></option><?php } ?>
<option><?php echo TEXT_GREAT_YES; ?></option>
<option><?php echo TEXT_GREAT_NO; ?></option>
</select></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;lieferbarkeit&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="lieferbarkeit">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_T; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;lieferbarkeit&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  
  
  
<!-- ----------------------------------- -->
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_A; ?><br>
<br>
<?php echo TEXT_YOUR_DESC_A; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung1" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung1_temp;}?>">
<select name="inhalt1zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt1_temp; ?>"><?php if ($inhalt1_temp != "keine"){echo $inhalt1_temp+1;}else{echo $inhalt1_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;wunschfeld&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="wunschfeld">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_U; ?>
        <p align="right"><a href="javascript:toggleDisplay(&quot;wunschfeld&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  
  
  
   
  
  

  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_B; ?><br>
<br><?php echo TEXT_YOUR_DESC_B; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung2" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung2_temp;}?>">
<select name="inhalt2zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt2_temp; ?>"><?php if ($inhalt2_temp != "keine"){echo $inhalt2_temp+1;}else{echo $inhalt2_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_C; ?><br>
<br>
<?php echo TEXT_YOUR_DESC_C; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung3" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung3_temp;}?>">
<select name="inhalt3zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt3_temp; ?>"><?php if ($inhalt3_temp != "keine"){echo $inhalt3_temp+1;}else{echo $inhalt3_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_D; ?><br>
<br>
<?php echo TEXT_YOUR_DESC_D; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung4" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung4_temp;}?>">
<select name="inhalt4zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt4_temp; ?>"><?php if ($inhalt4_temp != "keine"){echo $inhalt4_temp+1;}else{echo $inhalt4_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_E; ?><br>
<br>
<?php echo TEXT_YOUR_DESC_E; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung5" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung5_temp;}?>">
<select name="inhalt5zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt5_temp; ?>"><?php if ($inhalt5_temp != "keine"){echo $inhalt5_temp+1;}else{echo $inhalt5_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_WISH_FIELD_F; ?><br>
<br>
<?php echo TEXT_YOUR_DESC_F; ?></td>
    <td class="TbInsideData" width="30%">
&nbsp;&nbsp;
&nbsp;<br>
<input type="text" name="bezeichnung6" size="11" value="<?php if ($geladen == "ja"){echo $bezeichnung6_temp;}?>">
<select name="inhalt6zahl" style="color: #000000">
<option value=""><?php echo TEXT_PLEASE_SELECT; ?></option>
<?php if ($geladen == "ja"){?><option selected value="<?php echo $inhalt6_temp; ?>"><?php if ($inhalt6_temp != "keine"){echo $inhalt6_temp+1;}else{echo $inhalt6_temp;} ?></option><?php } ?>
<option value="keine"><?php echo TEXT_NO_FIELD; ?></option>
<?php
for ($i=1; $i<80; $i++) {
$value = $i-1;
echo "<option value=\"$value\">$i</option>\n";
}
?>
</select> 
</td>
    <td class="TbInsideData"></td>
    <td class="TbInsideData"> </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td class="TbInsideData"><?php echo TEXT_MAIN_CAT; ?></td>
    <td class="TbInsideData" colspan="2">
    	<br  /><br />
	<?php
		$default_main_cate =($geladen == "ja")? $oberkat_temp:""; 
		echo go_fetch_pull_down_menu('namekat' ,$cate_tree,$default_main_cate);
	 ?>
	<br  /><br />
    </td>		    
    <td class="TbInsideData"> 
    <a href="javascript:toggleDisplay(&quot;hauptkategorie&quot;)"><?php echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif'); ?></a>
    </td>
  </tr>
  
  <tr id="hauptkategorie">
    <td class="infoFrameInside" colspan="4">
    <?php echo CONTENT_W; ?>
    <p align="right"><a href="javascript:toggleDisplay(&quot;hauptkategorie&quot;)"><?php echo TEXT_CLOSE; ?></a>
    </td>
  </tr>
  <tr class="tbCountData" "onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">
    <td colspan="4" class="TbInsideData">
<p align="left">
<?php echo TEXT_SELECT_CSV; ?></p>
<p align="center">
	<input name="userfile" type="file" class="button" size="30" style="float: left">
	</p>
	<p align="center"><br>
&nbsp;</td>
  </tr>
</table>
	
	</td>
	    <td style="font-family: arial, helvetica, geneva, sans-serif; font-size: small" valign="top">
	        
 		</td>
	          </tr>
	          </table>
	<p align="left"><span class="style10">
	<input type="hidden" value="JA" name="abgehts">
	          <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse">
                <tr>
                  <td width="50%"><span class="style10">
	<input type="checkbox" name="vorlage" value="ON"></span></td>
                  <td width="50%" class="smallText">
                  <?php echo TEXT_SAVE_AS_TEMPLATE; ?></td>
                </tr>
                <tr>
                  <td width="50%"><span class="style10">
	              <input type="text" name="vorlagennamen" size="20"></span></td>
                  <td width="50%" class="smallText">
	              <?php echo TEXT_NAME_OF_TEMPLATE; ?></td>
                </tr>
    </table>
	<p align="left"><span class="style10">
    <br>
	<?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?>
	
	</span></p>
	          </form>
           </td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td><table border="0" cellpadding="0" cellspacing="2">
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?>
                
                </td>
              </tr>
<!-- body_text_eof //-->
        </table></td>
      </tr>
    </table></td>
  </tr>
</table>
<!-- body_eof //-->
<script type="text/javascript" language="JavaScript">
<!--
    
    function toggleDisplay(id) {
      if (document.getElementById(id).style.display == '') {
        document.getElementById(id).style.display = 'none';
      } else {
        document.getElementById(id).style.display = '';
      }
    }
    
    $(function(){
    	$('td.infoFrameInside').on('click','a.toggle',function(event){
    		$(this).parents('tr:first').toggle();	

    	});
    	$('td.TbInsideData').on('click','a.toggle',function(event){
    		$(this).parents('tr:first').next().toggle();	
    	});
    	$('form[name="upload"]').on('submit',function(event){
    		console.log(event);
    		$('select.field_option').each(function(i,e){
    			if ( e.value.length ==0){
    				console.log(e);
    				if ($(this).hasClass('required')) { 
    					alert('empty value');
    					$(this).focus();
    					return false;
    				}else {
    					 e.value = 'keine';
    				}
    			}
    		});
    	//	return false;
    	});
    	
    });
    
  //--> 
    </script>
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php 
require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); 
?>
