<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015

  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse
  Community, die bei Problemen weiterhelfen kann.

  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.

  Hilfe erhalten Sie im Forum auf www.bigware.de

  -----------------------------------------------------------------------

 ##################################################################################




*/
?>
<?php

require('load_this/load_bigware_11.php');

require(FOLDER_RELATIV_CLASSES . 'class_bigware_1.php');
$currencies = new currencies();
include(FOLDER_RELATIV_CLASSES . 'class_bigware_9.php');
$OldNewStatusValues = (go_field_exists(DB_TBL_ORDERS_STATUS_HISTORY, "old_value") && go_field_exists(DB_TBL_ORDERS_STATUS_HISTORY, "new_value"));
$CommentsWithStatus = go_field_exists(DB_TBL_ORDERS_STATUS_HISTORY, "comments");
$orders_statuses = array();
$orders_status_array = array();
$orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "'");
while ($orders_status = go_db_fetch_array($orders_status_query)) {
    $orders_statuses[] = array('id' => $orders_status['orders_status_id'],
        'text' => $orders_status['orders_status_name']);
    $orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}
$order_total_modules_array = array();
$order_total_modules_query = go_db_query("SELECT set_it_up_key,set_it_up_value FROM set_it_up WHERE set_it_up_key LIKE 'CONSTITUENT_ORDER_TOTAL_%_STATUS'");
while ($order_total_modules = go_db_fetch_array($order_total_modules_query)) {
    $order_total_modules_array[$order_total_modules['set_it_up_key']] = $order_total_modules['set_it_up_value'];
}
$tax_rates_array = array();
$tax_rates_query = go_db_query("SELECT tax_rate, concat(tax_description,':') as description FROM tax_rates");
while ($tax_rates = go_db_fetch_array($tax_rates_query)) {
    $tax_rates_array[$tax_rates['tax_rate']+0]=$tax_rates['description'];
}

$action = (isset($_GET['action']) ? $_GET['action'] : 'change');
if (go_not_null($action)) {
    switch ($action) {
    case 'update_order':
        if (isset($update_items)) {


            $oID = go_db_producing_input($_GET['oID']);
            $order = new order($oID);
            $status = go_db_producing_input($_POST['status']);
            $UpdateOrders = "update " . DB_TBL_ORDERS . " set
                attendees_name = '" . go_db_input($update_attendee_name) . "',
                    attendees_street_address = '" . go_db_input($update_attendee_street_address) . "',
                    attendees_street_address2 = '" . go_db_input($update_attendee_street_address2) . "',
                    attendees_city = '" . go_db_input($update_attendee_city) . "',
                    attendees_state = '" . go_db_input($update_attendee_state) . "',
                    attendees_postcode = '" . go_db_input($update_attendee_postcode) . "',
                    attendees_land = '" . go_db_input($update_attendee_land) . "',
                    attendees_telephone = '" . go_db_input($update_attendee_telephone) . "',
                    attendees_email_address = '" . go_db_input($update_attendee_email_address) . "',
                    billing_name = '" . go_db_input($update_attendee_name) . "',
                    billing_street_address = '" . go_db_input($update_attendee_street_address) . "',
                    billing_city = '" . go_db_input($update_attendee_city) . "',
                    billing_state = '" . go_db_input($update_attendee_state) . "',
                    billing_postcode = '" . go_db_input($update_attendee_postcode) . "',
                    billing_land = '" . go_db_input($update_attendee_land) . "',
                    delivery_name = '" . go_db_input($update_delivery_name) . "',
                    delivery_street_address = '" . go_db_input($update_delivery_street_address) . "',
                    delivery_street_address2 = '" . go_db_input($update_delivery_street_address2) . "',
                    delivery_city = '" . go_db_input($update_delivery_city) . "',
                    delivery_state = '" . go_db_input($update_delivery_state) . "',
                    delivery_postcode = '" . go_db_input($update_delivery_postcode) . "',
                    delivery_land = '" . go_db_input($update_delivery_land) . "',
                    payment_method = '" . go_db_input($update_info_payment_method) . "',
                    cc_type = '" . go_db_input($update_info_cc_type) . "',
                    cc_owner = '" . go_db_input($update_info_cc_owner) . "',
                    shipping_method = '" . go_db_input($update_info_shipping_method) . "',";

            if(substr($update_info_cc_number,0,8) != "(Last 4)")
                $UpdateOrders .= "cc_number = '$update_info_cc_number',";
            if(preg_match('/^[0-9]+$/', $update_info_cc_code))
                $UpdateOrders .= "cc_code = '$update_info_cc_code',";
            $UpdateOrders .= "cc_expires = '$update_info_cc_expires',
                orders_status = '" . go_db_input($status) . ",'";

            if(!$CommentsWithStatus) {
                $UpdateOrders .= "comments = '" . go_db_input($comments) . "'";
            }

            $UpdateOrders .= " where orders_id = '" . go_db_input($oID) . "';";

            go_db_query($UpdateOrders);
            $order_updated = true;
            $check_status_query = go_db_query("select attendees_name, attendees_email_address, orders_status, date_purchased from " . DB_TBL_ORDERS . " where orders_id = '" . (int)$oID . "'");
            $check_status = go_db_fetch_array($check_status_query);
            if ($order->info['orders_status'] != $status)
            {
                $attendee_notified = '0';
                if (isset($_POST['notify']) && ($_POST['notify'] == 'on'))
                {
                    $notify_comments = '';
                    if (isset($_POST['notify_comments']) && ($_POST['notify_comments'] == 'on')) {
                        $notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments) . "\n\n";
                    }
                    $email = SHOP_NAME . "\n" . EMAIL_SEPARATOR . "\n" . EMAIL_TEXT_ORDER_NUMBER . ' ' . $oID . "\n" . EMAIL_TEXT_INVOICE_URL . ' ' . go_catalog_href_link(NAME_OF_FILE_CATALOG_MEMBER_HISTORY_INFO, 'order_id=' . $oID, 'SSL') . "\n" . EMAIL_TEXT_DATE_ORDERED . ' ' . go_date_long($check_status['date_purchased']) . "\n\n" . $notify_comments . sprintf(EMAIL_TEXT_STATUS_UPDATE, $orders_status_array[$status]);
                    go_mail($check_status['attendees_name'], $check_status['attendees_email_address'], EMAIL_TEXT_SUBJECT, $email, SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS);
                    $attendee_notified = '1';
                }

                if($CommentsWithStatus)
                {
                    go_db_query("insert into " . DB_TBL_ORDERS_STATUS_HISTORY . "
                        (orders_id, orders_status_id, date_added, attendee_notified, comments)
                        values ('" . go_db_input($oID) . "', '" . go_db_input($status) . "', now(), " . go_db_input($attendee_notified) . ", '" . go_db_input($comments)  . "')");
                }
                else
                {
                    if($OldNewStatusValues)
                    {
                        go_db_query("insert into " . DB_TBL_ORDERS_STATUS_HISTORY . "
                            (orders_id, new_value, old_value, date_added, attendee_notified)
                            values ('" . go_db_input($oID) . "', '" . go_db_input($status) . "', '" . $order->info['orders_status'] . "', now(), " . go_db_input($attendee_notified) . ")");
                    }
                    else
                    {
                        go_db_query("insert into " . DB_TBL_ORDERS_STATUS_HISTORY . "
                            (orders_id, orders_status_id, date_added, attendee_notified)
                            values ('" . go_db_input($oID) . "', '" . go_db_input($status) . "', now(), " . go_db_input($attendee_notified) . ")");
                    }
                }
            }
            $RunningSubTotal = 0;
            $RunningTax = array();
            foreach($update_items as $orders_items_id => $items_details)
            {
                if($items_details["qty"] > 0)
                {
                    $order_items_quantity_query = go_db_query("select items_quantity, items_id from " . DB_TBL_ORDERS_ITEMS . " where orders_items_id = '" . $orders_items_id . "'");
                    $order_items_quantity = go_db_fetch_array($order_items_quantity_query);

                    $count_befor = $order_items_quantity["items_quantity"];
                    $count_after = $items_details["qty"];

                    if ($count_befor != $count_after){
                        $count_different = $count_after - $count_befor;

                        $pos = substr_count($count_different, '-');

                        if ($pos > 0) {
                            $zeichenkette = $count_different;
                            $suchmuster = '/\-/';
                            $ersetzung = '';
                            $count_different = preg_replace($suchmuster, $ersetzung, $zeichenkette);
                            $vorzeichen1 = '+';
                            $vorzeichen2 = '-';
                        }
                        elseif ($pos < 1){
                            $zeichenkette = $count_different;
                            $suchmuster = '/\+/';
                            $ersetzung = '';
                            $count_different = preg_replace($suchmuster, $ersetzung, $zeichenkette);
                            $vorzeichen1 = '-';
                            $vorzeichen2 = '+';

                        }
                        if ($quantity_get_two == 'on') {
                            go_db_query("update " . DB_TBL_ITEMS . " set items_quantity = items_quantity " . $vorzeichen1 . " " . $count_different . ", items_ordered = items_ordered " . $vorzeichen2 . " " . $count_different . " where items_id = '" . $order_items_quantity["items_id"] . "'");
                        }
                    }

                    $Query = "update " . DB_TBL_ORDERS_ITEMS . " set
                        items_model = '" . $items_details["model"] . "',
                        items_name = '" . str_replace("'", "&#39;", $items_details["name"]) . "',
                        items_price = '" . $items_details["items_price"] . "',
                        final_price = '" . $items_details["final_price"] . "',
                        items_basis_price = '" . $items_details["items_basis_price"] . "',
                        items_tax = '" . $items_details["tax"] . "',
                        items_quantity = '" . $items_details["qty"] . "'
                        where orders_items_id = '$orders_items_id';";
                    go_db_query($Query);
                    $RunningSubTotal += $items_details["qty"] * $items_details["final_price"] + $items_details["qty"] * $items_details["items_basis_price"];
                    $tax_title = $tax_rates_array[$items_details["tax"]+0];
                    $tax_value = (($items_details["tax"]/100) * ($items_details["qty"] * $items_details["final_price"] + $items_details["qty"] * $items_details["items_basis_price"]));
                    $RunningTax[$tax_title] += $tax_value;
                    $RunningSubTotal += $tax_value;
                    if(IsSet($items_details[characteristics])) {
                        foreach($items_details["characteristics"] as $orders_items_characteristics_id => $characteristics_details) {
                            $Query = "update " . DB_TBL_ORDERS_ITEMS_CHARACTERISTICS . " set
                                items_options = '" . $characteristics_details["option"] . "',
                                items_options_values = '" . $characteristics_details["value"] . "'
                                where orders_items_characteristics_id = '$orders_items_characteristics_id';";
                            go_db_query($Query);
                        }
                    }
                } else {
                    $Query = "delete from " . DB_TBL_ORDERS_ITEMS . " where orders_items_id = '$orders_items_id';";
                    go_db_query($Query);
                    $Query = "delete from " . DB_TBL_ORDERS_ITEMS_CHARACTERISTICS . " where orders_items_id = '$orders_items_id';";
                    go_db_query($Query);
                }
            }

            $RunningTotal = 0;
            $sort_order = 0;

            foreach ($update_totals as $total_details) {
                extract($total_details,EXTR_PREFIX_ALL,"ot");
                if (trim($ot_title) && trim($ot_value)) {
                    $sort_order++;

                    if($ot_class == "ot_subtotal")
                        $ot_value = $RunningSubTotal;

                    if($ot_class == "ot_total")
                        $ot_value = $RunningTotal;

                    if ($ot_class == "ot_tax")
                        $ot_value = $RunningTax[$ot_title];

                    $ot_text =  $currencies->format($ot_value,false, $order->info['currency']);
                    if($ot_class == "ot_total")
                        $ot_text = "<b>" . $ot_text . "</b>";

                    if ($ot_class == "ot_subtotal" || $ot_class == "ot_shipping")
                        $RunningTotal += $ot_value;

                    if($ot_total_id > 0) {
                        $Query = "update " . DB_TBL_ORDERS_TOTAL . " set
                            title = '$ot_title',
                            text = '$ot_text',
                            value = '$ot_value',
                            sort_order = '$sort_order'
                            where orders_total_id = '$ot_total_id'";
                        go_db_query($Query);
                    } else {
                        if ($ot_class == "ot_tax" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_TAX_STATUS'] != 'true')
next;

if ($ot_class == "ot_subtotal" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_SUBTOTAL_STATUS'] != 'true')
next;

if ($ot_class == "ot_total" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_TOTAL_STATUS'] != 'true')
next;

$Query = "insert into " . DB_TBL_ORDERS_TOTAL . " set
orders_id = '$oID',
title = '$ot_title',
text = '$ot_text',
value = '$ot_value',
class = '$ot_class',
    sort_order = '$sort_order'";
go_db_query($Query);
                    }
                } elseif($ot_total_id > 0) {
                    $Query = "delete from " . DB_TBL_ORDERS_TOTAL . " where orders_total_id = '$ot_total_id'";
                    go_db_query($Query);
                }
            }

            if ($order_updated)
            {
                $messageStack->add_session(SUCCESS_ORDER_UPDATED, 'success');
            }
            go_forward(go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))));
            //NAME_OF_FILE_ORDERS?oID=$oID
        }
        else{
            $messageStack->add_session(ERROR_ORDER_UPDATED, 'error');
            go_forward(go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))));
            //go_forward(go_href_link("main_bigware_17.php", go_get_all_get_parameter(array('action')) . 'action=change'));
        }
        break;
    case 'add_item':
        if($step == 5)
        {
            $oID = go_db_producing_input($_GET['oID']);
            $order = new order($oID);
            $AddedOptionsPrice = 0;
            if(IsSet($add_item_options))
            {
                foreach($add_item_options as $option_id => $option_value_id)
                {
                    $result = go_db_query("SELECT * FROM (((" . DB_TBL_ITEMS_CHARACTERISTICS . " pa) LEFT JOIN " . DB_TBL_ITEMS_OPTIONS . " po ON po.items_options_id=pa.options_id) LEFT JOIN " . DB_TBL_ITEMS_OPTIONS_VALUES . " pov ON pov.items_options_values_id=pa.options_values_id) WHERE items_id='$add_item_items_id' and options_id=$option_id and options_values_id=$option_value_id");
                    $row = go_db_fetch_array($result);
                    extract($row, EXTR_PREFIX_ALL, "opt");
                    $AddedOptionsPrice += $opt_options_values_price;
                    $option_value_details[$option_id][$option_value_id] = array ("options_values_price" => $opt_options_values_price);
                    $option_names[$option_id] = $opt_items_options_name;
                    $option_values_names[$option_value_id] = $opt_items_options_values_name;
                }
            }
            $InfoQuery = "select p.items_model,p.items_price,pd.items_name,p.items_tax_class_id from ((" . DB_TBL_ITEMS . " p) left join " . DB_TBL_ITEMS_DESCRIPTION . " pd on pd.items_id=p.items_id) where p.items_id='$add_item_items_id'";
            $result = go_db_query($InfoQuery);
            $row = go_db_fetch_array($result);
            extract($row, EXTR_PREFIX_ALL, "p");
            $CountryID = go_get_land_id($order->delivery["land"]);
            $ZoneID = go_get_zone_id($CountryID, $order->delivery["state"]);

            $ProductsTax = go_get_tax_rate($p_items_tax_class_id, $CountryID, $ZoneID);
            if ($quantity_get == 'on') {
                go_db_query("update " . DB_TBL_ITEMS . " set items_quantity = items_quantity - " . $add_item_quantity . ", items_ordered = items_ordered + " . $add_item_quantity . " where items_id = '" . $add_item_items_id . "'");
            }
            if ($order->attendee['group_id'] != '0') {
                $specials_query = go_db_query("select specials_new_items_price from " . DB_TBL_SPECIALS . " where items_id = '" . (int)$add_item_items_id . "' and status = '1' and ( date(expires_date) ='0000-00-00' OR expires_date >= now()) ");
                if (go_db_num_rows ($specials_query)) {
                    $specials = go_db_fetch_array($specials_query);
                    $p_items_price = $specials['specials_new_items_price'];
                }else{
                    $attendees_group_query = go_db_query("select * FROM " . DB_TBL_ATTENDEES_GROUPS . " c  where c.attendees_group_id = '" . $order->attendee['group_id'] . "'");
                    $attendees_group = go_db_fetch_array($attendees_group_query);
                    $cInfo = new objectInfo($attendees_group);
                    $payments_unallowed = explode (",",$cInfo->group_payment_unallowed);
                    if (empty( $order->info['payment_method'] ) || !in_array($order->info['payment_method'],$payments_unallowed)){
                        $orders_attendees_price = go_db_query("select attendees_group_price from " . DB_TBL_ITEMS_GROUPS . " where attendees_group_id = '". $order->attendee['group_id'] . "' and items_id = '" . $add_item_items_id. "'");
                        if ($orders_attendees = go_db_fetch_array($orders_attendees_price)) {
                            $p_items_price =  $orders_attendees['attendees_group_price'];
                        }
                    }
                }
            }
            $Query = "insert into " . DB_TBL_ORDERS_ITEMS . " set
                orders_id = $oID,
                items_id = $add_item_items_id,
                items_model = '$p_items_model',
                items_name = '" . str_replace("'", "&#39;", $p_items_name) . "',
                items_price = '$p_items_price',
                items_basis_price = '$p_items_basis_price',
                final_price = '" . ($p_items_price + $AddedOptionsPrice) . "',
                items_tax = '$ProductsTax',
                items_quantity = $add_item_quantity;";
            go_db_query($Query);
            $new_item_id = go_db_insert_id();

            if(IsSet($add_item_options))
            {
                foreach($add_item_options as $option_id => $option_value_id)
                {
                    $Query = "insert into " . DB_TBL_ORDERS_ITEMS_CHARACTERISTICS . " set
                        orders_id = $oID,
                        orders_items_id = $new_item_id,
                        items_options = '" . $option_names[$option_id] . "',
                        items_options_values = '" . $option_values_names[$option_value_id] . "',
                        options_values_price = '" . $option_value_details[$option_id][$option_value_id]["options_values_price"] . "',
                        price_prefix = '+';";
                    go_db_query($Query);
                }
            }
            $order = new order($oID);
            $RunningSubTotal = 0;
            $RunningTax = array();
            for ($i=0; $i<sizeof($order->items); $i++)
            {
                $RunningSubTotal += ($order->items[$i]['qty'] * $order->items[$i]['final_price']) + ($order->items[$i]['qty'] * $order->items[$i]['items_basis_price']);
                $tax_title = $tax_rates_array[$order->items[$i]['tax']+0];
                $tax_value = (($order->items[$i]['tax'] / 100) * ($order->items[$i]['qty'] * $order->items[$i]['final_price'] + $order->items[$i]['qty'] * $order->items[$i]['items_basis_price']));
                $RunningTax[$tax_title] += $tax_value;
                $RunningSubTotal += $tax_value;
            }

            foreach ($RunningTax as $tax_title => $tax_value) {
                $Query = "update " . DB_TBL_ORDERS_TOTAL . " set text = '". $currencies->format($tax_value,false, $order->info['currency']) . "', value = '" . $tax_value . "' where class='ot_tax' and orders_id=$oID and title='" . $tax_title . "'";
                go_db_query($Query);
            }

            $Query = "update " . DB_TBL_ORDERS_TOTAL . " set text = '". $currencies->format($RunningSubTotal,false, $order->info['currency']) . "', value = '" . $RunningSubTotal . "' where class='ot_subtotal' and orders_id=$oID";
            go_db_query($Query);
            $Query = "select sum(value) as total_value from " . DB_TBL_ORDERS_TOTAL . " where class != 'ot_total' and orders_id=$oID";
            $result = go_db_query($Query);
            $row = go_db_fetch_array($result);
            $Total = $row["total_value"];
            $Query = "update " . DB_TBL_ORDERS_TOTAL . " set
                text = '<b>".$currencies->format($Total,false, $order->info['currency']) . "</b>',
                    value = '" . $Total . "'
                    where class='ot_total' and orders_id=$oID";
            go_db_query($Query);
            go_forward(go_href_link("main_bigware_17.php", go_get_all_get_parameter(array('action')) . 'action=change'));
        }
        break;
    }
}
if (($action == 'change') && isset($_GET['oID'])) {
    $oID = go_db_producing_input($_GET['oID']);
    $orders_query = go_db_query("select orders_id from " . DB_TBL_ORDERS . " where orders_id = '" . (int)$oID . "'");
    $order_exists = true;
    if (!go_db_num_rows($orders_query)) {
        $order_exists = false;
        $messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
    }
}
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php
  require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php');
?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
  if (($action == 'change') && ($order_exists == true)) {
    $order = new order($oID);
?>


      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?> #<?php echo $oID; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
            <td class="pageGeneralsign" align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>'; ?></td>
          </tr>
        </table></td>
      </tr>


<!-- Begin Addresses Block -->
      <tr><?php echo go_fetch_form('change_order', "main_bigware_17.php", go_get_all_get_parameter(array('action','paycc')) . 'action=update_order'); ?>
	<td><table width="100%" border="0" cellspacing="0" cellpadding="2">
	  <tr>
	    <td colspan="2"><?php echo go_fetch_dividing_up(); ?></td>
	  </tr>
	  <tr>
	    <td valign="top">
	    <!-- Billing Address Block -->
		<table class="formArea" border="0" cellspacing="0" cellpadding="2">
		<tr class="tbUPCountData">
		<td colspan='2' class="tbUPDataInside" valign="top"><b><?php echo TYPE_IN_BILLING_ADDRESS; ?></b></td>
		</tr>
		<tr class="tbCountData">
		<td colspan='2' class="TbInsideData">
		<input name='update_attendee_name' size='37' value='<?php echo $order->attendee['name']; ?>'><br>
		<input name='update_attendee_street_address' size='37' value='<?php echo $order->attendee['street_address']; ?>'><br>
		<input name='update_attendee_street_address2' size='37' value='<?php echo $order->attendee['street_address2']; ?>'><br>
		<input name='update_attendee_city' size='15' value='<?php echo $order->attendee['city']; ?>'>
		<input name='update_attendee_state' size='10' value='<?php echo $order->attendee['state']; ?>'>
		<input name='update_attendee_postcode' size='5' value='<?php echo $order->attendee['postcode']; ?>'><br>
		<input name='update_attendee_land' size='37' value='<?php echo $order->attendee['land']; ?>'>
		</td>
		</tr>
		</table>
	    </td>
	    <td valign="top">
	    <!-- Shipping Address Block -->
		<table class="formArea" border="0" cellspacing="0" cellpadding="2">
		<tr class="tbUPCountData">
		<td class="tbUPDataInside" valign="top"><b><?php echo TYPE_IN_SHIPPING_ADDRESS; ?></b></td>
		</tr>
		<tr class="tbCountData">
		<td colspan='2' class="TbInsideData">
		<input name='update_delivery_name' size='37' value='<?php echo $order->delivery['name']; ?>'><br>
		<input name='update_delivery_street_address' size='37' value='<?php echo $order->delivery['street_address']; ?>'><br>
		<input name='update_delivery_street_address2' size='37' value='<?php echo $order->delivery['street_address2']; ?>'><br>
		<input name='update_delivery_city' size='15' value='<?php echo $order->delivery['city']; ?>'>
		<input name='update_delivery_state' size='10' value='<?php echo $order->delivery['state']; ?>'>
		<input name='update_delivery_postcode' size='5' value='<?php echo $order->delivery['postcode']; ?>'><br>
		<input name='update_delivery_land' size='37' value='<?php echo $order->delivery['land']; ?>'>
		</td>
		</tr>
		</table>
	    </td>
	  </tr>
	</table></td>
      </tr>
<!-- End Addresses Block -->
      <tr>
	<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
<!-- Begin Phone/Email Block -->
      <tr>
        <td><table class="formArea" border="0" cellspacing="0" cellpadding="2">
        	<tr class="tbUPCountData">
		<td class="tbUPDataInside" valign="top" colspan="4"><b><?php echo TEXT_MEDIA_DATA; ?></b></td>
		</tr>
      		<tr class="tbCountData">
      		  <td colspan='2' class="TbInsideData"><b><?php echo TYPE_IN_TELEPHONE_NUMBER; ?></b></td>
      		  <td colspan='2' class="TbInsideData"><input name='update_attendee_telephone' size='15' value='<?php echo $order->attendee['telephone']; ?>'></td>
      		</tr>
      		<tr>
      		  <td colspan='2' class="TbInsideData"><b><?php echo TYPE_IN_EMAIL_ADDRESS; ?></b></td>
      		  <td colspan='2' class="TbInsideData"><input name='update_attendee_email_address' size='35' value='<?php echo $order->attendee['email_address']; ?>'></td>
      		</tr>
      	</table></td>
      </tr>
<!-- End Phone/Email Block -->

      <tr>
	<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
<!-- Begin Payment Block -->
      <tr>
	<td>



<table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" width="100%" id="AutoNumber1">
  <tr>
    <td>


		<table class="formArea" border="0" cellspacing="0" cellpadding="2">
	  <tr class="tbUPCountData">
            <td class="tbUPDataInside" colspan="4"><?php echo PAYMENTMETHODE; ?></td>
          </tr>
	  <tr class="tbCountData">
	    <td colspan='2' class="TbInsideData"><b><?php echo TYPE_IN_PAYMENT_METHOD; ?></b></td>
	    <td colspan='2' class="TbInsideData">

<?php
	    if($order->info['payment_method'] == "Crchange Card"){
	    	echo TYPE_IN_UPDATE_TO_CC;
?>

	    	<input name='update_info_payment_method' size='20' value='<?php echo $order->info['payment_method']; ?>'>

<?php
			}
			else{
		 			$query = go_db_query("select * from payment_words ORDER BY words DESC");

					$result = $query;
					$standart_there = '0';
						$SelectWordsBox = "<select name='update_info_payment_method'>\n";
						while ($werte = go_db_fetch_array($query)){
							$words = $werte["words"];
							$standart = $werte["standart"];

				 			$SelectWordsBox .= "<option value='" . $words . "'";
				 			if ( $standart == '1'){
								$SelectWordsBox .= " SELECTED ";
								$standart_there = '1';
							}
						  $SelectWordsBox .= ">" . $words . "</option>\n";

						}

						$SelectWordsBox .= "<option value='" . $order->info['payment_method'] . "'";
						if ( $standart_there == '0' ){
							$SelectWordsBox .= " SELECTED ";
						}
						$SelectWordsBox .= ">" . $order->info['payment_method'] . "</option>\n";
						$SelectWordsBox .= "</select>\n";

						echo $SelectWordsBox . '<a href="' . NAME_OF_FILE_INDV_PAYMENTWORD . '">' . SIEHE_HIER . '</a>';
			 }

?>

</td>
	  </tr>
	<?php if ($order->info['cc_type'] || $order->info['cc_owner'] || $order->info['payment_method'] == "Crchange Card" || $order->info['cc_number'] || $order->info['cc_code']) { ?>
	  <!-- Begin Crchange Card Info Block -->
	  <tr class="tbCountData">
	    <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
	  </tr>
	  <tr class="tbCountData">
	    <td class="TbInsideData"><?php echo TYPE_IN_CRCHANGE_CARD_TYPE; ?></td>
	    <td class="TbInsideData"><input name='update_info_cc_type' size='10' value='<?php echo $order->info['cc_type']; ?>'></td>
	  </tr>
	  <tr class="tbCountData">
	    <td class="TbInsideData"><?php echo TYPE_IN_CRCHANGE_CARD_OWNER; ?></td>
	    <td class="TbInsideData"><input name='update_info_cc_owner' size='20' value='<?php echo $order->info['cc_owner']; ?>'></td>
	  </tr>
	  <tr class="tbCountData">
	    <td class="TbInsideData"><?php echo TYPE_IN_CRCHANGE_CARD_NUMBER; ?></td>
	    <td class="TbInsideData"><input name='update_info_cc_number' size='20' value='<?php echo "(Last 4) " . substr($order->info['cc_number'],-4); ?>'></td>
	  </tr>
	  <tr class="tbCountData">
	    <td class="TbInsideData"><?php echo TYPE_IN_CRCHANGE_CARD_CODE; ?></td>
	    <td class="TbInsideData"><input name='update_info_cc_code' size='4' value='xxxx'></td>
	  </tr>
	  <tr class="tbCountData">
	    <td class="TbInsideData"><?php echo TYPE_IN_CRCHANGE_CARD_EXPIRES; ?></td>
	    <td class="TbInsideData"><input name='update_info_cc_expires' size='4' value='<?php echo $order->info['cc_expires']; ?>'></td>
	  </tr>
	  <!-- End Crchange Card Info Block -->
	<?php } ?>
	</table>



</td>
<td>



<table class="formArea" border="0" cellspacing="0" cellpadding="2">
	  <tr class="tbUPCountData">
            <td class="tbUPDataInside" colspan="4"><?php echo SHIPPINGMETHODE; ?></td>
          </tr>
	  <tr class="tbCountData">
	    <td colspan='2' class="TbInsideData"><b><?php echo TYPE_IN_SHIPPING_METHOD; ?></b></td>
	    <td colspan='2' class="TbInsideData">
<?php
 			$query = go_db_query("select * from shipping_words ORDER BY words DESC");

			$result = $query;
			$standart_there = '0';
				$SelectWordsBox = "<select name='update_info_shipping_method'>\n";
				while ($werte = go_db_fetch_array($query)){
					$words = $werte["words"];
					$standart = $werte["standart"];

		 			$SelectWordsBox .= "<option value='" . $words . "'";
		 			if ( $standart == '1'){
						$SelectWordsBox .= " SELECTED ";
						$standart_there = '1';
					}
				  $SelectWordsBox .= ">" . $words . "</option>\n";

				}

				$SelectWordsBox .= "<option value='" . $order->info['shipping_method'] . "'";
				if ( $standart_there == '0' ){
					$SelectWordsBox .= " SELECTED ";
				}
				$SelectWordsBox .= ">" . $order->info['shipping_method'] . "</option>\n";
				$SelectWordsBox .= "</select>\n";

				echo $SelectWordsBox . '<a href="' . NAME_OF_FILE_INDV_VERSANDWORT . '">' . SIEHE_HIER . '</a>';


?>

	    </td>
	  </tr>
	</table>

</td>
  </tr>
</table>


	</td>
      </tr>
<!-- End Payment Block -->

      <tr>
	<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
<!-- Begin Products Listing Block -->
      <tr>
	<td><table class="formArea" border="0" width="100%" cellspacing="0" cellpadding="2">
	  <tr class="tbUPCountData">
	    <td class="tbUPDataInside" colspan="2"><?php echo DB_TBL_ABOVE_ITEMS; ?></td>
	    <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_ITEMS_MODEL; ?></td>
	    <td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_TAX; ?></td>
	    <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_UNIT_PRICE; ?></td>
	    <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_TOTAL_PRICE; ?></td>
	  </tr>
	<!-- Begin Products Listings Block -->
	<?php
		$index = 0;
		$order->items = array();
		$orders_items_query = go_db_query("select * from " . DB_TBL_ORDERS_ITEMS . " where orders_id = '" . (int)$oID . "'");
		while ($orders_items = go_db_fetch_array($orders_items_query)) {
		$order->items[$index] = array('qty' => $orders_items['items_quantity'],
                                        'name' => str_replace("'", "&#39;", $orders_items['items_name']),
                                        'model' => $orders_items['items_model'],
                                        'tax' => $orders_items['items_tax'],
                                        'price' => $orders_items['items_price'],
                                        'items_basis_price' => $orders_items['items_basis_price'],
                                        'final_price' => $orders_items['final_price'],
                                        'orders_items_id' => $orders_items['orders_items_id']);
		$subindex = 0;
		$characteristics_query_string = "select * from " . DB_TBL_ORDERS_ITEMS_CHARACTERISTICS . " where orders_id = '" . (int)$oID . "' and orders_items_id = '" . (int)$orders_items['orders_items_id'] . "'";
		$characteristics_query = go_db_query($characteristics_query_string);
		if (go_db_num_rows($characteristics_query)) {
		while ($characteristics = go_db_fetch_array($characteristics_query)) {
		  $order->items[$index]['characteristics'][$subindex] = array('option' => $characteristics['items_options'],
		                                                           'value' => $characteristics['items_options_values'],
		                                                           'prefix' => $characteristics['price_prefix'],
		                                                           'price' => $characteristics['options_values_price'],
		                                                           'orders_items_characteristics_id' => $characteristics['orders_items_characteristics_id']);
		$subindex++;
		}
		}
		$index++;
		}

	for ($i=0; $i<sizeof($order->items); $i++) {
		$orders_items_id = $order->items[$i]['orders_items_id'];

		$RowStyle = "TbInsideData";

		echo '	  <tr class="tbCountData">' . "\n" .
		   '	    <td class="' . $RowStyle . '" valign="top" align="right">' . "<input name='update_items[$orders_items_id][qty]' size='2' value='" . $order->items[$i]['qty'] . "'>&nbsp;x</td>\n" .
		   '	    <td class="' . $RowStyle . '" valign="top">' . "<input name='update_items[$orders_items_id][name]' size='25' value='" . $order->items[$i]['name'] . "'>";
		if (sizeof($order->items[$i]['characteristics']) > 0) {
			for ($j=0; $j<sizeof($order->items[$i]['characteristics']); $j++) {
				$orders_items_characteristics_id = $order->items[$i]['characteristics'][$j]['orders_items_characteristics_id'];
				echo '<br><nobr><small>&nbsp;<i> - ' . "<input name='update_items[$orders_items_id][characteristics][$orders_items_characteristics_id][option]' size='6' value='" . $order->items[$i]['characteristics'][$j]['option'] . "'>" . ': ' . "<input name='update_items[$orders_items_id][characteristics][$orders_items_characteristics_id][value]' size='10' value='" . $order->items[$i]['characteristics'][$j]['value'] . "'>";
				echo '</i></small></nobr>';
			}
		}

		echo '	    </td>' . "\n" .
		     '	    <td class="' . $RowStyle . '" valign="top">' . "<input name='update_items[$orders_items_id][model]' size='12' value='" . $order->items[$i]['model'] . "'>" . '</td>' . "\n" .
		     '	    <td class="' . $RowStyle . '" align="center" valign="top">' . "<input name='update_items[$orders_items_id][tax]' size='3' value='" . go_display_tax_value($order->items[$i]['tax']) . "'>" . '%</td>' . "\n" .
		     '	    <td class="' . $RowStyle . '" align="right" valign="top">' . "<input name='update_items[$orders_items_id][final_price]' size='5' value='" . number_format($order->items[$i]['final_price'], 2, '.', '') . "'>" . '</td>' . "\n" .
		     '	    <td class="' . $RowStyle . '" align="right" valign="top">' . $currencies->format($order->items[$i]['final_price'] * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</td>' . "\n" .
		     '	  </tr>' . "\n";
	}
	?>
	<!-- End Products Listings Block -->
	<!-- Begin Order Total Block -->
	  <tr>
	    <td align="right" colspan="6">
	    	<table border="0" cellspacing="0" cellpadding="2" width="100%">
	    	<tr>
	    	<td align='center' valign='top'><br><a href="<?php print $PHP_SELF . "?oID=$oID&action=add_item&step=1"; ?>"><u><b><font size='3'><?php echo TEXT_CLICK_ITEM_ADD; ?></font></b></u></a></td>
	    	<td align='right'>
	    	<table border="0" cellspacing="0" cellpadding="2">
<?php
        $totals_query = go_db_query("select * from " . DB_TBL_ORDERS_TOTAL . " where orders_id = '" . (int)$oID . "' order by sort_order");
        $order->totals = array();
        while ($totals = go_db_fetch_array($totals_query)) { $order->totals[] = array('title' => $totals['title'], 'text' => $totals['text'], 'class' => $totals['class'], 'value' => $totals['value'], 'orders_total_id' => $totals['orders_total_id']); }

        $TotalsArray = array();
        for ($i=0; $i<sizeof($order->totals); $i++) {
            $TotalsArray[] = array("Name" => $order->totals[$i]['title'], "Price" => number_format($order->totals[$i]['value'], 2, '.', ''), "Class" => $order->totals[$i]['class'], "TotalID" => $order->totals[$i]['orders_total_id']);
            $TotalsArray[] = array("Name" => "          ", "Price" => "", "Class" => "ot_custom", "TotalID" => "0");
        }

        array_pop($TotalsArray);
        foreach($TotalsArray as $TotalIndex => $TotalDetails)
        {

            $ot_class = $TotalDetails["Class"];

            if ($ot_class == "ot_tax" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_TAX_STATUS'] != 'true')
next;

if ($ot_class == "ot_subtotal" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_SUBTOTAL_STATUS'] != 'true')
next;

if ($ot_class == "ot_total" && $order_total_modules_array['CONSTITUENT_ORDER_TOTAL_TOTAL_STATUS'] != 'true')
next;

$TotalStyle = "smallText";
if(($ot_class == "ot_subtotal") || ($ot_class == "ot_tax") || ($ot_class == "ot_total"))
{
    echo	'	      <tr>' . "\n" .
        '		<td class="main" align="right"><b>' . $TotalDetails["Name"] . '</b></td>' .
        '		<td class="main"><b>' . $TotalDetails["Price"] .
        "<input name='update_totals[$TotalIndex][title]' type='hidden' value='" . trim($TotalDetails["Name"]) . "' size='" . strlen($TotalDetails["Name"]) . "' >" .
        "<input name='update_totals[$TotalIndex][value]' type='hidden' value='" . $TotalDetails["Price"] . "' size='6' >" .
        "<input name='update_totals[$TotalIndex][class]' type='hidden' value='" . $TotalDetails["Class"] . "'>\n" .
        "<input type='hidden' name='update_totals[$TotalIndex][total_id]' value='" . $TotalDetails["TotalID"] . "'>" . '</b></td>' .
        '	      </tr>' . "\n";
}
else
{
    echo	'	      <tr>' . "\n" .
        '		<td align="right" class="' . $TotalStyle . '">' . "<input name='update_totals[$TotalIndex][title]' size='" . strlen(trim($TotalDetails["Name"])) . "' value='" . trim($TotalDetails["Name"]) . "'>" . '</td>' . "\n" .
        '		<td align="right" class="' . $TotalStyle . '">' . "<input name='update_totals[$TotalIndex][value]' size='6' value='" . $TotalDetails["Price"] . "'>" .
        "<input type='hidden' name='update_totals[$TotalIndex][class]' value='" . $TotalDetails["Class"] . "'>" .
        "<input type='hidden' name='update_totals[$TotalIndex][total_id]' value='" . $TotalDetails["TotalID"] . "'>" .
        '</td>' . "\n" .
        '	      </tr>' . "\n";
}
        }
?>
	    	</table>
	    	</td>
	    	</tr>
	    	</table>
	    </td>
	  </tr>
	<!-- End Order Total Block -->
	</table></td>
      </tr>

      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="main"><table border="1" cellspacing="0" cellpadding="5">
          <tr class="tbUPCountData">
            <td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_DATE_ADDED; ?></b></td>
            <td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_ATTENDEE_NOTIFIED; ?></b></td>
            <td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_STATUS; ?></b></td>
            <?php if($CommentsWithStatus) { ?>
            <td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_COMMENTS; ?></b></td>
            <?php } ?>
          </tr>
<?php
    $orders_history_query = go_db_query("select * from " . DB_TBL_ORDERS_STATUS_HISTORY . " where orders_id = '" . go_db_input($oID) . "' order by date_added");
    if (go_db_num_rows($orders_history_query)) {
      while ($orders_history = go_db_fetch_array($orders_history_query)) {
        echo '          <tr class="tbCountData">' . "\n" .
             '            <td class="TbInsideData" align="center">' . go_datetime_short($orders_history['date_added']) . '</td>' . "\n" .
             '            <td class="TbInsideData" align="center">';
        if ($orders_history['attendee_notified'] == '1') {
          echo go_picture(FOLDER_RELATIV_ICONS . 'tick.gif', ICON_TICK) . "</td>\n";
        } else {
          echo go_picture(FOLDER_RELATIV_ICONS . 'cross.gif', ICON_CROSS) . "</td>\n";
        }
        echo '            <td class="TbInsideData">' . $orders_status_array[$orders_history['orders_status_id']] . '</td>' . "\n";

        if($CommentsWithStatus) {
        echo '            <td class="TbInsideData">' . nl2br(go_db_output($orders_history['comments'])) . '&nbsp;</td>' . "\n";
        }

        echo '          </tr>' . "\n";
      }
    } else {
        echo '          <tr>' . "\n" .
             '            <td class="TbInsideData"" colspan="5">' . TEXT_NO_ORDER_HISTORY . '</td>' . "\n" .
             '          </tr>' . "\n";
    }
?>
        </table></td>
      </tr>
      <tr>
        <td class="main"><br><b><?php echo DB_TBL_ABOVE_COMMENTS; ?></b></td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '5'); ?></td>
      </tr>
      <tr>
        <td class="main">
        <?php
        if($CommentsWithStatus) {
        	echo go_fetch_textarea_field('comments', 'soft', '60', '5');
	}
	else
	{
		echo go_fetch_textarea_field('comments', 'soft', '60', '5', $order->info['comments']);
	}
	?>
        </td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td><table border="0" cellspacing="0" cellpadding="2">
          <tr>
            <td class="main"><b><?php echo TYPE_IN_STATUS; ?></b> <?php echo go_fetch_pull_down_menu('status', $orders_statuses, $order->info['orders_status']); ?></td>
          </tr>
          <tr>
            <td class="main"><b><?php echo TYPE_IN_NOTIFY_ATTENDEE; ?></b> <?php echo go_fetch_checkbox_field('notify', '', false); ?></td>
          </tr>
          <?php if($CommentsWithStatus) { ?>
          <tr>
                <td class="main"><b><?php echo TYPE_IN_NOTIFY_COMMENTS; ?></b> <?php echo go_fetch_checkbox_field('notify_comments', '', false); ?></td>
          </tr>
          <?php } ?>
          <tr>
                <td class="main"><b><?php echo TEXT_INFO_ITEM_QUANTITY; ?></b> <?php echo go_fetch_checkbox_field('quantity_get_two', '', true); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
	<td align='center' valign="top"><?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?></td>
      </tr>
      </form>
<?php
  }

if($action == "add_item")
{
?>
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ADDING_TITLE; ?> #<?php echo $oID; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
            <td class="pageGeneralsign" align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>'; ?></td>
          </tr>
        </table></td>
      </tr>
<?php
        $categories_id = go_db_producing_input(0);
        $categories = go_get_category_tree($categories_id, '', '0', '', true);
		$query = "SELECT items_name, p.items_id, categories_name, ptc.categories_id FROM ((((" . DB_TBL_ITEMS . " p) LEFT JOIN " . DB_TBL_ITEMS_DESCRIPTION . " pd ON pd.items_id=p.items_id) LEFT JOIN " . DB_TBL_ITEMS_TO_CATEGORIES . " ptc ON ptc.items_id=p.items_id) LEFT JOIN " . DB_TBL_CATEGORIES_DESCRIPTION . " cd ON cd.categories_id=ptc.categories_id) WHERE pd.language_id = '".(int)$languages_id."' AND cd.language_id = '".(int)$languages_id."' ORDER BY categories_name";
        error_log($query);
		$result = go_db_query($query);
		while($row = go_db_fetch_array($result)) {
			extract($row,EXTR_PREFIX_ALL,"db");
			if (empty($db_items_name))
				$db_items_name = "no item name given";
			if (empty($db_categories_name))
				$db_categories_name = "no category name given";
			$ProductList[$db_categories_id][$db_items_id] = $db_items_name;
			$CategoryList[$db_categories_id] = $db_categories_name;
			$LastCategory = $db_categories_name;
		}
		$LastOptionTag = "";
		$ProductSelectOptions = "<option value='0'>" . TEXT_DONT_ADD_ITEM . $LastOptionTag . "\n";
		$ProductSelectOptions .= "<option value='0'>&nbsp;" . $LastOptionTag . "\n";
		foreach($ProductList as $Category => $Products) {
			$ProductSelectOptions .= "<option value='0'>$Category" . $LastOptionTag . "\n";
			$ProductSelectOptions .= "<option value='0'>---------------------------" . $LastOptionTag . "\n";
			asort($Products);
			foreach($Products as $Product_ID => $Product_Name) {
				$ProductSelectOptions .= "<option value='$Product_ID'> &nbsp; $Product_Name" . $LastOptionTag . "\n";
			}
			if($Category != $LastCategory) {
				$ProductSelectOptions .= "<option value='0'>&nbsp;" . $LastOptionTag . "\n";
				$ProductSelectOptions .= "<option value='0'>&nbsp;" . $LastOptionTag . "\n";
			}
		}
		print "<tr><td><table class='formArea' border='0'><tr><td class='TbInsideData' colspan='3'><b>" . SECOND_OBEN . "</b><br><br></td></tr>\n";
			if(!IsSet($add_item_categories_id))
			$add_item_categories_id = 0;
			if(!IsSet($add_item_items_id))
			$add_item_items_id = 0;
			print "<tr><form action='$PHP_SELF?oID=$oID&action=$action' method='POST'>\n";
			print "<td class='TbInsideData' align='right'><b>" . STEP_ONE . ":</b></td><td class='TbInsideData' valign='top'><select name='add_item_categories_id'>";
			$CategoryOptions = "<option value='0'>" . KATEGORIE_WAEHLEN . "\n";
            $count = count($categories);
            for ($i = 1; $i < $count; $i++) {
                $CategoryID = $categories[$i]['id'];
                $CategoryName = $categories[$i]['text'];
				$CategoryOptions .= "<option value='$CategoryID'> $CategoryName\n";
			}
			$CategoryOptions = str_replace("value='$add_item_categories_id'","value='$add_item_categories_id' selected", $CategoryOptions);
			print $CategoryOptions;
			print "</select></td>\n";
			print "<td class='TbInsideData' align='center'><input type='submit' value='" . KATEGORIE_BUTTON . "'>";
			print "<input type='hidden' name='step' value='2'>";
			print "</td>\n";
			print "</form></tr>\n";
			print "<tr><td colspan='3'>&nbsp;</td></tr>\n";
		if(($step > 1) && ($add_item_categories_id > 0)) {
			print "<tr><form action='$PHP_SELF?oID=$oID&action=$action' method='POST'>\n";
			print "<td class='TbInsideData' align='right'><b>" . STEP_TWO . ":</b></td><td class='TbInsideData' valign='top'><select name='add_item_items_id'>";
			$ProductOptions = "<option value='0'>" . ITEM_WAEHLEN . "\n";
			asort($ProductList[$add_item_categories_id]);
			foreach($ProductList[$add_item_categories_id] as $ProductID => $ProductName) {
				$ProductOptions .= "<option value='$ProductID'> $ProductName\n";
			}
			$ProductOptions = str_replace("value='$add_item_items_id'","value='$add_item_items_id' selected", $ProductOptions);
			print $ProductOptions;
			print "</select></td>\n";
			print "<td class='TbInsideData' align='center'><input type='submit' value='" . PRODUKT_BUTTON . "'>";
			print "<input type='hidden' name='add_item_categories_id' value='$add_item_categories_id'>";
			print "<input type='hidden' name='step' value='3'>";
			print "</td>\n";
			print "</form></tr>\n";
			print "<tr><td colspan='3'>&nbsp;</td></tr>\n";
		}
		if(($step > 2) && ($add_item_items_id > 0))
		{
			$result = go_db_query("SELECT * FROM (((" . DB_TBL_ITEMS_CHARACTERISTICS . " pa) LEFT JOIN " . DB_TBL_ITEMS_OPTIONS . " po ON po.items_options_id=pa.options_id) LEFT JOIN " . DB_TBL_ITEMS_OPTIONS_VALUES . " pov ON pov.items_options_values_id=pa.options_values_id) WHERE items_id='$add_item_items_id'");
			if(go_db_num_rows($result) == 0)
			{
				print "<tr>\n";
				print "<td class='TbInsideData' align='right'><b>" . STEP_THREE . ":</b></td><td class='TbInsideData' valign='top' colspan='2'><i>" . NO_OPTONS . "</i></td>";
				print "</tr>\n";
				$step = 4;
			}
			else
			{
				while($row = go_db_fetch_array($result))
				{
					extract($row,EXTR_PREFIX_ALL,"db");
					$Options[$db_items_options_id] = $db_items_options_name;
					$ProductOptionValues[$db_items_options_id][$db_items_options_values_id] = $db_items_options_values_name;
				}

				print "<tr><form action='$PHP_SELF?oID=$oID&action=$action' method='POST'>\n";
				print "<td class='TbInsideData' align='right'><b>" . STEP_THREE . ":</b></td><td class='TbInsideData' valign='top'>";
				foreach($ProductOptionValues as $OptionID => $OptionValues)
				{
					$OptionOption = "<b>" . $Options[$OptionID] . "</b> - <select name='add_item_options[$OptionID]'>";
					foreach($OptionValues as $OptionValueID => $OptionValueName)
					{
					$OptionOption .= "<option value='$OptionValueID'> $OptionValueName\n";
					}
					$OptionOption .= "</select><br>\n";

					if(IsSet($add_item_options))
					$OptionOption = str_replace("value='" . $add_item_options[$OptionID] . "'","value='" . $add_item_options[$OptionID] . "' selected",$OptionOption);

					print $OptionOption;
				}
				print "</td>";
				print "<td class='TbInsideData' align='center'><input type='submit' value='" . MERMALE_BUTTON . "'>";
				print "<input type='hidden' name='add_item_categories_id' value='$add_item_categories_id'>";
				print "<input type='hidden' name='add_item_items_id' value='$add_item_items_id'>";
				print "<input type='hidden' name='step' value='4'>";
				print "</td>\n";
				print "</form></tr>\n";
			}
			print "<tr><td colspan='3'>&nbsp;</td></tr>\n";
		}
		if($step > 3)
		{
			print "<tr><form action='$PHP_SELF?oID=$oID&action=$action' method='POST'>\n";
			print "<td class='TbInsideData' align='right' valign='top'><b>" . STEP_FOUR . ":</b></td>";
			print "<td class='TbInsideData' valign='top'><input name='add_item_quantity' size='2' value='1'>" . STEP_ANZAHL . "<br><br>" .  go_fetch_checkbox_field('quantity_get', '', true) . TEXT_INFO_ITEM_QUANTITY_STEPS . "</td>";
			print "<td class='TbInsideData' align='center' valign='bottom'><input type='submit' value='" . ADD_NOW . "'>";
			if(IsSet($add_item_options))
			{
				foreach($add_item_options as $option_id => $option_value_id)
				{
					print "<input type='hidden' name='add_item_options[$option_id]' value='$option_value_id'>";
				}
			}
			print "<input type='hidden' name='add_item_categories_id' value='$add_item_categories_id'>";
			print "<input type='hidden' name='add_item_items_id' value='$add_item_items_id'>";
			print "<input type='hidden' name='step' value='5'>";
			print "</td>\n";
			print "</form></tr>\n";
		}

		print "</table></td></tr>\n";
}
?>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php
  function go_get_land_id($land_name) {
    $land_id_query = go_db_query("select * from " . DB_TBL_LANDS . " where lands_name = '" . $land_name . "'");
    if (!go_db_num_rows($land_id_query)) {
      return 0;
    }
    else {
      $land_id_row = go_db_fetch_array($land_id_query);
      return $land_id_row['lands_id'];
    }
  }
  function go_get_land_iso_code_2($land_id) {
    $land_iso_query = go_db_query("select * from " . DB_TBL_LANDS . " where lands_id = '" . $land_id . "'");
    if (!go_db_num_rows($land_iso_query)) {
      return 0;
    }
    else {
      $land_iso_row = go_db_fetch_array($land_iso_query);
      return $land_iso_row['lands_iso_code_2'];
    }
  }
  function go_get_zone_id($land_id, $zone_name) {
    $zone_id_query = go_db_query("select * from " . DB_TBL_ZONES . " where zone_land_id = '" . $land_id . "' and zone_name = '" . $zone_name . "'");
    if (!go_db_num_rows($zone_id_query)) {
      return 0;
    }
    else {
      $zone_id_row = go_db_fetch_array($zone_id_query);
      return $zone_id_row['zone_id'];
    }
  }
  function go_field_exists($table,$field) {
    $describe_query = go_db_query("describe $table");
    while($d_row = go_db_fetch_array($describe_query))
    {
      if ($d_row["Field"] == "$field")
      return true;
    }
    return false;
  }

?>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
