<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  $error = false;
  $processed = false;
  if (go_not_null($action)) {
    switch ($action) {
      case 'update':
        $attendees_id = go_db_producing_input($_GET['bigID']);
        $attendees_firstname = go_db_producing_input($_POST['attendees_firstname']);
        $attendees_lastname = go_db_producing_input($_POST['attendees_lastname']);
        $attendees_email_address = go_db_producing_input($_POST['attendees_email_address']);
        $attendees_telephone = go_db_producing_input($_POST['attendees_telephone']);
        $attendees_fax = go_db_producing_input($_POST['attendees_fax']);
        $attendees_newsletter = go_db_producing_input($_POST['attendees_newsletter']); 
		$multiple_groups_query = go_db_query("select distinct attendees_group_id from " . DB_TBL_ITEMS_GROUPS . " ");
		while ($group_ids = go_db_fetch_array($multiple_groups_query)) {
			$multiple_attendees_query = go_db_query("select distinct attendees_group_id from " . DB_TBL_ATTENDEES_GROUPS . " where attendees_group_id = " . $group_ids['attendees_group_id'] . " ");
			if (!($multiple_groups = go_db_fetch_array($multiple_attendees_query))) {
				go_db_query("delete from " . DB_TBL_ITEMS_GROUPS . " where attendees_group_id = '" . $group_ids['attendees_group_id'] . "'");
			}
		}
		$attendees_group_name = go_db_producing_input($_POST['attendees_group_name']);
		$attendees_group_name_query = go_db_query("select distinct attendees_group_name, attendees_group_id from " . DB_TBL_ATTENDEES_GROUPS . " order by attendees_group_id");
		$group_name_check = go_db_fetch_array($attendees_group_name_query); 
        $attendees_gender = go_db_producing_input($_POST['attendees_gender']);
        $attendees_invoice = go_db_producing_input($_POST['attendees_invoice']);
        $attendees_dob = go_db_producing_input($_POST['attendees_dob']);
        $default_address_id = go_db_producing_input($_POST['default_address_id']);
        $entry_street_address = go_db_producing_input($_POST['entry_street_address']);
        $entry_suburb = go_db_producing_input($_POST['entry_suburb']);
        $entry_postcode = go_db_producing_input($_POST['entry_postcode']);
        $entry_city = go_db_producing_input($_POST['entry_city']);
        $entry_land_id = go_db_producing_input($_POST['entry_land_id']);
        $entry_company = go_db_producing_input($_POST['entry_company']); 
		$entry_piva = go_db_producing_input($_POST['entry_piva']);//PIVACF VAT 
		$entry_cf = go_db_producing_input($_POST['entry_cf']);//PIVACF VAT 
        $entry_state = go_db_producing_input($_POST['entry_state']);
        if (isset($_POST['entry_zone_id'])) $entry_zone_id = go_db_producing_input($_POST['entry_zone_id']);
        if (strlen($attendees_firstname) < TYPE_IN_FIRST_NAME_MIN_LENGTH) {
          $error = true;
          $entry_firstname_error = true;
        } else {
          $entry_firstname_error = false;
        }
        if (strlen($attendees_lastname) < TYPE_IN_LAST_NAME_MIN_LENGTH) {
          $error = true;
          $entry_lastname_error = true;
        } else {
          $entry_lastname_error = false;
        }
        if (MEMBER_DOB_REQ == 'true') {
          if (checkdate(substr(go_date_raw($attendees_dob), 4, 2), substr(go_date_raw($attendees_dob), 6, 2), substr(go_date_raw($attendees_dob), 0, 4))) {
            $entry_date_of_birth_error = false;
          } else {
            $error = true;
            $entry_date_of_birth_error = true;
          }
        }
        if (strlen($attendees_email_address) < TYPE_IN_EMAIL_ADDRESS_MIN_LENGTH) {
          $error = true;
          $entry_email_address_error = true;
        } else {
          $entry_email_address_error = false;
        }
        if (!go_validate_email($attendees_email_address)) {
          $error = true;
          $entry_email_address_check_error = true;
        } else {
          $entry_email_address_check_error = false;
        }
        if (strlen($entry_street_address) < TYPE_IN_STREET_ADDRESS_MIN_LENGTH) {
          $error = true;
          $entry_street_address_error = true;
        } else {
          $entry_street_address_error = false;
        }
        if (strlen($entry_postcode) < TYPE_IN_POSTCODE_MIN_LENGTH) {
          $error = true;
          $entry_post_code_error = true;
        } else {
          $entry_post_code_error = false;
        }
        if (strlen($entry_city) < TYPE_IN_CITY_MIN_LENGTH) {
          $error = true;
          $entry_city_error = true;
        } else {
          $entry_city_error = false;
        }
        if ($entry_land_id == false) {
          $error = true;
          $entry_land_error = true;
        } else {
          $entry_land_error = false;
        }
        if (MEMBER_STATE_REQ == 'true') {
          if ($entry_land_error == true) {
            $entry_state_error = true;
          } else {
            $zone_id = 0;
            $entry_state_error = false;
            $check_query = go_db_query("select count(*) as total from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$entry_land_id . "'");
            $check_value = go_db_fetch_array($check_query);
            $entry_state_has_zones = ($check_value['total'] > 0);
            if ($entry_state_has_zones == true) {
              $zone_query = go_db_query("select zone_id from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$entry_land_id . "' and zone_name = '" . go_db_input($entry_state) . "'");
              if (go_db_num_rows($zone_query) == 1) {
                $zone_values = go_db_fetch_array($zone_query);
                $entry_zone_id = $zone_values['zone_id'];
              } else {
                $error = true;
                $entry_state_error = true;
              }
            } else {
              if ($entry_state == false) {
                $error = true;
                $entry_state_error = true;
              }
            }
         }
      }
      if (MEMBER_TEL_REQ == 'true' && strlen($attendees_telephone) < TYPE_IN_TELEPHONE_MIN_LENGTH) {
        $error = true;
        $entry_telephone_error = true;
      } else {
        $entry_telephone_error = false;
      }
      $check_email = go_db_query("select attendees_email_address from " . DB_TBL_ATTENDEES . " where attendees_email_address = '" . go_db_input($attendees_email_address) . "' and attendees_id != '" . (int)$attendees_id . "'");
      if (go_db_num_rows($check_email)) {
        $error = true;
        $entry_email_address_exists = true;
      } else {
        $entry_email_address_exists = false;
      }
      if ($error == false) { 
        $sql_data_array = array('attendees_firstname' => $attendees_firstname,
                                'attendees_lastname' => $attendees_lastname,
                                'attendees_email_address' => $attendees_email_address,
                                'attendees_telephone' => $attendees_telephone,
                                'attendees_fax' => $attendees_fax,
                                'attendees_invoice' => $attendees_invoice,
                                'attendees_newsletter' => $attendees_newsletter,
								'attendees_group_id' => $attendees_group_id); 
        if (MEMBER_GENDER == 'true') $sql_data_array['attendees_gender'] = $attendees_gender;
        if (MEMBER_DOB == 'true') $sql_data_array['attendees_dob'] = go_date_raw($attendees_dob);
        go_db_carry(DB_TBL_ATTENDEES, $sql_data_array, 'update', "attendees_id = '" . (int)$attendees_id . "'");
        go_db_query("update " . DB_TBL_ATTENDEES_INFO . " set attendees_info_date_member_last_modified = now() where attendees_info_id = '" . (int)$attendees_id . "'");
        if ($entry_zone_id > 0) $entry_state = '';
        $sql_data_array = array('entry_firstname' => $attendees_firstname,
                                'entry_lastname' => $attendees_lastname,
                                'entry_street_address' => $entry_street_address,
                                'entry_postcode' => $entry_postcode,
                                'entry_city' => $entry_city,
                                'entry_land_id' => $entry_land_id);
        if (MEMBER_COMPANY == 'true') $sql_data_array['entry_company'] = $entry_company; 
		if (MEMBER_PIVA == 'true') $sql_data_array['entry_piva'] = $entry_piva;//PIVACF start
		if (MEMBER_CF == 'true') $sql_data_array['entry_cf'] = $entry_cf;//PIVACF end 
        if (MEMBER_SUBURB == 'true') $sql_data_array['entry_suburb'] = $entry_suburb;
        if (MEMBER_STATE == 'true') {
          if ($entry_zone_id > 0) {
            $sql_data_array['entry_zone_id'] = $entry_zone_id;
            $sql_data_array['entry_state'] = '';
          } else {
            $sql_data_array['entry_zone_id'] = '0';
            $sql_data_array['entry_state'] = $entry_state;
          }
        }
        go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array, 'update', "attendees_id = '" . (int)$attendees_id . "' and directory_to_address_id = '" . (int)$default_address_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $attendees_id));
        } else if ($error == true) {
          $bigwareInfo = new objectInfo($_POST);
          $processed = true;
        }
        break;
      case 'deleteconfirm':
        $attendees_id = go_db_producing_input($_GET['bigID']);
        if (isset($_POST['delete_reviews']) && ($_POST['delete_reviews'] == 'on')) {
          $reviews_query = go_db_query("select reviews_id from " . DB_TBL_REVIEWS . " where attendees_id = '" . (int)$attendees_id . "'");
          while ($reviews = go_db_fetch_array($reviews_query)) {
            go_db_query("delete from " . DB_TBL_REVIERELATIV_DESCRIPTION . " where reviews_id = '" . (int)$reviews['reviews_id'] . "'");
          }
          go_db_query("delete from " . DB_TBL_REVIEWS . " where attendees_id = '" . (int)$attendees_id . "'");
        } else {
          go_db_query("update " . DB_TBL_REVIEWS . " set attendees_id = null where attendees_id = '" . (int)$attendees_id . "'");
        }
        go_db_query("delete from " . DB_TBL_DIRECTORY_TO_ADDRESS . " where attendees_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_ATTENDEES . " where attendees_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_ATTENDEES_INFO . " where attendees_info_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where attendees_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_WHOS_ONLINE . " where attendee_id = '" . (int)$attendees_id . "'");
        go_db_query("delete from " . DB_TBL_SOURCES_OTHER . " where attendees_id = '" . (int)$attendees_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action'))));
        break;
      default:  
        //echo "select c.attendees_id, c.attendees_gender, c.attendees_invoice, c.attendees_firstname, c.attendees_lastname, c.attendees_dob, c.attendees_email_address, a.entry_company, a.entry_piva, a.entry_cf, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_land_id, c.attendees_telephone, c.attendees_fax, c.attendees_newsletter, c.attendees_group_id, c.attendees_default_address_id from ((" . DB_TBL_ATTENDEES . " c) left join " . DB_TBL_DIRECTORY_TO_ADDRESS . " a on c.attendees_default_address_id = a.directory_to_address_id) where a.attendees_id = c.attendees_id and c.attendees_id = '" . (int)$_GET['bigID'] . "'";
        $attendees_query = go_db_query("select c.attendees_id, c.attendees_gender, c.attendees_invoice, c.attendees_firstname, c.attendees_lastname, c.attendees_dob, c.attendees_email_address, a.entry_company, a.entry_piva, a.entry_cf, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_land_id, c.attendees_telephone, c.attendees_fax, c.attendees_newsletter, c.attendees_group_id, c.attendees_default_address_id from ((" . DB_TBL_ATTENDEES . " c) left join " . DB_TBL_DIRECTORY_TO_ADDRESS . " a on c.attendees_default_address_id = a.directory_to_address_id) where c.attendees_id = '" . (int)$_GET['bigID'] . "'");		
		$existing_attendees_query = go_db_query("select distinct attendees_group_name from " . DB_TBL_ATTENDEES_GROUPS . " order by attendees_group_id "); 
        $attendees = go_db_fetch_array($attendees_query);
        $bigwareInfo = new objectInfo($attendees);
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
<?php
  if ($action == 'change' || $action == 'update') {
?>
<script language="javascript"><!--
function check_form() {
  var error = 0;
  var error_message = "<?php echo JS_ERROR; ?>";
  var attendees_firstname = document.attendees.attendees_firstname.value;
  var attendees_lastname = document.attendees.attendees_lastname.value;
<?php if (MEMBER_COMPANY == 'true') echo 'var entry_company = document.attendees.entry_company.value;' . "\n"; ?> 
<?php if (MEMBER_PIVA == 'true') echo 'var entry_piva = document.attendees.entry_piva.value;' . "\n"; ?>
<?php if (MEMBER_CF == 'true') echo 'var entry_cf = document.attendees.entry_cf.value;' . "\n"; ?> 
<?php if (MEMBER_DOB == 'true') echo 'var attendees_dob = document.attendees.attendees_dob.value;' . "\n"; ?>
  var attendees_email_address = document.attendees.attendees_email_address.value;
  var entry_street_address = document.attendees.entry_street_address.value;
  var entry_postcode = document.attendees.entry_postcode.value;
  var entry_city = document.attendees.entry_city.value;
  var attendees_telephone = document.attendees.attendees_telephone.value;
  var attendees_fax = document.attendees.attendees_fax.value;
<?php if (MEMBER_GENDER_REQ == 'true') { ?>
  if (document.attendees.attendees_gender[0].checked || document.attendees.attendees_gender[1].checked) {
  } else {
    error_message = error_message + "<?php echo JS_GENDER; ?>";
    error = 1;
  }
<?php } ?>
  if (attendees_firstname == "" || attendees_firstname.length < <?php echo TYPE_IN_FIRST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_FIRST_NAME; ?>";
    error = 1;
  }
  if (attendees_lastname == "" || attendees_lastname.length < <?php echo TYPE_IN_LAST_NAME_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_LAST_NAME; ?>";
    error = 1;
  }
<?php if (MEMBER_DOB_REQ == 'true') { ?>
  if (attendees_dob == "" || attendees_dob.length < <?php echo TYPE_IN_DOB_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_DOB; ?>";
    error = 1;
  }
<?php } ?>
  if (attendees_email_address == "" || attendees_email_address.length < <?php echo TYPE_IN_EMAIL_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_EMAIL_ADDRESS; ?>";
    error = 1;
  }
  if (entry_street_address == "" || entry_street_address.length < <?php echo TYPE_IN_STREET_ADDRESS_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_ADDRESS; ?>";
    error = 1;
  }
  if (entry_postcode == "" || entry_postcode.length < <?php echo TYPE_IN_POSTCODE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_POST_CODE; ?>";
    error = 1;
  }
  if (entry_city == "" || entry_city.length < <?php echo TYPE_IN_CITY_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_CITY; ?>";
    error = 1;
  }
<?php
  if (MEMBER_STATE_REQ == 'true') {
?>		
  if (document.attendees.elements['entry_state'].type != "hidden") {
    if (document.attendees.entry_state.value == '' || document.attendees.entry_state.value.length < <?php echo TYPE_IN_STATE_MIN_LENGTH; ?> ) {
       error_message = error_message + "<?php echo JS_STATE; ?>";
       error = 1;
    }
  }
<?php
  }
?>
  if (document.attendees.elements['entry_land_id'].type != "hidden") {
    if (document.attendees.entry_land_id.value == 0) {
      error_message = error_message + "<?php echo JS_LAND; ?>";
      error = 1;
    }
  }
  <?php if (MEMBER_TEL_REQ == 'true') {?>
  if (attendees_telephone == "" || attendees_telephone.length < <?php echo TYPE_IN_TELEPHONE_MIN_LENGTH; ?>) {
    error_message = error_message + "<?php echo JS_TELEPHONE; ?>";
    error = 1;
  } 
  <?php 
  }
  if (MEMBER_FAX_REQ == 'true') {?>
  if (attendees_fax == "" || attendees_fax.length < 4) {
    error_message = error_message + "<?php echo JS_FAX; ?>";
    error = 1;
  } 
<?php 
  }
if (MEMBER_CF_REQ == 'true' && $land_id == '105') {
?>
  if (document.attendees.elements['entry_cf'].value == "") {
    error_message = error_message + "<?php echo JS_CF; ?>";
    error = 1;
  }
<?php
  }
?>
<?php if (MEMBER_PIVA_REQ == 'true') {
?>
  if (document.attendees.elements['entry_piva'].value == "") {
    error_message = error_message + "<?php echo JS_PIVA; ?>";
    error = 1;
  }
<?php
  }
?> 
  
  
  if (error == 1) {
    alert(error_message);
    return false;
  } else {
    return true;
  }
}
//--></script>
<?php
  }
?>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF" onload="SetFocus();">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
  if ($action == 'change' || $action == 'update') {
    $newsletter_array = array(array('id' => '1', 'text' => TYPE_IN_NEWSLETTER_YES),
                              array('id' => '0', 'text' => TYPE_IN_NEWSLETTER_NO));
?>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr><?php echo go_fetch_form('attendees', NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('action')) . 'action=update', 'post', 'onSubmit="return check_form();"') . go_fetch_hidden_field('default_address_id', $bigwareInfo->attendees_default_address_id); ?>
        <td class="formAreaTitle"><?php echo CATEGORY_PERSONAL; ?></td>
      </tr>
      <tr>
        <td class="formArea"><table border="0" cellspacing="2" cellpadding="2">
<?php
    if (MEMBER_GENDER == 'true') {
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_GENDER; ?></td>
            <td class="main">
<?php
    if ($error == true) {
      if ($entry_gender_error == true) {
        echo go_fetch_radio_field('attendees_gender', 'm', false, $bigwareInfo->attendees_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . go_fetch_radio_field('attendees_gender', 'f', false, $bigwareInfo->attendees_gender) . '&nbsp;&nbsp;' . FEMALE . '&nbsp;' . TYPE_IN_GENDER_ERROR;
      } else {
        echo ($bigwareInfo->attendees_gender == 'm') ? MALE : FEMALE;
        echo go_fetch_hidden_field('attendees_gender');
      }
    } else {
      echo go_fetch_radio_field('attendees_gender', 'm', false, $bigwareInfo->attendees_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . go_fetch_radio_field('attendees_gender', 'f', false, $bigwareInfo->attendees_gender) . '&nbsp;&nbsp;' . FEMALE;
    }
?></td>
          </tr>
<?php
    }
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_FIRST_NAME; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_firstname_error == true) {
      echo go_fetch_inputfeld('attendees_firstname', $bigwareInfo->attendees_firstname, 'maxlength="32"') . '&nbsp;' . TYPE_IN_FIRST_NAME_ERROR;
    } else {
      echo $bigwareInfo->attendees_firstname . go_fetch_hidden_field('attendees_firstname');
    }
  } else {
    echo go_fetch_inputfeld('attendees_firstname', $bigwareInfo->attendees_firstname, 'maxlength="32"', true);
  }
?></td>
          </tr>
          <tr>
            <td class="main"><?php echo TYPE_IN_LAST_NAME; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_lastname_error == true) {
      echo go_fetch_inputfeld('attendees_lastname', $bigwareInfo->attendees_lastname, 'maxlength="32"') . '&nbsp;' . TYPE_IN_LAST_NAME_ERROR;
    } else {
      echo $bigwareInfo->attendees_lastname . go_fetch_hidden_field('attendees_lastname');
    }
  } else {
    echo go_fetch_inputfeld('attendees_lastname', $bigwareInfo->attendees_lastname, 'maxlength="32"', true);
  }
?></td>
          </tr>
<?php
    if (MEMBER_DOB == 'true') {
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_DATE_OF_BIRTH; ?></td>
            <td class="main">
<?php
    if ($error == true) {
      if ($entry_date_of_birth_error == true) {
        echo go_fetch_inputfeld('attendees_dob', go_date_short($bigwareInfo->attendees_dob), 'maxlength="10"') . '&nbsp;' . TYPE_IN_DATE_OF_BIRTH_ERROR;
      } else {
        echo $bigwareInfo->attendees_dob . go_fetch_hidden_field('attendees_dob');
      }
    } else {
      echo go_fetch_inputfeld('attendees_dob', go_date_short($bigwareInfo->attendees_dob), 'maxlength="10"', true);
    }
?></td>
          </tr>
<?php
    }
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_EMAIL_ADDRESS; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_email_address_error == true) {
      echo go_fetch_inputfeld('attendees_email_address', $bigwareInfo->attendees_email_address, 'maxlength="96"') . '&nbsp;' . TYPE_IN_EMAIL_ADDRESS_ERROR;
    } elseif ($entry_email_address_check_error == true) {
      echo go_fetch_inputfeld('attendees_email_address', $bigwareInfo->attendees_email_address, 'maxlength="96"') . '&nbsp;' . TYPE_IN_EMAIL_ADDRESS_CHECK_ERROR;
    } elseif ($entry_email_address_exists == true) {
      echo go_fetch_inputfeld('attendees_email_address', $bigwareInfo->attendees_email_address, 'maxlength="96"') . '&nbsp;' . TYPE_IN_EMAIL_ADDRESS_ERROR_EXISTS;
    } else {
      echo $attendees_email_address . go_fetch_hidden_field('attendees_email_address');
    }
  } else {
    echo go_fetch_inputfeld('attendees_email_address', $bigwareInfo->attendees_email_address, 'maxlength="96"', true);
  }
?></td>
<!-- B2B start -->
<!--PIVACF start-->
<?php  if (MEMBER_CF == 'true') { ?>                                   
              <tr>
                  <td class="main"><?php echo TYPE_IN_CF; ?></td>
            <td class="main"><?php
               if (MEMBER_CF_REQ == 'true')     echo go_fetch_inputfeld('entry_cf', $bigwareInfo->entry_cf, 'maxlength="16"', true);
            else echo go_fetch_inputfeld('entry_cf', $bigwareInfo->entry_cf, 'maxlength="16"'); ?></td>
          </tr>
<?php } ?>
<!--PIVACF end-->
<!-- B2B end -->
          </tr>
        </table></td>
      </tr>
<?php
    if (MEMBER_COMPANY == 'true') {
?>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="formAreaTitle"><?php echo CATEGORY_COMPANY; ?></td>
      </tr>
      <tr>
        <td class="formArea"><table border="0" cellspacing="2" cellpadding="2">
          <tr>
            <td class="main"><?php echo TYPE_IN_COMPANY; ?></td>
            <td class="main">
<?php
    if ($error == true) {
      if ($entry_company_error == true) {
        echo go_fetch_inputfeld('entry_company', $bigwareInfo->entry_company, 'maxlength="32"') . '&nbsp;' . TYPE_IN_COMPANY_ERROR;
      } else {
        echo $bigwareInfo->entry_company . go_fetch_hidden_field('entry_company');
      }
    } else {
      echo go_fetch_inputfeld('entry_company', $bigwareInfo->entry_company, 'maxlength="32"');
    }
?></td>
          </tr>
<!-- B2B start -->  
<!--PIVACF start-->
<?php  if (MEMBER_PIVA == 'true') { ?>
        <tr>
            <td class="main"><?php echo TYPE_IN_PIVA; ?></td>
            <td class="main"><?php 
               if (MEMBER_PIVA_REQ == 'true')   echo go_fetch_inputfeld('entry_piva', $bigwareInfo->entry_piva, 'maxlength="11"', true);
            else echo go_fetch_inputfeld('entry_piva', $bigwareInfo->entry_piva, 'maxlength="11"'); ?></td>        
        </tr>
<?php } ?>    
<!--PIVACF end-->
<!-- B2B end -->
        </table></td>
      </tr>
<?php
    }
?>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="formAreaTitle"><?php echo CATEGORY_ADDRESS; ?></td>
      </tr>
      <tr>
        <td class="formArea"><table border="0" cellspacing="2" cellpadding="2">
          <tr>
            <td class="main"><?php echo TYPE_IN_STREET_ADDRESS; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_street_address_error == true) {
      echo go_fetch_inputfeld('entry_street_address', $bigwareInfo->entry_street_address, 'maxlength="64"') . '&nbsp;' . TYPE_IN_STREET_ADDRESS_ERROR;
    } else {
      echo $bigwareInfo->entry_street_address . go_fetch_hidden_field('entry_street_address');
    }
  } else {
    echo go_fetch_inputfeld('entry_street_address', $bigwareInfo->entry_street_address, 'maxlength="64"', true);
  }
?></td>
          </tr>
<?php
    if (MEMBER_SUBURB == 'true') {
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_SUBURB; ?></td>
            <td class="main">
<?php
    if ($error == true) {
      if ($entry_suburb_error == true) {
        echo go_fetch_inputfeld('suburb', $bigwareInfo->entry_suburb, 'maxlength="32"') . '&nbsp;' . TYPE_IN_SUBURB_ERROR;
      } else {
        echo $bigwareInfo->entry_suburb . go_fetch_hidden_field('entry_suburb');
      }
    } else {
      echo go_fetch_inputfeld('entry_suburb', $bigwareInfo->entry_suburb, 'maxlength="32"');
    }
?></td>
          </tr>
<?php
    }
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_POST_CODE; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_post_code_error == true) {
      echo go_fetch_inputfeld('entry_postcode', $bigwareInfo->entry_postcode, 'maxlength="8"') . '&nbsp;' . TYPE_IN_POST_CODE_ERROR;
    } else {
      echo $bigwareInfo->entry_postcode . go_fetch_hidden_field('entry_postcode');
    }
  } else {
    echo go_fetch_inputfeld('entry_postcode', $bigwareInfo->entry_postcode, 'maxlength="8"', true);
  }
?></td>
          </tr>
          <tr>
            <td class="main"><?php echo TYPE_IN_CITY; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_city_error == true) {
      echo go_fetch_inputfeld('entry_city', $bigwareInfo->entry_city, 'maxlength="32"') . '&nbsp;' . TYPE_IN_CITY_ERROR;
    } else {
      echo $bigwareInfo->entry_city . go_fetch_hidden_field('entry_city');
    }
  } else {
    echo go_fetch_inputfeld('entry_city', $bigwareInfo->entry_city, 'maxlength="32"', true);
  }
?></td>
          </tr>
<?php
    if (MEMBER_STATE == 'true') {
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_STATE; ?></td>
            <td class="main">
<?php
    $entry_state = go_get_zone_name($bigwareInfo->entry_land_id, $bigwareInfo->entry_zone_id, $bigwareInfo->entry_state);
    if ($error == true) {
      if ($entry_state_error == true) {
        if ($entry_state_has_zones == true) {
          $zones_array = array();
          $zones_query = go_db_query("select zone_name from " . DB_TBL_ZONES . " where zone_land_id = '" . go_db_input($bigwareInfo->entry_land_id) . "' order by zone_name");
          while ($zones_values = go_db_fetch_array($zones_query)) {
            $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
          }
          echo go_fetch_pull_down_menu('entry_state', $zones_array) . '&nbsp;' . TYPE_IN_STATE_ERROR;
        } else {
          echo go_fetch_inputfeld('entry_state', go_get_zone_name($bigwareInfo->entry_land_id, $bigwareInfo->entry_zone_id, $bigwareInfo->entry_state)) . '&nbsp;' . TYPE_IN_STATE_ERROR;
        }
      } else {
        echo $entry_state . go_fetch_hidden_field('entry_zone_id') . go_fetch_hidden_field('entry_state');
      }
    } else {
      if (MEMBER_STATE_REQ == 'true') {
        echo go_fetch_inputfeld('entry_state', go_get_zone_name($bigwareInfo->entry_land_id, $bigwareInfo->entry_zone_id, $bigwareInfo->entry_state), 'maxlength="50"', true);
      } else {
        echo go_fetch_inputfeld('entry_state', go_get_zone_name($bigwareInfo->entry_land_id, $bigwareInfo->entry_zone_id, $bigwareInfo->entry_state), 'maxlength="50"');
      }
    }
?></td>
         </tr>
<?php
    }
?>
          <tr>
            <td class="main"><?php echo TYPE_IN_LAND; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_land_error == true) {
      echo go_fetch_pull_down_menu('entry_land_id', go_get_lands(), $bigwareInfo->entry_land_id) . '&nbsp;' . TYPE_IN_LAND_ERROR;
    } else {
      echo go_get_land_name($bigwareInfo->entry_land_id) . go_fetch_hidden_field('entry_land_id');
    }
  } else {
    echo go_fetch_pull_down_menu('entry_land_id', go_get_lands(), $bigwareInfo->entry_land_id);
  }
?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="formAreaTitle"><?php echo CATEGORY_CONTACT; ?></td>
      </tr>
      <tr>
        <td class="formArea"><table border="0" cellspacing="2" cellpadding="2">
          <tr>
            <td class="main"><?php echo TYPE_IN_TELEPHONE_NUMBER; ?></td>
            <td class="main">
<?php
  if ($error == true) {
    if ($entry_telephone_error == true) {
      echo go_fetch_inputfeld('attendees_telephone', $bigwareInfo->attendees_telephone, 'maxlength="32"') . '&nbsp;' . TYPE_IN_TELEPHONE_NUMBER_ERROR;
    } else {
      echo $bigwareInfo->attendees_telephone . go_fetch_hidden_field('attendees_telephone');
    }
  } else {
    if (MEMBER_TEL_REQ == 'true') {
        echo go_fetch_inputfeld('attendees_telephone', $bigwareInfo->attendees_telephone, 'maxlength="32"', true);
    } else { 
        echo go_fetch_inputfeld('attendees_telephone', $bigwareInfo->attendees_telephone, 'maxlength="32"');
    }
  }
?></td>
          </tr>
          <tr>
            <td class="main"><?php echo TYPE_IN_FAX_NUMBER; ?></td>
            <td class="main">
<?php
  if ($processed == true) {
    echo $bigwareInfo->attendees_fax . go_fetch_hidden_field('attendees_fax');
  } else {
    if (MEMBER_FAX_REQ == 'true') {
        echo go_fetch_inputfeld('attendees_fax', $bigwareInfo->attendees_fax, 'maxlength="32"', true);
    } else {
        echo go_fetch_inputfeld('attendees_fax', $bigwareInfo->attendees_fax, 'maxlength="32"');
    }
  }
?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td class="formAreaTitle"><?php echo CATEGORY_OPTIONS; ?></td>
      </tr>
      <tr>
        <td class="formArea"><table border="0" cellspacing="2" cellpadding="2">
          <tr>
            <td class="main"><?php echo TYPE_IN_NEWSLETTER; ?></td>
            <td class="main">
<?php
  if ($processed == true) {
    if ($bigwareInfo->attendees_newsletter == '1') {
      echo TYPE_IN_NEWSLETTER_YES;
    } else {
      echo TYPE_IN_NEWSLETTER_NO;
    }
    echo go_fetch_hidden_field('attendees_newsletter');
  } else {
    echo go_fetch_pull_down_menu('attendees_newsletter', $newsletter_array, (($bigwareInfo->attendees_newsletter == '1') ? '1' : '0'));
  }
?></td>
          </tr>
          
          
          
           <tr>
            <td class="main"><?php echo ENTRY_INVOICE; ?></td>
            <td class="main">
<?php
    if ($error == true) {
      if ($entry_invoice_error == true) {
        echo go_fetch_radio_field('attendees_invoice', '0', false, $bigwareInfo->attendees_invoice) . '&nbsp;&nbsp;' . INVOICE_NOT . '&nbsp;&nbsp;' . go_fetch_radio_field('attendees_invoice', '1', false, $bigwareInfo->attendees_invoice) . '&nbsp;&nbsp;' . INVOICE_FREE . '&nbsp;';
      } else {
        echo ($bigwareInfo->attendees_invoice == '0') ? INVOICE_NOT : INVOICE_FREE;
        echo go_fetch_hidden_field('attendees_invoice');
      }
    } else {
      echo go_fetch_radio_field('attendees_invoice', '0', false, $bigwareInfo->attendees_invoice) . '&nbsp;&nbsp;' . INVOICE_NOT . '&nbsp;&nbsp;' . go_fetch_radio_field('attendees_invoice', '1', false, $bigwareInfo->attendees_invoice) . '&nbsp;&nbsp;' . INVOICE_FREE;
    }
?></td>
          </tr>         
          
          
          
          
          
<!-- B2B end -->
<tr>                
	<td class="main"><?php echo TYPE_IN_ATTENDEES_GROUP_NAME; ?></td>
	<td class="main"><?php echo go_fetch_pull_down_menu('attendees_group_id', go_get_attendees_group(''. VISITOR_NAME .''), $bigwareInfo->attendees_group_id); ?></td>
</tr>
<!-- B2B end -->
        </table></td>
      </tr>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr>
        <td align="right" class="main"><?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE) . ' <a href="' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('action'))) .'">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>'; ?></td>
      </tr></form>
<?php
  } else {
?>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr><?php echo go_fetch_form('search', NAME_OF_FILE_ATTENDEES, '', 'get'); ?>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
            <td class="smallText" align="right"><?php echo ABOVE_TITLE_SEARCH . ' ' . go_fetch_inputfeld('search'); ?></td>
          </form></tr>
        </table></td>
      </tr>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
			  	<!-- B2B start -->
			  	<td class="tbUPDataInside"><?php echo TYPE_IN_COMPANY; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_LASTNAME; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_FIRSTNAME; ?></td>
				<td class="tbUPDataInside"><?php echo TYPE_IN_GROUPS_NAME; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_MEMBER_CREATED; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_REFERRED_BY; ?>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
				<!-- B2B end -->
              </tr>
	      <?php
	      $search = '';
if (isset($_GET['search']) && go_not_null($_GET['search'])) {
	$keywords = go_db_input(go_db_producing_input($_GET['search'])); 
	$search = "where c.attendees_lastname like '%" . $keywords . "%' or c.attendees_firstname like '%" . $keywords . "%' or c.attendees_email_address like '%" . $keywords . "%' or a.entry_company like '%" . $keywords . "%'"; 
} 
$attendees_query_raw = "select distinct c.attendees_id, c.attendees_lastname, c.attendees_firstname, c.attendees_group_id, a.entry_company, c.attendees_email_address, a.entry_land_id from ((" . DB_TBL_ATTENDEES . " c) left join " . DB_TBL_DIRECTORY_TO_ADDRESS . " a on c.attendees_id = a.attendees_id and c.attendees_default_address_id = a.directory_to_address_id) " . $search . " order by c.attendees_lastname, c.attendees_firstname"; 
$attendees_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $attendees_query_raw, $attendees_query_numrows);
$attendees_query = go_db_query($attendees_query_raw);
while ($attendees = go_db_fetch_array($attendees_query)) {
	$info_query = go_db_query("select attendees_info_date_member_created as date_member_created, attendees_info_date_member_last_modified as date_member_last_modified, attendees_info_date_of_last_logon as date_last_logon, attendees_info_number_of_logons as number_of_logons from " . DB_TBL_ATTENDEES_INFO . " where attendees_info_id = '" . $attendees['attendees_id'] . "'");
	$info = go_db_fetch_array($info_query); 
	$cust_coll = go_db_query ("select attendees_group_id, attendees_group_name FROM ". DB_TBL_ATTENDEES_GROUPS ." where attendees_group_id = ". (int)$attendees['attendees_group_id'] ."");
	$cust_ret = go_db_fetch_array($cust_coll);
	if ($cust_ret['attendees_group_id'] == 0){
		$cust_ret['attendees_group_name'] = ''. VISITOR_NAME .'' ;
	} 
	if ((!isset($_GET['bigID']) || (isset($_GET['bigID']) && ($_GET['bigID'] == $attendees['attendees_id']))) && !isset($bigwareInfo)) {
		$land_query = go_db_query("select lands_name from " . DB_TBL_LANDS . " where lands_id = '" . (int)$attendees['entry_land_id'] . "'");
		$land = go_db_fetch_array($land_query);
		$reviews_query = go_db_query("select count(*) as number_of_reviews from " . DB_TBL_REVIEWS . " where attendees_id = '" . (int)$attendees['attendees_id'] . "'");
		$reviews = go_db_fetch_array($reviews_query); 
		$orders_query = go_db_query("select count(*) as number_of_orders from " . DB_TBL_ORDERS . " where attendees_id = '" . (int)$attendees['attendees_id'] . "'");
		$orders = go_db_fetch_array($orders_query);
		$attendee_info = array_merge($land, $info, $reviews, $orders); 
		$bigwareInfo_array = array_merge($attendees, $attendee_info, $cust_ret);
		$bigwareInfo = new objectInfo($bigwareInfo_array);
	}
	if (isset($bigwareInfo) && is_object($bigwareInfo) && ($attendees['attendees_id'] == $bigwareInfo->attendees_id)) {
		echo '          <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $bigwareInfo->attendees_id . '&action=change') . '\'">' . "\n";
	} else {
		echo '          <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID')) . 'bigID=' . $attendees['attendees_id']) . '\'">' . "\n";
	}
	$source_query = go_db_query("select attendees_info_source_id  from " . DB_TBL_ATTENDEES_INFO . " where attendees_info_id = '" . $attendees['attendees_id'] . "'");
	$source = go_db_fetch_array($source_query);
	$entry_referral = go_get_sources_name($source['attendees_info_source_id'], $attendees['attendees_id']);
	?>
		<!-- B2B start -->
		<td class="TbInsideData"><?php echo $attendees['entry_company']; ?></td>
		<td class="TbInsideData"><?php echo $attendees['attendees_lastname']; ?></td>
		<td class="TbInsideData"><?php echo $attendees['attendees_firstname']; ?></td>
		<td class="TbInsideData"><?php echo $cust_ret['attendees_group_name']; ?></td>
		<td class="TbInsideData" align="right"><?php echo go_date_short($info['date_member_created']); ?></td>
		<td class="TbInsideData" align="right"><?php echo $entry_referral; ?>
		<td class="TbInsideData" align="right"><?php if ((is_object($bigwareInfo)) && ($attendees['attendees_id'] == $bigwareInfo->attendees_id)) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID')) . 'bigID=' . $attendees['attendees_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
		<!-- B2B end -->
		</tr>
		<?php
}
?>
<tr>
<td colspan="4"><table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr>
<td class="smallText" valign="top"><?php echo $attendees_split->display_count($attendees_query_numrows, MAX_SHOW_SEARCH_RESULTS, $_GET['page'], TEXT_SHOW_NUMBER_OF_ATTENDEES); ?></td>
<td class="smallText" align="right"><?php echo $attendees_split->display_links($attendees_query_numrows, MAX_SHOW_SEARCH_RESULTS, MAX_SHOW_PAGE_LINKS, $_GET['page'], go_get_all_get_parameter(array('page', 'info', 'x', 'y', 'bigID'))); ?></td>
</tr>
<?php
if (isset($_GET['search']) && go_not_null($_GET['search'])) {
	?>
		<tr>
		<td align="right" colspan="2"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ATTENDEES) . '">' . go_picture_button('button_reset.gif', PICTURE_RESET) . '</a>'; ?></td>
		</tr>
		<?php
}
?>
</table></td>
</tr>
</table></td>
<?php
$heading = array();
$contents = array();
switch ($action) {
	case 'confirm':
		$heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_DELETE_ATTENDEE . '</b>');
		$contents = array('form' => go_fetch_form('attendees', NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $bigwareInfo->attendees_id . '&action=deleteconfirm'));
		$contents[] = array('text' => TEXT_DELETE_INTRO . '<br><br><b>' . $bigwareInfo->attendees_firstname . ' ' . $bigwareInfo->attendees_lastname . '</b>');
		if (isset($bigwareInfo->number_of_reviews) && ($bigwareInfo->number_of_reviews) > 0) $contents[] = array('text' => '<br>' . go_fetch_checkbox_field('delete_reviews', 'on', true) . ' ' . sprintf(TEXT_DELETE_REVIEWS, $bigwareInfo->number_of_reviews));
		$contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $bigwareInfo->attendees_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
		break;
	default:
		if (isset($bigwareInfo) && is_object($bigwareInfo)) {
			$heading[] = array('text' => '<b>' . $bigwareInfo->attendees_firstname . ' ' . $bigwareInfo->attendees_lastname . '</b>');
			$contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $bigwareInfo->attendees_id . '&action=change') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ATTENDEES, go_get_all_get_parameter(array('bigID', 'action')) . 'bigID=' . $bigwareInfo->attendees_id . '&action=confirm') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ORDERS, 'bigID=' . $bigwareInfo->attendees_id) . '">' . go_picture_button('button_orders.gif', PICTURE_ORDERS) . '</a> <a href="' . go_href_link(NAME_OF_FILE_MAIL, 'selected_frame=tools&attendee=' . $bigwareInfo->attendees_email_address) . '">' . go_picture_button('button_email.gif', PICTURE_EMAIL) . '</a>');
			$contents[] = array('text' => '<br>' . TEXT_DATE_MEMBER_CREATED . ' ' . go_date_short($bigwareInfo->date_member_created));
			$contents[] = array('text' => '<br>' . TEXT_DATE_MEMBER_LAST_MODIFIED . ' ' . go_date_short($bigwareInfo->date_member_last_modified));
			$contents[] = array('text' => '<br>' . TEXT_INFO_DATE_LAST_LOGON . ' '  . go_date_short($bigwareInfo->date_last_logon));
			$contents[] = array('text' => '<br>' . TEXT_INFO_NUMBER_OF_LOGONS . ' ' . $bigwareInfo->number_of_logons);
			$contents[] = array('text' => '<br>' . TEXT_INFO_LAND . ' ' . $bigwareInfo->lands_name);
			$contents[] = array('text' => '<br>' . TEXT_INFO_NUMBER_OF_REVIEWS . ' ' . $bigwareInfo->number_of_reviews); 
			$contents[] = array('text' => '<br>' . TEXT_INFO_NUMBER_OF_ORDERS . ' ' . $bigwareInfo->number_of_orders);
		}
		break;
}
if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
	echo '            <td width="25%" valign="top"><br>' . "\n";
	$frame = new frame;
	echo $frame->infoBox($heading, $contents);
	echo '            </td>' . "\n";
}
?>
</tr>
</table></td>
</tr>
<?php
}
?>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
