<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  require(FOLDER_RELATIV_CLASSES . 'class_bigware_1.php');
  $currencies = new currencies();
  if ($_GET['selected_frame']) {
    $_GET['action']='';
    $_GET['old_action']='';
  }
  
  if (($_GET['action'] == 'send_email_to_user') && ($_POST['attendees_email_address']) && (!$_POST['back_x'])) {
    switch ($_POST['attendees_email_address']) {
    case '***':
      $mail_query = go_db_query("select attendees_firstname, attendees_lastname, attendees_email_address from " . DB_TBL_ATTENDEES);
      $mail_sent_to = TEXT_ALL_ATTENDEES;
      break;
    case '**D':
      $mail_query = go_db_query("select attendees_firstname, attendees_lastname, attendees_email_address from " . DB_TBL_ATTENDEES . " where attendees_newsletter = '1'");
      $mail_sent_to = TEXT_NEWSLETTER_ATTENDEES;
      break;
    default:
      $attendees_email_address = go_db_producing_input($_POST['attendees_email_address']);
      $mail_query = go_db_query("select attendees_firstname, attendees_lastname, attendees_email_address from " . DB_TBL_ATTENDEES . " where attendees_email_address = '" . go_db_input($attendees_email_address) . "'");
      $mail_sent_to = $_POST['attendees_email_address'];
      break;
    }
    $coupon_query = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_id = '" . (int)$_GET['cid'] . "'");
    $coupon_result = go_db_fetch_array($coupon_query);
    $coupon_name_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . (int)$_GET['cid'] . "' and language_id = '" . $languages_id . "'");
    $coupon_name = go_db_fetch_array($coupon_name_query);
    $from = go_db_producing_input($_POST['from']);
    $subject = go_db_producing_input($_POST['subject']);
    while ($mail = go_db_fetch_array($mail_query)) {
      $message = go_db_producing_input($_POST['message']);
      $message .= "\n\n" . TEXT_TO_REDEEM . "\n\n";
      $message .= TEXT_VOUCHER_IS . $coupon_result['coupon_code'] . "\n\n";
      $message .= TEXT_REMEMBER . "\n\n";
      $message .= TEXT_VISIT . "\n\n"; 
      $mimemessage = new email(array('X-Mailer: bigWare bulk mailer')); 
      $mimemessage->add_text($message);
      $mimemessage->build_message();    
      $mimemessage->send($mail['attendees_firstname'] . ' ' . $mail['attendees_lastname'], $mail['attendees_email_address'], '', $from, $subject);
    }
    go_forward(go_href_link(NAME_OF_FILE_COUPON_FORMER, 'mail_sent_to=' . urlencode($mail_sent_to)));
  }
 
  if ( ($_GET['action'] == 'preview_email') && (!$_POST['attendees_email_address']) ) {
    $_GET['action'] = 'email';    
    $messageStack->add(ERROR_NO_ATTENDEE_SELECTED, 'error');
  }
  if ($_GET['mail_sent_to']) {
    $messageStack->add(sprintf(NOTICE_EMAIL_SENT_TO, $_GET['mail_sent_to']), 'notice');
  }
  switch ($_GET['action']) {
    case 'confirmdelete':
      $delete_query=go_db_query("update " . DB_TBL_COUPONS . " set coupon_active = 'N' where coupon_id='".(int)$_GET['cid']."'");
      break;
    case 'update': 
      $_POST['coupon_code'] = trim($_POST['coupon_code']);
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $language_id = $languages[$i]['id'];
          $_POST['coupon_name'][$language_id] = trim($_POST['coupon_name'][$language_id]);
          $_POST['coupon_desc'][$language_id] = trim($_POST['coupon_desc'][$language_id]);
        }
      $_POST['coupon_amount'] = trim($_POST['coupon_amount']);
      $update_errors = 0;
      if (!$_POST['coupon_name']) {
        $update_errors = 1;
        $messageStack->add(ERROR_NO_COUPON_NAME, 'error');
      }
      if ((!$_POST['coupon_amount']) && (!$_POST['coupon_free_ship'])) {
        $update_errors = 1;
        $messageStack->add(ERROR_NO_COUPON_AMOUNT, 'error');
      }
      if (!$_POST['coupon_code']) {
        $coupon_code = create_coupon_code(); 
      }
      if ($_POST['coupon_code']) $coupon_code = $_POST['coupon_code'];
      $query1 = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_code = '" . go_db_producing_input($coupon_code) . "'");    
      if (go_db_num_rows($query1) && $_POST['coupon_code'] && $_GET['oldaction'] != 'voucherchange')  {
        $update_errors = 1;
        $messageStack->add(ERROR_COUPON_EXISTS, 'error');
      }
      if ($update_errors != 0) {
        $_GET['action'] = 'new';  
      } else {  
        $_GET['action'] = 'update_preview';
      }
      break;
    case 'update_confirm':
      if ( ($_POST['back_x']) || ($_POST['back_y']) ) {
        $_GET['action'] = 'new';
      } else {
        $coupon_type = "F";
        if (substr($_POST['coupon_amount'], -1) == '%') $coupon_type='P';
        if ($_POST['coupon_free_ship']) $coupon_type = 'S';
        $sql_data_array = array('coupon_code' => go_db_producing_input($_POST['coupon_code']),
                                'coupon_amount' => go_db_producing_input($_POST['coupon_amount']),
                                'coupon_type' => go_db_producing_input($coupon_type),
                                'uses_per_coupon' => go_db_producing_input($_POST['coupon_uses_coupon']),
                                'uses_per_user' => go_db_producing_input($_POST['coupon_uses_user']),
                                'coupon_minimum_order' => go_db_producing_input($_POST['coupon_min_order']),
                                'restrict_to_items' => go_db_producing_input($_POST['coupon_items']),
                                'restrict_to_categories' => go_db_producing_input($_POST['coupon_categories']),
                                'coupon_start_date' => $_POST['coupon_startdate'],
                                'coupon_expire_date' => $_POST['coupon_finishdate'],
                                'date_created' => 'now()',
                                'date_modified' => 'now()');
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $language_id = $languages[$i]['id'];
          $sql_data_marray[$i] = array('coupon_name' => go_db_producing_input($_POST['coupon_name'][$language_id]),
                                 'coupon_description' => go_db_producing_input($_POST['coupon_desc'][$language_id])
                                 );
        }  
        if ($_GET['oldaction']=='voucherchange') {
          go_db_carry(DB_TBL_COUPONS, $sql_data_array, 'update', "coupon_id='" . (int)$_GET['cid']."'"); 
          for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $language_id = $languages[$i]['id'];
            $update = go_db_query("update " . DB_TBL_COUPONS_DESCRIPTION . " set coupon_name = '" . go_db_producing_input($_POST['coupon_name'][$language_id]) . "', coupon_description = '" . go_db_producing_input($_POST['coupon_desc'][$language_id]) . "' where coupon_id = '" . (int)$_GET['cid'] . "' and language_id = '" . $language_id . "'"); 
          }
        } else {   
          $query = go_db_carry(DB_TBL_COUPONS, $sql_data_array);
          $insert_id = go_db_insert_id($query);
          
          for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $language_id = $languages[$i]['id'];
            $sql_data_marray[$i]['coupon_id'] = $insert_id;
            $sql_data_marray[$i]['language_id'] = $language_id;
            go_db_carry(DB_TBL_COUPONS_DESCRIPTION, $sql_data_marray[$i]);            
          } 
      }
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
<link rel="stylesheet" type="text/css" href="load_this/javascript/spiffyCal/spiffyCal_v2_1.css">
<script language="JavaScript" src="load_this/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
<script language="javascript">
  var dateAvailable = new ctlSpiffyCalendarBox("dateAvailable", "new_item", "items_date_available","btnDate1","<?php echo $pInfo->items_date_available; ?>",scBTNMODE_CUSTOMBLUE);
  var dateAvailableEnd = new ctlSpiffyCalendarBox("dateAvailableEnd", "new_item", "items_date_available_end","btnDate2","<?php echo $pInfo->items_date_available_end; ?>",scBTNMODE_CUSTOMBLUE);
</script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<div id="spiffycalendar" class="text"></div>
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td>
<!-- body_text //-->
<?php 
  switch ($_GET['action']) {
  case 'voucherreport':
?>
      <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td class="smallText"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo ATTENDEE_ID; ?></td>
                <td class="tbUPDataInside" align="center"><?php echo ATTENDEE_NAME; ?></td>	
                <td class="tbUPDataInside" align="center"><?php echo IP_ADDRESS; ?></td>	
                <td class="tbUPDataInside" align="center"><?php echo REDEEM_DATE; ?></td>	
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
    $cc_query_raw = "select * from " . DB_TBL_COUPON_REDEEM_TRACK . " where coupon_id = '" . (int)$_GET['cid'] . "'";
    $cc_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $cc_query_raw, $cc_query_numrows);
    $cc_query = go_db_query($cc_query_raw);
    while ($cc_list = go_db_fetch_array($cc_query)) {
      $rows++;
      if (strlen($rows) < 2) {
        $rows = '0' . $rows;
      }
      if (((!$_GET['uid']) || (@$_GET['uid'] == $cc_list['unique_id'])) && (!$bigwareInfo)) {
        $bigwareInfo = new objectInfo($cc_list);
      }
      if ( (is_object($bigwareInfo)) && ($cc_list['unique_id'] == $bigwareInfo->unique_id) ) {
        echo '          <tr class="tbCountDataSelected" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . go_href_link('main_bigware_21.php', go_get_all_get_parameter(array('cid', 'action', 'uid')) . 'cid=' . $bigwareInfo->coupon_id . '&action=voucherreport&uid=' . $cinfo->unique_id) . '\'">' . "\n";
      } else {
        echo '          <tr class="tbCountData" onmouseover="this.className=\'tbCountDataOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'tbCountData\'" onclick="document.location.href=\'' . go_href_link('main_bigware_21.php', go_get_all_get_parameter(array('cid', 'action', 'uid')) . 'cid=' . $cc_list['coupon_id'] . '&action=voucherreport&uid=' . $cc_list['unique_id']) . '\'">' . "\n";
      }
$attendee_query = go_db_query("select attendees_firstname, attendees_lastname from " . DB_TBL_ATTENDEES . " where attendees_id = '" . $cc_list['attendee_id'] . "'");
$attendee = go_db_fetch_array($attendee_query);
?>
                <td class="TbInsideData"><?php echo $cc_list['attendee_id']; ?></td>
                <td class="TbInsideData" align="center"><?php echo $attendee['attendees_firstname'] . ' ' . $attendee['attendees_lastname']; ?></td>
                <td class="TbInsideData" align="center"><?php echo $cc_list['redeem_ip']; ?></td>
                <td class="TbInsideData" align="center"><?php echo go_date_short($cc_list['redeem_date']); ?></td>
                <td class="TbInsideData" align="right"><?php if ( (is_object($bigwareInfo)) && ($cc_list['unique_id'] == $bigwareInfo->unique_id) ) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif'); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_COUPON_FORMER, 'page=' . $_GET['page'] . '&cid=' . $cc_list['coupon_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
?>
 
             </table></td>
<?php
    $heading = array();
    $contents = array();
      $coupon_description_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . (int)$_GET['cid'] . "' and language_id = '" . $languages_id . "'");
      $coupon_desc = go_db_fetch_array($coupon_description_query);
      $count_attendees = go_db_query("select * from " . DB_TBL_COUPON_REDEEM_TRACK . " where coupon_id = '" . (int)$_GET['cid'] . "' and attendee_id = '" . $bigwareInfo->attendee_id . "'");
       
      $heading[] = array('text' => '<b>[' . $_GET['cid'] . ']' . COUPON_NAME . ' ' . $coupon_desc['coupon_name'] . '</b>');
      $contents[] = array('text' => '<b>' . TEXT_REDEMPTIONS . '</b>');
      $contents[] = array('text' => TEXT_REDEMPTIONS_TOTAL . '=' . go_db_num_rows($cc_query));
      $contents[] = array('text' => TEXT_REDEMPTIONS_ATTENDEE . '=' . go_db_num_rows($count_attendees));
      $contents[] = array('text' => '');
?>
    <td width="25%" valign="top">
<?php
      $frame = new frame;
      echo $frame->infoBox($heading, $contents);
      echo '            </td>' . "\n";
?>
<?php
    break;
  case 'preview_email': 
    $coupon_query = go_db_query("select coupon_code from " .DB_TBL_COUPONS . " where coupon_id = '" . (int)$_GET['cid'] . "'");
    $coupon_result = go_db_fetch_array($coupon_query);
    $coupon_name_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . (int)$_GET['cid'] . "' and language_id = '" . $languages_id . "'");
    $coupon_name = go_db_fetch_array($coupon_name_query);
    switch ($_POST['attendees_email_address']) {
    case '***':
      $mail_sent_to = TEXT_ALL_ATTENDEES;
      break;
    case '**D':
      $mail_sent_to = TEXT_NEWSLETTER_ATTENDEES;
      break;
    default:
      $mail_sent_to = $_POST['attendees_email_address'];
      break;
    }
?>
      <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
          <tr><?php echo go_fetch_form('mail', NAME_OF_FILE_COUPON_FORMER, 'action=send_email_to_user&cid=' . $_GET['cid']); ?>
            <td><table border="0" width="100%" cellpadding="0" cellspacing="2">
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="smallText"><b><?php echo TEXT_ATTENDEE; ?></b><br><?php echo $mail_sent_to; ?></td>
              </tr>
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="smallText"><b><?php echo TEXT_COUPON; ?></b><br><?php echo $coupon_name['coupon_name']; ?></td>
              </tr>
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="smallText"><b><?php echo TEXT_FROM; ?></b><br><?php echo isohtmlspecialchars(stripslashes($_POST['from'])); ?></td>
              </tr>
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="smallText"><b><?php echo TEXT_SUBJECT; ?></b><br><?php echo isohtmlspecialchars(stripslashes($_POST['subject'])); ?></td>
              </tr>
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="smallText"><b><?php echo TEXT_MESSAGE; ?></b><br><?php echo nl2br(isohtmlspecialchars(stripslashes($_POST['message']))); ?></td>
              </tr>
              <tr>
                <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td>
<?php
 reset($_POST);
    while (list($key, $value) = each($_POST)) {
      if (!is_array($_POST[$key])) {
        echo go_fetch_hidden_field($key, isohtmlspecialchars(stripslashes($value)));
      }
    }
?>
                <table border="0" width="100%" cellpadding="0" cellspacing="2">
                  <tr>
                    <td><?php ?>&nbsp;</td>
                    <td align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_COUPON_FORMER) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a> ' . go_picture_submit('button_send_mail.gif', PICTURE_SEND_EMAIL); ?></td>
                  </tr>
                </table></td>
              </tr>
            </table></td>
          </form></tr>
<?php 
    break;       
  case 'email':
    $coupon_query = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_id = '" . (int)$_GET['cid'] . "'");
    $coupon_result = go_db_fetch_array($coupon_query);
    $coupon_name_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . (int)$_GET['cid'] . "' and language_id = '" . $languages_id . "'");
    $coupon_name = go_db_fetch_array($coupon_name_query);
?>
      <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
          <?php echo go_fetch_form('mail', NAME_OF_FILE_COUPON_FORMER, 'action=preview_email&cid='. $_GET['cid']); ?>
            <td><table border="0" cellpadding="0" cellspacing="2">
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
<?php
    $attendees = array();
    $attendees[] = array('id' => '', 'text' => TEXT_SELECT_ATTENDEE);
    $attendees[] = array('id' => '***', 'text' => TEXT_ALL_ATTENDEES);
    $attendees[] = array('id' => '**D', 'text' => TEXT_NEWSLETTER_ATTENDEES);
    $mail_query = go_db_query("select attendees_email_address, attendees_firstname, attendees_lastname from " . DB_TBL_ATTENDEES . " order by attendees_lastname");
    while($attendees_values = go_db_fetch_array($mail_query)) {
      $attendees[] = array('id' => $attendees_values['attendees_email_address'],
                           'text' => $attendees_values['attendees_lastname'] . ', ' . $attendees_values['attendees_firstname'] . ' (' . $attendees_values['attendees_email_address'] . ')');
    }
?>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="main"><?php echo TEXT_COUPON; ?>&nbsp;&nbsp;</td>
                <td><?php echo $coupon_name['coupon_name']; ?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="main"><?php echo TEXT_ATTENDEE; ?>&nbsp;&nbsp;</td>
                <td><?php echo go_fetch_pull_down_menu('attendees_email_address', $attendees, $_GET['attendee']);?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td class="main"><?php echo TEXT_FROM; ?>&nbsp;&nbsp;</td>
                <td><?php echo go_fetch_inputfeld('from', EMAIL_FROM); ?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
<?php
 ?>
              <tr>
                <td class="main"><?php echo TEXT_SUBJECT; ?>&nbsp;&nbsp;</td>
                <td><?php echo go_fetch_inputfeld('subject'); ?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td valign="top" class="main"><?php echo TEXT_MESSAGE; ?>&nbsp;&nbsp;</td>
                <td><?php echo go_fetch_textarea_field('message', 'soft', '60', '15'); ?></td>
              </tr>
              <tr>
                <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
              </tr>
              <tr>
                <td colspan="2" align="right"><?php echo go_picture_submit('button_send_mail.gif', PICTURE_SEND_EMAIL); ?></td>
              </tr>
            </table></td>
          </form>
<?php      
    break;
  case 'update_preview':
?>
      <td width="100%" valign="top">
      	<table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td>
        	<table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table>
        </td>
      </tr>
      <tr>
      <td>
<?php echo go_fetch_form('coupon', 'main_bigware_21.php', 'action=update_confirm&oldaction=' . $_GET['oldaction'] . '&cid=' . $_GET['cid']); ?>
      <table border="0" width="100%" cellspacing="0" cellpadding="6">
<?php
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $language_id = $languages[$i]['id'];
?>
      <tr>
        <td align="left"><?php echo COUPON_NAME; ?></td>
        <td align="left"><?php echo $_POST['coupon_name'][$language_id]; ?></td>
      </tr>
<?php
}
?>
<?php
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $language_id = $languages[$i]['id'];
?>
      <tr>
        <td align="left"><?php echo COUPON_DESC; ?></td>
        <td align="left"><?php echo $_POST['coupon_desc'][$language_id]; ?></td>
      </tr>
<?php
}
?>
      <tr>
        <td align="left"><?php echo COUPON_AMOUNT; ?></td>
        <td align="left"><?php echo $_POST['coupon_amount']; ?></td>
      </tr>
 
      <tr>
        <td align="left"><?php echo COUPON_MIN_ORDER; ?></td>
        <td align="left"><?php echo $_POST['coupon_min_order']; ?></td>
      </tr>
      <tr>
        <td align="left"><?php echo COUPON_FREE_SHIP; ?></td>
<?php
    if ($_POST['coupon_free_ship']) {
?>
        <td align="left"><?php echo TEXT_FREE_SHIPPING; ?></td>
<?php
    } else { 
?>
        <td align="left"><?php echo TEXT_NO_FREE_SHIPPING; ?></td>
<?php
    }
?>
      </tr>
      <tr>
        <td align="left"><?php echo COUPON_CODE; ?></td>
<?php
    if ($_POST['coupon_code']) {
      $c_code = $_POST['coupon_code'];
    } else {
      $c_code = $coupon_code;
    }
?>
        <td align="left"><?php echo $coupon_code; ?></td>
      </tr>
      
      <tr>
        <td align="left"><?php echo COUPON_USES_COUPON; ?></td>
        <td align="left"><?php echo $_POST['coupon_uses_coupon']; ?></td>
      </tr>
      <tr>
        <td align="left"><?php echo COUPON_USES_USER; ?></td>
        <td align="left"><?php echo $_POST['coupon_uses_user']; ?></td>
      </tr>
      
       <tr>
        <td align="left"><?php echo COUPON_ITEMS; ?></td>
        <td align="left"><?php echo $_POST['coupon_items']; ?></td>
      </tr>
      <tr>
        <td align="left"><?php echo COUPON_CATEGORIES; ?></td>
        <td align="left"><?php echo $_POST['coupon_categories']; ?></td>
      </tr>
      <tr>
        <td align="left"><?php echo COUPON_STARTDATE; ?></td>
<?php
    $start_date = date(DATE_FORMAT, mktime(0, 0, 0, $_POST['coupon_startdate_month'],$_POST['coupon_startdate_day'] ,$_POST['coupon_startdate_year'] ));
?>
        <td align="left"><?php echo $start_date; ?></td>
      </tr>
      
      <tr>
        <td align="left"><?php echo COUPON_FINISHDATE; ?></td>
<?php
    $finish_date = date(DATE_FORMAT, mktime(0, 0, 0, $_POST['coupon_finishdate_month'],$_POST['coupon_finishdate_day'] ,$_POST['coupon_finishdate_year'] ));
    echo date('Y-m-d', mktime(0, 0, 0, $_POST['coupon_startdate_month'],$_POST['coupon_startdate_day'] ,$_POST['coupon_startdate_year'] ));
?>
        <td align="left"><?php echo $finish_date; ?></td>
      </tr>
<?php
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $language_id = $languages[$i]['id'];
          echo go_fetch_hidden_field('coupon_name[' . $languages[$i]['id'] . ']', $_POST['coupon_name'][$language_id]);
          echo go_fetch_hidden_field('coupon_desc[' . $languages[$i]['id'] . ']', $_POST['coupon_desc'][$language_id]);
       }
    echo go_fetch_hidden_field('coupon_amount', $_POST['coupon_amount']);
    echo go_fetch_hidden_field('coupon_min_order', $_POST['coupon_min_order']);
    echo go_fetch_hidden_field('coupon_free_ship', $_POST['coupon_free_ship']);
    echo go_fetch_hidden_field('coupon_code', $c_code);
    echo go_fetch_hidden_field('coupon_uses_coupon', $_POST['coupon_uses_coupon']);
    echo go_fetch_hidden_field('coupon_uses_user', $_POST['coupon_uses_user']);
    echo go_fetch_hidden_field('coupon_items', $_POST['coupon_items']);
    echo go_fetch_hidden_field('coupon_categories', $_POST['coupon_categories']);
    echo go_fetch_hidden_field('coupon_startdate', date('Y-m-d', mktime(0, 0, 0, $_POST['coupon_startdate_month'],$_POST['coupon_startdate_day'] ,$_POST['coupon_startdate_year'] )));
    echo go_fetch_hidden_field('coupon_finishdate', date('Y-m-d', mktime(0, 0, 0, $_POST['coupon_finishdate_month'],$_POST['coupon_finishdate_day'] ,$_POST['coupon_finishdate_year'] )));
?>
     <tr>
        <td align="left"><?php echo go_picture_submit('button_confirm.gif',COUPON_BUTTON_CONFIRM); ?></td>
        <td align="left"><?php echo go_picture_submit('button_back.gif',COUPON_BUTTON_BACK, 'name=back'); ?></td>
      </td>
      </tr>
      </table>
      </form>
      
      </td>
      </tr>
      </table>
      
      </td>
<?php      
   
    break;
  case 'voucherchange':
    $languages = go_get_languages();
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
      $language_id = $languages[$i]['id'];
      $coupon_query = go_db_query("select coupon_name,coupon_description from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" .  (int)$_GET['cid'] . "' and language_id = '" . $language_id . "'");
      $coupon = go_db_fetch_array($coupon_query);
      $coupon_name[$language_id] = $coupon['coupon_name'];
      $coupon_desc[$language_id] = $coupon['coupon_description'];
    }
    $coupon_query=go_db_query("select coupon_code, coupon_amount, coupon_type, coupon_minimum_order, coupon_start_date, coupon_expire_date, uses_per_coupon, uses_per_user, restrict_to_items, restrict_to_categories from " . DB_TBL_COUPONS . " where coupon_id = '" . (int)$_GET['cid'] . "'");
    $coupon=go_db_fetch_array($coupon_query);
    $coupon_amount = $coupon['coupon_amount'];
    if ($coupon['coupon_type']=='P') {
      $coupon_amount .= '%';
    }
    if ($coupon['coupon_type']=='S') {
      $coupon_free_ship .= true;
    }     
    $coupon_min_order = $coupon['coupon_minimum_order'];
    $coupon_code = $coupon['coupon_code'];
    $coupon_uses_coupon = $coupon['uses_per_coupon'];
    $coupon_uses_user = $coupon['uses_per_user'];
    $coupon_items = $coupon['restrict_to_items'];
    $coupon_categories = $coupon['restrict_to_categories'];     
  case 'new': 
    if (!$coupon_uses_user) $coupon_uses_user=1;
?>
      <td width="100%" valign="top">
      
      <table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td>
        
        <table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table>
        
        </td>
      </tr>
      <tr>
        <td>
<?php 
    echo go_fetch_form('coupon', 'main_bigware_21.php', 'action=update&oldaction='.$_GET['action'] . '&cid=' . $_GET['cid']); 
?>
      <table border="0" width="100%" cellspacing="0" cellpadding="6">
<?php
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        $language_id = $languages[$i]['id'];
?>
      <tr>
        <td align="left" class="main"><?php if ($i==0) echo COUPON_NAME; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_name[' . $languages[$i]['id'] . ']', $coupon_name[$language_id]) . '&nbsp;' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']); ?></td>
        <td align="left" class="main" width="40%"><?php if ($i==0) echo COUPON_NAME_HELP; ?></td>
      </tr>
<?php
}
?>
<?php
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        $language_id = $languages[$i]['id'];
?>
      <tr>
        <td align="left" valign="top" class="main"><?php if ($i==0) echo COUPON_DESC; ?></td>
        <td align="left" valign="top"><?php echo go_fetch_textarea_field('coupon_desc[' . $languages[$i]['id'] . ']','physical','24','3', $coupon_desc[$language_id]) . '&nbsp;' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']); ?></td>
        <td align="left" valign="top" class="main"><?php if ($i==0) echo COUPON_DESC_HELP; ?></td>
      </tr>
<?php
}
?>
      <tr>
        <td align="left" class="main"><?php echo COUPON_AMOUNT; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_amount', $coupon_amount); ?></td>
        <td align="left" class="main"><?php echo COUPON_AMOUNT_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_MIN_ORDER; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_min_order', $coupon_min_order); ?></td>
        <td align="left" class="main"><?php echo COUPON_MIN_ORDER_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_FREE_SHIP; ?></td>
        <td align="left"><?php echo go_fetch_checkbox_field('coupon_free_ship', $coupon_free_ship); ?></td>
        <td align="left" class="main"><?php echo COUPON_FREE_SHIP_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_CODE; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_code', $coupon_code); ?></td>
        <td align="left" class="main"><?php echo COUPON_CODE_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_USES_COUPON; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_uses_coupon', $coupon_uses_coupon); ?></td>
        <td align="left" class="main"><?php echo COUPON_USES_COUPON_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_USES_USER; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_uses_user', $coupon_uses_user); ?></td>
        <td align="left" class="main"><?php echo COUPON_USES_USER_HELP; ?></td>
      </tr>
       <tr>
        <td align="left" class="main"><?php echo COUPON_ITEMS; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_items', $coupon_items); ?> <A HREF="main_bigware_123.php" TARGET="_blank" ONCLICK="window.open('main_bigware_123.php', 'Valid_Products', 'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600'); return false"><?php echo TEXT_VIEW; ?></A></td>
        <td align="left" class="main"><?php echo COUPON_ITEMS_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_CATEGORIES; ?></td>
        <td align="left"><?php echo go_fetch_inputfeld('coupon_categories', $coupon_categories); ?> <A HREF="main_bigware_122.php" TARGET="_blank" ONCLICK="window.open('main_bigware_122.php', 'Valid_Categories', 'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600'); return false"><?php echo TEXT_VIEW; ?></A></td>
        <td align="left" class="main"><?php echo COUPON_CATEGORIES_HELP; ?></td>
      </tr>
      <tr>
<?php
    if (!$_POST['coupon_startdate']) {
      $coupon_startdate = preg_split("/[-]/", date('Y-m-d'));
    } else {
      $coupon_startdate = preg_split("/[-]/", $_POST['coupon_startdate']);
    }
    if (!$_POST['coupon_finishdate']) {
      $coupon_finishdate = preg_split("/[-]/", date('Y-m-d'));
      $coupon_finishdate[0] = $coupon_finishdate[0] + 1;
    } else {
      $coupon_finishdate = preg_split("/[-]/", $_POST['coupon_finishdate']);
    }
?>
        <td align="left" class="main"><?php echo COUPON_STARTDATE; ?></td>
        <td align="left"><?php echo go_fetch_date_selector('coupon_startdate', mktime(0,0,0, $coupon_startdate[1], $coupon_startdate[2], $coupon_startdate[0], 0)); ?></td>
        <td align="left" class="main"><?php echo COUPON_STARTDATE_HELP; ?></td>
      </tr>
      <tr>
        <td align="left" class="main"><?php echo COUPON_FINISHDATE; ?></td>
        <td align="left"><?php echo go_fetch_date_selector('coupon_finishdate', mktime(0,0,0, $coupon_finishdate[1], $coupon_finishdate[2], $coupon_finishdate[0], 0)); ?></td>
        <td align="left" class="main"><?php echo COUPON_FINISHDATE_HELP; ?></td>
      </tr>
      <tr>
        <td align="left"><?php echo go_picture_submit('button_preview.gif',COUPON_BUTTON_PREVIEW); ?></td>
        <td align="left"><?php echo '&nbsp;&nbsp;<a href="' . go_href_link('main_bigware_21.php', ''); ?>"><?php echo go_picture_button('button_cancel.gif', PICTURE_CANCEL); ?></a>
      </td>
      </tr>
      </table></form>
      </td></tr>
      </table></td>
<?php
    break;
  default:
?>    
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td width="100%" class="smallText"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="main"><?php echo go_fetch_form('status', NAME_OF_FILE_COUPON_FORMER, '', 'get'); ?>
<?php
    $status_array[] = array('id' => 'Y', 'text' => TEXT_COUPON_ACTIVE);
    $status_array[] = array('id' => 'N', 'text' => TEXT_COUPON_INACTIVE);
    $status_array[] = array('id' => '*', 'text' => TEXT_COUPON_ALL);
    if ($_GET['status']) {
      $status = go_db_producing_input($_GET['status']);
    } else { 
      $status = 'Y';
    } 
    echo ABOVE_TITLE_STATUS . ' ' . go_fetch_pull_down_menu('status', $status_array, $status, 'onChange="this.form.submit();"'); 
?>
              </form>
           </td>
          </tr>
        </table><br><?php echo ANMERKUNG; ?><br><br></td>
      </tr>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo COUPON_NAME; ?></td>
                <td class="tbUPDataInside" align="center"><?php echo COUPON_AMOUNT; ?></td>	
                <td class="tbUPDataInside" align="center"><?php echo COUPON_CODE; ?></td>	
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
    if ($_GET['page'] > 1) $rows = $_GET['page'] * 20 - 20;
    if ($status != '*') {
      $cc_query_raw = "select coupon_id, coupon_code, coupon_amount, coupon_type, coupon_start_date,coupon_expire_date,uses_per_user,uses_per_coupon,restrict_to_items, restrict_to_categories, date_created,date_modified from " . DB_TBL_COUPONS ." where coupon_active='" . go_db_input($status) . "' and coupon_type != 'G'";
    } else {
      $cc_query_raw = "select coupon_id, coupon_code, coupon_amount, coupon_type, coupon_start_date,coupon_expire_date,uses_per_user,uses_per_coupon,restrict_to_items, restrict_to_categories, date_created,date_modified from " . DB_TBL_COUPONS . " where coupon_type != 'G'";
    }
    $cc_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $cc_query_raw, $cc_query_numrows);
    $cc_query = go_db_query($cc_query_raw);
    while ($cc_list = go_db_fetch_array($cc_query)) {
      $rows++;
      if (strlen($rows) < 2) {
        $rows = '0' . $rows;
      }
      if (((!$_GET['cid']) || (@$_GET['cid'] == $cc_list['coupon_id'])) && (!$bigwareInfo)) {
        $bigwareInfo = new objectInfo($cc_list);
      }
      if ( (is_object($bigwareInfo)) && ($cc_list['coupon_id'] == $bigwareInfo->coupon_id) ) {
        echo '          <tr class="tbCountDataSelected" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . go_href_link('main_bigware_21.php', go_get_all_get_parameter(array('cid', 'action')) . 'cid=' . $bigwareInfo->coupon_id . '&action=change') . '\'">' . "\n";
      } else {
        echo '          <tr class="tbCountData" onmouseover="this.className=\'tbCountDataOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'tbCountData\'" onclick="document.location.href=\'' . go_href_link('main_bigware_21.php', go_get_all_get_parameter(array('cid', 'action')) . 'cid=' . $cc_list['coupon_id']) . '\'">' . "\n";
      }
      $coupon_description_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . $cc_list['coupon_id'] . "' and language_id = '" . $languages_id . "'");
      $coupon_desc = go_db_fetch_array($coupon_description_query);
?>
                <td class="TbInsideData"><?php echo $coupon_desc['coupon_name']; ?></td>
                <td class="TbInsideData" align="center">
<?php  
      if ($cc_list['coupon_type'] == 'P') {
        echo $cc_list['coupon_amount'] . '%';
      } elseif ($cc_list['coupon_type'] == 'S') {
        echo TEXT_FREE_SHIPPING;
      } else {
        echo $currencies->format($cc_list['coupon_amount']);
      }
?>
            &nbsp;</td>
                <td class="TbInsideData" align="center"><?php echo $cc_list['coupon_code']; ?></td>
                <td class="TbInsideData" align="right"><?php if ( (is_object($bigwareInfo)) && ($cc_list['coupon_id'] == $bigwareInfo->coupon_id) ) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif'); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_COUPON_FORMER, 'page=' . $_GET['page'] . '&cid=' . $cc_list['coupon_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
?>


          <tr>
            <td colspan="5"><table border="0" width="100%" cellspacing="0" cellpadding="2">
              <tr>
                <td class="smallText">&nbsp;<?php echo $cc_split->display_count($cc_query_numrows, MAX_SHOW_SEARCH_RESULTS, $_GET['page'], TEXT_SHOW_NUMBER_OF_COUPONS); ?>&nbsp;</td>
                <td align="right" class="smallText">&nbsp;<?php echo $cc_split->display_links($cc_query_numrows, MAX_SHOW_SEARCH_RESULTS, MAX_SHOW_PAGE_LINKS, $_GET['page']); ?>&nbsp;</td>
              </tr>
              <tr>
                <td align="right" colspan="2" class="smallText"><?php echo '<a href="' . go_href_link('main_bigware_21.php', 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->coupon_id . '&action=new') . '">' . go_picture_button('button_insert.gif', PICTURE_INSERT) . '</a>'; ?></td>
              </tr>
            </table></td>
          </tr>
        </table></td>
<?php
    $heading = array();
    $contents = array();
    switch ($_GET['action']) {
    case 'release':
      break;
    case 'voucherreport':
      $heading[] = array('text' => '<b>' . TEXT_ABOVE_COUPON_REPORT . '</b>');
      $contents[] = array('text' => TEXT_NEW_INTRO);
      break;
    case 'neww':
      $heading[] = array('text' => '<b>' . TEXT_ABOVE_NEW_COUPON . '</b>');
      $contents[] = array('text' => TEXT_NEW_INTRO);
      $contents[] = array('text' => '<br>' . COUPON_NAME . '<br>' . go_fetch_inputfeld('name'));
      $contents[] = array('text' => '<br>' . COUPON_AMOUNT . '<br>' . go_fetch_inputfeld('voucher_amount'));
      $contents[] = array('text' => '<br>' . COUPON_CODE . '<br>' . go_fetch_inputfeld('voucher_code'));
      $contents[] = array('text' => '<br>' . COUPON_USES_COUPON . '<br>' . go_fetch_inputfeld('voucher_number_of'));
      break;
    default:
      $heading[] = array('text'=>'['.$bigwareInfo->coupon_id.']  '.$bigwareInfo->coupon_code);
      $amount = $bigwareInfo->coupon_amount;
      if ($bigwareInfo->coupon_type == 'P') {
        $amount .= '%';
      } else {
        $amount = $currencies->format($amount);
      }
      if ($_GET['action'] == 'voucherdelete') {
        $contents[] = array('text'=> TEXT_CONFIRM_DELETE . '</br></br>' . 
                '<a href="'.go_href_link('main_bigware_21.php','action=confirmdelete&cid='.$_GET['cid'],'NONSSL').'">'.go_picture_button('button_confirm.gif','Confirm Delete Voucher').'</a>' .
                '<a href="'.go_href_link('main_bigware_21.php','cid='.$bigwareInfo->coupon_id,'NONSSL').'">'.go_picture_button('button_cancel.gif','Cancel').'</a>'
                );
      } else { 
        $prod_details = NONE;
        if ($bigwareInfo->restrict_to_items) {
          $prod_details = '<A HREF="main_bigware_78.php?cid=' . $bigwareInfo->coupon_id . '" TARGET="_blank" ONCLICK="window.open(\'main_bigware_78.php?cid=' . $bigwareInfo->coupon_id . '\', \'Valid_Categories\', \'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600\'); return false">View</A>';
        }     
        $cat_details = NONE;
        if ($bigwareInfo->restrict_to_categories) {
          $cat_details = '<A HREF="main_bigware_77.php?cid=' . $bigwareInfo->coupon_id . '" TARGET="_blank" ONCLICK="window.open(\'main_bigware_77.php?cid=' . $bigwareInfo->coupon_id . '\', \'Valid_Categories\', \'scrollbars=yes,resizable=yes,menubar=yes,width=600,height=600\'); return false">View</A>';
        }
        $coupon_name_query = go_db_query("select coupon_name from " . DB_TBL_COUPONS_DESCRIPTION . " where coupon_id = '" . $bigwareInfo->coupon_id . "' and language_id = '" . $languages_id . "'");
        $coupon_name = go_db_fetch_array($coupon_name_query);       
        $contents[] = array('text'=>COUPON_NAME . '&nbsp;::&nbsp; ' . $coupon_name['coupon_name'] . '<br>' .
                     COUPON_AMOUNT . '&nbsp;::&nbsp; ' . $amount . '<br>' .
                     COUPON_STARTDATE . '&nbsp;::&nbsp; ' . go_date_short($bigwareInfo->coupon_start_date) . '<br>' .
                     COUPON_FINISHDATE . '&nbsp;::&nbsp; ' . go_date_short($bigwareInfo->coupon_expire_date) . '<br>' .
                     COUPON_USES_COUPON . '&nbsp;::&nbsp; ' . $bigwareInfo->uses_per_coupon . '<br>' .
                     COUPON_USES_USER . '&nbsp;::&nbsp; ' . $bigwareInfo->uses_per_user . '<br>' .
                     COUPON_ITEMS . '&nbsp;::&nbsp; ' . $prod_details . '<br>' .
                     COUPON_CATEGORIES . '&nbsp;::&nbsp; ' . $cat_details . '<br>' .
                     DATE_CREATED . '&nbsp;::&nbsp; ' . go_date_short($bigwareInfo->date_created) . '<br>' .
                     DATE_MODIFIED . '&nbsp;::&nbsp; ' . go_date_short($bigwareInfo->date_modified) . '<br><br>' .
                     '<center><a href="'.go_href_link('main_bigware_21.php','action=email&cid='.$bigwareInfo->coupon_id,'NONSSL').'">'.go_picture_button('button_email.gif', TEXT_EMAIL_VOUCHER).'</a>' .
                     '<a href="'.go_href_link('main_bigware_21.php','action=voucherchange&cid='.$bigwareInfo->coupon_id,'NONSSL').'">'.go_picture_button('button_change.gif', TEXT_EDIT_VOUCHER).'</a>' .
                     '<a href="'.go_href_link('main_bigware_21.php','action=voucherdelete&cid='.$bigwareInfo->coupon_id,'NONSSL').'">'.go_picture_button('button_delete.gif', TEXT_DELETE_VOUCHER).'</a>' .
                     '<br><a href="'.go_href_link('main_bigware_21.php','action=voucherreport&cid='.$bigwareInfo->coupon_id,'NONSSL').'">'.go_picture_button('button_report.gif', TEXT_REPORT_VOUCHER).'</a></center>'
                     );
        }
        break;
      }
?>                       
    <td width="25%" valign="top">
<?php
      $frame = new frame;
      echo $frame->infoBox($heading, $contents);
    echo '            </td>' . "\n";
    }
?>
          </tr>
        </table>
<?php 
if (($_GET['action'] == "update_confirm" AND $_GET['oldaction']=="new") OR ($_GET['action'] != "voucherchange" AND $_GET['action'] != "new" AND ($_GET['action'] != "update" AND $_GET['oldaction']!="new"))){
	?>        
	        
	        </td>
	      </tr>
	    </table>
	<!-- body_eof //-->
	<?php 
	if ($_GET['action'] != "email" AND $_GET['action'] != "preview_email"){
	?>
	</td>
	<!-- body_text_eof //-->
	  </tr>
	</table>
	<?php 
	}
}



?>
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
