<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  require(FOLDER_RELATIV_CLASSES . 'class_bigware_1.php');
  $currencies = new currencies();
  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  
  if (go_not_null($action)) {
    switch ($action) {
      case 'insert':
      case 'save':
        if (isset($_GET['bigID'])) $currency_id = go_db_producing_input($_GET['bigID']);
        $title = go_db_producing_input($_POST['title']);
        $code = go_db_producing_input($_POST['code']);
        $symbol_left = go_db_producing_input($_POST['symbol_left']);
        $symbol_right = go_db_producing_input($_POST['symbol_right']);
        $decimal_point = go_db_producing_input($_POST['decimal_point']);
        $thousands_point = go_db_producing_input($_POST['thousands_point']);
        $decimal_places = go_db_producing_input($_POST['decimal_places']);
        $roundings = go_db_producing_input($_POST['roundings']);
        if ( $roundings != 'std'){
        	$roundings = go_db_producing_input($_POST['roundings_from']).";".implode(",",go_db_producing_input($_POST['roundings_custom']));
        }
        $value = go_db_producing_input($_POST['value']);
        $sql_data_array = array('title' => $title,
                                'code' => $code,
                                'symbol_left' => $symbol_left,
                                'symbol_right' => $symbol_right,
                                'decimal_point' => $decimal_point,
                                'thousands_point' => $thousands_point,
                                'decimal_places' => $decimal_places,
            					'roundings'=>$roundings,
                                'value' => $value);
        if ($action == 'insert') {
          go_db_carry(DB_TBL_CURRENCIES, $sql_data_array);
          $currency_id = go_db_insert_id();
        } elseif ($action == 'save') {
          go_db_carry(DB_TBL_CURRENCIES, $sql_data_array, 'update', "currencies_id = '" . (int)$currency_id . "'");
        }
        if (isset($_POST['default']) && ($_POST['default'] == 'on')) {
          go_db_query("update " . DB_TBL_SET_IT_UP . " set set_it_up_value = '" . go_db_input($code) . "' where set_it_up_key = 'DEFAULT_CURRENCY'");
        }
        go_forward(go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $currency_id));
        break;
      case 'deleteconfirm':
        $currencies_id = go_db_producing_input($_GET['bigID']);
        $currency_query = go_db_query("select currencies_id from " . DB_TBL_CURRENCIES . " where code = '" . DEFAULT_CURRENCY . "'");
        $currency = go_db_fetch_array($currency_query);
        if ($currency['currencies_id'] == $currencies_id) {
          go_db_query("update " . DB_TBL_SET_IT_UP . " set set_it_up_value = '' where set_it_up_key = 'DEFAULT_CURRENCY'");
        }
        go_db_query("delete from " . DB_TBL_CURRENCIES . " where currencies_id = '" . (int)$currencies_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page']));
        break;
      case 'update':
        $server_used = CURRENCY_SERVER_PRIMARY;
        $currency_query = go_db_query("select currencies_id, code, title from " . DB_TBL_CURRENCIES);
        while ($currency = go_db_fetch_array($currency_query)) {
          $quote_function = 'quote_' . CURRENCY_SERVER_PRIMARY . '_currency';
          $rate = $quote_function($currency['code']);
          if (empty($rate) && (go_not_null(CURRENCY_SERVER_BACKUP))) {
            $messageStack->add_session(sprintf(WARNING_PRIMARY_SERVER_FAILED, CURRENCY_SERVER_PRIMARY, $currency['title'], $currency['code']), 'warning');
            $quote_function = 'quote_' . CURRENCY_SERVER_BACKUP . '_currency';
            $rate = $quote_function($currency['code']);
            $server_used = CURRENCY_SERVER_BACKUP;
          }
          if (go_not_null($rate)) {
            go_db_query("update " . DB_TBL_CURRENCIES . " set value = '" . $rate . "', last_updated = now() where currencies_id = '" . (int)$currency['currencies_id'] . "'");
            $messageStack->add_session(sprintf(TEXT_INFO_CURRENCY_UPDATED, $currency['title'], $currency['code'], $server_used), 'success');
          } else {
            $messageStack->add_session(sprintf(ERROR_CURRENCY_INVALID, $currency['title'], $currency['code'], $server_used), 'error');
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $_GET['bigID']));
        break;
      case 'delete':
        $currencies_id = go_db_producing_input($_GET['bigID']);
        $currency_query = go_db_query("select code from " . DB_TBL_CURRENCIES . " where currencies_id = '" . (int)$currencies_id . "'");
        $currency = go_db_fetch_array($currency_query);
        $remove_currency = true;
        if ($currency['code'] == DEFAULT_CURRENCY) {
          $remove_currency = false;
          $messageStack->add(ERROR_REMOVE_DEFAULT_CURRENCY, 'error');
        }
        break;
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
<script src="http://code.jquery.com/jquery-1.11.0.min.js"></script>	
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF" onload="SetFocus();">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top">
<!-- left_navigation //-->
<!-- left_navigation_eof //-->
</td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_CURRENCY_NAME; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_CURRENCY_CODES; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_CURRENCY_VALUE; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
  $currency_query_raw = "select * from " . DB_TBL_CURRENCIES . " order by title"; //currencies_id, title, code, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, last_updated, value
  $currency_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $currency_query_raw, $currency_query_numrows);
  $currency_query = go_db_query($currency_query_raw);
  while ($currency = go_db_fetch_array($currency_query)) {
    if ((!isset($_GET['bigID']) || (isset($_GET['bigID']) && ($_GET['bigID'] == $currency['currencies_id']))) && !isset($bigwareInfo) && (substr($action, 0, 3) != 'new')) {
      $bigwareInfo = new objectInfo($currency);
    }
    if (isset($bigwareInfo) && is_object($bigwareInfo) && ($currency['currencies_id'] == $bigwareInfo->currencies_id) ) {
      echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=change') . '\'">' . "\n";
    } else {
      echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $currency['currencies_id']) . '\'">' . "\n";
    }
    if (DEFAULT_CURRENCY == $currency['code']) {
      echo '                <td class="TbInsideData"><b>' . $currency['title'] . ' (' . TEXT_DEFAULT . ')</b></td>' . "\n";
    } else {
      echo '                <td class="TbInsideData">' . $currency['title'] . '</td>' . "\n";
    }
?>
                <td class="TbInsideData"><?php echo $currency['code']; ?></td>
                <td class="TbInsideData" align="right"><?php echo number_format($currency['value'], 8); ?></td>
                <td class="TbInsideData" align="right"><?php if (isset($bigwareInfo) && is_object($bigwareInfo) && ($currency['currencies_id'] == $bigwareInfo->currencies_id) ) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif'); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $currency['currencies_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
              <tr>
                <td colspan="4"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td class="smallText" valign="top"><?php echo $currency_split->display_count($currency_query_numrows, MAX_SHOW_SEARCH_RESULTS, $_GET['page'], TEXT_SHOW_NUMBER_OF_CURRENCIES); ?></td>
                    <td class="smallText" align="right"><?php echo $currency_split->display_links($currency_query_numrows, MAX_SHOW_SEARCH_RESULTS, MAX_SHOW_PAGE_LINKS, $_GET['page']); ?></td>
                  </tr>
<?php
  if (empty($action)) {
?>
                  <tr>
                    <td><?php if (CURRENCY_SERVER_PRIMARY) { echo '<a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=update') . '">' . go_picture_button('button_update_currencies.gif', PICTURE_UPDATE_CURRENCIES) . '</a>'; } ?></td>
                    <td align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=new') . '">' . go_picture_button('button_new_currency.gif', PICTURE_NEW_CURRENCY) . '</a>'; ?></td>
                  </tr>
<?php
  }
?>
                </table></td>
              </tr>
            </table></td>
<?php
  $heading = array();
  $contents = array();
  $roundings = array();
  $roundings_custom = array();
  if (isset($bigwareInfo)){
  	  $roundings = $bigwareInfo->roundings;
  	  $decimal_places = $bigwareInfo->decimal_places;
  	  if ( $roundings != "std"){
  	  	list($roundings_from,$roundings_customed) = explode(";",$roundings);
  	  	$roundings_customed = explode(",",$roundings_customed);
  	  	$roundings = 'custom';  

  	  }
  }else{
  	  $roundings = 'std';
  	  $decimal_places = 2;
  }	  
  if (empty($roundings_from)){
  	 $roundings_from = $decimal_places + 1;
  }

  for ($i =0 ; $i< 10; $i++){
  	  $roundings_list[$i] = array("id"=>$i,"text"=>$i);
  	  $rvalue = str_replace("1",$i, pow(10,$decimal_places* -1));
  	  $roundings_custom[$i] = array("id"=>$rvalue,"text"=>$rvalue);
  }
  	$roundings_custom[10] = array("id"=>pow(10, ($decimal_places-1) * -1)."0","text"=>pow(10,($decimal_places-1)*-1)."0");
  	$display = ($roundings == 'std')? "none":"block";
  	$roundings_custom_content = '<div id="rounding_custom" style="display:'.$display.';">';
   	$roundings_custom_content .= TEXT_INFO_CURRENCY_ROUNDINGS_FROM.go_fetch_pull_down_menu('roundings_from',array_slice($roundings_list,$decimal_places,2),$roundings_from);
   	$roundings_custom_content .= '<ul style="list-style-type:none; margin:2px;padding:5px;text-indent:5px;">';
  for ($i =0 ; $i< 10; $i++){
  	  $roundings_custom_content .= '<li style="border:1px solid #eee;"><span>'.str_replace("1",$i, pow(10,$roundings_from*-1))."</span> -> ".go_fetch_pull_down_menu('roundings_custom[]',$roundings_custom, $roundings_customed[$i])."</li>";
  }
  $roundings_custom_content .= '</ul>';
  $roundings_custom_content .= '</div>';
  switch ($action) {
    case 'new':
      $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_NEW_CURRENCY . '</b>');
      $contents = array('form' => go_fetch_form('currencies', NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . (isset($bigwareInfo) ? '&bigID=' . $bigwareInfo->currencies_id : '') . '&action=insert'));
      $contents[] = array('text' => TEXT_INFO_INSERT_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_TITLE . '<br>' . go_fetch_inputfeld('title'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_CODE . '<br>' . go_fetch_inputfeld('code'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_SYMBOL_LEFT . '<br>' . go_fetch_inputfeld('symbol_left'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_SYMBOL_RIGHT . '<br>' . go_fetch_inputfeld('symbol_right'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_DECIMAL_POINT . '<br>' . go_fetch_inputfeld('decimal_point'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_THOUSANDS_POINT . '<br>' . go_fetch_inputfeld('thousands_point'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_DECIMAL_PLACES . '<br>' . go_fetch_pull_down_menu('decimal_places',array_slice($roundings_list,0,5),$decimal_places));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_ROUNDINGS . '<br>' . go_fetch_pull_down_menu('roundings',array(array("id"=>"std","text"=>TEXT_INFO_CURRENCY_ROUNDINGS_STD) ,array("id"=>"custom","text"=>TEXT_INFO_CURRENCY_ROUNDINGS_CUSTOM)),'std').$roundings_custom_content);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_VALUE . '<br>' . go_fetch_inputfeld('value'));
      $contents[] = array('text' => '<br>' . go_fetch_checkbox_field('default') . ' ' . TEXT_INFO_SET_AS_DEFAULT);
      $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_insert.gif', PICTURE_INSERT) . ' <a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $_GET['bigID']) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    case 'change':
      $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_CHANGE_CURRENCY . '</b>');
      $contents = array('form' => go_fetch_form('currencies', NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=save'));
      $contents[] = array('text' => TEXT_INFO_CHANGE_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_TITLE . '<br>' . go_fetch_inputfeld('title', $bigwareInfo->title));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_CODE . '<br>' . go_fetch_inputfeld('code', $bigwareInfo->code));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_SYMBOL_LEFT . '<br>' . go_fetch_inputfeld('symbol_left', $bigwareInfo->symbol_left));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_SYMBOL_RIGHT . '<br>' . go_fetch_inputfeld('symbol_right', $bigwareInfo->symbol_right));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_DECIMAL_POINT . '<br>' . go_fetch_inputfeld('decimal_point', $bigwareInfo->decimal_point));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_THOUSANDS_POINT . '<br>' . go_fetch_inputfeld('thousands_point', $bigwareInfo->thousands_point));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_DECIMAL_PLACES . '<br>' . go_fetch_pull_down_menu('decimal_places',array_slice($roundings_list,0,5),$decimal_places));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_ROUNDINGS . '<br>' . go_fetch_pull_down_menu('roundings',array(array("id"=>"std","text"=>TEXT_INFO_CURRENCY_ROUNDINGS_STD) ,array("id"=>"custom","text"=>TEXT_INFO_CURRENCY_ROUNDINGS_CUSTOM)),$roundings).$roundings_custom_content);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_VALUE . '<br>' . go_fetch_inputfeld('value', $bigwareInfo->value));
      if (DEFAULT_CURRENCY != $bigwareInfo->code) $contents[] = array('text' => '<br>' . go_fetch_checkbox_field('default') . ' ' . TEXT_INFO_SET_AS_DEFAULT);
      $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_update.gif', PICTURE_UPDATE) . ' <a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    case 'delete':
      $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_DELETE_CURRENCY . '</b>');
      $contents[] = array('text' => TEXT_INFO_DELETE_INTRO);
      $contents[] = array('text' => '<br><b>' . $bigwareInfo->title . '</b>');
      $contents[] = array('align' => 'center', 'text' => '<br>' . (($remove_currency) ? '<a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=deleteconfirm') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a>' : '') . ' <a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
      break;
    default:
      if (is_object($bigwareInfo)) {
        $heading[] = array('text' => '<b>' . $bigwareInfo->title . '</b>');
        $contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=change') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_CURRENCIES, 'page=' . $_GET['page'] . '&bigID=' . $bigwareInfo->currencies_id . '&action=delete') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a>');
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_TITLE . ' ' . $bigwareInfo->title);
        $contents[] = array('text' => TEXT_INFO_CURRENCY_CODE . ' ' . $bigwareInfo->code);
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_SYMBOL_LEFT . ' ' . $bigwareInfo->symbol_left);
        $contents[] = array('text' => TEXT_INFO_CURRENCY_SYMBOL_RIGHT . ' ' . $bigwareInfo->symbol_right);
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_DECIMAL_POINT . ' ' . $bigwareInfo->decimal_point);
        $contents[] = array('text' => TEXT_INFO_CURRENCY_THOUSANDS_POINT . ' ' . $bigwareInfo->thousands_point);
        $contents[] = array('text' => TEXT_INFO_CURRENCY_DECIMAL_PLACES . ' ' . $bigwareInfo->decimal_places);
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_LAST_UPDATED . ' ' . go_date_short($bigwareInfo->last_updated));
        $contents[] = array('text' => TEXT_INFO_CURRENCY_VALUE . ' ' . number_format($bigwareInfo->value, 8));
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENCY_EXAMPLE . '<br>' . $currencies->format('30', false, DEFAULT_CURRENCY) . ' = ' . $currencies->format('30', true, $bigwareInfo->code));
      }
      break;
  }
  if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
    echo '            <td width="25%" valign="top"><br>' . "\n";
    $frame = new frame;
    echo $frame->infoBox($heading, $contents);
    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
<script type="text/javascript" language="JavaScript">
	$(function(){
		$('select[name="decimal_places"]').on('change',function(event){
				var ops = $('<select />'), d = $(this).val(), t = '0.',t1,
				 f = $('select[name="roundings_from"]');
				  f.empty().append(
					$('<option />',{value:parseInt(d)+1}).html(parseInt(d)+1)
				);
				if (d == 0){
					ops.append(
						$('<option />',{value:0}).html('0'),
						$('<option />',{value:1}).html('1')
					);		
				}else{
					for (var j=1; j< d; j++){
						t = t + '0';
					}
					for (var k=0;k<=10;k++){
						if (k == 10) t = t.slice(0,-1);  
						t1 = t + k.toString();
						if (k == 10 & d == 1) t1 = '1.0'; 
						ops.append($('<option />',{value:t1}).html(t1) );
					}
					f.append( $('<option />',{value:d}).html(d));
				}
				$('li>select','#rounding_custom').each(function(i,e){
					$(e).html(ops.html());
				});
				f.trigger('change');
		});
		$('select[name="roundings_from"]').on('change',function(event){
				var t = '0.';
				for (var j=1; j< $(this).val(); j++){
					t = t + '0';
				}	
			$(this).next().find('li>span').each(function(i,e){
				$(this).text(t + i.toString());
			});
		});
		$('select[name="roundings"]').on('change',function(event){
			if ($(this).val() == 'std'){
				$('#rounding_custom').hide();
			}else{
				$('#rounding_custom').show();
			}
		});
		
		
	})
	
</script>		
	
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
