<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  if (!go_session_is_registered('current_path')) {
    $current_path = FOLDER_ABSOLUT_DOCUMENT_ROOT;
    go_session_register('current_path');
  }
  if (isset($_GET['goto'])) {
    $current_path = $_GET['goto'];
    go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
  }
  if (strstr($current_path, '..')) $current_path = FOLDER_ABSOLUT_DOCUMENT_ROOT;
  if (!is_dir($current_path)) $current_path = FOLDER_ABSOLUT_DOCUMENT_ROOT;
  if (!preg_match('#^' . FOLDER_ABSOLUT_DOCUMENT_ROOT . '#', $current_path)) $current_path = FOLDER_ABSOLUT_DOCUMENT_ROOT;
  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  if (go_not_null($action)) {
    switch ($action) {
      case 'reset':
        go_session_unregister('current_path');
        go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        break;
      case 'deleteconfirm':
        if (strstr($_GET['info'], '..')) go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        go_remove($current_path . '/' . $_GET['info']);
        if (!$go_remove_error) go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        break;
      case 'insert':
        if (mkdir($current_path . '/' . $_POST['folder_name'], 0777)) {
          go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($_POST['folder_name'])));
        }
        break;
      case 'save':
        if ($fp = fopen($current_path . '/' . $_POST['filename'], 'w+')) {
          fputs($fp, stripslashes($_POST['file_contents']));
          fclose($fp);
          go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($_POST['filename'])));
        }
        break;
      case 'processuploads':
        for ($i=1; $i<6; $i++) {
          if (isset($GLOBALS['file_' . $i]) && go_not_null($GLOBALS['file_' . $i])) {
            new upload('file_' . $i, $current_path);
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        break;
      case 'download':
        header('Content-type: application/x-octet-stream');
        header('Content-disposition: attachment; filename=' . urldecode($_GET['filename']));
        readfile($current_path . '/' . urldecode($_GET['filename']));
        exit;
        break;
      case 'upload':
      case 'new_folder':
      case 'new_file':
        $directory_writeable = true;
        if (!is_writeable($current_path)) {
          $directory_writeable = false;
          $messageStack->add(sprintf(ERROR_DIRECTORY_NOT_WRITEABLE, $current_path), 'error');
        }
        break;
      case 'change':
        if (strstr($_GET['info'], '..')) go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        $file_writeable = true;
        if (!is_writeable($current_path . '/' . $_GET['info'])) {
          $file_writeable = false;
          $messageStack->add(sprintf(ERROR_FILE_NOT_WRITEABLE, $current_path . '/' . $_GET['info']), 'error');
        }
        break;
      case 'delete':
        if (strstr($_GET['info'], '..')) go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
        break;
    }
  }
  $in_directory = substr(substr(FOLDER_ABSOLUT_DOCUMENT_ROOT, strrpos(FOLDER_ABSOLUT_DOCUMENT_ROOT, '/')), 1);
  $current_path_array = explode('/', $current_path);
  $document_root_array = explode('/', FOLDER_ABSOLUT_DOCUMENT_ROOT);
  $goto_array = array(array('id' => FOLDER_ABSOLUT_DOCUMENT_ROOT, 'text' => $in_directory));
  for ($i=0, $n=sizeof($current_path_array); $i<$n; $i++) {
    if ((isset($document_root_array[$i]) && ($current_path_array[$i] != $document_root_array[$i])) || !isset($document_root_array[$i])) {
      $goto_array[] = array('id' => implode('/', array_slice($current_path_array, 0, $i+1)), 'text' => $current_path_array[$i]);
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top">
<!-- left_navigation //-->
<!-- left_navigation_eof //-->
</td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr><?php echo go_fetch_form('goto', NAME_OF_FILE_FILE_MANAGER, '', 'get'); ?>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE . '<br><span class="smallText">' . $current_path . '</span>'; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', ABOVE_PICTURE_HEIGHT); ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_pull_down_menu('goto', $goto_array, $current_path, 'onChange="this.form.submit();"'); ?></td>
          </form></tr>
        </table></td>
      </tr>
<?php
  if ( (($action == 'new_file') && ($directory_writeable == true)) || ($action == 'change') ) {
    if (isset($_GET['info']) && strstr($_GET['info'], '..')) go_forward(go_href_link(NAME_OF_FILE_FILE_MANAGER));
    if (!isset($file_writeable)) $file_writeable = true;
    $file_contents = '';
    if ($action == 'new_file') {
      $filename_inputfeld = go_fetch_inputfeld('filename');
    } elseif ($action == 'change') {
      if ($file_array = file($current_path . '/' . $_GET['info'])) {
        $file_contents = addslashes(implode('', $file_array));
      }
      $filename_inputfeld = $_GET['info'] . go_fetch_hidden_field('filename', $_GET['info']);
    }
?>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      <tr><?php echo go_fetch_form('new_file', NAME_OF_FILE_FILE_MANAGER, 'action=save'); ?>
        <td><table border="0" cellspacing="0" cellpadding="2">
          <tr>
            <td class="main"><?php echo TEXT_FILE_NAME; ?></td>
            <td class="main"><?php echo $filename_inputfeld; ?></td>
          </tr>
          <tr>
            <td class="main" valign="top"><?php echo TEXT_FILE_CONTENTS; ?></td>
            <td class="main"><?php echo go_fetch_textarea_field('file_contents', 'soft', '80', '20', $file_contents, (($file_writeable) ? '' : 'readonly')); ?></td>
          </tr>
          <tr>
            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
          </tr>
          <tr>
            <td align="right" class="main" colspan="2"><?php if ($file_writeable == true) echo go_picture_submit('button_save.gif', PICTURE_SAVE) . '&nbsp;'; echo '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>'; ?></td>
          </tr>
        </table></td>
      </form></tr>
<?php
  } else {
    $showuser = (function_exists('posix_getpwuid') ? true : false);
    $contents = array();
    $dir = dir($current_path);
    while ($file = $dir->read()) {
      if ( ($file != '.') && ($file != 'CVS') && ( ($file != '..') || ($current_path != FOLDER_ABSOLUT_DOCUMENT_ROOT) ) ) {
        $file_size = number_format(filesize($current_path . '/' . $file)) . ' bytes';
        $permissions = go_get_file_permissions(fileperms($current_path . '/' . $file));
        if ($showuser) {
          $user = @posix_getpwuid(fileowner($current_path . '/' . $file));
          $group = @posix_getgrgid(filegroup($current_path . '/' . $file));
        } else {
          $user = $group = array();
        }
        $contents[] = array('name' => $file,
                            'is_dir' => is_dir($current_path . '/' . $file),
                            'last_modified' => strftime(DATE_TIME_FORMAT, filemtime($current_path . '/' . $file)),
                            'size' => $file_size,
                            'permissions' => $permissions,
                            'user' => $user['name'],
                            'group' => $group['name']);
      }
    }
    function go_cmp($a, $b) {
      return strcmp( ($a['is_dir'] ? 'D' : 'F') . $a['name'], ($b['is_dir'] ? 'D' : 'F') . $b['name']);
    }
    usort($contents, 'go_cmp');
?>
      <tr>
        <td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_FILENAME; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_SIZE; ?></td>
                <td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_PERMISSIONS; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_USER; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_GROUP; ?></td>
                <td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_LAST_MODIFIED; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
  for ($i=0, $n=sizeof($contents); $i<$n; $i++) {
    if ((!isset($_GET['info']) || (isset($_GET['info']) && ($_GET['info'] == $contents[$i]['name']))) && !isset($fInfo) && ($action != 'upload') && ($action != 'new_folder')) {
      $fInfo = new objectInfo($contents[$i]);
    }
    if ($contents[$i]['name'] == '..') {
      $goto_link = substr($current_path, 0, strrpos($current_path, '/'));
    } else {
      $goto_link = $current_path . '/' . $contents[$i]['name'];
    }
    if (isset($fInfo) && is_object($fInfo) && ($contents[$i]['name'] == $fInfo->name)) {
      if ($fInfo->is_dir) {
        echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">' . "\n";
        $onclick_link = 'goto=' . $goto_link;
      } else {
        echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">' . "\n";
        $onclick_link = 'info=' . urlencode($fInfo->name) . '&action=change';
      }
    } else {
      echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)">' . "\n";
      $onclick_link = 'info=' . urlencode($contents[$i]['name']);
    }
    if ($contents[$i]['is_dir']) {
      if ($contents[$i]['name'] == '..') {
        $icon = go_picture(FOLDER_RELATIV_ICONS . 'previous_level.gif', ICON_PREVIOUS_LEVEL);
      } else {
        $icon = (isset($fInfo) && is_object($fInfo) && ($contents[$i]['name'] == $fInfo->name) ? go_picture(FOLDER_RELATIV_ICONS . 'current_folder.gif', ICON_CURRENT_FOLDER) : go_picture(FOLDER_RELATIV_ICONS . 'folder.gif', ICON_FOLDER));
      }
      $link = go_href_link(NAME_OF_FILE_FILE_MANAGER, 'goto=' . $goto_link);
    } else {
      $icon = go_picture(FOLDER_RELATIV_ICONS . 'file_download.gif', ICON_FILE_DOWNLOAD);
      $link = go_href_link(NAME_OF_FILE_FILE_MANAGER, 'action=download&filename=' . urlencode($contents[$i]['name']));
    }
?>
                <td class="TbInsideData" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><?php echo '<a href="' . $link . '">' . $icon . '</a>&nbsp;' . $contents[$i]['name']; ?></td>
                <td class="TbInsideData" align="right" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><?php echo ($contents[$i]['is_dir'] ? '&nbsp;' : $contents[$i]['size']); ?></td>
                <td class="TbInsideData" align="center" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><tt><?php echo $contents[$i]['permissions']; ?></tt></td>
                <td class="TbInsideData" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><?php echo $contents[$i]['user']; ?></td>
                <td class="TbInsideData" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><?php echo $contents[$i]['group']; ?></td>
                <td class="TbInsideData" align="center" onclick="document.location.href='<?php echo go_href_link(NAME_OF_FILE_FILE_MANAGER, $onclick_link); ?>'"><?php echo $contents[$i]['last_modified']; ?></td>
                <td class="TbInsideData" align="right"><?php if ($contents[$i]['name'] != '..') echo '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($contents[$i]['name']) . '&action=delete') . '">' . go_picture(FOLDER_RELATIV_ICONS . 'delete.gif', ICON_DELETE) . '</a>&nbsp;'; if (isset($fInfo) && is_object($fInfo) && ($fInfo->name == $contents[$i]['name'])) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif'); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($contents[$i]['name'])) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
              <tr>
                <td colspan="7"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr valign="top">
                    <td class="smallText"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, 'action=reset') . '">' . go_picture_button('button_reset.gif', PICTURE_RESET) . '</a>'; ?></td>
                    <td class="smallText" align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) . '&' : '') . 'action=upload') . '">' . go_picture_button('button_upload.gif', PICTURE_UPLOAD) . '</a>&nbsp;<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) . '&' : '') . 'action=new_file') . '">' . go_picture_button('button_new_file.gif', PICTURE_NEW_FILE) . '</a>&nbsp;<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) . '&' : '') . 'action=new_folder') . '">' . go_picture_button('button_new_folder.gif', PICTURE_NEW_FOLDER) . '</a>'; ?></td>
                  </tr>
                </table></td>
              </tr>
            </table></td>
<?php
    $heading = array();
    $contents = array();
    switch ($action) {
      case 'delete':
        $heading[] = array('text' => '<b>' . $fInfo->name . '</b>');
        $contents = array('form' => go_fetch_form('file', NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($fInfo->name) . '&action=deleteconfirm'));
        $contents[] = array('text' => TEXT_DELETE_INTRO);
        $contents[] = array('text' => '<br><b>' . $fInfo->name . '</b>');
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (go_not_null($fInfo->name) ? 'info=' . urlencode($fInfo->name) : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'new_folder':
        $heading[] = array('text' => '<b>' . TEXT_NEW_FOLDER . '</b>');
        $contents = array('form' => go_fetch_form('folder', NAME_OF_FILE_FILE_MANAGER, 'action=insert'));
        $contents[] = array('text' => TEXT_NEW_FOLDER_INTRO);
        $contents[] = array('text' => '<br>' . TEXT_FILE_NAME . '<br>' . go_fetch_inputfeld('folder_name'));
        $contents[] = array('align' => 'center', 'text' => '<br>' . (($directory_writeable == true) ? go_picture_submit('button_save.gif', PICTURE_SAVE) : '') . ' <a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'upload':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_UPLOAD . '</b>');
        $contents = array('form' => go_fetch_form('file', NAME_OF_FILE_FILE_MANAGER, 'action=processuploads', 'post', 'enctype="multipart/form-data"'));
        $contents[] = array('text' => TEXT_UPLOAD_INTRO);
        $file_upload = '';
        for ($i=1; $i<6; $i++) $file_upload .= go_fetch_file_field('file_' . $i) . '<br>';
        $contents[] = array('text' => '<br>' . $file_upload);
        $contents[] = array('align' => 'center', 'text' => '<br>' . (($directory_writeable == true) ? go_picture_submit('button_upload.gif', PICTURE_UPLOAD) : '') . ' <a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, (isset($_GET['info']) ? 'info=' . urlencode($_GET['info']) : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      default:
        if (isset($fInfo) && is_object($fInfo)) {
          $heading[] = array('text' => '<b>' . $fInfo->name . '</b>');
          if (!$fInfo->is_dir) $contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_FILE_MANAGER, 'info=' . urlencode($fInfo->name) . '&action=change') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a>');
          $contents[] = array('text' => '<br>' . TEXT_FILE_NAME . ' <b>' . $fInfo->name . '</b>');
          if (!$fInfo->is_dir) $contents[] = array('text' => '<br>' . TEXT_FILE_SIZE . ' <b>' . $fInfo->size . '</b>');
          $contents[] = array('text' => '<br>' . TEXT_LAST_MODIFIED . ' ' . $fInfo->last_modified);
        }
    }
    if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
      echo '            <td width="25%" valign="top"><br>' . "\n";
      $frame = new frame;
      echo $frame->infoBox($heading, $contents);
      echo '            </td>' . "\n";
    }
?>
          </tr>
        </table></td>
      </tr>
<?php
  }
?>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
