<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  
  $action = (isset($_GET['action']) ? $_GET['action'] : '');  
  if ( preg_match("/(insert|update|setflag)/i", $action) ) include_once('load_this/load_bigware_14.php');
  if (go_not_null($action)) {
    switch ($action) {
      case 'setflag':
        if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
          if (isset($_GET['bigID'])) {
            go_set_galerie_status($_GET['bigID'], $_GET['flag']);
          }
          if (USE_CACHE == 'true') {
            go_reset_cache_block('categories');
            go_reset_cache_block('also_purchased');
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $_GET['bigPfad'] . '&bigID=' . $_GET['bigID']));
        break;
		case 'setflag_cat':
        		if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') )
			{
	      		if (isset($_GET['bigID']))
				{
            		go_set_galerie_cat_status($_GET['bigID'], $_GET['flag']);
    				}
          		if (USE_CACHE == 'true')
				{
            			go_reset_cache_block('categories');
            			go_reset_cache_block('also_purchased');
          			}
        		}
	go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $_GET['bigPfad'] . '&bigID=' . $_GET['bigID']));
	break;
      case 'insert_category':
      case 'update_category':
        if (isset($_POST['categories_id'])) $categories_id = go_db_producing_input($_POST['categories_id']);
        $sort_order = go_db_producing_input($_POST['sort_order']); 
        $categories_status = go_db_producing_input($_POST['categories_status']);
        $sql_data_array = array('sort_order' => $sort_order, 'categories_status' => $categories_status);
        if ($action == 'insert_category') {
          $insert_sql_data = array('parent_id' => $current_category_id,
                                   'date_added' => 'now()');
          $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
          go_db_carry(DB_TBL_GALERIE_CAT, $sql_data_array);
          $categories_id = go_db_insert_id();
        } elseif ($action == 'update_category') {
          $update_sql_data = array('last_modified' => 'now()');
          $sql_data_array = array_merge($sql_data_array, $update_sql_data);
          go_db_carry(DB_TBL_GALERIE_CAT, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "'");
        }
        $languages = go_get_languages();
        for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
          $language_id = $languages[$i]['id'];
          $categories_name_array = $_POST['categories_name'];
          $categories_desc_array = $_POST['categories_desc'.$language_id];
          $sql_data_array = array('categories_name' => go_db_producing_input($categories_name_array[$language_id]),'categories_desc' => go_db_producing_input($categories_desc_array));
          if ($action == 'insert_category') {
            $insert_sql_data = array('categories_id' => $categories_id,
                                     'language_id' => $languages[$i]['id']);
            $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
            go_db_carry(DB_TBL_GALERIE_CAT_DESCRIPTION, $sql_data_array);
          } elseif ($action == 'update_category') {
            go_db_carry(DB_TBL_GALERIE_CAT_DESCRIPTION, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "' and language_id = '" . (int)$languages[$i]['id'] . "'");
          }
        }
        
        
			$wert1 = '';
			$stuecke = '';
	              		
				$stuecke = split ('"', $_POST['categories_picture']);
				while (list($schluessel, $wert) = each($stuecke)){
					
					if (substr_count($wert, FOLDER_RELATIV_PICTURES) > 0){

						$pfad_kommentiert = preg_replace('/\//', '\/', FOLDER_RELATIV_PICTURES);
						$wert1 = preg_replace('/' . $pfad_kommentiert . '/', '', strstr(trim(stripslashes($wert)), FOLDER_RELATIV_PICTURES));

					
					}
		
			 	}    
 			if ($wert1 == ''){
				$_POST['categories_picture'] = '';
			}
			else{$_POST['categories_picture'] = $wert1;}        
        
        
        
        
          if (isset($_POST['categories_picture']) && go_not_null($_POST['categories_picture']) && ($_POST['categories_picture'] != 'none')) {
            go_db_query("update " . DB_TBL_GALERIE_CAT . " set categories_picture = '" . go_db_input($_POST['categories_picture']) . "' where categories_id = '" . (int)$categories_id . "'");
          }
        if (USE_CACHE == 'true') {
          go_reset_cache_block('categories');
          go_reset_cache_block('also_purchased');
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $categories_id));
        break;
      case 'delete_category_confirm':
        if (isset($_POST['categories_id'])) {
          $categories_id = go_db_producing_input($_POST['categories_id']);
          $categories = go_get_galerie_cat_tree($categories_id, '', '0', '', true);
          $galeries = array();
          $galeries_delete = array();
          for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
            $galerie_ids_query = go_db_query("select galeries_id from " . DB_TBL_GALERIE_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
            while ($galerie_ids = go_db_fetch_array($galerie_ids_query)) {
              $galeries[$galerie_ids['galeries_id']]['categories'][] = $categories[$i]['id'];
            }
          }
          reset($galeries);
          while (list($key, $value) = each($galeries)) {
            $category_ids = '';
            for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++) {
              $category_ids .= "'" . (int)$value['categories'][$i] . "', ";
            }
            $category_ids = substr($category_ids, 0, -2);
            $check_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
            $check = go_db_fetch_array($check_query);
            if ($check['total'] < '1') {
              $galeries_delete[$key] = $key;
            }
          }  
          for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
            go_remove_galerie_cat($categories[$i]['id']);
            go_remove_galerie_cat_api($categories[$i]['id']);
          }
          reset($galeries_delete);
          while (list($key) = each($galeries_delete)) {
            go_remove_galerie($key);
          }
        }
        if (USE_CACHE == 'true') {
          go_reset_cache_block('categories');
          go_reset_cache_block('also_purchased');
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad));
        break;
      case 'delete_galerie_confirm':
        if (isset($_POST['galeries_id']) && isset($_POST['galerie_categories']) && is_array($_POST['galerie_categories'])) {
          $galerie_id = go_db_producing_input($_POST['galeries_id']);
          $galerie_categories = $_POST['galerie_categories'];
          for ($i=0, $n=sizeof($galerie_categories); $i<$n; $i++) {
            go_db_query("delete from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$galerie_id . "' and categories_id = '" . (int)$galerie_categories[$i] . "'");
          }
					
	  $galerie_categories_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$galerie_id . "'");
          $galerie_categories = go_db_fetch_array($galerie_categories_query);
          if ($galerie_categories['total'] == '0') {
            go_remove_galerie($galerie_id);
          }
        }
        if (USE_CACHE == 'true') {
          go_reset_cache_block('categories');
          go_reset_cache_block('also_purchased');
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad));
        break;
      case 'move_category_confirm':
        if (isset($_POST['categories_id']) && ($_POST['categories_id'] != $_POST['move_to_category_id'])) {
          $categories_id = go_db_producing_input($_POST['categories_id']);
          $new_parent_id = go_db_producing_input($_POST['move_to_category_id']);
          $path = explode('_', go_get_generated_galerie_cat_path_ids($new_parent_id));
          if (in_array($categories_id, $path)) {
            $messageStack->add_session(ERROR_CANNOT_MOVE_CATEGORY_TO_PARENT, 'error');
            go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $categories_id));
          } else {
            go_db_query("update " . DB_TBL_GALERIE_CAT . " set parent_id = '" . (int)$new_parent_id . "', last_modified = now() where categories_id = '" . (int)$categories_id . "'");
            if (USE_CACHE == 'true') {
              go_reset_cache_block('categories');
              go_reset_cache_block('also_purchased');
            }
            go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $new_parent_id . '&bigID=' . $categories_id));
          }
        }
        break;
      case 'move_galerie_confirm':
        $galeries_id = go_db_producing_input($_POST['galeries_id']);
        $new_parent_id = go_db_producing_input($_POST['move_to_category_id']);
        $duplicate_check_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$galeries_id . "' and categories_id = '" . (int)$new_parent_id . "'");
        $duplicate_check = go_db_fetch_array($duplicate_check_query);
        if ($duplicate_check['total'] < 1) go_db_query("update " . DB_TBL_GALERIE_TO_CATEGORIES . " set categories_id = '" . (int)$new_parent_id . "' where galeries_id = '" . (int)$galeries_id . "' and categories_id = '" . (int)$current_category_id . "'");
        if (USE_CACHE == 'true') {
          go_reset_cache_block('categories');
          go_reset_cache_block('also_purchased');
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $new_parent_id . '&bigID=' . $galeries_id));
        break; 
      case 'neues_galerie_confirm':
        if (isset($_POST['galeries_id']) && isset($_POST['galerie_categories']) && is_array($_POST['galerie_categories'])) {
          $galerie_id = go_db_producing_input($_POST['galeries_id']);
  		   go_db_query("update " . DB_TBL_GALERIE . " set galeries_date_added = now() where galeries_id = '" . $galerie_id . "'");
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad));
        break; 
      case 'neu_im_category_confirm':
        if (isset($_POST['categories_id'])) {
          $categories_id = go_db_producing_input($_POST['categories_id']);
          $categories = go_get_galerie_cat_tree($categories_id, '', '0', '', true);
          $galeries = array();
          $galeries_delete = array();
          for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
            $galerie_ids_query = go_db_query("select galeries_id from " . DB_TBL_GALERIE_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
            while ($galerie_ids = go_db_fetch_array($galerie_ids_query)) {
              $galeries[$galerie_ids['galeries_id']]['categories'][] = $categories[$i]['id'];
            }
          }
          reset($galeries);
          while (list($key, $value) = each($galeries)) {
            $category_ids = '';
            for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++) {
              $category_ids .= "'" . (int)$value['categories'][$i] . "', ";
            }
            $category_ids = substr($category_ids, 0, -2);
            $check_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
            $check = go_db_fetch_array($check_query);
            if ($check['total'] < '1') {
              $galeries_delete[$key] = $key;
            }
          } 
          reset($galeries_delete);
          while (list($key) = each($galeries_delete)) {
  		   go_db_query("update " . DB_TBL_GALERIE . " set galeries_date_added = now() where galeries_id = '" . $key . "'");
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad));
	go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $new_parent_id . '&bigID=' . $galeries_id));
        break;
      case 'insert_galerie':
      case 'update_galerie':
     
        if (isset($_POST['change_x']) || isset($_POST['change_y'])) {
          $action = 'new_galerie';
        } else {
          if (isset($_GET['bigID'])) $galeries_id = go_db_producing_input($_GET['bigID']);
          $galeries_date_available = go_db_producing_input($_POST['galeries_date_available']);
          $galeries_date_available = (date('Y-m-d') < $galeries_date_available) ? $galeries_date_available : 'null';
          $sql_data_array = array('galeries_quantity' => go_db_producing_input($_POST['galeries_quantity']),
                                  'galeries_model' => go_db_producing_input($_POST['galeries_model']),
                                  'galeries_date_available' => $galeries_date_available,
                                  'galeries_weight' => go_db_producing_input($_POST['galeries_weight']),
                                  'galeries_status' => go_db_producing_input($_POST['galeries_status']),
				  'galeries_percentage' => go_db_producing_input($_POST['galeries_percentage']),
                                  'galeries_tax_class_id' => go_db_producing_input($_POST['galeries_tax_class_id']),
                                  'producers_id' => go_db_producing_input($_POST['producers_id']));
          if ($action == 'insert_galerie') {
            $insert_sql_data = array('galeries_date_added' => 'now()');
            $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
            go_db_carry(DB_TBL_GALERIE, $sql_data_array);
            $galeries_id = go_db_insert_id();
            go_db_query("insert into " . DB_TBL_GALERIE_TO_CATEGORIES . " (galeries_id, categories_id) values ('" . (int)$galeries_id . "', '" . (int)$current_category_id . "')");
	    go_db_query("insert into " . DB_TBL_GALERIE_TO_TEMPLATE . " (galeries_id, template_id) values ('" . (int)$galeries_id . "', '" . $_POST['galeries_model'] . "')");
		$f = 0;	
		if ($_POST['pictures'] != ''){	
			foreach ($_POST['pictures'] as $arr_pictures) {
				if ($arr_pictures != ''){
				        if (isset($arr_pictures)) {
				            $galeries_picture = go_db_producing_input(preg_replace('/%20/', ' ', $arr_pictures));
				
					}
					if ($f == $vorschaubild){$eintragen = 1;}else{$eintragen = 0;}
					go_db_query("insert into " . DB_TBL_GALERIE_TO_PICTURES . " (galeries_id, pictures, sort_order, vorschau) values ('" . (int)$galeries_id . "', '" . $galeries_picture . "', '" . $sort_order_picture[$f] . "', '" . $eintragen . "')");
				$f++;
				}
			}
		}
	
          } elseif ($action == 'update_galerie') {
            $update_sql_data = array('galeries_last_modified' => 'now()');
            $sql_data_array = array_merge($sql_data_array, $update_sql_data);
            go_db_carry(DB_TBL_GALERIE, $sql_data_array, 'update', "galeries_id = '" . (int)$galeries_id . "'");
	    $count_model_in_template_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_TEMPLATE . " where galeries_id='" . (int)$galeries_id . "'");
	    $count_model_in_template_id = go_db_fetch_array($count_model_in_template_query);
		if ($count_model_in_template_id['total'] == 0) {   
			go_db_query("insert into " . DB_TBL_GALERIE_TO_TEMPLATE . " (galeries_id, template_id) values ('" . (int)$galeries_id . "', '" . $_POST['galeries_model'] . "')");
		}      
	   	else{
			go_db_query("update " . DB_TBL_GALERIE_TO_TEMPLATE  . " SET galeries_id='" . (int)$galeries_id . "', template_id='" . $_POST['galeries_model'] . "'  WHERE galeries_id = '" . (int)$galeries_id . "'");
		   	
	   	}
		$f = 0;
		$pictures_id = $_POST['pictures_id'];
		foreach ($_POST['pictures'] as $arr_pictures) {
			//echo "vorschau: " . $vorschaubild . " f: $f";
		    	if ($f == $vorschaubild){$eintragen = 1;}else{$eintragen = 0;}
		        $galeries_picture = go_db_producing_input(preg_replace('/%20/', ' ', $arr_pictures));
			$count_gal_to_pic_id_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_PICTURES . " where galerie_to_picture_id='" . $pictures_id[$f] . "' AND galeries_id = '" . (int)$galeries_id . "'");
		    	$count_gal_to_pic_id = go_db_fetch_array($count_gal_to_pic_id_query);
		    	if ($count_gal_to_pic_id['total'] == 0) {
		    		if ($arr_pictures != ""){
		    			
		    			go_db_query("insert into " . DB_TBL_GALERIE_TO_PICTURES . " (galeries_id, pictures, sort_order, vorschau) values ('" . (int)$galeries_id . "', '" . $galeries_picture . "', '" . $sort_order_picture[$f] . "', '" . $eintragen . "')");
				}
		    	}		
			else{
				if ($arr_pictures == ""){
					go_db_query("DELETE FROM " . DB_TBL_GALERIE_TO_PICTURES . " WHERE galerie_to_picture_id = '" . $pictures_id[$f] . "'");
	
				}
				else{
					go_db_query("update " . DB_TBL_GALERIE_TO_PICTURES . " SET pictures='" . $galeries_picture . "', sort_order='" . $sort_order_picture[$f] . "', vorschau='" . $eintragen . "'  WHERE galeries_id = '" . (int)$galeries_id . "' AND galerie_to_picture_id = '" . $pictures_id[$f] . "'");
				}
			}
		$f++;
		}
          }
					
          $languages = go_get_languages();
          for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
            $language_id = $languages[$i]['id'];
            $sql_data_array = array('galeries_name' => go_db_producing_input($_POST['galeries_name'][$language_id]),
            			    'galeries_name2' => go_db_producing_input($_POST['galeries_name2'][$language_id]),
                                    'galeries_description' => go_db_producing_input($_POST["galeries_description$language_id"]),
            			    'galeries_info1' => go_db_producing_input($_POST['galeries_info1'][$language_id]),
            			    'galeries_info2' => go_db_producing_input($_POST['galeries_info2'][$language_id]),
            			    'galeries_info3' => go_db_producing_input($_POST['galeries_info3'][$language_id]),
            			    'galeries_info4' => go_db_producing_input($_POST['galeries_info4'][$language_id]));
            if ($action == 'insert_galerie') {
              $insert_sql_data = array('galeries_id' => $galeries_id,
                                       'language_id' => $language_id);
              $sql_data_array = array_merge($sql_data_array, $insert_sql_data);
              go_db_carry(DB_TBL_GALERIE_DESCRIPTION, $sql_data_array);
            } elseif ($action == 'update_galerie') {
              go_db_carry(DB_TBL_GALERIE_DESCRIPTION, $sql_data_array, 'update', "galeries_id = '" . (int)$galeries_id . "' and language_id = '" . (int)$language_id . "'");
            }
          }
          if (USE_CACHE == 'true') {
            go_reset_cache_block('categories');
            go_reset_cache_block('also_purchased');
          }
          go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $galeries_id. "&dd=1"));
        }
        break;
      case 'copy_to_confirm':
        if (isset($_POST['galeries_id']) && isset($_POST['categories_id'])) {
          $galeries_id = go_db_producing_input($_POST['galeries_id']);
          $categories_id = go_db_producing_input($_POST['categories_id']);
          if ($_POST['copy_as'] == 'link') {
            if ($categories_id != $current_category_id) {
              $check_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$galeries_id . "' and categories_id = '" . (int)$categories_id . "'");
              $check = go_db_fetch_array($check_query);
              if ($check['total'] < '1') {
                go_db_query("insert into " . DB_TBL_GALERIE_TO_CATEGORIES . " (galeries_id, categories_id) values ('" . (int)$galeries_id . "', '" . (int)$categories_id . "')");
              }
            } else {
              $messageStack->add_session(ERROR_CANNOT_LINK_TO_SAME_CATEGORY, 'error');
            }
          } elseif ($_POST['copy_as'] == 'duplicate') {
          	$galerie_query = go_db_query("select galeries_quantity, galeries_model, galeries_date_available, galeries_weight, galeries_tax_class_id, producers_id from " . DB_TBL_GALERIE . " where galeries_id = '" . (int)$galeries_id . "'");
          	$galerie = go_db_fetch_array($galerie_query);  
            ##added big galeries picture
            go_db_query("insert into " . DB_TBL_GALERIE . " (galeries_quantity, galeries_model, galeries_date_added, galeries_date_available, galeries_weight, galeries_status, galeries_tax_class_id, producers_id) values ('" . go_db_input($galerie['galeries_quantity']) . "', '" . go_db_input($galerie['galeries_model']) . "',  now(), '" . go_db_input($galerie['galeries_date_available']) . "', '" . go_db_input($galerie['galeries_weight']) . "', '0', '" . (int)$galerie['galeries_tax_class_id'] . "', '" . (int)$galerie['producers_id'] . "')");
        	######
            $dup_galeries_id = go_db_insert_id();
            
		$gal_to_pic_query = go_db_query("SELECT * FROM " . DB_TBL_GALERIE_TO_PICTURES . " WHERE  galeries_id = '" . (int)$galeries_id . "'");
		while($gal_to_pic_werte = go_db_fetch_array($gal_to_pic_query)){
		    
		    	go_db_query("insert into " . DB_TBL_GALERIE_TO_PICTURES . " (galeries_id, pictures, sort_order, vorschau) values ('" . (int)$dup_galeries_id . "', '" . $gal_to_pic_werte["pictures"] . "', '" . $gal_to_pic_werte["sort_order"] . "', '" . $gal_to_pic_werte["vorschau"] . "')");
	
		}
		
            echo $galeries_id."-".$dup_galeries_id;
            $description_query = go_db_query("select language_id, galeries_name, galeries_name2, galeries_description, galeries_info1, galeries_info2, galeries_info3, galeries_info4 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galeries_id . "'");
            while ($description = go_db_fetch_array($description_query)) {
              go_db_query("insert into " . DB_TBL_GALERIE_DESCRIPTION . " (galeries_id, language_id, galeries_name, galeries_name2, galeries_description, galeries_viewed, galeries_info1, galeries_info2, galeries_info3, galeries_info4) values ('" . (int)$dup_galeries_id . "', '" . (int)$description['language_id'] . "', '" . go_db_input($description['galeries_name']) . "', '" . go_db_input($description['galeries_name2']) . "', '" . go_db_input($description['galeries_description']) . "', '0', galeries_info1='" . go_db_input($description['galeries_info1']) . "', galeries_info2='" . go_db_input($description['galeries_info2']) . "', galeries_info3='" . go_db_input($description['galeries_info3']) . "', galeries_info4='" . go_db_input($description['galeries_info4']) . "')");
            }
            go_db_query("insert into " . DB_TBL_GALERIE_TO_CATEGORIES . " (galeries_id, categories_id) values ('" . (int)$dup_galeries_id . "', '" . (int)$categories_id . "')");
            $galeries_id = $dup_galeries_id;
          }
          if (USE_CACHE == 'true') {
            go_reset_cache_block('categories');
            go_reset_cache_block('also_purchased');
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $categories_id . '&bigID=' . $galeries_id));
        break;
      case 'new_galerie_preview':
          $picture_name = array();
	
		$zaehler = 0;
		if ($_POST['pictures'] != ''){
			foreach ($_POST['pictures'] as $arr_pictures) {
				
			        //$picture_name = $arr_pictures;
	
				$wert1 = '';
				$stuecke = '';
		              		
					$stuecke = split ('"', $_POST['pictures'][$zaehler]);
					while (list($schluessel, $wert) = each($stuecke)){
						
						if (substr_count($wert, FOLDER_RELATIV_PICTURES) > 0){
	
							$pfad_kommentiert = preg_replace('/\//', '\/', FOLDER_RELATIV_PICTURES);
							$wert1 = preg_replace('/' . $pfad_kommentiert . '/', '', strstr(trim(stripslashes($wert)), FOLDER_RELATIV_PICTURES));
	
						
						}
			
				 	}    
	 			if ($wert1 == ''){
					$_POST['pictures'][$zaehler] = '';
					$picture_name = '';
				}
				else{
				$_POST['pictures'][$zaehler] = $wert1;
				$picture_name = $wert1;
				}
				
				//////////////////
				$zaehler++;
		
			}
		}
        
        break;
    }
  } 
  if (is_dir(FOLDER_ABSOLUT_CATALOG_PICTURES)) {
    if (!is_writeable(FOLDER_ABSOLUT_CATALOG_PICTURES)) $messageStack->add(ERROR_CATALOG_PICTURE_DIRECTORY_NOT_WRITEABLE, 'error');
  } else {
    $messageStack->add(ERROR_CATALOG_PICTURE_DIRECTORY_DOES_NOT_EXIST, 'error');
  }
  
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/general.js"></script>
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="tiny_mce/tiny_mce.js"></script>
<script language="javascript" src="tiny_mce/tiny_mce_init.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<div id="spiffycalendar" class="text"></div>
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2" align="center">
  <tr>
    <!--td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td-->
<!-- body_text //-->
    <td width="100%" valign="top">
<?php
  if ($action == 'new_galerie') {
    $parameters = array('galeries_name' => '',
                       'galeries_name2' => '',
                       'galeries_description' => '',
                       'galeries_info1' => '',
                       'galeries_info2' => '',
                       'galeries_info3' => '',
                       'galeries_info4' => '',
                       'galeries_id' => '',
                       'galeries_quantity' => '',
                       'galeries_model' => '',
                       'galeries_date_added' => '',
                       'galeries_last_modified' => '',
                       'galeries_date_available' => '',
                       'galeries_status' => '',
		       'galeries_percentage' => '',
                       'galeries_tax_class_id' => ''); 
    $pInfo = new objectInfo($parameters);
    if (isset($_GET['bigID']) && empty($_POST)) {
      $galerie_query = go_db_query("select pd.galeries_name, pd.galeries_name2, pd.galeries_description, pd.galeries_info1, pd.galeries_info2, pd.galeries_info3, pd.galeries_info4, p.galeries_id, p.galeries_quantity, p.galeries_model, p.galeries_weight, p.galeries_date_added, p.galeries_last_modified, date_format(p.galeries_date_available, '%Y-%m-%d') as galeries_date_available, p.galeries_status, p.galeries_percentage,p.galeries_tax_class_id, p.producers_id from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_DESCRIPTION . " pd where p.galeries_id = '" . (int)$_GET['bigID'] . "' and p.galeries_id = pd.galeries_id and pd.language_id = '" . (int)$languages_id . "'");
      $galerie = go_db_fetch_array($galerie_query);    
      $pInfo->objectInfo($galerie);
			
    } elseif (go_not_null($_POST)) {
      $pInfo->objectInfo($_POST);
      $galeries_name = $_POST['galeries_name'];
      $galeries_name2 = $_POST['galeries_name2'];
      $galeries_description = $_POST['galeries_description'];
      $galeries_info1 = $_POST['galeries_info1'];
      $galeries_info2 = $_POST['galeries_info2'];
      $galeries_info3 = $_POST['galeries_info3'];
      $galeries_info4 = $_POST['galeries_info4'];
    }
    $languages = go_get_languages();
    if (!isset($pInfo->galeries_status)) $pInfo->galeries_status = '1';
    switch ($pInfo->galeries_status) {
      case '0': $in_status = false; $out_status = true; break;
      case '1':
      default: $in_status = true; $out_status = false;
    }
		
	if (!isset($pInfo->galeries_percentage)) $pInfo->galeries_percentage = '1';
	switch ($pInfo->galeries_percentage) {
		case '0': $in_percent = false; $out_percent = true; break;
		case '1':
		default: $in_percent = true; $out_percent = false;
	}
?>
	<?php 
	if ($zusaetzliche_bilder == ""){
	?>
	<table border="0" cellpadding="0" cellspacing="8" style="border-collapse: collapse" id="AutoNumber1" bgcolor="#FFFFFF">
	  <tr>
	    <td class="main" width="100%">
		<form method="POST">
		<script language="JavaScript" type="text/javascript">
		<!--
		function surfto1(form){
		var myindex=form.select1.selectedIndex 
		var anzahlzusammen=form.select1.selectedIndex; 
				window.location.href = "<?php echo 'http://' . getenv('HTTP_HOST') . getenv('REQUEST_URI'); ?>&zusaetzliche_bilder="+anzahlzusammen; 
		}
		// -->
		</script>            
		            
		<?php echo TEXT_QUESTION_PIC_AMOUNT; ?><select name="select1" size="1"
		onchange="surfto1(this.form)">
		<option selected value="0"><?php echo TEXT_PLS_CHOOSE; ?></option>
		<option value="0"><?php echo TEXT_PIC_AMOUNT; ?></option>
		<?php 
			for ($i=1; $i<100; $i++) {
			echo "<option value=\"$i\">$i Bilder</option>\n";
			}
		?>
		</select> 
		</form>
	    </td>
	  </tr>
	</table>
	<?php 	
	}
	else {
	?>
		<link rel="stylesheet" type="text/css" href="load_this/javascript/spiffyCal/spiffyCal_v2_1.css">
		<script language="JavaScript" src="load_this/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
		<!-- B2B start -->
		<script language="javascript" src="load_this/javascript/dhtml.js"></script>
		<!-- B2B end -->
		<script language="javascript"><!--
		  var dateAvailable = new ctlSpiffyCalendarBox("dateAvailable", "new_galerie", "galeries_date_available","btnDate1","<?php echo $pInfo->galeries_date_available; ?>",scBTNMODE_CUSTOMBLUE);
		//--></script>
		<script language="javascript"><!--
		var tax_rates = new Array();
		<?php
		    for ($i=0, $n=sizeof($tax_class_array); $i<$n; $i++) {
		      if ($tax_class_array[$i]['id'] > 0) {
		        echo 'tax_rates["' . $tax_class_array[$i]['id'] . '"] = ' . go_get_tax_rate_value($tax_class_array[$i]['id']) . ';' . "\n";
		      }
		    }
		?>
		
		function doRound(x, places) {
		  return Math.round(x * Math.pow(10, places)) / Math.pow(10, places);
		}
		
		function getTaxRate() {
		  var selected_value = document.forms["new_galerie"].galeries_tax_class_id.selectedIndex;
		  var parameterVal = document.forms["new_galerie"].galeries_tax_class_id[selected_value].value;
		
		  if ( (parameterVal > 0) && (tax_rates[parameterVal] > 0) ) {
		    return tax_rates[parameterVal];
		  } else {
		    return 0;
		  }
		}
		
		function updateGross() {
		  var taxRate = getTaxRate();
		  var grossValue = document.forms["new_galerie"].galeries_price.value;
		
		  if (taxRate > 0) {
		    grossValue = grossValue * ((taxRate / 100) + 1);
		  }
		
		  document.forms["new_galerie"].galeries_price_gross.value = doRound(grossValue, 4);
		}
		
		function updateNet() {
		  var taxRate = getTaxRate();
		  var netValue = document.forms["new_galerie"].galeries_price_gross.value;
		
		  if (taxRate > 0) {
		    netValue = netValue / ((taxRate / 100) + 1);
		  }
		
		  document.forms["new_galerie"].galeries_price.value = doRound(netValue, 4);
		}
		//--></script>
		    <?php echo go_fetch_form('new_galerie', NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . (isset($_GET['bigID']) ? '&bigID=' . $_GET['bigID'] : '') . '&action=new_galerie_preview', 'post', 'enctype="multipart/form-data"'); ?>
		    <table border="0" width="100%" cellspacing="0" cellpadding="2">
		      <tr>
		        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
		          <tr>
		            <td class="pageGeneralsign"><?php echo sprintf(TEXT_NEW_ITEM, go_output_generated_galerie_cat_path($current_category_id)); ?></td>
		            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
		          </tr>
		        </table></td>
		      </tr>
		      <tr>
		        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		      </tr>
		      <tr>
		        <td><table border="0" cellspacing="0" cellpadding="2">
								  <!-- B2B start -->
				  <table cellspacing="0" cellpadding="4" border="0" width="100%">
					<tr>    
					        <td id="tab1" class="offtab" onclick="dhtml.cycleTab(this.id)"><?php echo TAB_IMG; ?></td>
									
						<td id="tab3" class="offtab" onclick="dhtml.cycleTab(this.id)"><?php echo TAB_DESC; ?></td>
						<td id="tab4" class="offtab" onclick="dhtml.cycleTab(this.id)"><?php echo TAB_NAME; ?></td>
		
						<td width="90%" class="tabpadding">&nbsp;</td>
					</tr>
				  </table>         
					                                   
				<div id="page4" class="pagetext">
					<table border="0" cellspacing="0" cellpadding="5" class="formerform" width="100%">
		
		
		
		
		
							
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
				  <!-- B2B start -->
					<?php 
						for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
					?>
		          <tr>
		            <td class="main"><?php 
							if ($i == 0) echo TEXT_ITEMS_NAME; 
						?></td>
		            <td class="main"><?php 
							echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_name[' . $languages[$i]['id'] . ']', (isset($galeries_name[$languages[$i]['id']]) ? $galeries_name[$languages[$i]['id']] : go_get_galerie_name($pInfo->galeries_id, $languages[$i]['id'])), 'size="35"'); 
						?></td>
		          </tr>
				  <?php 
		
						}
		
				  ?> 
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
					
		<?php 
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		          <tr>
		            <td class="main"><?php if ($i == 0) echo TEXT_ITEMS_NAME2; ?></td>
		            <td class="main"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_name2[' . $languages[$i]['id'] . ']', (isset($galeries_name2[$languages[$i]['id']]) ? $galeries_name2[$languages[$i]['id']] : go_get_galerie_name2($pInfo->galeries_id, $languages[$i]['id']))); ?></td>
		          </tr>
	
		<?php 
			}
		?>
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>		
		<?php 
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		          <tr>
		            <td class="main"><?php if ($i == 0) echo TEXT_GALERIE_INFO1; ?></td>
		            <td class="main"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_info1[' . $languages[$i]['id'] . ']', (isset($galeries_info1[$languages[$i]['id']]) ? $galeries_info1[$languages[$i]['id']] : go_get_galerie_info1($pInfo->galeries_id, $languages[$i]['id']))); ?></td>
		          </tr>
	
		<?php 
		    }
		?>
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>		
		<?php   
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		          <tr>
		            <td class="main"><?php if ($i == 0) echo TEXT_GALERIE_INFO2; ?></td>
		            <td class="main"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_info2[' . $languages[$i]['id'] . ']', (isset($galeries_info2[$languages[$i]['id']]) ? $galeries_info2[$languages[$i]['id']] : go_get_galerie_info2($pInfo->galeries_id, $languages[$i]['id']))); ?></td>
		          </tr>
		
		<?php 
		    }
		?>
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>		
		<?php 
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		          <tr>
		            <td class="main"><?php if ($i == 0) echo TEXT_GALERIE_INFO3; ?></td>
		            <td class="main"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_info3[' . $languages[$i]['id'] . ']', (isset($galeries_info3[$languages[$i]['id']]) ? $galeries_info3[$languages[$i]['id']] : go_get_galerie_info3($pInfo->galeries_id, $languages[$i]['id']))); ?></td>
		          </tr>
		
		<?php 
		    }
		?>
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>		
		<?php 
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		          <tr>
		            <td class="main"><?php if ($i == 0) echo TEXT_GALERIE_INFO4; ?></td>
		            <td class="main"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('galeries_info4[' . $languages[$i]['id'] . ']', (isset($galeries_info4[$languages[$i]['id']]) ? $galeries_info4[$languages[$i]['id']] : go_get_galerie_info4($pInfo->galeries_id, $languages[$i]['id']))); ?></td>
		          </tr>
		
		<?php 
		    }
		?>
					
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
		          <tr>
		            <td class="main"><?php echo TEXT_ITEMS_MODEL; ?></td>
		            <td class="main"><?php echo go_fetch_dividing_up('tranparentes.gif', '24', '15'); 
			            	?>
		            <select name="galeries_model" size="1">
		            <?php 
		            	if ($pInfo->galeries_model != ""){
		            		$gal_model_name_query = go_db_query("SELECT name FROM " . DB_TBL_GALERIE_TEMPLATE . " WHERE  template_id = '" . $pInfo->galeries_model . "'");
			            	$gal_model_name_werte = go_db_fetch_array($gal_model_name_query);
			            	?>
					<option selected value="<?php echo $pInfo->galeries_model; ?>"><?php echo $pInfo->galeries_model . ' - ' . $gal_model_name_werte['name']; ?></option>
					<?php 
		        	}
		        	else{
		        		?>
		        		<option selected value=""><?php echo TEXT_PLS_CHOOSE; ?></option>
		        		<?php 
		        	}
		        	
		        	
				$gal_model_query = go_db_query("SELECT template_id, name FROM " . DB_TBL_GALERIE_TEMPLATE);
				while($gal_model_werte = go_db_fetch_array($gal_model_query)){	
		        		?>
		        		<option value="<?php echo $gal_model_werte["template_id"]; ?>"><?php echo $gal_model_werte["template_id"] . ' - ' . $gal_model_werte["name"]; ?></option>
		        		<?php 			        }
			        
			        
			        ?>	
		        	</select> (<a href="main_bigware_50.php"><?php echo TEXT_SEE_ALSO; ?></a>)
			</td>
		          </tr>
		

		
		
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
		          <tr>
		            <td class="main"><?php echo TEXT_ITEMS_STATUS; ?></td>
		            <td class="main"><?php 
							   echo go_fetch_dividing_up('tranparentes.gif', '24', '15') . '&nbsp;' . go_fetch_radio_field('galeries_status', '1', $in_status) . '&nbsp;' . TEXT_ITEM_AVAILABLE . '&nbsp;' . go_fetch_radio_field('galeries_status', '0', $out_status) . '&nbsp;' . TEXT_ITEM_NOT_AVAILABLE; 
								?></td>
		          </tr>

		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
		          <tr>
		            <td class="main"><?php echo TEXT_ITEMS_DATE_AVAILABLE; ?><br><small><?php echo TEXT_DATE_FORMAT; ?></small></td>
		            <td class="main"><?php echo go_fetch_dividing_up('tranparentes.gif', '24', '15') . '&nbsp;'; ?><script language="javascript">dateAvailable.writeControl(); dateAvailable.dateFormat="yyyy-MM-dd";</script></td>
		          </tr>
					</table></div>
					
					
			
			
		  <div id="page3" class="pagetext">
		 <table cellpadding="5" cellspacing="0" border="0" class="formerform">
			<!-- B2B end -->
		<?php
		    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
		?>
		<script language="JavaScript">
		<!--
		function PageEinfuegen<?php echo $languages[$i]['id']; ?>(Code)
		{
			document.new_galerie.galeries_description<?php echo $languages[$i]['id']; ?>.value+=Code+"";
			document.new_galerie.galeries_description<?php echo $languages[$i]['id']; ?>.focus();
		}
		//-->
		</script>
		
		<script language="Javascript">
		<!--
		
		function eingabe<?php echo $languages[$i]['id']; ?>(){
		  var Zusatz = 'page_insert()';
		  var Eingabe = window.prompt(<?php echo TEXT_URL_DECLARATION; ?>, <?php echo TEXT_HTTP; ?>);
		  document.new_galerie.galeries_description<?php echo $languages[$i]['id']; ?>.value+=Zusatz+Eingabe;
		
		}
		-->
		</script>
		
		
		          <tr>
		            <td class="main" valign="top"></td>
		            <td><table border="0" cellspacing="0" cellpadding="0">
		              <tr>
		                <td class="main" valign="top"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']); ?>&nbsp;<br>
		             
		                </td>
		                <td class="main"> 
		           
		                
<?php 
echo '<textarea class="mce" name="galeries_description' . $languages[$i]['id'] . '">'.(isset(${'galeries_description'.$languages[$i]['id']}) ? stripslashes(${'galeries_description'.$languages[$i]['id']}) : stripslashes(go_get_galerie_description($pInfo->galeries_id, $languages[$i]['id']))).'</textarea></br>';
?>   		                
		                
		                </td>
		
		              </tr>
		            </table></td>
		          </tr>
		<?php
		    }
		?>
		          <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
				<!-- B2B start -->
				 </table>
			</div>
			
			
			<div id="page1" class="pagetext">
			<table cellpadding="5" cellspacing="0" border="0" class="formerform">
		 	  <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>
		
			<tr>
			   <td class="main"></td>
			   <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
			   <td class="main"><?php echo TEXT_PIC_CHOISE; ?></td>
			   <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
			   <td class="main"><?php echo TEXT_PREVIEW_MARK; ?></td>
			   <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
			   <td class="main"><?php echo TEXT_GALERY_SORT; ?></td>
			</tr>
		 	  <tr>
		            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		          </tr>				
		
		<?php  
		    
		$arr_pictures_changeor = 0;
		if ($pInfo->galeries_id == ""){$galerie_id = $bigID;} else {$galerie_id = $pInfo->galeries_id;}
			$count_gal_to_pic_id_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_PICTURES . " where galeries_id = '" . $galerie_id . "'");
			$count_gal_to_pic_id = go_db_fetch_array($count_gal_to_pic_id_query);
			if ($count_gal_to_pic_id['total'] != 0) {
				$gal_to_pic_query = go_db_query("SELECT * FROM " . DB_TBL_GALERIE_TO_PICTURES . " WHERE  galeries_id = '" . $galerie_id . "'");
				$arr_pictures = 0;
				while($gal_to_pic_werte = go_db_fetch_array($gal_to_pic_query)){
						
					$count_anzeige = $arr_pictures+1;
					$arr_pictures_changeor++;
					if ($pictures_id[$arr_pictures] == ""){$pictures_id_show = $gal_to_pic_werte["galerie_to_picture_id"];}else{$pictures_id_show = $pictures_id[$arr_pictures];}
					if ($pictures[$arr_pictures] == ""){$pictures_show = $gal_to_pic_werte["pictures"];}else{$pictures_show = $pictures[$arr_pictures];}
					if ($sort_order_picture[$arr_pictures] == ""){$sort_orter_picture_show = $gal_to_pic_werte["sort_order"];}else{$sort_orter_picture_show = $sort_order_picture[$arr_pictures];}
					if ($vorschaubild == ""){$vorschaubild_show = $gal_to_pic_werte["vorschau"];  $vergleich_vorschau = '1';}else{$vorschaubild_show = $vorschaubild; $vergleich_vorschau = $arr_pictures;}
					if ($vorschaubild_show == $vergleich_vorschau){
						$vorschauchecked = ' checked';
					}
					else{
						$vorschauchecked = '';
					}
					
					?>		    
					        <tr>
					            <td class="main"><?php echo TEXT_PIC_ONE . ' ' . $count_anzeige; ?></td>
					            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
					            <td class="main">
					            
					            
							<?php

							if ($pictures_show != ""){
							$pictures_show = '<IMG src="' . FOLDER_RELATIV_CATALOG_PICTURES . $pictures_show . '">';
							}

							echo '<textarea class="mceimg" name="pictures[' . $arr_pictures .']">'.stripslashes($pictures_show).'</textarea></br>';
							
							echo go_fetch_hidden_field('pictures_id[' . $arr_pictures . ']', $pictures_id_show) . '</td>
					            <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
					            <td class="main"><p align="center"><input type="radio" value="' . $arr_pictures . '"' . $vorschauchecked . ' name="vorschaubild"></td>
					            <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
					            <td class="main">' . go_fetch_inputfeld('sort_order_picture[' . $arr_pictures . ']', $sort_orter_picture_show, 'size="3"'); ?></td>
					        </tr>
					      		
					<?php 	
		
					$arr_pictures++;
				}
		
			}
				if ($zusaetzliche_bilder != ""){
					$b = $arr_pictures_changeor-1;
					for ($i = 1; $i < $zusaetzliche_bilder; $i++) {	
						$b++;
						$c = $b+1;
						
						if ($action == "new_galerie"){
						//if ($zusaetzliche_bilder != ""){
							if ($vorschaubild == $b){
								$vorschauchecked = ' checked';
							}
							else{
								$vorschauchecked = '';
							}
							?>		    
							        <tr>
							            <td class="main"><?php echo TEXT_PIC_TWO . ' ' . $c; ?></td>
							            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
							            <td class="main">
							            <?php
									if ($pictures[$b] != ""){
										$pictures[$b] = '<IMG src="' . FOLDER_RELATIV_CATALOG_PICTURES . $pictures[$b] . '">';
									}							            
									echo '<textarea class="mceimg" name="pictures[' . $b .']">'.stripslashes($pictures[$b]).'</textarea></br>';
							             echo '</td>
							            <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
							            <td class="main"><p align="center"><input type="radio" value="' . $b . '"' . $vorschauchecked . ' name="vorschaubild"></td>
							            <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
					              		    <td class="main">' . go_fetch_inputfeld('sort_order_picture[' . $b . ']', $sort_order_picture[$b], 'size="3"'); ?></td>
							        </tr>
							      		
							<?php 
						}
						else{
							if ($vorschaubild == $b){
								$vorschauchecked = ' checked';
							}
							else{
								$vorschauchecked = '';
							}
							?>		    
							        <tr>
							            <td class="main"><?php echo TEXT_PIC_TWO . ' ' . $c; ?></td>
							            <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '10', '1'); ?></td>
							            <td class="main"><?php echo go_fetch_textarea_field('pictures[' . $b . ']', 'soft', '50', '2','') . '</td>
							            <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
							            <td class="main"><p align="center"><input type="radio" value="' . $b . '" name="vorschaubild"></td>
					              		    <td colspan="2">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>
					              		    <td class="main">' . go_fetch_inputfeld('sort_order_picture[' . $b . ']', '', 'size="2"'); ?></td>
							        </tr>
							       		
							<?php 
						}
		
					}
				}
		
		
  
		?>         
		
		<td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?>
		<?php 
		 echo '&nbsp;' . go_fetch_hidden_field('zusaetzliche_bilder','' . $zusaetzliche_bilder . '');  
		?>          
			  </td>
		          </tr>
						</table>
			
		</div>
			
			
		</td>
						
						<!-- B2B start -->
		      </tr></div>   
		<script language="javascript" type="text/javascript">
		    dhtml.cycleTab('tab1');
		</script>
				<!-- B2B end -->
				
		      </tr>
		      <tr>
		        <td>
		        
		        
		        
		   
		        
		        <?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		      </tr>
		      <tr>
		        <td class="main" align="right"><?php echo go_fetch_hidden_field('galeries_date_added', (go_not_null($pInfo->galeries_date_added) ? $pInfo->galeries_date_added : date('Y-m-d'))) . go_picture_submit('button_preview.gif', PICTURE_PREVIEW) . '&nbsp;&nbsp;<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . (isset($_GET['bigID']) ? '&bigID=' . $_GET['bigID'] : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>'; ?></td>
		      </tr>
		    </table></form>
		
		
		

		             
		             <?php   
	}            
} elseif ($action == 'new_galerie_preview') {
    if (go_not_null($_POST)) {
      $pInfo = new objectInfo($_POST);
			
						
      $galeries_name = $_POST['galeries_name'];
      $galeries_name2 = $_POST['galeries_name2'];
      $galeries_description = $_POST['galeries_description'];
      $galeries_info1 = $_POST['galeries_info1'];
      $galeries_info2 = $_POST['galeries_info2'];
      $galeries_info3 = $_POST['galeries_info3'];
      $galeries_info4 = $_POST['galeries_info4'];
    } else {
      $galerie_query = go_db_query("select p.galeries_id, pd.language_id, pd.galeries_name, pd.galeries_name2, pd.galeries_description, pd.galeries_info1, pd.galeries_info2, pd.galeries_info3, pd.galeries_info4, p.galeries_quantity, p.galeries_model, p.galeries_weight, p.galeries_date_added, p.galeries_last_modified, p.galeries_date_available, p.galeries_status, p.producers_id  from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_DESCRIPTION . " pd where p.galeries_id = pd.galeries_id and p.galeries_id = '" . (int)$_GET['bigID'] . "'");
      $galerie = go_db_fetch_array($galerie_query);
			
			$pInfo = new objectInfo($galerie); 
    }
    $form_action = (isset($_GET['bigID'])) ? 'update_galerie' : 'insert_galerie';
    echo go_fetch_form($form_action, NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . (isset($_GET['bigID']) ? '&bigID=' . $_GET['bigID'] : '') . '&action=' . $form_action, 'post', 'enctype="multipart/form-data"');
    $languages = go_get_languages();
    for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
      if (isset($_GET['read']) && ($_GET['read'] == 'only')) {
        $pInfo->galeries_name = go_get_galerie_name($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_name2 = go_get_galerie_name2($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_description = go_get_galerie_description($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_info1 = go_get_galerie_info1($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_info2 = go_get_galerie_info2($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_info3 = go_get_galerie_info3($pInfo->galeries_id, $languages[$i]['id']);
        $pInfo->galeries_info4 = go_get_galerie_info4($pInfo->galeries_id, $languages[$i]['id']);
      } else {
        $pInfo->galeries_name = go_db_producing_input($galeries_name[$languages[$i]['id']]);
        $pInfo->galeries_name2 = go_db_producing_input($galeries_name2[$languages[$i]['id']]);
        $pInfo->galeries_description = go_db_producing_input(${'galeries_description'.$languages[$i]['id']});
        $pInfo->galeries_info1 = go_db_producing_input($galeries_info1[$languages[$i]['id']]);
        $pInfo->galeries_info2 = go_db_producing_input($galeries_info2[$languages[$i]['id']]);
        $pInfo->galeries_info3 = go_db_producing_input($galeries_info3[$languages[$i]['id']]);
        $pInfo->galeries_info4 = go_db_producing_input($galeries_info4[$languages[$i]['id']]);
      }
?>
    <table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td colspan="2"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . $pInfo->galeries_name; ?></td>
            <td class="pageGeneralsign" align="right">
</td>
          </tr>
          <tr>
            <td class="smallText"><?php echo '&nbsp;' . $pInfo->galeries_name2; ?></td>
          </tr>
        </table></td>
				
	
      </tr>
      <tr>
        <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
      
      
      
      <tr>
        <td class="main"><?php echo $pInfo->galeries_description; ?></td>
        <td class="main"><p align="right">
       <?php if($galeries_picture_name != "") {?>
        <?php echo go_picture(FOLDER_RELATIV_CATALOG_PICTURES . $galeries_picture_name, $pInfo->galeries_name, SMALL_PICTURE_WIDTH, SMALL_PICTURE_HEIGHT, 'align="right" hspace="5" vspace="5"') ?>
        <?php }?>
        </td>
      </tr>
      
      
  
      
      
<?php       
	$hidden_preview_id_echo = '';
	$hidden_preview_echo = '';
	$count_gal_to_pic_id_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_PICTURES . " where galeries_id = '" . $pInfo->galeries_id . "'");
	$count_gal_to_pic_id = go_db_fetch_array($count_gal_to_pic_id_query);
	if ($count_gal_to_pic_id['total'] != 0) {
		$gal_to_pic_query = go_db_query("SELECT * FROM " . DB_TBL_GALERIE_TO_PICTURES . " WHERE  galeries_id = '" . $pInfo->galeries_id . "'");
		$arr_pictures = 0;
		while($gal_to_pic_werte = go_db_fetch_array($gal_to_pic_query)){
		
		$count_anzeige = $arr_pictures+1;
?>
       <tr>
        <td class="main"><?php echo 'Bild: ' . $count_anzeige; ?></td>
        <td class="main"><?php echo go_picture(FOLDER_RELATIV_CATALOG_PICTURES . $gal_to_pic_werte["pictures"], $gal_to_pic_werte["pictures"], SMALL_PICTURE_WIDTH, SMALL_PICTURE_HEIGHT, 'align="right" hspace="5" vspace="5"');?></a></td>
      </tr>
		    
	
<?php 	
      $hidden_preview_echo .= go_fetch_hidden_field('picture[$arr_pictures]', stripslashes($gal_to_pic_werte["pictures"])) . "\n";
      $hidden_preview_id_echo .= go_fetch_hidden_field('picture_id[$arr_pictures]', $gal_to_pic_werte["galerie_to_picture_id"]) . "\n";
		$arr_pictures++;
		}
	$arr_pictures_hidden = $arr_pictures;
	}
    
?>        
      
      <tr>
        <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
<?php
      if ($pInfo->galeries_date_available > date('Y-m-d')) {
?>
      <tr>
        <td align="center" class="smallText"><?php echo sprintf(TEXT_ITEM_DATE_AVAILABLE, go_date_long($pInfo->galeries_date_available)); ?></td>
      </tr>
<?php
      } else {
?>
      <tr>
        <td align="center" class="smallText"><?php echo sprintf(TEXT_ITEM_DATE_ADDED, go_date_long($pInfo->galeries_date_added)); ?></td>
      </tr>
<?php
      }
?>
      <tr>
        <td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
      </tr>
<?php
    }
    if (isset($_GET['read']) && ($_GET['read'] == 'only')) {
      if (isset($_GET['origin'])) {
        $pos_parameter = strpos($_GET['origin'], '?', 0);
        if ($pos_parameter != false) {
          $back_url = substr($_GET['origin'], 0, $pos_parameter);
          $back_url_parameter = substr($_GET['origin'], $pos_parameter + 1);
        } else {
          $back_url = $_GET['origin'];
          $back_url_parameter = '';
        }
      } else {
        $back_url = NAME_OF_FILE_GALERIE_CAT;
        $back_url_parameter = 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id;
      }
?>
      <tr>
        <td align="right"><?php echo '<a href="' . go_href_link($back_url, $back_url_parameter, 'NONSSL') . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>'; ?></td>
      </tr></tr>
    </table>
<?php
    } else {
?>
      <tr>
        <td align="right" class="smallText">
<?php
 $dd_out=$_POST['dd'];
      reset($_POST); 
      while (list($key, $value) = each($_POST)) {
          if (is_array($value)) {
              while (list($k, $v) = each($value)) {
              	
          		if ($key == 'pictures'){
				echo '<input type="hidden" name="' . $key . '[' . $k . ']" value="' . $v . '">' . "\n";
			}
			else{
          			echo go_fetch_hidden_field($key . '[' . $k . ']', isohtmlspecialchars(stripslashes($v))) . "\n";
          		}              	
                 }
           } else {    

          
          	if ($key == 'pictures'){
			echo '<input type="hidden" name="' . $key . '" value="' . $value . '">' . "\n";
		}
		else{
          		echo go_fetch_hidden_field($key, isohtmlspecialchars(stripslashes($value))) . "\n";
          	}
          
        }
      } 
      
      echo $hidden_preview_id_echo;
      echo $hidden_preview_echo;
      echo go_picture_submit('button_back.gif', PICTURE_BACK, 'name="change"') . '&nbsp;&nbsp;';
      echo go_fetch_hidden_field('dd_out', isohtmlspecialchars(stripslashes($dd_out)));
      if (isset($_GET['bigID'])) {
        echo go_picture_submit('button_update.gif', PICTURE_UPDATE);
      } else {
        echo go_picture_submit('button_insert.gif', PICTURE_INSERT);
      }
      echo '&nbsp;&nbsp;<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . (isset($_GET['bigID']) ? '&bigID=' . $_GET['bigID'] : '')) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>';
?></td>
      </tr>
    </table><input type="hidden" value="das ist ein test" name="mytest"></form>
<?php
  }
  } else {
?>
    <table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
            <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
            <td align="right"><table border="0" width="100%" cellspacing="0" cellpadding="0">
              <tr>
                <td class="smallText" align="right">
<?php
    echo go_fetch_form('search', NAME_OF_FILE_GALERIE_CAT, '', 'get');
    echo ABOVE_TITLE_SEARCH . ' ' . go_fetch_inputfeld('search');
    echo '</form>';
?>
                </td>
              </tr>
              <tr>
                <td class="smallText" align="right">
<?php
    echo go_fetch_form('goto', NAME_OF_FILE_GALERIE_CAT, '', 'get');
    echo ABOVE_TITLE_GOTO . ' ' . go_fetch_pull_down_menu('bigPfad', go_get_galerie_cat_tree(), $current_category_id, 'onChange="this.form.submit();"');
    echo '</form>';
?>
                </td>
              </tr>
            </table></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="5">
          <tr>
            <td valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="5">
              <tr class="tbUPCountData">
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_CATEGORIES_ITEMS; ?></td>
                <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_ART_Number; ?></td>
 

 
                <td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_STATUS; ?></td>
                <td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
<?php
    $categories_count = 0;
    $rows = 0;
    if (isset($_GET['search'])) {
      $search = go_db_producing_input($_GET['search']); 
        $categories_query = go_db_query("select c.categories_id, cd.categories_name,cd.categories_desc, c.categories_picture, c.parent_id, c.sort_order, c.date_added, c.last_modified, c.categories_status from " . DB_TBL_GALERIE_CAT . " c, " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and cd.categories_name like '%" . go_db_input($search) . "%' order by c.sort_order, cd.categories_name");
    } else { 
      $categories_query = go_db_query("select c.categories_id, cd.categories_name, cd.categories_desc, c.categories_picture, c.parent_id, c.sort_order, c.date_added, c.last_modified, c.categories_status from " . DB_TBL_GALERIE_CAT . " c, " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where c.parent_id = '" . (int)$current_category_id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' order by c.sort_order, cd.categories_name");
    }
    while ($categories = go_db_fetch_array($categories_query)) {
      $categories_count++;
      $rows++; 
      if (isset($_GET['search'])) $bigPfad= $categories['parent_id'];
      if ((!isset($_GET['bigID']) && !isset($_GET['bigID']) || (isset($_GET['bigID']) && ($_GET['bigID'] == $categories['categories_id']))) && !isset($bigwareInfo) && (substr($action, 0, 3) != 'new')) {
        $category_childs = array('childs_count' => go_childs_in_category_count($categories['categories_id']));
        $category_galeries = array('galeries_count' => go_galeries_in_category_count($categories['categories_id']));
        $bigwareInfo_array = array_merge($categories, $category_childs, $category_galeries);
        $bigwareInfo = new objectInfo($bigwareInfo_array);
      }
      if (isset($bigwareInfo) && is_object($bigwareInfo) && ($categories['categories_id'] == $bigwareInfo->categories_id) ) {
        echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_GALERIE_CAT, go_get_path($categories['categories_id'])) . '\'">' . "\n";
      } else {
        echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $categories['categories_id']) . '\'">' . "\n";
      }
?>
                <td class="TbInsideData"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, go_get_path($categories['categories_id'])) . '">' . go_picture(FOLDER_RELATIV_ICONS . 'folder.gif', ICON_FOLDER) . '</a>&nbsp;<b>' . $categories['categories_name'] . '</b>'; ?></td>
                <td class="TbInsideData"></td>


                <td class="TbInsideData" align="center">
<?php
      if ($categories['categories_status'] == '1') {
        echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_status_green.gif', PICTURE_ICON_STATUS_GREEN, 10, 10) . '&nbsp;&nbsp;<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'action=setflag_cat&flag=0&bigID=' . $categories['categories_id'] . '&bigPfad=' . $bigPfad) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_status_red_light.gif', PICTURE_ICON_STATUS_RED_LIGHT, 10, 10) . '</a>';
      } else {
        echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'action=setflag_cat&flag=1&bigID=' . $categories['categories_id'] . '&bigPfad=' . $bigPfad) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_status_green_light.gif', PICTURE_ICON_STATUS_GREEN_LIGHT, 10, 10) . '</a>&nbsp;&nbsp;' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_status_red.gif', PICTURE_ICON_STATUS_RED, 10, 10);
      }
?>
                </td>
                <td class="TbInsideData" align="right"><?php if (isset($bigwareInfo) && is_object($bigwareInfo) && ($categories['categories_id'] == $bigwareInfo->categories_id) ) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $categories['categories_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
    $galeries_count = 0;
    if (isset($_GET['search'])) {
      $galeries_query = go_db_query("select p.syn, p.galeries_id, p.galeries_model, p.galeries_weight, pd.galeries_name, pd.galeries_name2, pd.galeries_info1,  pd.galeries_info2,  pd.galeries_info3,  pd.galeries_info4,  p.galeries_quantity, p.galeries_date_added, p.galeries_last_modified, p.galeries_date_available, p.galeries_status, p2c.categories_id from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_DESCRIPTION . " pd, " . DB_TBL_GALERIE_TO_CATEGORIES . " p2c where p.galeries_id = pd.galeries_id and pd.language_id = '" . (int)$languages_id . "' and p.galeries_id = p2c.galeries_id and pd.galeries_name like '%" . go_db_input($search) . "%' order by pd.galeries_name");
    } else {
      $galeries_query = go_db_query("select p.syn, p.galeries_id, p.galeries_model, p.galeries_weight, pd.galeries_name, pd.galeries_name2, pd.galeries_info1,  pd.galeries_info2,  pd.galeries_info3,  pd.galeries_info4,  p.galeries_quantity, p.galeries_date_added, p.galeries_last_modified, p.galeries_date_available, p.galeries_status from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_DESCRIPTION . " pd, " . DB_TBL_GALERIE_TO_CATEGORIES . " p2c where p.galeries_id = pd.galeries_id and pd.language_id = '" . (int)$languages_id . "' and p.galeries_id = p2c.galeries_id and p2c.categories_id = '" . (int)$current_category_id . "' order by pd.galeries_name");
    }
    while ($galeries = go_db_fetch_array($galeries_query)) {
      $galeries_count++;
      $rows++; 
      if (isset($_GET['search'])) $bigPfad = $galeries['categories_id'];
      if ( (!isset($_GET['bigID']) && !isset($_GET['bigID']) || (isset($_GET['bigID']) && ($_GET['bigID'] == $galeries['galeries_id']))) && !isset($pInfo) && !isset($bigwareInfo) && (substr($action, 0, 3) != 'new')) {   
// Korrektur Bert Galeriefunktion
// Objekt wird jetzt korrekt initialisiert
//        $pInfo_array = array_merge($galeries, $reviews);
//        $pInfo = new objectInfo($pInfo_array);
        $pInfo = new objectInfo($galeries);
      }
      if (isset($pInfo) && is_object($pInfo) && ($galeries['galeries_id'] == $pInfo->galeries_id) ) {
        echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $galeries['galeries_id'] . '&action=new_galerie_preview&read=only') . '\'">' . "\n";
      } else {
        echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $galeries['galeries_id']) . '\'">' . "\n";
      }
?>
                <td class="TbInsideData"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $galeries['galeries_id'] . '&action=new_galerie_preview&read=only') . '">' . go_picture(FOLDER_RELATIV_ICONS . 'preview.gif', ICON_PREVIEW) . '</a>&nbsp;' . $galeries['galeries_name']; ?></td>
                <td class="TbInsideData"><?php echo $galeries['galeries_model']; ?></td>



                <td class="TbInsideData" align="center">
                <?php
      if ($galeries['galeries_status'] == '1') {
        echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_ansicht_green.gif', PICTURE_ICON_STATUS_GREEN, 10, 10) . '&nbsp;&nbsp;<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'action=setflag&flag=0&bigID=' . $galeries['galeries_id'] . '&bigPfad=' . $bigPfad) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_ansicht_red_light.gif', PICTURE_ICON_STATUS_RED_LIGHT, 10, 10) . '</a>';
      } else {
        echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'action=setflag&flag=1&bigID=' . $galeries['galeries_id'] . '&bigPfad=' . $bigPfad) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_ansicht_green_light.gif', PICTURE_ICON_STATUS_GREEN_LIGHT, 10, 10) . '</a>&nbsp;&nbsp;' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_ansicht_red.gif', PICTURE_ICON_STATUS_RED, 10, 10);
      }
?>
</td>
                <td class="TbInsideData" align="right"><?php if (isset($pInfo) && is_object($pInfo) && ($galeries['galeries_id'] == $pInfo->galeries_id)) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $galeries['galeries_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
    $bigPfad_back = '';
    if (sizeof($bigPfad_array) > 0) {
      for ($i=0, $n=sizeof($bigPfad_array)-1; $i<$n; $i++) {
        if (empty($bigPfad_back)) {
          $bigPfad_back .= $bigPfad_array[$i];
        } else {
          $bigPfad_back .= '_' . $bigPfad_array[$i];
        }
      }
    }
    $bigPfad_back = (go_not_null($bigPfad_back)) ? 'bigPfad=' . $bigPfad_back . '&' : '';
?>
              <tr>
                <td colspan="3"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td class="smallText"><?php echo TEXT_CATEGORIES . '&nbsp;' . $categories_count . '<br>' . TEXT_ITEMS . '&nbsp;' . $galeries_count; ?></td>
                    <?php if ($bigPfad == "") { ?>
                    <td align="right" class="smallText"><?php if (sizeof($bigPfad_array) > 0) echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, $bigPfad_back . 'bigID=' . $current_category_id) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>&nbsp;'; if (!isset($_GET['search'])) echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&action=new_category') . '">' . go_picture_button('button_new_category.gif', PICTURE_NEW_CATEGORY); ?>&nbsp;<a href="javascript:alert('<?php echo TEXT_PRODUCT_DESIGN; ?>')"><?php echo go_picture_button('button_new_galerie.gif', PICTURE_NEW_ITEM); ?></a></td>
                    
		    <?php } else{ ?>
                    <td align="right" class="smallText"><?php if (sizeof($bigPfad_array) > 0) echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, $bigPfad_back . 'bigID=' . $current_category_id) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>&nbsp;'; if (!isset($_GET['search'])) echo '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&action=new_category') . '">' . go_picture_button('button_new_category.gif', PICTURE_NEW_CATEGORY) . '</a>&nbsp;<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&action=new_galerie') . '">' . go_picture_button('button_new_galerie.gif', PICTURE_NEW_ITEM) . '</a>'; ?>&nbsp;</td>
                    <?php } ?>
                  </tr>
                </table></td>
              </tr>
            </table></td>
<?php
    $heading = array();
    $contents = array();
    switch ($action) {
      case 'new_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_NEW_CATEGORY . '</b>');
        $contents = array('form' => go_fetch_form('newcategory', NAME_OF_FILE_GALERIE_CAT, 'action=insert_category&bigPfad=' . $bigPfad, 'post', 'enctype="multipart/form-data"'));
        $contents[] = array('text' => TEXT_NEW_CATEGORY_INTRO);
        $category_inputs_string = '';
        $category_desc_string = '';
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $category_inputs_string .= '<br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('categories_name[' . $languages[$i]['id'] . ']');
          
$zeigen =  '<textarea class="mce" name="categories_desc' . $languages[$i]['id'] . '"></textarea></br>';
          
          $category_desc_string .= '<table><tr><td><br><br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;</td><td>' . $zeigen . '</td></tr></table>'; 
        }
        $contents[] = array('text' => '<br>' . TEXT_CATEGORIES_NAME . $category_inputs_string);
        $contents[] = array('text' => '<br>' . TEXT_CATEGORIES_NAME . $category_desc_string);
       
$zeigen =  '<textarea class="mceimg" name="categories_picture"></textarea></br>';
       
        $contents[] = array('text' => '<br>' . TEXT_CATEGORIES_PICTURE . '<br>' . $zeigen2);
        $contents[] = array('text' => '<br>' . TEXT_SORT_ORDER . '<br>' . go_fetch_inputfeld('sort_order', '', 'size="2"'));
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_STATUS . '<br>' . go_fetch_inputfeld('categories_status', '1', 'size="2"') . TEXT_VISIBILITY);
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_SAVE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'change_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_CHANGE_CATEGORY . '</b>');
        $contents = array('form' => go_fetch_form('categories', NAME_OF_FILE_GALERIE_CAT, 'action=update_category&bigPfad=' . $bigPfad, 'post', 'enctype="multipart/form-data"') . go_fetch_hidden_field('categories_id', $bigwareInfo->categories_id));
        $contents[] = array('text' => TEXT_CHANGE_INTRO);
        $category_inputs_string = '';
        $category_desc_string = '';
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
          $category_inputs_string .= '<br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;' . go_fetch_inputfeld('categories_name[' . $languages[$i]['id'] . ']', go_get_galerie_cat_name($bigwareInfo->categories_id, $languages[$i]['id'])); 
          
$zeigen =  '<textarea class="mce" name="categories_desc' . $languages[$i]['id'].'">'.stripslashes(go_get_galerie_cat_desc($bigwareInfo->categories_id, $languages[$i]['id'])).'</textarea></br>';
          
          $category_desc_string .= '<table><tr><td><br><br>' . go_picture(FOLDER_RELATIV_LANG_TEMPLATES . $languages[$i]['directory'] . '/picture/' . $languages[$i]['picture'], $languages[$i]['name']) . '&nbsp;</td><td>' . $zeigen . '</td></tr></table>';
        }
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_CATEGORIES_NAME . $category_inputs_string);
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_CATEGORIES_DESC . $category_desc_string);
	$contents[] = array('text' => '<br>' . go_info_picture($bigwareInfo->categories_picture, $bigwareInfo->categories_name, ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT) . '<br>' . FOLDER_RELATIV_CATALOG_PICTURES . '<br><b>' . $bigwareInfo->categories_picture . '</b>'); 
          
$categories_picture = $bigwareInfo->categories_picture;
if ($categories_picture != ""){
$categories_picture = '<IMG src="' . FOLDER_RELATIV_CATALOG_PICTURES . $categories_picture . '">';
}
$zeigen2 =  '<textarea class="mceimg" name="categories_picture">'.stripslashes($categories_picture).'</textarea></br>';
          
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_CATEGORIES_PICTURE . '<br>' . $zeigen2);
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_SORT_ORDER . '<br>' . go_fetch_inputfeld('sort_order', $bigwareInfo->sort_order, 'size="2"')); 
        $contents[] = array('text' => '<br>' . TEXT_CHANGE_STATUS . '<br>' . go_fetch_inputfeld('categories_status', $bigwareInfo->categories_status, 'size="2"') . TEXT_VISIBILITY);
	$contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_SAVE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'delete_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_DELETE_CATEGORY . '</b>');
        $contents = array('form' => go_fetch_form('categories', NAME_OF_FILE_GALERIE_CAT, 'action=delete_category_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('categories_id', $bigwareInfo->categories_id));
        $contents[] = array('text' => TEXT_DELETE_CATEGORY_INTRO);
        $contents[] = array('text' => '<br><b>' . $bigwareInfo->categories_name . '</b>');
        if ($bigwareInfo->childs_count > 0) $contents[] = array('text' => '<br>' . sprintf(TEXT_DELETE_WARNING_CHILDS, $bigwareInfo->childs_count));
        if ($bigwareInfo->galeries_count < 500){
        if ($bigwareInfo->galeries_count > 0) $contents[] = array('text' => '<br>' . sprintf(TEXT_DELETE_WARNING_ITEMS, $bigwareInfo->galeries_count));
        $contents[] = array('align' => 'center', 'text' => '<br>'. go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
	}
        else{
        if ($bigwareInfo->galeries_count > 0) $contents[] = array('text' => '<br>' . sprintf(TEXT_DELETE_WARNING_ZU_VIEL_ITEMS, $bigwareInfo->galeries_count));
        $contents[] = array('align' => 'center', 'text' => '<br> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        }
        break; 
      case 'neu_im_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_NEU_IM . '</b>');
        $contents = array('form' => go_fetch_form('categories', NAME_OF_FILE_GALERIE_CAT, 'action=neu_im_category_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('categories_id', $bigwareInfo->categories_id));
        $contents[] = array('text' => sprintf(TEXT_NEUE_PRODUKTE_INTRO, $bigwareInfo->categories_name));
        $contents[] = array('text' => '<br><b>' . $bigwareInfo->categories_name . '</b>');
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_MOVE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'move_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_MOVE_CATEGORY . '</b>');
        $contents = array('form' => go_fetch_form('categories', NAME_OF_FILE_GALERIE_CAT, 'action=move_category_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('categories_id', $bigwareInfo->categories_id));
        $contents[] = array('text' => sprintf(TEXT_MOVE_CATEGORIES_INTRO, $bigwareInfo->categories_name));
        $contents[] = array('text' => '<br>' . sprintf(TEXT_MOVE, $bigwareInfo->categories_name) . '<br>' . go_fetch_pull_down_menu('move_to_category_id', go_get_galerie_cat_tree(), $current_category_id));
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_move.gif', PICTURE_MOVE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'delete_galerie':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_DELETE_ITEM . '</b>');
        $contents = array('form' => go_fetch_form('galeries', NAME_OF_FILE_GALERIE_CAT, 'action=delete_galerie_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('galeries_id', $pInfo->galeries_id));
        $contents[] = array('text' => TEXT_DELETE_ITEM_INTRO);
        $contents[] = array('text' => '<br><b>' . $pInfo->galeries_name . '</b>');
        $galerie_categories_string = '';
        $galerie_categories = go_generate_galerie_cat_path($pInfo->galeries_id, 'galerie');
        for ($i = 0, $n = sizeof($galerie_categories); $i < $n; $i++) {
          $category_path = '';
          for ($j = 0, $k = sizeof($galerie_categories[$i]); $j < $k; $j++) {
            $category_path .= $galerie_categories[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
          }
          $category_path = substr($category_path, 0, -16);
          $galerie_categories_string .= go_fetch_checkbox_field('galerie_categories[]', $galerie_categories[$i][sizeof($galerie_categories[$i])-1]['id'], true) . '&nbsp;' . $category_path . '<br>';
        }
        $galerie_categories_string = substr($galerie_categories_string, 0, -4);
        $contents[] = array('text' => '<br>' . $galerie_categories_string);
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break; 
      case 'neues_galerie':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_NEUES_ITEM . '</b>');
        $contents = array('form' => go_fetch_form('galeries', NAME_OF_FILE_GALERIE_CAT, 'action=neues_galerie_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('galeries_id', $pInfo->galeries_id));
        $contents[] = array('text' => TEXT_NEU_ITEM_INTRO);
        $contents[] = array('text' => '<br><b>' . $pInfo->galeries_name . '</b>');
        $galerie_categories_string = '';
        $galerie_categories = go_generate_galerie_cat_path($pInfo->galeries_id, 'galerie');
        for ($i = 0, $n = sizeof($galerie_categories); $i < $n; $i++) {
          $category_path = '';
          for ($j = 0, $k = sizeof($galerie_categories[$i]); $j < $k; $j++) {
            $category_path .= $galerie_categories[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
          }
          $category_path = substr($category_path, 0, -16);
          $galerie_categories_string .= go_fetch_checkbox_field('galerie_categories[]', $galerie_categories[$i][sizeof($galerie_categories[$i])-1]['id'], true) . '&nbsp;' . $category_path . '<br>';
        }
        $galerie_categories_string = substr($galerie_categories_string, 0, -4);
        $contents[] = array('text' => '<br>' . $galerie_categories_string);
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_save.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'move_galerie':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_MOVE_ITEM . '</b>');
        $contents = array('form' => go_fetch_form('galeries', NAME_OF_FILE_GALERIE_CAT, 'action=move_galerie_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('galeries_id', $pInfo->galeries_id));
        $contents[] = array('text' => sprintf(TEXT_MOVE_ITEMS_INTRO, $pInfo->galeries_name));
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENT_CATEGORIES . '<br><b>' . go_output_generated_galerie_cat_path($pInfo->galeries_id, 'galerie') . '</b>');
        $contents[] = array('text' => '<br>' . sprintf(TEXT_MOVE, $pInfo->galeries_name) . '<br>' . go_fetch_pull_down_menu('move_to_category_id', go_get_galerie_cat_tree(), $current_category_id));
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_move.gif', PICTURE_MOVE) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      case 'copy_to':
        $heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_COPY_TO . '</b>');
        $contents = array('form' => go_fetch_form('copy_to', NAME_OF_FILE_GALERIE_CAT, 'action=copy_to_confirm&bigPfad=' . $bigPfad) . go_fetch_hidden_field('galeries_id', $pInfo->galeries_id));
        $contents[] = array('text' => TEXT_INFO_COPY_TO_INTRO);
        $contents[] = array('text' => '<br>' . TEXT_INFO_CURRENT_CATEGORIES . '<br><b>' . go_output_generated_galerie_cat_path($pInfo->galeries_id, 'galerie') . '</b>');
        $contents[] = array('text' => '<br>' . TEXT_CATEGORIES . '<br>' . go_fetch_pull_down_menu('categories_id', go_get_galerie_cat_tree(), $current_category_id));
        $contents[] = array('text' => '<br>' . TEXT_HOW_TO_COPY . '<br>' . go_fetch_radio_field('copy_as', 'link', true) . ' ' . TEXT_COPY_AS_LINK . '<br>' . go_fetch_radio_field('copy_as', 'duplicate') . ' ' . TEXT_COPY_AS_DUPLICATE);
        $contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_copy.gif', PICTURE_COPY) . ' <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
        break;
      default:
      
      
        if ($rows > 0) {
        	
          if (isset($bigwareInfo) && is_object($bigwareInfo)) { 
          
            $heading[] = array('text' => '<b>' . $bigwareInfo->categories_name . '</b>'); 
            $contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id . '&action=change_category') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id . '&action=delete_category') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $bigwareInfo->categories_id . '&action=move_category') . '">' . go_picture_button('button_move.gif', PICTURE_MOVE) . '</a>' . '</a>');
            $contents[] = array('text' => '<br>' . TEXT_DATE_ADDED . ' ' . go_date_short($bigwareInfo->date_added));
            if (go_not_null($bigwareInfo->last_modified)) $contents[] = array('text' => TEXT_LAST_MODIFIED . ' ' . go_date_short($bigwareInfo->last_modified));
            $contents[] = array('text' => '<br>' . go_info_picture($bigwareInfo->categories_picture, $bigwareInfo->categories_name, ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT) . '<br>' . $bigwareInfo->categories_picture);
            $contents[] = array('text' => '<br>' . TEXT_SUBCATEGORIES . ' ' . $bigwareInfo->childs_count . '<br>' . TEXT_ITEMS . ' ' . $bigwareInfo->galeries_count);
          } elseif (isset($pInfo) && is_object($pInfo)) { 
            $heading[] = array('text' => '<b>' . go_get_galerie_name($pInfo->galeries_id, $languages_id) . '</b>'); 
            $contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id . '&action=new_galerie') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id . '&action=delete_galerie') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id . '&action=move_galerie') . '">' . go_picture_button('button_move.gif', PICTURE_MOVE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_GALERIE_CAT, 'bigPfad=' . $bigPfad . '&bigID=' . $pInfo->galeries_id . '&action=copy_to') . '">' . go_picture_button('button_copy_to.gif', PICTURE_COPY_TO) . '</a>');
            $contents[] = array('text' => '<br>' . TEXT_DATE_ADDED . ' ' . go_date_short($pInfo->galeries_date_added));
            if (go_not_null($pInfo->galeries_last_modified)) $contents[] = array('text' => TEXT_LAST_MODIFIED . ' ' . go_date_short($pInfo->galeries_last_modified));
            if (date('Y-m-d') < $pInfo->galeries_date_available) $contents[] = array('text' => TEXT_DATE_AVAILABLE . ' ' . go_date_short($pInfo->galeries_date_available));
            $contents[] = array('text' => '<br>' . go_info_picture($pInfo->galeries_picture, $pInfo->galeries_name, SMALL_PICTURE_WIDTH, SMALL_PICTURE_HEIGHT) . '<br>' . $pInfo->galeries_picture);
            $contents[] = array('text' => '<br>' . TEXT_ITEMS_AVERAGE_RATING . ' ' . number_format($pInfo->average_rating, 2) . '%');
          }
        } else { 
          $heading[] = array('text' => '<b>' . EMPTY_CATEGORY . '</b>');
          $contents[] = array('text' => TEXT_NO_CHILD_CATEGORIES_OR_ITEMS);
        }
        break;
    }
    if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
      echo '            <td width="25%" valign="top">' . "\n";
      $frame = new frame;
      echo $frame->infoBox($heading, $contents);
      echo '            </td>' . "\n"; 
    }
?>
          </tr>
        </table></td>
      </tr>
    </table>
<?php
  }
?>
    </td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
