<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_bigware_11.php');
  $languages = go_get_languages();
  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  if (go_not_null($action)) {
    $page_info = '';
    if (isset($_GET['option_page'])) $page_info .= 'option_page=' . $_GET['option_page'] . '&';
    if (isset($_GET['value_page'])) $page_info .= 'value_page=' . $_GET['value_page'] . '&';
    if (isset($_GET['characteristic_page'])) $page_info .= 'characteristic_page=' . $_GET['characteristic_page'] . '&';
    if (go_not_null($page_info)) {
      $page_info = substr($page_info, 0, -1);
    }
    switch ($action) {
      case 'add_item_options':
        $items_options_id = go_db_producing_input($_POST['items_options_id']);
        $option_name_array = $_POST['option_name'];
        for ($i=0, $n=sizeof($languages); $i<$n; $i ++) {
          $option_name = go_db_producing_input($option_name_array[$languages[$i]['id']]);
          go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS . " (items_options_id, items_options_name, language_id) values ('" . (int)$items_options_id . "', '" . go_db_input($option_name) . "', '" . (int)$languages[$i]['id'] . "')");
        }
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'add_item_option_values':
        $value_name_array = $_POST['value_name'];
        $value_id = go_db_producing_input($_POST['value_id']);
        $option_id = go_db_producing_input($_POST['option_id']);
        for ($i=0, $n=sizeof($languages); $i<$n; $i ++) {
          $value_name = go_db_producing_input($value_name_array[$languages[$i]['id']]);
          go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES . " (items_options_values_id, language_id, items_options_values_name) values ('" . (int)$value_id . "', '" . (int)$languages[$i]['id'] . "', '" . go_db_input($value_name) . "')");
        }
        go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " (items_options_id, items_options_values_id) values ('" . (int)$option_id . "', '" . (int)$value_id . "')");
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'add_item_characteristics':
        $items_id = go_db_producing_input($_POST['items_id']);
        $options_id = go_db_producing_input($_POST['options_id']);
        $values_id = go_db_producing_input($_POST['values_id']);
        $value_price = go_db_producing_input($_POST['value_price']);
        $price_prefix = go_db_producing_input($_POST['price_prefix']);
        go_db_query("insert into " . DB_TBL_ITEMS_CHARACTERISTICS . "(items_id,options_id,options_values_id,options_values_price,price_prefix) values ( '" . (int)$items_id . "', '" . (int)$options_id . "', '" . (int)$values_id . "', '" . go_db_input($value_price) . "', '" . go_db_input($price_prefix) . "')");
        if (DOWNLOAD_ENABLED == 'true') {
          $items_characteristics_id = go_db_insert_id();
          $items_characteristics_filename = go_db_producing_input($_POST['items_characteristics_filename']);
          $items_characteristics_maxdays = go_db_producing_input($_POST['items_characteristics_maxdays']);
          $items_characteristics_maxcount = go_db_producing_input($_POST['items_characteristics_maxcount']);
          if (go_not_null($items_characteristics_filename)) {
            go_db_query("insert into " . DB_TBL_ITEMS_CHARACTERISTICS_DOWNLOAD . " values (" . (int)$items_characteristics_id . ", '" . go_db_input($items_characteristics_filename) . "', '" . go_db_input($items_characteristics_maxdays) . "', '" . go_db_input($items_characteristics_maxcount) . "')");
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'update_option_name':
        $option_name_array = $_POST['option_name'];
        $option_id = go_db_producing_input($_POST['option_id']);
        for ($i=0, $n=sizeof($languages); $i<$n; $i ++) {
          $option_name = go_db_producing_input($option_name_array[$languages[$i]['id']]);
          go_db_query("update " . DB_TBL_ITEMS_OPTIONS . " set items_options_name = '" . go_db_input($option_name) . "' where items_options_id = '" . (int)$option_id . "' and language_id = '" . (int)$languages[$i]['id'] . "'");
        }
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'update_value':
        $value_name_array = $_POST['value_name'];
        $value_id = go_db_producing_input($_POST['value_id']);
        $option_id = go_db_producing_input($_POST['option_id']);
        for ($i=0, $n=sizeof($languages); $i<$n; $i ++) {
          $value_name = go_db_producing_input($value_name_array[$languages[$i]['id']]);
          go_db_query("update " . DB_TBL_ITEMS_OPTIONS_VALUES . " set items_options_values_name = '" . go_db_input($value_name) . "' where items_options_values_id = '" . go_db_input($value_id) . "' and language_id = '" . (int)$languages[$i]['id'] . "'");
        }
        go_db_query("update " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " set items_options_id = '" . (int)$option_id . "'  where items_options_values_id = '" . (int)$value_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'update_item_characteristic':
        $items_id = go_db_producing_input($_POST['items_id']);
        $options_id = go_db_producing_input($_POST['options_id']);
        $values_id = go_db_producing_input($_POST['values_id']);
        $value_price = go_db_producing_input($_POST['value_price']);
        $price_prefix = go_db_producing_input($_POST['price_prefix']);
        $characteristic_id = go_db_producing_input($_POST['characteristic_id']);
        go_db_query("update " . DB_TBL_ITEMS_CHARACTERISTICS . " set items_id = '" . (int)$items_id . "', options_id = '" . (int)$options_id . "', options_values_id = '" . (int)$values_id . "', options_values_price = '" . go_db_input($value_price) . "', price_prefix = '" . go_db_input($price_prefix) . "' where items_characteristics_id = '" . (int)$characteristic_id . "'");
        if (DOWNLOAD_ENABLED == 'true') {
          $items_characteristics_filename = go_db_producing_input($_POST['items_characteristics_filename']);
          $items_characteristics_maxdays = go_db_producing_input($_POST['items_characteristics_maxdays']);
          $items_characteristics_maxcount = go_db_producing_input($_POST['items_characteristics_maxcount']);
          if (go_not_null($items_characteristics_filename)) {
            go_db_query("replace into " . DB_TBL_ITEMS_CHARACTERISTICS_DOWNLOAD . " set items_characteristics_id = '" . (int)$characteristic_id . "', items_characteristics_filename = '" . go_db_input($items_characteristics_filename) . "', items_characteristics_maxdays = '" . go_db_input($items_characteristics_maxdays) . "', items_characteristics_maxcount = '" . go_db_input($items_characteristics_maxcount) . "'");
          }
        }
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'delete_option':
        $option_id = go_db_producing_input($_GET['option_id']);
        go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . (int)$option_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'delete_value':
        $value_id = go_db_producing_input($_GET['value_id']);
        go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . (int)$value_id . "'");
        go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . (int)$value_id . "'");
        go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_values_id = '" . (int)$value_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
      case 'delete_characteristic':
        $characteristic_id = go_db_producing_input($_GET['characteristic_id']);
        go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_characteristics_id = '" . (int)$characteristic_id . "'"); 
        go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS_DOWNLOAD . " where items_characteristics_id = '" . (int)$characteristic_id . "'");
        go_forward(go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, $page_info));
        break;
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript"><!--
function go_option() {
  if (document.option_order_by.selected.options[document.option_order_by.selected.selectedIndex].value != "none") {
    location = "<?php echo go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'option_page=' . ($_GET['option_page'] ? $_GET['option_page'] : 1)); ?>&option_order_by="+document.option_order_by.selected.options[document.option_order_by.selected.selectedIndex].value;
  }
}
//--></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo FRAME_WIDTH; ?>" valign="top">
<!-- left_navigation //-->
<!-- left_navigation_eof //-->
</td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
<!-- options and values//-->
      <tr>
        <td width="100%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top" width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="2">
<!-- options //-->
<?php
  if ($action == 'delete_item_option') { 
    $options = go_db_query("select items_options_id, items_options_name from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . (int)$_GET['option_id'] . "' and language_id = '" . (int)$languages_id . "'");
    $options_values = go_db_fetch_array($options);
?>
              <tr>
                <td class="pageGeneralsign">&nbsp;<?php echo $options_values['items_options_name']; ?>&nbsp;</td>
                <td>&nbsp;<?php echo go_picture(FOLDER_RELATIV_PICTURES . 'tranparentes.gif', '', '1', '53'); ?>&nbsp;</td>
              </tr>
              <tr>
                <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
<?php
    $items = go_db_query("select p.items_id, pd.items_name, pov.items_options_values_name from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_OPTIONS_VALUES . " pov, " . DB_TBL_ITEMS_CHARACTERISTICS . " pa, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pov.language_id = '" . (int)$languages_id . "' and pd.language_id = '" . (int)$languages_id . "' and pa.items_id = p.items_id and pa.options_id='" . (int)$_GET['option_id'] . "' and pov.items_options_values_id = pa.options_values_id order by pd.items_name");
    if (go_db_num_rows($items)) {
?>
                  <tr class="tbUPCountData">
                    <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_ID; ?>&nbsp;</td>
                    <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ITEM; ?>&nbsp;</td>
                    <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_VALUE; ?>&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
<?php
      $rows = 0;
      while ($items_values = go_db_fetch_array($items)) {
        $rows++;
?>
                  <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
                    <td align="center" class="smallText">&nbsp;<?php echo $items_values['items_id']; ?>&nbsp;</td>
                    <td class="smallText">&nbsp;<?php echo $items_values['items_name']; ?>&nbsp;</td>
                    <td class="smallText">&nbsp;<?php echo $items_values['items_options_values_name']; ?>&nbsp;</td>
                  </tr>
<?php
      }
?>
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
                  <tr>
                    <td colspan="3" class="main"><br><?php echo TEXT_WARNING_OF_DELETE; ?></td>
                  </tr>
                  <tr>
                    <td align="right" colspan="3" class="main"><br><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, (isset($_GET['value_page']) ? 'value_page=' . $_GET['value_page'] . '&' : '') . (isset($_GET['characteristic_page']) ? 'characteristic_page=' . $_GET['characteristic_page'] : ''), 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', ' cancel '); ?></a>&nbsp;</td>
                  </tr>
<?php
    } else {
?>
                  <tr>
                    <td class="main" colspan="3"><br><?php echo TEXT_OK_TO_DELETE; ?></td>
                  </tr>
                  <tr>
                    <td class="main" align="right" colspan="3"><br><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_option&option_id=' . $_GET['option_id'], 'NONSSL') . '">'; ?><?php echo go_picture_button('button_delete.gif', ' delete '); ?></a>&nbsp;&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, (isset($_GET['order_by']) ? 'order_by=' . $_GET['order_by'] . '&' : '') . (isset($_GET['page']) ? 'page=' . $_GET['page'] : ''), 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', ' cancel '); ?></a>&nbsp;</td>
                  </tr>
<?php
    }
?>
                </table></td>
              </tr>
<?php
  } else {
    if (isset($_GET['option_order_by'])) {
      $option_order_by = $_GET['option_order_by'];
    } else {
      $option_order_by = 'items_options_id';
    }
?>
              <tr>
                <td colspan="2" class="pageGeneralsign">&nbsp;<?php echo ABOVE_TITLE_OPT; ?>&nbsp;</td>
                <td align="right"><br><form name="option_order_by" action="<?php echo NAME_OF_FILE_ITEMS_CHARACTERISTICS; ?>"><select name="selected" onChange="go_option()"><option value="items_options_id"<?php if ($option_order_by == 'items_options_id') { echo ' SELECTED'; } ?>><?php echo TEXT_OPTION_ID; ?></option><option value="items_options_name"<?php if ($option_order_by == 'items_options_name') { echo ' SELECTED'; } ?>><?php echo TEXT_OPTION_NAME; ?></option></select></form></td>
              </tr>
              <tr>
                <td colspan="3" class="smallText">
<?php
    $per_page = MAX_ROW_LISTS_OPTIONS;
    $options = "select * from " . DB_TBL_ITEMS_OPTIONS . " where language_id = '" . (int)$languages_id . "' order by " . $option_order_by;
    if (!isset($option_page)) {
      $option_page = 1;
    }
    $prev_option_page = $option_page - 1;
    $next_option_page = $option_page + 1;
    $option_query = go_db_query($options);
    $option_page_start = ($per_page * $option_page) - $per_page;
    $num_rows = go_db_num_rows($option_query);
    if ($num_rows <= $per_page) {
      $num_pages = 1;
    } else if (($num_rows % $per_page) == 0) {
      $num_pages = ($num_rows / $per_page);
    } else {
      $num_pages = ($num_rows / $per_page) + 1;
    }
    $num_pages = (int) $num_pages;
    $options = $options . " LIMIT $option_page_start, $per_page"; 
    if ($prev_option_page)  {
      echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'option_page=' . $prev_option_page) . '"> &lt;&lt; </a> | ';
    }
    for ($i = 1; $i <= $num_pages; $i++) {
      if ($i != $option_page) {
        echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'option_page=' . $i) . '">' . $i . '</a> | ';
      } else {
        echo '<b><font color=red>' . $i . '</font></b> | ';
      }
    } 
    if ($option_page != $num_pages) {
      echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'option_page=' . $next_option_page) . '"> &gt;&gt; </a>';
    }
?>
                </td>
              </tr>
              <tr>
                <td colspan="3"><?php echo go_black_line(); ?></td>
              </tr>
              <tr class="tbUPCountData">
                <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ID; ?>&nbsp;</td>
                <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_NAME; ?>&nbsp;</td>
                <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
              <tr>
                <td colspan="3"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    $next_id = 1;
    $rows = 0;
    $options = go_db_query($options);
    while ($options_values = go_db_fetch_array($options)) {
      $rows++;
?>
              <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
<?php
      if (($action == 'update_option') && ($_GET['option_id'] == $options_values['items_options_id'])) {
        echo '<form name="option" action="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=update_option_name', 'NONSSL') . '" method="post">';
        $inputs = '';
        for ($i = 0, $n = sizeof($languages); $i < $n; $i ++) {
          $option_name = go_db_query("select items_options_name from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . $options_values['items_options_id'] . "' and language_id = '" . $languages[$i]['id'] . "'");
          $option_name = go_db_fetch_array($option_name);
          $inputs .= $languages[$i]['code'] . ':&nbsp;<input type="text" name="option_name[' . $languages[$i]['id'] . ']" size="20" value="' . $option_name['items_options_name'] . '">&nbsp;<br>';
        }
?>
                <td align="center" class="smallText">&nbsp;<?php echo $options_values['items_options_id']; ?><input type="hidden" name="option_id" value="<?php echo $options_values['items_options_id']; ?>">&nbsp;</td>
                <td class="smallText"><?php echo $inputs; ?></td>
                <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?>&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, '', 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', PICTURE_CANCEL); ?></a>&nbsp;</td>
<?php
        echo '</form>' . "\n";
      } else {
?>
                <td align="center" class="smallText">&nbsp;<?php echo $options_values["items_options_id"]; ?>&nbsp;</td>
                <td class="smallText">&nbsp;<?php echo $options_values["items_options_name"]; ?>&nbsp;</td>
                <td align="center" class="smallText">&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=update_option&option_id=' . $options_values['items_options_id'] . '&option_order_by=' . $option_order_by . '&option_page=' . $option_page, 'NONSSL') . '">'; ?><?php echo go_picture_button('button_change.gif', PICTURE_UPDATE); ?></a>&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_item_option&option_id=' . $options_values['items_options_id'], 'NONSSL') , '">'; ?><?php echo go_picture_button('button_delete.gif', PICTURE_DELETE); ?></a>&nbsp;</td>
<?php
      }
?>
              </tr>
<?php
      $max_options_id_query = go_db_query("select max(items_options_id) + 1 as next_id from " . DB_TBL_ITEMS_OPTIONS);
      $max_options_id_values = go_db_fetch_array($max_options_id_query);
      $next_id = $max_options_id_values['next_id'];
    }
?>
              <tr>
                <td colspan="3"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    if ($action != 'update_option') {
?>
              <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
<?php
      echo '<form name="options" action="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=add_item_options&option_page=' . $option_page, 'NONSSL') . '" method="post"><input type="hidden" name="items_options_id" value="' . $next_id . '">';
      $inputs = '';
      for ($i = 0, $n = sizeof($languages); $i < $n; $i ++) {
        $inputs .= $languages[$i]['code'] . ':&nbsp;<input type="text" name="option_name[' . $languages[$i]['id'] . ']" size="20">&nbsp;<br>';
      }
?>
                <td align="center" class="smallText">&nbsp;<?php echo $next_id; ?>&nbsp;</td>
                <td class="smallText"><?php echo $inputs; ?></td>
                <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_insert.gif', PICTURE_INSERT); ?>&nbsp;</td>
<?php
      echo '</form>';
?>
              </tr>
              <tr>
                <td colspan="3"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    }
  }
?>
            </table></td>
<!-- options eof //-->
            <td valign="top" width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="2">
<!-- value //-->
<?php
  if ($action == 'delete_option_value') { 
    $values = go_db_query("select items_options_values_id, items_options_values_name from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . (int)$_GET['value_id'] . "' and language_id = '" . (int)$languages_id . "'");
    $values_values = go_db_fetch_array($values);
?>
              <tr>
                <td colspan="3" class="pageGeneralsign">&nbsp;<?php echo $values_values['items_options_values_name']; ?>&nbsp;</td>
                <td>&nbsp;<?php echo go_picture(FOLDER_RELATIV_PICTURES . 'tranparentes.gif', '', '1', '53'); ?>&nbsp;</td>
              </tr>
              <tr>
                <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
<?php
    $items = go_db_query("select p.items_id, pd.items_name, po.items_options_name from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_CHARACTERISTICS . " pa, " . DB_TBL_ITEMS_OPTIONS . " po, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.language_id = '" . (int)$languages_id . "' and po.language_id = '" . (int)$languages_id . "' and pa.items_id = p.items_id and pa.options_values_id='" . (int)$_GET['value_id'] . "' and po.items_options_id = pa.options_id order by pd.items_name");
    if (go_db_num_rows($items)) {
?>
                  <tr class="tbUPCountData">
                    <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_ID; ?>&nbsp;</td>
                    <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ITEM; ?>&nbsp;</td>
                    <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_NAME; ?>&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
<?php
      while ($items_values = go_db_fetch_array($items)) {
        $rows++;
?>
                  <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
                    <td align="center" class="smallText">&nbsp;<?php echo $items_values['items_id']; ?>&nbsp;</td>
                    <td class="smallText">&nbsp;<?php echo $items_values['items_name']; ?>&nbsp;</td>
                    <td class="smallText">&nbsp;<?php echo $items_values['items_options_name']; ?>&nbsp;</td>
                  </tr>
<?php
      }
?>
                  <tr>
                    <td colspan="3"><?php echo go_black_line(); ?></td>
                  </tr>
                  <tr>
                    <td class="main" colspan="3"><br><?php echo TEXT_WARNING_OF_DELETE; ?></td>
                  </tr>
                  <tr>
                    <td class="main" align="right" colspan="3"><br><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, (isset($_GET['value_page']) ? 'value_page=' . $_GET['value_page'] . '&' : '') . (isset($_GET['characteristic_page']) ? 'characteristic_page=' . $characteristic_page : ''), 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', ' cancel '); ?></a>&nbsp;</td>
                  </tr>
<?php
    } else {
?>
                  <tr>
                    <td class="main" colspan="3"><br><?php echo TEXT_OK_TO_DELETE; ?></td>
                  </tr>
                  <tr>
                    <td class="main" align="right" colspan="3"><br><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_value&value_id=' . $_GET['value_id'], 'NONSSL') . '">'; ?><?php echo go_picture_button('button_delete.gif', ' delete '); ?></a>&nbsp;&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, '&option_page=' . $option_page . (isset($_GET['value_page']) ? '&value_page=' . $value_page : '') . (isset($_GET['characteristic_page']) ? '&characteristic_page=' . $characteristic_page : ''), 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', ' cancel '); ?></a>&nbsp;</td>
                  </tr>
<?php
    }
?>
              	</table></td>
              </tr>
<?php
  } else {
?>
              <tr>
                <td colspan="3" class="pageGeneralsign">&nbsp;<?php echo ABOVE_TITLE_VAL; ?>&nbsp;</td>
                <td>&nbsp;<?php echo go_picture(FOLDER_RELATIV_PICTURES . 'tranparentes.gif', '', '1', '53'); ?>&nbsp;</td>
              </tr>
              <tr>
                <td colspan="4" class="smallText">
<?php
    $per_page = MAX_ROW_LISTS_OPTIONS;
    $values = "select pov.items_options_values_id, pov.items_options_values_name, pov2po.items_options_id from ((" . DB_TBL_ITEMS_OPTIONS_VALUES . " pov) left join " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " pov2po on pov.items_options_values_id = pov2po.items_options_values_id) where pov.language_id = '" . (int)$languages_id . "' order by pov.items_options_values_id";
    if (!isset($value_page)) {
      $value_page = 1;
    }
    $prev_value_page = $value_page - 1;
    $next_value_page = $value_page + 1;
    $value_query = go_db_query($values);
    $value_page_start = ($per_page * $value_page) - $per_page;
    $num_rows = go_db_num_rows($value_query);
    if ($num_rows <= $per_page) {
      $num_pages = 1;
    } else if (($num_rows % $per_page) == 0) {
      $num_pages = ($num_rows / $per_page);
    } else {
      $num_pages = ($num_rows / $per_page) + 1;
    }
    $num_pages = (int) $num_pages;
    $values = $values . " LIMIT $value_page_start, $per_page"; 
    if ($prev_value_page)  {
      echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'option_order_by=' . $option_order_by . '&value_page=' . $prev_value_page) . '"> &lt;&lt; </a> | ';
    }
    for ($i = 1; $i <= $num_pages; $i++) {
      if ($i != $value_page) {
         echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, (isset($option_order_by) ? 'option_order_by=' . $option_order_by . '&' : '') . 'value_page=' . $i) . '">' . $i . '</a> | ';
      } else {
         echo '<b><font color=red>' . $i . '</font></b> | ';
      }
    } 
    if ($value_page != $num_pages) {
      echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, (isset($option_order_by) ? 'option_order_by=' . $option_order_by . '&' : '') . 'value_page=' . $next_value_page) . '"> &gt;&gt;</a> ';
    }
?>
                </td>
              </tr>
              <tr>
                <td colspan="4"><?php echo go_black_line(); ?></td>
              </tr>
              <tr class="tbUPCountData">
                <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ID; ?>&nbsp;</td>
                <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_NAME; ?>&nbsp;</td>
                <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_VALUE; ?>&nbsp;</td>
                <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
              </tr>
              <tr>
                <td colspan="4"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    $next_id = 1;
    $rows = 0;
    $values = go_db_query($values);
    while ($values_values = go_db_fetch_array($values)) {
      $options_name = go_options_name($values_values['items_options_id']);
      $values_name = $values_values['items_options_values_name'];
      $rows++;
?>
              <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
<?php
      if (($action == 'update_option_value') && ($_GET['value_id'] == $values_values['items_options_values_id'])) {
        echo '<form name="values" action="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=update_value', 'NONSSL') . '" method="post">';
        $inputs = '';
        for ($i = 0, $n = sizeof($languages); $i < $n; $i ++) {
          $value_name = go_db_query("select items_options_values_name from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . (int)$values_values['items_options_values_id'] . "' and language_id = '" . (int)$languages[$i]['id'] . "'");
          $value_name = go_db_fetch_array($value_name);
          $inputs .= $languages[$i]['code'] . ':&nbsp;<input type="text" name="value_name[' . $languages[$i]['id'] . ']" size="15" value="' . $value_name['items_options_values_name'] . '">&nbsp;<br>';
        }
?>
                <td align="center" class="smallText">&nbsp;<?php echo $values_values['items_options_values_id']; ?><input type="hidden" name="value_id" value="<?php echo $values_values['items_options_values_id']; ?>">&nbsp;</td>
                <td align="center" class="smallText">&nbsp;<?php echo "\n"; ?><select name="option_id">
<?php
        $options = go_db_query("select items_options_id, items_options_name from " . DB_TBL_ITEMS_OPTIONS . " where language_id = '" . (int)$languages_id . "' order by items_options_name");
        while ($options_values = go_db_fetch_array($options)) {
          echo "\n" . '<option name="' . $options_values['items_options_name'] . '" value="' . $options_values['items_options_id'] . '"';
          if ($values_values['items_options_id'] == $options_values['items_options_id']) { 
            echo ' selected';
          }
          echo '>' . $options_values['items_options_name'] . '</option>';
        } 
?>
                </select>&nbsp;</td>
                <td class="smallText"><?php echo $inputs; ?></td>
                <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?>&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, '', 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', PICTURE_CANCEL); ?></a>&nbsp;</td>
<?php
        echo '</form>';
      } else {
?>
                <td align="center" class="smallText">&nbsp;<?php echo $values_values["items_options_values_id"]; ?>&nbsp;</td>
                <td align="center" class="smallText">&nbsp;<?php echo $options_name; ?>&nbsp;</td>
                <td class="smallText">&nbsp;<?php echo $values_name; ?>&nbsp;</td>
                <td align="center" class="smallText">&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=update_option_value&value_id=' . $values_values['items_options_values_id'] . (isset($_GET['value_page']) ? '&value_page=' . $_GET['value_page'] : ''), 'NONSSL') . '">'; ?><?php echo go_picture_button('button_change.gif', PICTURE_UPDATE); ?></a>&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_option_value&value_id=' . $values_values['items_options_values_id'], 'NONSSL') , '">'; ?><?php echo go_picture_button('button_delete.gif', PICTURE_DELETE); ?></a>&nbsp;</td>
<?php
      }
      $max_values_id_query = go_db_query("select max(items_options_values_id) + 1 as next_id from " . DB_TBL_ITEMS_OPTIONS_VALUES);
      $max_values_id_values = go_db_fetch_array($max_values_id_query);
      $next_id = $max_values_id_values['next_id'];
    }
?>
              </tr>
              <tr>
                <td colspan="4"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    if ($action != 'update_option_value') {
?>
              <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
<?php
      echo '<form name="values" action="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=add_item_option_values&value_page=' . $value_page, 'NONSSL') . '" method="post">';
?>
                <td align="center" class="smallText">&nbsp;<?php echo $next_id; ?>&nbsp;</td>
                <td align="center" class="smallText">&nbsp;<select name="option_id">
<?php
      $options = go_db_query("select items_options_id, items_options_name from " . DB_TBL_ITEMS_OPTIONS . " where language_id = '" . $languages_id . "' order by items_options_name");
      while ($options_values = go_db_fetch_array($options)) {
        echo '<option name="' . $options_values['items_options_name'] . '" value="' . $options_values['items_options_id'] . '">' . $options_values['items_options_name'] . '</option>';
      }
      $inputs = '';
      for ($i = 0, $n = sizeof($languages); $i < $n; $i ++) {
        $inputs .= $languages[$i]['code'] . ':&nbsp;<input type="text" name="value_name[' . $languages[$i]['id'] . ']" size="15">&nbsp;<br>';
      }
?>
                </select>&nbsp;</td>
                <td class="smallText"><input type="hidden" name="value_id" value="<?php echo $next_id; ?>"><?php echo $inputs; ?></td>
                <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_insert.gif', PICTURE_INSERT); ?>&nbsp;</td>
<?php
      echo '</form>';
?>
              </tr>
              <tr>
                <td colspan="4"><?php echo go_black_line(); ?></td>
              </tr>
<?php
    }
  }
?>
            </table></td>
          </tr>
        </table></td>
<!-- option value eof //-->
      </tr> 
<!-- items_characteristics //-->  
      <tr>
        <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageGeneralsign">&nbsp;<?php echo ABOVE_TITLE_ATRIB; ?>&nbsp;</td>
            <td>&nbsp;<?php echo go_picture(FOLDER_RELATIV_PICTURES . 'tranparentes.gif', '', '1', '53'); ?>&nbsp;</td>
          </tr>
        </table></td>
      </tr>
      <tr>
<?php
  if ($action == 'update_characteristic') {
    $form_action = 'update_item_characteristic';
  } else {
    $form_action = 'add_item_characteristics';
  }
  if (!isset($characteristic_page)) {
    $characteristic_page = 1;
  }
  $prev_characteristic_page = $characteristic_page - 1;
  $next_characteristic_page = $characteristic_page + 1;
?>
        <td><form name="characteristics" action="<?php echo go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=' . $form_action . '&option_page=' . $option_page . '&value_page=' . $value_page . '&characteristic_page=' . $characteristic_page); ?>" method="post"><table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
            <td colspan="7" class="smallText">
<?php
  $per_page = MAX_ROW_LISTS_OPTIONS;
  $characteristics = "select pa.* from ((" . DB_TBL_ITEMS_CHARACTERISTICS . " pa) left join " . DB_TBL_ITEMS_DESCRIPTION . " pd on pa.items_id = pd.items_id and pd.language_id = '" . (int)$languages_id . "') order by pd.items_name";
  $characteristic_query = go_db_query($characteristics);
  $characteristic_page_start = ($per_page * $characteristic_page) - $per_page;
  $num_rows = go_db_num_rows($characteristic_query);
  if ($num_rows <= $per_page) {
     $num_pages = 1;
  } else if (($num_rows % $per_page) == 0) {
     $num_pages = ($num_rows / $per_page);
  } else {
     $num_pages = ($num_rows / $per_page) + 1;
  }
  $num_pages = (int) $num_pages;
  $characteristics = $characteristics . " LIMIT $characteristic_page_start, $per_page"; 
  if ($prev_characteristic_page) {
    echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'characteristic_page=' . $prev_characteristic_page) . '"> &lt;&lt; </a> | ';
  }
  for ($i = 1; $i <= $num_pages; $i++) {
    if ($i != $characteristic_page) {
      echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'characteristic_page=' . $i) . '">' . $i . '</a> | ';
    } else {
      echo '<b><font color="red">' . $i . '</font></b> | ';
    }
  } 
  if ($characteristic_page != $num_pages) {
    echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'characteristic_page=' . $next_characteristic_page) . '"> &gt;&gt; </a>';
  }
?>
            </td>
          </tr>
          <tr>
            <td colspan="7"><?php echo go_black_line(); ?></td>
          </tr>
          <tr class="tbUPCountData">
            <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ID; ?>&nbsp;</td>
            <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_ITEM; ?>&nbsp;</td>
            <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_NAME; ?>&nbsp;</td>
            <td class="tbUPDataInside">&nbsp;<?php echo DB_TBL_ABOVE_OPT_VALUE; ?>&nbsp;</td>
            <td class="tbUPDataInside" align="right">&nbsp;<?php echo DB_TBL_ABOVE_OPT_PRICE; ?>&nbsp;</td>
            <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_OPT_PRICE_PREFIX; ?>&nbsp;</td>
            <td class="tbUPDataInside" align="center">&nbsp;<?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
          </tr>
          <tr>
            <td colspan="7"><?php echo go_black_line(); ?></td>
          </tr>
<?php
  $next_id = 1;
  $characteristics = go_db_query($characteristics);
  while ($characteristics_values = go_db_fetch_array($characteristics)) {
    $items_name_only = go_get_values_from_items_description($characteristics_values['items_id'], '', 'items_name');
    $options_name = go_options_name($characteristics_values['options_id']);
    $values_name = go_values_name($characteristics_values['options_values_id']);
    $rows++;
?>
          <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
<?php
    if (($action == 'update_characteristic') && ($_GET['characteristic_id'] == $characteristics_values['items_characteristics_id'])) {
?>
            <td class="smallText">&nbsp;<?php echo $characteristics_values['items_characteristics_id']; ?><input type="hidden" name="characteristic_id" value="<?php echo $characteristics_values['items_characteristics_id']; ?>">&nbsp;</td>
            <td class="smallText">&nbsp;<select name="items_id">
<?php
      $items = go_db_query("select p.items_id, pd.items_name from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.language_id = '" . $languages_id . "' order by pd.items_name");
      while($items_values = go_db_fetch_array($items)) {
        if ($characteristics_values['items_id'] == $items_values['items_id']) {
          echo "\n" . '<option name="' . $items_values['items_name'] . '" value="' . $items_values['items_id'] . '" SELECTED>' . $items_values['items_name'] . '</option>';
        } else {
          echo "\n" . '<option name="' . $items_values['items_name'] . '" value="' . $items_values['items_id'] . '">' . $items_values['items_name'] . '</option>';
        }
      } 
?>
            </select>&nbsp;</td>
            <td class="smallText">&nbsp;<select name="options_id">
<?php
      $options = go_db_query("select * from " . DB_TBL_ITEMS_OPTIONS . " where language_id = '" . $languages_id . "' order by items_options_name");
      while($options_values = go_db_fetch_array($options)) {
        if ($characteristics_values['options_id'] == $options_values['items_options_id']) {
          echo "\n" . '<option name="' . $options_values['items_options_name'] . '" value="' . $options_values['items_options_id'] . '" SELECTED>' . $options_values['items_options_name'] . '</option>';
        } else {
          echo "\n" . '<option name="' . $options_values['items_options_name'] . '" value="' . $options_values['items_options_id'] . '">' . $options_values['items_options_name'] . '</option>';
        }
      } 
?>
            </select>&nbsp;</td>
            <td class="smallText">&nbsp;<select name="values_id">
<?php
      $values = go_db_query("select * from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where language_id ='" . $languages_id . "' order by items_options_values_name");
      while($values_values = go_db_fetch_array($values)) {
        if ($characteristics_values['options_values_id'] == $values_values['items_options_values_id']) {
          echo "\n" . '<option name="' . $values_values['items_options_values_name'] . '" value="' . $values_values['items_options_values_id'] . '" SELECTED>' . $values_values['items_options_values_name'] . '</option>';
        } else {
          echo "\n" . '<option name="' . $values_values['items_options_values_name'] . '" value="' . $values_values['items_options_values_id'] . '">' . $values_values['items_options_values_name'] . '</option>';
        }
      } 
?>        
            </select>&nbsp;</td>
            <td align="right" class="smallText">&nbsp;<input type="text" name="value_price" value="<?php echo $characteristics_values['options_values_price']; ?>" size="6">&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<input type="text" name="price_prefix" value="<?php echo $characteristics_values['price_prefix']; ?>" size="2">&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?>&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, '&characteristic_page=' . $characteristic_page, 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', PICTURE_CANCEL); ?></a>&nbsp;</td>
<?php
      if (DOWNLOAD_ENABLED == 'true') {
        $download_query_raw ="select items_characteristics_filename, items_characteristics_maxdays, items_characteristics_maxcount 
                              from " . DB_TBL_ITEMS_CHARACTERISTICS_DOWNLOAD . " 
                              where items_characteristics_id='" . $characteristics_values['items_characteristics_id'] . "'";
        $download_query = go_db_query($download_query_raw);
        if (go_db_num_rows($download_query) > 0) {
          $download = go_db_fetch_array($download_query);
          $items_characteristics_filename = $download['items_characteristics_filename'];
          $items_characteristics_maxdays  = $download['items_characteristics_maxdays'];
          $items_characteristics_maxcount = $download['items_characteristics_maxcount'];
        }
?>
          <tr class="<?php echo (!($rows % 2)? 'characteristics-even' : 'characteristics-odd');?>">
            <td>&nbsp;</td>
            <td colspan="5">
              <table>
                <tr class="<?php echo (!($rows % 2)? 'characteristics-even' : 'characteristics-odd');?>">
                  <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_DOWNLOAD; ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_FILENAME; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_filename', $items_characteristics_filename, 'size="15"'); ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_MAX_DAYS; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_maxdays', $items_characteristics_maxdays, 'size="5"'); ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_MAX_COUNT; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_maxcount', $items_characteristics_maxcount, 'size="5"'); ?>&nbsp;</td>
                </tr>
              </table>
            </td>
            <td>&nbsp;</td>
          </tr>
<?php
      }
?>
<?php
    } elseif (($action == 'delete_item_characteristic') && ($_GET['characteristic_id'] == $characteristics_values['items_characteristics_id'])) {
?>
            <td class="smallText">&nbsp;<b><?php echo $characteristics_values["items_characteristics_id"]; ?></b>&nbsp;</td>
            <td class="smallText">&nbsp;<b><?php echo $items_name_only; ?></b>&nbsp;</td>
            <td class="smallText">&nbsp;<b><?php echo $options_name; ?></b>&nbsp;</td>
            <td class="smallText">&nbsp;<b><?php echo $values_name; ?></b>&nbsp;</td>
            <td align="right" class="smallText">&nbsp;<b><?php echo $characteristics_values["options_values_price"]; ?></b>&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<b><?php echo $characteristics_values["price_prefix"]; ?></b>&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<b><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_characteristic&characteristic_id=' . $_GET['characteristic_id']) . '">'; ?><?php echo go_picture_button('button_confirm.gif', PICTURE_CONFIRM); ?></a>&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, '&option_page=' . $option_page . '&value_page=' . $value_page . '&characteristic_page=' . $characteristic_page, 'NONSSL') . '">'; ?><?php echo go_picture_button('button_cancel.gif', PICTURE_CANCEL); ?></a>&nbsp;</b></td>
<?php
    } else {
?>
            <td class="smallText">&nbsp;<?php echo $characteristics_values["items_characteristics_id"]; ?>&nbsp;</td>
            <td class="smallText">&nbsp;<?php echo $items_name_only; ?>&nbsp;</td>
            <td class="smallText">&nbsp;<?php echo $options_name; ?>&nbsp;</td>
            <td class="smallText">&nbsp;<?php echo $values_name; ?>&nbsp;</td>
            <td align="right" class="smallText">&nbsp;<?php echo $characteristics_values["options_values_price"]; ?>&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<?php echo $characteristics_values["price_prefix"]; ?>&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=update_characteristic&characteristic_id=' . $characteristics_values['items_characteristics_id'] . '&characteristic_page=' . $characteristic_page, 'NONSSL') . '">'; ?><?php echo go_picture_button('button_change.gif', PICTURE_UPDATE); ?></a>&nbsp;&nbsp;<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ITEMS_CHARACTERISTICS, 'action=delete_item_characteristic&characteristic_id=' . $characteristics_values['items_characteristics_id'] . '&characteristic_page=' . $characteristic_page, 'NONSSL') , '">'; ?><?php echo go_picture_button('button_delete.gif', PICTURE_DELETE); ?></a>&nbsp;</td>
<?php
    }
    $max_characteristics_id_query = go_db_query("select max(items_characteristics_id) + 1 as next_id from " . DB_TBL_ITEMS_CHARACTERISTICS);
    $max_characteristics_id_values = go_db_fetch_array($max_characteristics_id_query);
    $next_id = $max_characteristics_id_values['next_id'];
?>
          </tr>
<?php
  }
  if ($action != 'update_characteristic') {
?>
          <tr>
            <td colspan="7"><?php echo go_black_line(); ?></td>
          </tr>
          <tr class="<?php echo (floor($rows/2) == ($rows/2) ? 'characteristics-even' : 'characteristics-odd'); ?>">
            <td class="smallText">&nbsp;<?php echo $next_id; ?>&nbsp;</td>
      	    <td class="smallText">&nbsp;<select name="items_id">
<?php
    $items = go_db_query("select p.items_id, pd.items_name from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.language_id = '" . $languages_id . "' order by pd.items_name");
    while ($items_values = go_db_fetch_array($items)) {
      echo '<option name="' . $items_values['items_name'] . '" value="' . $items_values['items_id'] . '">' . $items_values['items_name'] . '</option>';
    } 
?>
            </select>&nbsp;</td>
            <td class="smallText">&nbsp;<select name="options_id">
<?php
    $options = go_db_query("select * from " . DB_TBL_ITEMS_OPTIONS . " where language_id = '" . $languages_id . "' order by items_options_name");
    while ($options_values = go_db_fetch_array($options)) {
      echo '<option name="' . $options_values['items_options_name'] . '" value="' . $options_values['items_options_id'] . '">' . $options_values['items_options_name'] . '</option>';
    } 
?>
            </select>&nbsp;</td>
            <td class="smallText">&nbsp;<select name="values_id">
<?php
    $values = go_db_query("select * from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where language_id = '" . $languages_id . "' order by items_options_values_name");
    while ($values_values = go_db_fetch_array($values)) {
      echo '<option name="' . $values_values['items_options_values_name'] . '" value="' . $values_values['items_options_values_id'] . '">' . $values_values['items_options_values_name'] . '</option>';
    } 
?>
            </select>&nbsp;</td>
            <td align="right" class="smallText">&nbsp;<input type="text" name="value_price" size="6">&nbsp;</td>
            <td align="right" class="smallText">&nbsp;<input type="text" name="price_prefix" size="2" value="+">&nbsp;</td>
            <td align="center" class="smallText">&nbsp;<?php echo go_picture_submit('button_insert.gif', PICTURE_INSERT); ?>&nbsp;</td>
          </tr>
<?php
      if (DOWNLOAD_ENABLED == 'true') {
        $items_characteristics_maxdays  = DOWNLOAD_MAX_DAYS;
        $items_characteristics_maxcount = DOWNLOAD_MAX_COUNT;
?>
          <tr class="<?php echo (!($rows % 2)? 'characteristics-even' : 'characteristics-odd');?>">
            <td>&nbsp;</td>
            <td colspan="5">
              <table>
                <tr class="<?php echo (!($rows % 2)? 'characteristics-even' : 'characteristics-odd');?>">
                  <td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_DOWNLOAD; ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_FILENAME; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_filename', $items_characteristics_filename, 'size="15"'); ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_MAX_DAYS; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_maxdays', $items_characteristics_maxdays, 'size="5"'); ?>&nbsp;</td>
                  <td class="smallText"><?php echo DB_TBL_TEXT_MAX_COUNT; ?></td>
                  <td class="smallText"><?php echo go_fetch_inputfeld('items_characteristics_maxcount', $items_characteristics_maxcount, 'size="5"'); ?>&nbsp;</td>
                </tr>
              </table>
            </td>
            <td>&nbsp;</td>
          </tr>
<?php
      } 
?>
<?php
  }
?>
          <tr>
            <td colspan="7"><?php echo go_black_line(); ?></td>
          </tr>
        </table></form></td>
      </tr>
    </table></td>
<!-- items_characteristics_eof //-->
  </tr>
</table>
<!-- body_text_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
