<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
require('load_this/load_bigware_11.php');
require(FOLDER_RELATIV_CLASSES . 'class_bigware_1.php');
$currencies = new currencies();
$orders_statuses = array();
$orders_status_array = array();
$orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "'");
while ($orders_status = go_db_fetch_array($orders_status_query)) {
	$orders_statuses[] = array('id' => $orders_status['orders_status_id'],
			'text' => $orders_status['orders_status_name']);
	$orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
}
$action = (isset($_GET['action']) ? $_GET['action'] : '');
if (go_not_null($action)) {
	switch ($action) {
		case 'update_order':
			$oID = go_db_producing_input($_GET['oID']);
			$status = go_db_producing_input($_POST['status']);
			$comments = go_db_producing_input($_POST['comments']);
			$order_updated = false;
			$check_status_query = go_db_query("select attendees_name, attendees_email_address, orders_status, date_purchased from " . DB_TBL_ORDERS . " where orders_id = '" . (int)$oID . "'");
			$check_status = go_db_fetch_array($check_status_query);
			if ( ($check_status['orders_status'] != $status) || go_not_null($comments)) {
				go_db_query("update " . DB_TBL_ORDERS . " set orders_status = '" . go_db_input($status) . "', last_modified = now() where orders_id = '" . (int)$oID . "'");
				$attendee_notified = '0';
				if (isset($_POST['notify']) && ($_POST['notify'] == 'on')) {
					$notify_comments = '';
					if (isset($_POST['notify_comments']) && ($_POST['notify_comments'] == 'on')) {
						$notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments) . "\n\n";
					}
					$email = SHOP_NAME . "\n" . EMAIL_SEPARATOR . "\n" . EMAIL_TEXT_ORDER_NUMBER . ' ' . $oID . "\n" . EMAIL_TEXT_INVOICE_URL . ' ' . go_catalog_href_link(NAME_OF_FILE_CATALOG_MEMBER_HISTORY_INFO, 'order_id=' . $oID, 'SSL') . "\n" . EMAIL_TEXT_DATE_ORDERED . ' ' . go_date_long($check_status['date_purchased']) . "\n\n" . $notify_comments . sprintf(EMAIL_TEXT_STATUS_UPDATE, $orders_status_array[$status]);
					go_mail($check_status['attendees_name'], $check_status['attendees_email_address'], EMAIL_TEXT_SUBJECT, $email, SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS);
					$attendee_notified = '1';
				}
				go_db_query("insert into " . DB_TBL_ORDERS_STATUS_HISTORY . " (orders_id, orders_status_id, date_added, attendee_notified, comments) values ('" . (int)$oID . "', '" . go_db_input($status) . "', now(), '" . go_db_input($attendee_notified) . "', '" . go_db_input($comments)  . "')");
				$order_updated = true;
			}
			if ($order_updated == true) {
				$messageStack->add_session(SUCCESS_ORDER_UPDATED, 'success');
			} else {
				$messageStack->add_session(WARNING_ORDER_NOT_UPDATED, 'warning');
			}
			//go_forward(go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action')) . 'action=change'));
			go_forward(go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))));
			break;
		case 'deleteconfirm':
			$oID = go_db_producing_input($_GET['oID']);
			go_remove_order($oID, $_POST['restock']); 
			go_forward(go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action'))));
			break;
		case 'update_currency_confirm':
			$oID = go_db_producing_input($_GET['oID']);
			$update_currency = go_db_producing_input($_POST['update_currency']);
			$update_currency_value=$currencies->get_value(go_db_input($update_currency));
			go_db_query("update " . DB_TBL_ORDERS . " set currency='".$update_currency."',currency_value=".$update_currency_value." where orders_id='" . (int)$oID . "'");

			$query_orders = go_db_query("select * from " . DB_TBL_ORDERS_TOTAL . " where orders_id='" . (int)$oID . "'");
			$orders_num = go_db_num_rows($query_orders);

			for ($i=0; $i<$orders_num; $i++){
				$text[$i] = go_db_result($query_orders, $i, "text");
				$value[$i] = go_db_result($query_orders, $i, "value");
				$class[$i] = go_db_result($query_orders, $i, "class");
				$value[$i] = $value[$i]*$update_currency_value;
				$text[$i] = $update_currency." ".number_format($value[$i], 2, '.', ',');
				go_db_query("update ". DB_TBL_ORDERS_TOTAL ." set text='".$text[$i]."', value=".$value[$i]." where class='".$class[$i]."' and orders_id='" . (int)$oID . "'");
			}		
			break;	        
	}
}
if (($action == 'change') && isset($_GET['oID'])) {
	$oID = go_db_producing_input($_GET['oID']);
	$orders_query = go_db_query("select orders_id from " . DB_TBL_ORDERS . " where orders_id = '" . (int)$oID . "'");
	$order_exists = true;
	if (!go_db_num_rows($orders_query)) {
		$order_exists = false;
		$messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
	}
}
include(FOLDER_RELATIV_CLASSES . 'class_bigware_9.php');
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<!-- B2B start -->
<style type="text/css">
<!--
tableDataColor  {background-color: <?php echo $color; ?>; }
//-->
</style>
<!-- B2B end -->
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="load_this/general.js"></script>

<!-- Modul -->
<?php
if (file_exists('modules/order_static/javascript/static.js')) {
	?>
		<script language="javascript" src="modules/order_static/javascript/static.js"></script>
		<?php
}
if (file_exists('modules/order_static/link.php')) {
	require('modules/order_static/link.php');
}
?>
<!-- Modul ENDE -->
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php
require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php');
?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
<tr>
<td width="<?php echo FRAME_WIDTH; ?>" valign="top">
</td>
<!-- body_text //-->
<td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
<?php
require(FOLDER_RELATIV_INCLUDES . 'load_bigware_5.php');
require(FOLDER_RELATIV_INCLUDES . 'load_bigware_3.php');
//require(FOLDER_RELATIV_INCLUDES . 'load_bigware_2.php');
if (($action == 'change') && ($order_exists == true)) {
	$order = new order($oID);
	?>
		<tr>
		<td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
		<td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
		<td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
		<td class="pageGeneralsign" align="right">
		<?php echo '<a href="' . go_href_link("main_bigware_17.php", go_get_all_get_parameter(array('action'))) . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> &nbsp; '; ?>
		<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>'; ?>
		</td>
		</tr>
		</table></td>
		</tr>
		<tr>
		<td>


		<table width="100%" border="0" cellspacing="0" cellpadding="2">
		<tr class="tbUPCountData">
		<td class="tbUPDataInside" colspan="3"><?php echo ABOVE_COSTUMERS_ADRESS; ?></td>
		</tr>
		<tr class="tbCountData">
		<td class="TbInsideData" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main" valign="top"><b><?php echo TYPE_IN_ATTENDEE; ?></b></td>
		<td class="main"><?php echo go_form_of_address($order->attendee['format_id'], $order->attendee, 1, '', '<br>'); ?></td>
		</tr>
		<tr>
		<td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '5'); ?></td>
		</tr>
		<!-- B2B start -->
		<!--PIVACF start-->
		<tr>
		<td class="main"><b><?php echo TYPE_IN_PIVA; ?></b></td>
		<td class="main"><?php echo $order->billing['piva']; ?></td>
		</tr>
		<tr>
		<td class="main"><b><?php echo TYPE_IN_CF; ?></b></td>
		<td class="main"><?php echo $order->billing['cf']; ?></td>
		</tr>                                            
		<!--PIVACF end-->
		<!-- B2B end -->
		<tr>
		<td class="main"><b><?php echo TYPE_IN_TELEPHONE_NUMBER; ?></b></td>
		<td class="main"><?php echo $order->attendee['telephone']; ?></td>
		</tr>
		<tr>
		<td class="main"><b><?php echo TYPE_IN_EMAIL_ADDRESS; ?></b></td>
		<td class="main"><?php echo '<a href="mailto:' . $order->attendee['email_address'] . '"><u>' . $order->attendee['email_address'] . '</u></a>'; ?></td>
		</tr>
		<tr>
		<td class="main"><b><?php echo COSTUMER_NUMBER; ?></b></td>
		<td class="main"><?php echo $order->attendee['id']; ?></td>
		</tr>
		</table></td>
		<td class="TbInsideData" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main" valign="top"><b><?php echo TYPE_IN_SHIPPING_ADDRESS; ?></b></td>
		<td class="main"><?php echo go_form_of_address($order->delivery['format_id'], $order->delivery, 1, '', '<br>'); ?></td>
		</tr>
		</table></td>
		<td class="TbInsideData" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main" valign="top"><b><?php echo TYPE_IN_BILLING_ADDRESS; ?></b></td>
		<td class="main"><?php echo go_form_of_address($order->billing['format_id'], $order->billing, 1, '', '<br>'); ?></td>
		</tr>
		</table></td>
		</tr>
		</table></td>
		</tr>
		<tr>
		<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		</tr>
		<tr class="tbUPCountData">
		<td class="tbUPDataInside" colspan="3"><?php echo PAYMENTMETHODE; ?> / <?php echo SHIPPINGMETHODE; ?></td>
		</tr>
		<tr class="tbCountData">
		<td class="TbInsideData">


		<table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" width="100%" id="AutoNumber1">
		<tr>
		<td>


		<table border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main"><b><?php echo TYPE_IN_PAYMENT_METHOD; ?></b></td>
		<td class="main"><?php echo $order->info['payment_method']; ?></td>
		</tr>
		<?php
			if ($order->info['payment_method'] == 'PayPal' && !empty($order->info['cc_number'])) {
				echo '<tr><td class="main"><b>PayPal TX:</b></td><td class="main">'.$order->info['cc_number'].'</td></tr>';
			}
		?>
		</tr>
		<?php
		if (go_not_null($order->info['cc_type']) || go_not_null($order->info['cc_owner']) || go_not_null($order->info['cc_code'])) {
			?>
				<tr>
				<td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
				</tr>
				<tr>
				<td class="main"><?php echo TYPE_IN_CRCHANGE_CARD_TYPE; ?></td>
				<td class="main"><?php echo $order->info['cc_type']; ?></td>
				</tr>
				<tr>
				<td class="main"><?php echo TYPE_IN_CRCHANGE_CARD_OWNER; ?></td>
				<td class="main"><?php echo $order->info['cc_owner']; ?></td>
				</tr>
				<tr>
				<td class="main"><?php echo TYPE_IN_CRCHANGE_CARD_NUMBER; ?></td>
				<td class="main"><?php echo $order->info['cc_number']; ?></td>
				</tr>
				<tr>
				<td class="main"><?php echo TYPE_IN_CRCHANGE_CARD_CODE; ?></td>
				<td class="main"><?php echo $order->info['cc_code']; ?></td>
				</tr>
				<tr>
				<td class="main"><?php echo TYPE_IN_CRCHANGE_CARD_EXPIRES; ?></td>
				<td class="main"><?php echo $order->info['cc_expires']; ?></td>
				</tr>
				<?php
		} 
	$banktransfer_query = go_db_query("select banktransfer_prz, banktransfer_status, banktransfer_owner, banktransfer_number, banktransfer_bankname, banktransfer_blz, banktransfer_fax from banktransfer where orders_id = '" . go_db_input($_GET['oID']) . "'");
	$banktransfer = go_db_fetch_array($banktransfer_query);
	if (($banktransfer['banktransfer_bankname']) || ($banktransfer['banktransfer_blz']) || ($banktransfer['banktransfer_number'])) {
		?>
			<tr>
			<td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_NAME; ?></td>
			<td class="main"><?php echo $banktransfer['banktransfer_bankname']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_BLZ; ?></td>
			<td class="main"><?php echo $banktransfer['banktransfer_blz']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_NUMBER; ?></td>
			<td class="main"><?php echo $banktransfer['banktransfer_number']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_OWNER; ?></td>
			<td class="main"><?php echo $banktransfer['banktransfer_owner']; ?></td>
			</tr>
			<?php
			if ($banktransfer['banktransfer_status'] == 0) {
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_STATUS; ?></td>
					<td class="main"><?php echo "OK"; ?></td>
					</tr>
					<?php
			} else {
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_STATUS; ?></td>
					<td class="main"><?php echo $banktransfer['banktransfer_status']; ?></td>
					</tr>
					<?php
					switch ($banktransfer['banktransfer_status']) {
						case 1: $error_val = TEXT_BANK_ERROR_1; break;
						case 2: $error_val = TEXT_BANK_ERROR_2; break;
						case 3: $error_val = TEXT_BANK_ERROR_3; break;
						case 4: $error_val = TEXT_BANK_ERROR_4; break;
						case 5: $error_val = TEXT_BANK_ERROR_5; break;
						case 8: $error_val = TEXT_BANK_ERROR_8; break;
						case 9: $error_val = TEXT_BANK_ERROR_9; break;
					}
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_ERRORCODE; ?></td>
					<td class="main"><?php echo $error_val; ?></td>
					</tr>
					<tr>
					<td class="main"><?php echo TEXT_BANK_PRZ; ?></td>
					<td class="main"><?php echo $banktransfer['banktransfer_prz']; ?></td>
					</tr>
					<?php
			}
	}
	if ($banktransfer['banktransfer_fax']) {
		?>
			<tr>
			<td class="main"><?php echo TEXT_BANK_FAX; ?></td>
			<td class="main"><?php echo $banktransfer['banktransfer_fax']; ?></td>
			</tr>
			<?php
	} 
	$banktransfer_sepa_query = go_db_query("select banktransfer_sepa_status, banktransfer_sepa_owner, banktransfer_sepa_iban, banktransfer_sepa_bankname, banktransfer_sepa_bic, banktransfer_sepa_fax from banktransfer_sepa where orders_id = '" . go_db_input($_GET['oID']) . "'");
	$banktransfer_sepa = go_db_fetch_array($banktransfer_sepa_query);
	if (($banktransfer_sepa['banktransfer_sepa_bankname']) || ($banktransfer_sepa['banktransfer_sepa_iban']) || ($banktransfer_sepa['banktransfer_sepa_bic'])) {
		?>
			<tr>
			<td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_SEPA_NAME; ?></td>
			<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_bankname']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_SEPA_IBAN; ?></td>
			<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_iban']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_SEPA_BIC; ?></td>
			<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_bic']; ?></td>
			</tr>
			<tr>
			<td class="main"><?php echo TEXT_BANK_SEPA_OWNER; ?></td>
			<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_owner']; ?></td>
			</tr>
			<?php
			if ($banktransfer_sepa['banktransfer_sepa_status'] == 0) {
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_SEPA_STATUS; ?></td>
					<td class="main"><?php echo "OK"; ?></td>
					</tr>
					<?php
			} else {
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_SEPA_STATUS; ?></td>
					<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_status']; ?></td>
					</tr>
					<?php
					switch ($banktransfer_sepa['banktransfer_sepa_status']) {
						case 1: $error_val = TEXT_BANK_SEPA_ERROR_1; break;
						case 2: $error_val = TEXT_BANK_SEPA_ERROR_2; break;
						case 3: $error_val = TEXT_BANK_SEPA_ERROR_3; break;
						case 4: $error_val = TEXT_BANK_SEPA_ERROR_4; break;
						case 5: $error_val = TEXT_BANK_SEPA_ERROR_5; break;
						case 8: $error_val = TEXT_BANK_SEPA_ERROR_8; break;
						case 9: $error_val = TEXT_BANK_SEPA_ERROR_9; break;
					}
				?>
					<tr>
					<td class="main"><?php echo TEXT_BANK_SEPA_ERRORCODE; ?></td>
					<td class="main"><?php echo $error_val; ?></td>
					</tr>
					<?php
			}
	}
	if ($banktransfer_sepa['banktransfer_sepa_fax']) {
		?>
			<tr>
			<td class="main"><?php echo TEXT_BANK_SEPA_FAX; ?></td>
			<td class="main"><?php echo $banktransfer_sepa['banktransfer_sepa_fax']; ?></td>
			</tr>
			<?php
	} 

	?>
		</table>


		</td>
		<td>        


		<table border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main"><b><?php echo TYPE_IN_SHIPPING_METHOD; ?></b></td>
		<td class="main"><?php echo $order->info['shipping_method']; ?></td>
		</tr>
		</table>




		</td>
		</tr>
		</table>        


		</td>
		</tr>
		<tr>
		<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		</tr>
		<tr>
		<td><table border="0" width="100%" cellspacing="0" cellpadding="2">
		<tr class="tbUPCountData">
		<td class="tbUPDataInside" colspan="2"><?php echo DB_TBL_ABOVE_ITEMS; ?></td>
		<td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_ITEMS_MODEL; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_TAX; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_PRICE_EXCLUDING_TAX; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_PRICE_INCLUDING_TAX; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_TOTAL_EXCLUDING_TAX; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_TOTAL_INCLUDING_TAX; ?></td>
		</tr>
		<?php
		for ($i=0, $n=sizeof($order->items); $i<$n; $i++) {
			$getImMeterQuery=go_db_query("select immeter, inmeter_breite from price_option where id=".$order->items[$i]['items_price_option']);
			if (go_db_num_rows($getImMeterQuery)!=0) {
				$getImMeter = go_db_result($getImMeterQuery,0,'immeter');
				$getInMeter_breite = go_db_result($getImMeterQuery,0,'inmeter_breite');
			}
			else {
				$getImMeter=1000;
				$getInMeter_breite=1000;
			}


			echo '          <tr class="tbCountData">' . "\n" .
				'            <td class="TbInsideData" valign="top" align="right">'.$order->items[$i]['qty'] . '&nbsp;x</td>' . "\n" .
				'            <td class="TbInsideData" valign="top">' . $order->items[$i]['name'];


			$produktpreis = $order->items[$i]['price'];

			if (isset($order->items[$i]['characteristics']) && (sizeof($order->items[$i]['characteristics']) > 0)) { 
				for ($j = 0, $k = sizeof($order->items[$i]['characteristics']); $j < $k; $j++) {

					if (!isset($order->items[$i]['characteristics'][$j]['value'])){
						$item_characteristics_keys = array_keys($order->items[$i]['characteristics'][$j]);
						for ($a=0;$a<sizeof($item_characteristics_keys);$a++){
							if ($order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['value']!=""){	
								echo '<br><nobr><small>&nbsp;<i> - ' . $order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['option'] . ': ' . $order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['value'];
								if ($order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['price'] != '0') echo ' (' . $order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['prefix'] . $currencies->format($order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['price'] * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . ')';
										$produktpreis = $produktpreis+$order->items[$i]['characteristics'][$j][$item_characteristics_keys[$a]]['price'];
										echo '</i></small></nobr>';
										}//if
										}//for a
										}
										else {
										if ($order->items[$i]['characteristics'][$j]['value']!=""){	
										echo '<br><nobr><small>&nbsp;<i> - ' . $order->items[$i]['characteristics'][$j]['option'] . ': ' . $order->items[$i]['characteristics'][$j]['value'];
										if ($order->items[$i]['characteristics'][$j]['price'] != '0') echo ' (' . $order->items[$i]['characteristics'][$j]['prefix'] . $currencies->format($order->items[$i]['characteristics'][$j]['price'] * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . ')';
											$produktpreis = $produktpreis+$order->items[$i]['characteristics'][$j]['price'];
											echo '</i></small></nobr>';
											}//if
											}




											}//for j
											}



											if ($order->items[$i]['items_price_option']!=0) {


											if ($order->items[$i]['items_price_option']==1){$price_option_name="qm";}
											elseif ($order->items[$i]['items_price_option']==2){$price_option_name="qmm";}
											elseif ($order->items[$i]['items_price_option']==3){$price_option_name="lfdm";}
											elseif ($order->items[$i]['items_price_option']==4){$price_option_name="U lfdm";}


											if ($order->items[$i]['items_price_option'] == 4){
												$quadratur_display = (($order->items[$i]['laenge']*2/$getImMeter)+($order->items[$i]['breite']*2/$getInMeter_breite));	
											} 
											else {
												$quadratur_display = (($order->items[$i]['laenge']/$getImMeter)*($order->items[$i]['breite']/$getInMeter_breite));
											}

											if ($order->items[$i]['items_basis_price'] > 0) {
												$basis_price = ' + ' . $order->items[$i]['qty'] . ' x ' .$currencies->format(go_add_tax($order->items[$i]['items_basis_price'], $order->items[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']). ' ' . TEXT_INK_TAX;
											} else {
												$basis_price = '';
											}


											$displayDim = '<br><nobr><small>&nbsp;<i> - ' . $order->items[$i]['qty'] . ' x ' . $quadratur_display . ' ' . $price_option_name . ' x ' . $currencies->format(go_add_tax($produktpreis, $order->items[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . ' ' . TEXT_INK_TAX . $basis_price.'</i></small></nobr><br><nobr><small>&nbsp;<i> - ' . TEXT_MESS . ' ' . $order->items[$i]['laenge'] .' mm x '.$order->items[$i]['breite']. ' mm</i></small></nobr><br><nobr><small>&nbsp;<i> -' . $order->items[$i]['items_price_option_comment'] . '</i></small></nobr>';
											echo $displayDim;
											}else{ 
												echo '<small>' . $order->items[$i]['items_display_opt_price'] . '</small>';
											}
											if ($order->items[$i]['items_price_option'] == 4){
												echo '            </td>' . "\n" .
													'            <td class="TbInsideData" valign="top">' . $order->items[$i]['model'] . '</td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top">' . go_display_tax_value($order->items[$i]['tax']) . '%</td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format($order->items[$i]['final_price'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format(go_add_tax($order->items[$i]['final_price'], $order->items[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format($order->items[$i]['final_price'] * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format(go_add_tax($order->items[$i]['final_price'], $order->items[$i]['tax']) * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</b>&nbsp;</td>' . "\n";
												echo '          </tr>' . "\n";        
											} 
											else {
												echo '            </td>' . "\n" .
													'            <td class="TbInsideData" valign="top">' . $order->items[$i]['model'] . '</td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top">' . go_display_tax_value($order->items[$i]['tax']) . '%</td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format($order->items[$i]['final_price'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format(go_add_tax($order->items[$i]['final_price'], $order->items[$i]['tax']), true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format($order->items[$i]['final_price'] * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</b></td>' . "\n" .
													'            <td class="TbInsideData" align="right" valign="top"><b>' . $currencies->format(go_add_tax($order->items[$i]['final_price'], $order->items[$i]['tax']) * $order->items[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</b>&nbsp;</td>' . "\n";
												echo '          </tr>' . "\n";        
											}
		}
	?>
		<tr>
		<td align="right" colspan="8"><table class="tbCountData" border="0" cellspacing="0" cellpadding="2">
		<?php
		for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
			echo '              <tr class="TbInsideData">' . "\n" .
				'                <td align="right" class="smallText">' . $order->totals[$i]['title'] . '</td>' . "\n" .
				'                <td align="right" class="smallText">' . $order->totals[$i]['text'] . '</td>' . "\n" .
				'              </tr>' . "\n";
		}
	?>
		</table></td>
		</tr>
		</table></td>
		</tr>
		<tr>
		<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		</tr>
		<tr>
		<td class="main"><table border="1" cellspacing="0" cellpadding="5">
		<tr class="tbUPCountData">
		<td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_DATE_ADDED; ?></b></td>
		<td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_ATTENDEE_NOTIFIED; ?></b></td>
		<td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_STATUS; ?></b></td>
		<td class="tbUPDataInside" align="center"><b><?php echo DB_TBL_ABOVE_COMMENTS; ?></b></td>
		</tr>
		<?php
		$orders_history_query = go_db_query("select orders_status_id, date_added, attendee_notified, comments from " . DB_TBL_ORDERS_STATUS_HISTORY . " where orders_id = '" . go_db_input($oID) . "' order by date_added");
	if (go_db_num_rows($orders_history_query)) {
		while ($orders_history = go_db_fetch_array($orders_history_query)) {
			echo '          <tr class="tbCountData">' . "\n" .
				'            <td class="TbInsideData" align="center">' . go_datetime_short($orders_history['date_added']) . '</td>' . "\n" .
				'            <td class="TbInsideData" align="center">';
			if ($orders_history['attendee_notified'] == '1') {
				echo go_picture(FOLDER_RELATIV_ICONS . 'tick.gif', ICON_TICK) . "</td>\n";
			} else {
				echo go_picture(FOLDER_RELATIV_ICONS . 'cross.gif', ICON_CROSS) . "</td>\n";
			}
			echo '            <td class="TbInsideData">' . $orders_status_array[$orders_history['orders_status_id']] . '</td>' . "\n" .
				'            <td class="TbInsideData">' . nl2br(str_replace("\\r\\n", "\r\n", go_db_output($orders_history['comments']))) . '&nbsp;</td>' . "\n" .
				'          </tr>' . "\n";
		}
	} else {
		echo '          <tr>' . "\n" .
			'            <td class="TbInsideData" colspan="5">' . TEXT_NO_ORDER_HISTORY . '</td>' . "\n" .
			'          </tr>' . "\n";
	}
	?>
		</table></td>
		</tr>
		<tr>
		<td class="main"><br><b><?php echo DB_TBL_ABOVE_COMMENTS; ?></b></td>
		</tr>
		<tr>
		<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '5'); ?></td>
		</tr>
		<tr><?php echo go_fetch_form('status', NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action')) . 'action=update_order'); ?>
		<td class="main"><?php echo go_fetch_textarea_field('comments', 'soft', '60', '5'); ?></td>
		</tr>
		<tr>
		<td><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
		</tr>
		<tr>
		<td><table border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td><table border="0" cellspacing="0" cellpadding="2">
		<tr>
		<td class="main"><b><?php echo TYPE_IN_STATUS; ?></b> <?php echo go_fetch_pull_down_menu('status', $orders_statuses, $order->info['orders_status']); ?></td>
		</tr>
		<tr>
		<td class="main"><b><?php echo TYPE_IN_NOTIFY_ATTENDEE; ?></b> <?php echo go_fetch_checkbox_field('notify', '', false); ?></td>
		<td class="main"><b><?php echo TYPE_IN_NOTIFY_COMMENTS; ?></b> <?php echo go_fetch_checkbox_field('notify_comments', '', false); ?></td>
		</tr>
		</table></td>
		<td valign="top"><?php echo go_picture_submit('button_update.gif', PICTURE_UPDATE); ?></td>
		</tr>
		</table></td>
		</form></tr>
		<tr>
		<td colspan="2" align="right"><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS_INVOICE, 'oID=' . $_GET['oID']) . '" TARGET="_blank">' . go_picture_button('button_invoice.gif', PICTURE_ORDERS_INVOICE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ORDERS_PACKINGSLIP, 'oID=' . $_GET['oID']) . '" TARGET="_blank">' . go_picture_button('button_packingslip.gif', PICTURE_ORDERS_PACKINGSLIP) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('action'))) . '">' . go_picture_button('button_back.gif', PICTURE_BACK) . '</a>'; ?></td>
		</tr>
		<?php
} else {
	?>
		<tr>
		<td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
		<td class="pageGeneralsign"><?php echo ABOVE_TITLE; ?></td>
		<td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', 1, ABOVE_PICTURE_HEIGHT); ?></td>
		<td align="right"><table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr><?php echo go_fetch_form('orders', NAME_OF_FILE_ORDERS, '', 'get'); ?>
		<td class="smallText" align="right"><?php echo ABOVE_TITLE_SEARCH . ' ' . go_fetch_inputfeld('oID', '', 'size="12"') . go_fetch_hidden_field('action', 'change'); ?></td>
		</form></tr>
		<tr><?php echo go_fetch_form('status', NAME_OF_FILE_ORDERS, '', 'get'); ?>
		<!-- B2B start -->
		<td class="smallText" align="right"><?php echo ABOVE_TITLE_STATUS . ' ' . go_fetch_pull_down_menu('status', array_merge(array(array('id' => '0', 'text' => TEXT_ALL_ORDERS)), $orders_statuses), '', 'onChange="this.form.submit();"'); ?></td>
		</form></tr>
		<tr><?php echo go_fetch_form('grouped', NAME_OF_FILE_ORDERS, '', 'get'); ?>
		<td class="smallText" align="right">
		<?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS) . '">' . go_picture_button('button_reset.gif', PICTURE_RESET) . '</a>';?>
		<?php echo ABOVE_TITLE_STATUS . ' ' . go_fetch_pull_down_menu('attendees_group_id', array_merge((array)go_get_attendees_group(''. VISITOR_NAME .''), (array)$oInfo->attendees_group_id), '', 'onChange="this.form.submit();"'); ?></td>
		</form></tr>
		<!-- B2B end -->
		</table></td>
		</tr>
		</table></td>
		</tr>
		<tr>
		<td><table cellpadding="5" border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
		<td valign="top"><table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
		<tr class="tbUPCountData">
		<td class="tbUPDataInside"><?php echo DB_TBL_ABOVE_ATTENDEES; ?></td>
		<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ORDER_TOTAL; ?></td>
		<td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_DATE_PURCHASED; ?></td>
		<?php if ( WEIGHT_COUNT == 'true' ){ ?>
			<td class="tbUPDataInside" align="center"><?php echo TEXT_WEIGHT; ?></td>
				<?php } ?>
				<td class="tbUPDataInside" align="center"><?php echo DB_TBL_ABOVE_SHIPPING; ?></td>
				<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_STATUS; ?></td>
				<td class="tbUPDataInside" align="right"><?php echo DB_TBL_ABOVE_ACTION; ?>&nbsp;</td>
				</tr>
				<?php
				require('main_bigware_90.php'); 
	if (isset($_GET['bigID'])) {
		$bigID = go_db_producing_input($_GET['bigID']);
		$orders_query_raw = "select o.orders_id, o.attendees_name, o.attendees_company, o.attendees_id, o.attendees_group_id, o.payment_method, o.shipping_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from ((" . DB_TBL_ORDERS . " o) left join " . DB_TBL_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . DB_TBL_ORDERS_STATUS . " s) where o.attendees_id = '" . (int)$bigID . "' and o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and ot.class = 'ot_total' order by orders_id DESC";
	} elseif (isset($_GET['attendees_group_id'])) {
		$statusgr = go_db_producing_input($_GET['attendees_group_id']);
		$orders_query_raw = "select o.orders_id, o.attendees_name, o.attendees_group_id, o.attendees_company, o.payment_method, o.shipping_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from ((" . DB_TBL_ORDERS . " o) left join " . DB_TBL_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . DB_TBL_ORDERS_STATUS . " s) where o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and o.attendees_group_id = '" . (int)$attendees_group_id . "' and ot.class = 'ot_total' order by o.orders_id DESC";
	} elseif (isset($_GET['status'])) {
		$status = go_db_producing_input($_GET['status']);
		if ($status == "0") {
			$orders_query_raw = "select o.orders_id, o.attendees_name, o.attendees_group_id, o.attendees_company, o.payment_method, o.shipping_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from ((" . DB_TBL_ORDERS . " o) left join " . DB_TBL_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . DB_TBL_ORDERS_STATUS . " s) where o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and ot.class = 'ot_total' order by o.orders_id DESC";
		} else {
			$orders_query_raw = "select o.orders_id, o.attendees_name, o.attendees_group_id, o.attendees_company, o.payment_method, o.shipping_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from ((" . DB_TBL_ORDERS . " o) left join " . DB_TBL_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . DB_TBL_ORDERS_STATUS . " s) where o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and s.orders_status_id = '" . (int)$status . "' and ot.class = 'ot_total' order by o.orders_id DESC";
		}
	} else {
		$orders_query_raw = "select o.orders_id, o.attendees_name, o.attendees_group_id, o.attendees_company, o.payment_method, o.shipping_method, o.date_purchased, o.last_modified, o.currency, o.currency_value, s.orders_status_name, ot.text as order_total from ((" . DB_TBL_ORDERS . " o) left join " . DB_TBL_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id), " . DB_TBL_ORDERS_STATUS . " s) where o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and ot.class = 'ot_total' order by o.orders_id DESC";
	} 

	$orders_split = new splitPageResults($_GET['page'], MAX_SHOW_SEARCH_RESULTS, $orders_query_raw, $orders_query_numrows);
	$orders_query = go_db_query($orders_query_raw);
	while ($orders = go_db_fetch_array($orders_query)) {
		if ((!isset($_GET['oID']) || (isset($_GET['oID']) && ($_GET['oID'] == $orders['orders_id']))) && !isset($oInfo)) {
			$oInfo = new objectInfo($orders);
		}  
		if ($orders['attendees_group_id'] != 0){
			$color_query = go_db_query("select color_bar FROM ". DB_TBL_ATTENDEES_GROUPS ." where attendees_group_id = ". $orders['attendees_group_id'] ."");
			$color = go_db_fetch_array($color_query); 
		} 

		if (isset($oInfo) && is_object($oInfo) && ($orders['orders_id'] == $oInfo->orders_id)) {
			echo '              <tr id="defaultSelected" class="tbCountDataSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=change') . '\'">' . "\n"; 
		} elseif ($orders['attendees_group_id'] != 0) {
			echo '<tr bgcolor="'. $color['color_bar'] .'" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID')) . 'oID=' . $orders['orders_id']) . '\'">' . "\n"; 
		} else {
			echo '              <tr class="tbCountData" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="document.location.href=\'' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID')) . 'oID=' . $orders['orders_id']) . '\'">' . "\n";
		}
		?>
			<td class="TbInsideData"><?php echo $orders['attendees_name']; ?></td>
			<!-- B2B start -->
			<?php if ($orders['attendees_group_id'] != '0'){ ?>
				<!--td bgcolor="<?php echo $color['color_bar']; ?>" width="10">asd</td-->
					<?php } else { ?><!--td></td--><?php } ?>
					<!-- B2B end -->
					<td class="TbInsideData" align="right"><?php echo strip_tags($orders['order_total']); ?></td>
					<td class="TbInsideData" align="center"><?php echo go_datetime_short($orders['date_purchased']); ?></td>
					<?php if ( WEIGHT_COUNT == 'true' ){ ?>
						<td class="TbInsideData" align="center">
							<?php



							$weight_query = go_db_query("select pd.items_quantity, p.items_weight from " . DB_TBL_ITEMS . " p, " . DB_TBL_ORDERS_ITEMS . " pd, " . DB_TBL_ORDERS . " po where pd.orders_id = po.orders_id and p.items_id = pd.items_id and pd.orders_id = '" . $orders['orders_id'] . "' and po.orders_id = '" . $orders['orders_id'] . "'"); 
						$count_weight = 0;
						while ($weight_result = go_db_fetch_array($weight_query)) {  
							$count_weight += $weight_result['items_quantity']*$weight_result['items_weight'];
						}
						if ( $count_weight == 0 ){
							echo '-';
						}
						else{
							echo round ($count_weight,2);  
						}   	
						?>
							</td>
							<?php } ?>
							<td class="TbInsideData" align="right"><?php echo $orders['shipping_method']; ?></td>
							<td class="TbInsideData" align="right"><?php echo $orders['orders_status_name']; ?></td>
							<td class="TbInsideData" align="right" nowrap><?php echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $orders['orders_id'] . '&action=import') . '">' . go_picture(FOLDER_RELATIV_ICONS . 'ab.gif', 'Afterbuyimport') . '</a>&nbsp;' . '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $orders['orders_id'] . '&action=change') . '">' . go_picture(FOLDER_RELATIV_ICONS . 'preview.gif', ICON_PREVIEW) . '</a>'; ?> <?php if (isset($oInfo) && is_object($oInfo) && ($orders['orders_id'] == $oInfo->orders_id)) { echo go_picture(FOLDER_RELATIV_PICTURES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID')) . 'oID=' . $orders['orders_id']) . '">' . go_picture(FOLDER_RELATIV_PICTURES . 'icon_info.gif', PICTURE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
							</tr>
							<?php
	}
	?>
		<tr>
		<td colspan="6"><table border="0" width="100%" cellspacing="0" cellpadding="2">
		<tr>
		<td class="smallText" valign="top"><?php echo $orders_split->display_count($orders_query_numrows, MAX_SHOW_SEARCH_RESULTS, $_GET['page'], TEXT_SHOW_NUMBER_OF_ORDERS); ?></td>
		<td class="smallText" align="right"><?php echo $orders_split->display_links($orders_query_numrows, MAX_SHOW_SEARCH_RESULTS, MAX_SHOW_PAGE_LINKS, $_GET['page'], go_get_all_get_parameter(array('page', 'oID', 'action'))); ?></td>
		</tr>
		</table></td>
		</tr>
		</table></td>
		<?php
		$heading = array();
	$contents = array();
	switch ($action) {
		case 'delete':
			$heading[] = array('text' => '<b>' . TEXT_INFO_ABOVE_DELETE_ORDER . '</b>');
			$contents = array('form' => go_fetch_form('orders', NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=deleteconfirm'));
			$contents[] = array('text' => TEXT_INFO_DELETE_INTRO . '<br><br><b>' . $bigwareInfo->attendees_firstname . ' ' . $bigwareInfo->attendees_lastname . '</b>');
			$contents[] = array('text' => '<br>' . go_fetch_checkbox_field('restock', '', true) . ' ' . TEXT_INFO_RESTOCK_ITEM_QUANTITY);
			$contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_delete.gif', PICTURE_DELETE) . ' <a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
			break;
		case 'update_currency':

			// require(DIR_WS_CLASSES . 'currencies.php');
			$currencies = new currencies();
			reset($currencies->currencies);
			$currencies_array = array();
			while (list($key, $value) = each($currencies->currencies)) {
				$currencies_array[] = array('id' => $key, 'text' => $value['title']);
			}

			$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_UPDATE_CUR_ORDER . '</b>');

			$contents = array('form' => go_fetch_form('orders', NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=update_currency_confirm'));
			//$contents[] = array('text' => '<br><br><b>' . $bigwareInfo->customers_firstname . ' ' . $bigwareInfo->customers_lastname . '</b>');
			$contents[] = array('text' => TEXT_CURRENCY . go_fetch_pull_down_menu('update_currency', $currencies_array, $currency));
			$contents[] = array('align' => 'center', 'text' => '<br>' . go_picture_submit('button_update.gif') . ' <a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id) . '">' . go_picture_button('button_cancel.gif', PICTURE_CANCEL) . '</a>');
			break;	
		default:
			if (isset($oInfo) && is_object($oInfo)) {
				$heading[] = array('text' => '<b>[' . $oInfo->orders_id . ']&nbsp;&nbsp;' . go_datetime_short($oInfo->date_purchased) . '</b>');
				$contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=change') . '">' . go_picture_button('button_change.gif', PICTURE_CHANGE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=delete') . '">' . go_picture_button('button_delete.gif', PICTURE_DELETE) . '</a>');
				$contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_ORDERS_INVOICE, 'oID=' . $oInfo->orders_id) . '" TARGET="_blank">' . go_picture_button('button_invoice.gif', PICTURE_ORDERS_INVOICE) . '</a> <a href="' . go_href_link(NAME_OF_FILE_ORDERS_PACKINGSLIP, 'oID=' . $oInfo->orders_id) . '" TARGET="_blank">' . go_picture_button('button_packingslip.gif', PICTURE_ORDERS_PACKINGSLIP) . '</a>');
				$contents[] = array('align' => 'center', 'text' => '<a href="' . go_href_link(NAME_OF_FILE_ORDERS, go_get_all_get_parameter(array('oID', 'action')) . 'oID=' . $oInfo->orders_id . '&action=update_currency') . '">' . go_picture_button('button_update_cur.gif', "W&auml;hrung aktualisieren") . '</a>');
				$contents[] = array('text' => '<br>' . TEXT_DATE_ORDER_CREATED . ' ' . go_date_short($oInfo->date_purchased));
				if (go_not_null($oInfo->last_modified)) $contents[] = array('text' => TEXT_DATE_ORDER_LAST_MODIFIED . ' ' . go_date_short($oInfo->last_modified));
				$contents[] = array('text' => '<br>' . TEXT_INFO_PAYMENT_METHOD . ' '  . $oInfo->payment_method);
			}
			break;
	}



	if ( (go_not_null($heading)) && (go_not_null($contents)) ) {
		echo '            <td width="25%" valign="top"><br>' . "\n";
		$frame = new frame;
		echo $frame->infoBox($heading, $contents);
		echo '            <!-- Modul Umsatzstatistik -->' . $modul_link_order_static . '<!-- Modul Umsatzstatistik Ende --></td>' . "\n";
	}
	?>
		</tr>
		</table></td>
		</tr>
		<?php
}
?>
</table></td>
<!-- body_text_eof //-->
</tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>
