<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
 $version_nr    = '0.8';
$version_datum = '2003.11.01';
   require('load_this/load_bigware_11.php'); 
if (!class_exists(upload)) {  
  class upload {
    var $file, $filename, $destination, $permissions, $extensions, $tmp_filename, $message_location;
    function upload($file = '', $destination = '', $permissions = '777', $extensions = '') {
      $this->set_file($file);
      $this->set_destination($destination);
      $this->set_permissions($permissions);
      $this->set_extensions($extensions);
      $this->set_output_messages('direct');
      if (go_not_null($this->file) && go_not_null($this->destination)) {
        $this->set_output_messages('session');
        if ( ($this->parse() == true) && ($this->save() == true) ) {
          return true;
        } else { 
          $this = null;
          return false;
        }
      }
    }
    function parse() {
      global $messageStack;
      if (isset($_FILES[$this->file])) {
        $file = array('name' => $_FILES[$this->file]['name'],
                      'type' => $_FILES[$this->file]['type'],
                      'size' => $_FILES[$this->file]['size'],
                      'tmp_name' => $_FILES[$this->file]['tmp_name']);
      } elseif (isset($GLOBALS['HTTP_POST_FILES'][$this->file])) {
        global $_FILES;
        $file = array('name' => $_FILES[$this->file]['name'],
                      'type' => $_FILES[$this->file]['type'],
                      'size' => $_FILES[$this->file]['size'],
                      'tmp_name' => $_FILES[$this->file]['tmp_name']);
      } else {
        $file = array('name' => (isset($GLOBALS[$this->file . '_name']) ? $GLOBALS[$this->file . '_name'] : ''),
                      'type' => (isset($GLOBALS[$this->file . '_type']) ? $GLOBALS[$this->file . '_type'] : ''),
                      'size' => (isset($GLOBALS[$this->file . '_size']) ? $GLOBALS[$this->file . '_size'] : ''),
                      'tmp_name' => (isset($GLOBALS[$this->file]) ? $GLOBALS[$this->file] : ''));
      }
      if ( go_not_null($file['tmp_name']) && ($file['tmp_name'] != 'none') && is_uploaded_file($file['tmp_name']) ) {
        if (sizeof($this->extensions) > 0) {
          if (!in_array(strtolower(substr($file['name'], strrpos($file['name'], '.')+1)), $this->extensions)) {
            if ($this->message_location == 'direct') {
              $messageStack->add(ERROR_FILETYPE_NOT_ALLOWED, 'error');
            } else {
              $messageStack->add_session(ERROR_FILETYPE_NOT_ALLOWED, 'error');
            }
            return false;
          }
        }
        $this->set_file($file);
        $this->set_filename($file['name']);
        $this->set_tmp_filename($file['tmp_name']);
        return $this->check_destination();
      } else {
        if ($this->message_location == 'direct') {
          $messageStack->add(WARNING_NO_FILE_UPLOADED, 'warning');
        } else {
          $messageStack->add_session(WARNING_NO_FILE_UPLOADED, 'warning');
        }
        return false;
      }
    }
    function save() {
      global $messageStack;
      if (substr($this->destination, -1) != '/') $this->destination .= '/';
      if (move_uploaded_file($this->file['tmp_name'], $this->destination . $this->filename)) {
        chmod($this->destination . $this->filename, $this->permissions);
        if ($this->message_location == 'direct') {
          $messageStack->add(SUCCESS_FILE_SAVED_SUCCESSFULLY, 'success');
        } else {
          $messageStack->add_session(SUCCESS_FILE_SAVED_SUCCESSFULLY, 'success');
        }
        return true;
      } else {
        if ($this->message_location == 'direct') {
          $messageStack->add(ERROR_FILE_NOT_SAVED, 'error');
        } else {
          $messageStack->add_session(ERROR_FILE_NOT_SAVED, 'error');
        }
        return false;
      }
    }
    function set_file($file) {
      $this->file = $file;
    }
    function set_destination($destination) {
      $this->destination = $destination;
    }
    function set_permissions($permissions) {
      $this->permissions = octdec($permissions);
    }
    function set_filename($filename) {
      $this->filename = $filename;
    }
    function set_tmp_filename($filename) {
      $this->tmp_filename = $filename;
    }
    function set_extensions($extensions) {
      if (go_not_null($extensions)) {
        if (is_array($extensions)) {
          $this->extensions = $extensions;
        } else {
          $this->extensions = array($extensions);
        }
      } else {
        $this->extensions = array();
      }
    }
    function check_destination() {
      global $messageStack;
      if (!is_writeable($this->destination)) {
        if (is_dir($this->destination)) {
          if ($this->message_location == 'direct') {
            $messageStack->add(sprintf(ERROR_DESTINATION_NOT_WRITEABLE, $this->destination), 'error');
          } else {
            $messageStack->add_session(sprintf(ERROR_DESTINATION_NOT_WRITEABLE, $this->destination), 'error');
          }
        } else {
          if ($this->message_location == 'direct') {
            $messageStack->add(sprintf(ERROR_DESTINATION_DOES_NOT_EXIST, $this->destination), 'error');
          } else {
            $messageStack->add_session(sprintf(ERROR_DESTINATION_DOES_NOT_EXIST, $this->destination), 'error');
          }
        }
        return false;
      } else {
        return true;
      }
    }
    function set_output_messages($location) {
      switch ($location) {
        case 'session':
          $this->message_location = 'session';
          break;
        case 'direct':
        default:
          $this->message_location = 'direct';
          break;
      }
    }
  }
}  
  header ("Last-Modified: ". gmdate ("D, d M Y H:i:s"). " GMT"); 
  header ("Cache-Control: no-cache, must-revalidate"); 
  header ("Pragma: no-cache"); 
  header ("Content-type: text/xml"); 
  $LangID = 2;
  
$method = $_SERVER['REQUEST_METHOD'];
  if (($_POST['action']) && ($method=='POST'))
  {
    switch ($_POST['action']) 
    {
      case 'producers_picture_upload':
        
        $producers_picture = new upload('producers_picture', FOLDER_ABSOLUT_CATALOG_PICTURES);
        
        echo go_db_input($producers_picture->filename);
        
        exit;
      
      
      case 'categories_picture_upload':
        
        $categories_picture = new upload('categories_picture', FOLDER_ABSOLUT_CATALOG_PICTURES);
        
        echo go_db_input($categories_picture->filename);
        
        exit;
        
      case 'items_picture_upload':
        
        $items_picture = new upload('items_picture');
        $items_picture->set_destination(FOLDER_ABSOLUT_CATALOG_PICTURES);
        if ($items_picture->parse() && $items_picture->save()) 
        {
          $items_picture_name = $items_picture->filename;
		    echo $items_picture_name;
        }
        exit;  
      
      case 'producers_update':
      
        $producers_id = go_db_producing_input($_POST['mID']);
        
        if (isset($producers_id))
        { 
	        $count_query = go_db_query("select producers_id, producers_name, producers_picture, date_added, last_modified from " . DB_TBL_PRODUCERS . " where producers_id='" . $producers_id . "'");
	        if ($producer = go_db_fetch_array($count_query))
	        {
	           $exists = 1; 
	           $producers_name  = $producer['producers_name'];
	           $producers_picture = $producer['producers_picture'];
	           $date_added          = $producer['date_added'];
	           $last_modified       = $producer['last_modified'];
	        } 
	        else $exists = 0; 
	        if (isset($_POST['producers_name'])) $producers_name = go_db_producing_input($_POST['producers_name']);
	        if (isset($_POST['producers_picture'])) $producers_picture = go_db_producing_input($_POST['producers_picture']);
	        
	        $sql_data_array = array('producers_id' => $producers_id,
	                                'producers_name' => $producers_name,
	                                'producers_picture' => $producers_picture);
	                                
	        if ($exists==0) 
	        {
	          $mode='APPEND';
	          $insert_sql_data = array('date_added' => 'now()');
	          $sql_data_array =  array_merge($sql_data_array, $insert_sql_data);
	           	          go_db_carry(DB_TBL_PRODUCERS, $sql_data_array);
	          $items_id = go_db_insert_id();
	        } 
	        elseif ($exists==1) 
	        {
	          $mode='UPDATE';
	          $update_sql_data = array('last_modified' => 'now()');
	          $sql_data_array =  array_merge($sql_data_array, $update_sql_data);
	           	          
	          go_db_carry(DB_TBL_PRODUCERS, $sql_data_array, 'update', 'producers_id = \'' . go_db_input($producers_id) . '\'');
	        }
	        
	        $languages = go_get_languages();
	        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) 
	        {
	          $language_id = $languages[$i]['id']; 
	          $desc_query = go_db_query("select producers_id,languages_id,producers_url,url_clicked,date_last_click from " . 
	                                    DB_TBL_PRODUCERS_INFO . " where producers_id='" . $producers_id . "' and languages_id='" . $language_id . "'");
	          if ($desc = go_db_fetch_array($desc_query))
	          {
	            $producers_url = $desc['producers_url'];
	            $url_clicked       = $desc['url_clicked'];
	            $date_last_click   = $desc['date_last_click'];
	          } 
	          if (isset($_POST['producers_url'][$language_id])) $producers_url=go_db_producing_input($_POST['producers_url'][$language_id]);
	          if (isset($_POST['url_clicked'][$language_id]))       $url_clicked=go_db_producing_input($_POST['url_clicked'][$language_id]);
	          if (isset($_POST['date_last_click'][$language_id]))   $date_last_click=go_db_producing_input($_POST['date_last_click'][$language_id]);
	              
	          
	          $sql_data_array = array('producers_url' => $producers_url);
	          
	          if ($exists==0) 
	          {
	            $insert_sql_data = array('producers_id' => $items_id,
	                                     'languages_id' => $language_id);
	            $sql_data_array =  array_merge($sql_data_array, $insert_sql_data);
	            go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array);
	          } 
	          elseif ($exists==1) 
	          {
	            go_db_carry(DB_TBL_PRODUCERS_INFO, $sql_data_array, 'update', 'producers_id = \'' . go_db_input($producers_id) . '\' and languages_id = \'' . $language_id . '\'');
	          }
	        }
	         
	        $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
		               '<STATUS>' . "\n" .
		               '<STATUS_DATA>' . "\n" .
		          	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
		           	   '<CODE>' . '0' . '</CODE>' . "\n" .
		               '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
		               '<MODE>' . $mode . '</MODE>' . "\n" .
		               '<PRODUCERS_ID>' . $mID . '</PRODUCERS_ID>' . "\n" .
		               '</STATUS_DATA>' . "\n" .
		               '</STATUS>' . "\n\n";
		                  
		     echo $schema;
			  
			  exit;
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
		  
		case 'producers_erase':
		
        $ManID  = go_db_producing_input($_POST['mID']);
		  
		  if (isset($ManID))
		  { 
          go_db_query("delete from " . DB_TBL_PRODUCERS . " where producers_id = '" . (int)$ManID . "'");
          go_db_query("delete from " . DB_TBL_PRODUCERS_INFO . " where producers_id = '" . (int)$ManID . "'"); 
          go_db_query("update " . DB_TBL_ITEMS . " set producers_id = '' where producers_id = '" . (int)$ManID . "'");
           
          $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                 '<STATUS>' . "\n" .
	                 '<STATUS_DATA>' . "\n" .
	             	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	             	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                 '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                 '</STATUS_DATA>' . "\n" .
	                 '</STATUS>' . "\n\n";
	                  
	       echo $schema;
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
           
		  exit;
        
        
      case 'items_update':
          
        $items_id = go_db_producing_input($_POST['bigID']); 
        $count_query = go_db_query("select items_quantity,items_model,items_picture,items_price,items_date_available,items_date_available_end,items_weight,items_status,items_tax_class_id,producers_id from " . DB_TBL_ITEMS . " where items_id='" . $items_id . "'");
        if ($item = go_db_fetch_array($count_query))
        {
           $exists = 1; 
           $items_quantity = $item['items_quantity'];
           $items_model = $item['items_model'];
           $items_picture = $item['items_picture'];
           $items_price = $item['items_price'];
           $items_date_available = $item['items_date_available'];
           $items_date_available_end = $item['items_date_available_end'];
           $items_weight = $item['items_weight'];
           $items_status = $item['items_status'];
           $items_tax_class_id = $item['items_tax_class_id'];
           $producers_id = $item['producers_id'];
        } 
        else $exists = 0; 
        if (isset($_POST['items_quantity'])) $items_quantity = go_db_producing_input($_POST['items_quantity']);
        if (isset($_POST['items_model'])) $items_model = go_db_producing_input($_POST['items_model']);
        if (isset($_POST['items_picture'])) $items_picture = go_db_producing_input($_POST['items_picture']);
        if (isset($_POST['items_price'])) $items_price = go_db_producing_input($_POST['items_price']);
        if (isset($_POST['items_date_available'])) $items_date_available = go_db_producing_input($_POST['items_date_available']);
        if (isset($_POST['items_date_available_end'])) $items_date_available_end = go_db_producing_input($_POST['items_date_available_end']);
        if (isset($_POST['items_weight'])) $items_weight = go_db_producing_input($_POST['items_weight']);
        if (isset($_POST['items_status'])) $items_status = go_db_producing_input($_POST['items_status']);
        if (isset($_POST['items_tax_class_id'])) $items_tax_class_id = go_db_producing_input($_POST['items_tax_class_id']);
        if (isset($_POST['producers_id'])) $producers_id = go_db_producing_input($_POST['producers_id']);
        
        # FIXME $items_date_available = (date('Y-m-d') < $items_date_available) ? $items_date_available : 'null';
        # FIXME $items_date_available_end = (date('Y-m-d') < $items_date_available_end) ? $items_date_available_end : 'null';
          
        $sql_data_array = array('items_id' => $items_id,
                                'items_quantity' => $items_quantity,
                                'items_model' => $items_model,
                                'items_picture' => ($items_picture == 'none') ? '' : $items_picture,
                                'items_price' => $items_price,
                                'items_date_available' => $items_date_available,
                                'items_date_available_end' => $items_date_available_end,
                                'items_weight' => $items_weight,
                                'items_status' => $items_status,
                                'items_tax_class_id' => $items_tax_class_id,
                                'producers_id' => $producers_id);
          
        if ($exists==0) 
        {
          $mode='APPEND';
          $insert_sql_data = array('items_date_added' => 'now()');
          $sql_data_array =  array_merge($sql_data_array, $insert_sql_data);
           go_db_carry(DB_TBL_ITEMS, $sql_data_array);
          $items_id = go_db_insert_id();
        } 
        elseif ($exists==1) 
        {
          $mode='UPDATE';
          $update_sql_data = array('items_last_modified' => 'now()');
          $sql_data_array =  array_merge($sql_data_array, $update_sql_data);
           go_db_carry(DB_TBL_ITEMS, $sql_data_array, 'update', 'items_id = \'' . go_db_input($items_id) . '\'');
        }
        
        $languages = go_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) 
        {
          $language_id = $languages[$i]['id']; 
          $desc_query = go_db_query("select items_id,items_name,items_description,items_url,items_viewed,language_id from " . 
                                    DB_TBL_ITEMS_DESCRIPTION . " where items_id='" . $items_id . "' and language_id='" . $language_id . "'");
          if ($desc = go_db_fetch_array($desc_query))
          {
            $items_name = $desc['items_name'];
            $items_description = $desc['items_description'];
            $items_url = $desc['items_url'];
          } 
          if (isset($_POST['items_name'][$language_id]))        $items_name=go_db_producing_input($_POST['items_name'][$language_id]);
          if (isset($_POST['items_description'][$language_id])) $items_description=go_db_producing_input($_POST['items_description'][$language_id]);
          if (isset($_POST['items_url'][$language_id]))         $items_url=go_db_producing_input($_POST['items_url'][$language_id]);
              
          
          $sql_data_array = array('items_name' => $items_name,
                                  'items_description' => $items_description,
                                  'items_url' => $items_url);
          
          if ($exists==0) 
          {
            $insert_sql_data = array('items_id' => $items_id,
                                     'language_id' => $language_id);
            $sql_data_array =  array_merge($sql_data_array, $insert_sql_data);
            go_db_carry(DB_TBL_ITEMS_DESCRIPTION, $sql_data_array);
          } 
          elseif ($exists==1) 
          {
            go_db_carry(DB_TBL_ITEMS_DESCRIPTION, $sql_data_array, 'update', 'items_id = \'' . go_db_input($items_id) . '\' and language_id = \'' . $language_id . '\'');
          }
        }
         
        $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	               '<STATUS>' . "\n" .
	               '<STATUS_DATA>' . "\n" .
	          	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	           	   '<CODE>' . '0' . '</CODE>' . "\n" .
	               '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	               '<MODE>' . $mode . '</MODE>' . "\n" .
	               '<ITEMS_ID>' . $items_id . '</ITEMS_ID>' . "\n" .
	               '</STATUS_DATA>' . "\n" .
	               '</STATUS>' . "\n\n";
	                  
	     echo $schema;
		  
		  exit;
		case 'items_erase':
		
        $ProdID  = go_db_producing_input($_POST['prodid']);
		  
		  if (isset($ProdID))
		  { 
           $res1 = go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id='" . $ProdID . "'"); 
           go_remove_item($ProdID);
           
           $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                  '<SQL_RES1>' . $res1 . '</SQL_RES1>' . "\n" .
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
           
		  exit;
		case 'categories_update':
		
		  
		  $CatID    = go_db_producing_input($_POST['catid']);
		  $ParentID = go_db_producing_input($_POST['parentid']);
		  $Sort     = go_db_producing_input($_POST['sort']);
		  $Image    = go_db_producing_input($_POST['picture']);
		  $Name     = go_db_producing_input(UrlDecode($_POST['name']));
		  
		  
		  if (isset($ParentID) && isset($CatID))
		  { 
           $count_query = go_db_query("select COUNT(*) as ANZ from " . DB_TBL_CATEGORIES . " where categories_id='" . $CatID . "'");
           if (go_db_num_rows($count_query)) 
           {
              $count = go_db_fetch_array($count_query);
              
              $exists = $count['ANZ'];
           } 
           else $exists = 0; 
           
           if ($exists==1)
           {          
             $mode='UPDATE';
             
             $values  = "parent_id='" . $ParentID . "', last_modified=now()";
             
             if (isset($Sort)) $values .= ", sort_order='" . $Sort . "'";
             if (isset($Image)) $values .= ", categories_picture='" . $Image . "'";
             
             $res1 = go_db_query("update " . DB_TBL_CATEGORIES . " SET " . $values . " where categories_id='" . $CatID . "'");	
           }
             else
           {
             $mode='APPEND';
             
             if (!isset($Sort)) $Sort=0;
             
             $felder  = "(categories_id, parent_id, date_added, sort_order";
             if (isset($Image)) $felder .= ", categories_picture";
             $felder .= ")";
           
             $values  = "Values(" . "'" . $CatID . "', '" . $ParentID . "', now(), '" . $Sort . "'";
             if (isset($Image)) $values .= ", '" . $Image . "'";
             $values .= ")";
             
             $res1 = go_db_query("insert into " . DB_TBL_CATEGORIES . " " . $felder . $values);           
           } 
           if (isset($Name))
           {
             $res2 = go_db_query("replace into " . DB_TBL_CATEGORIES_DESCRIPTION . " (categories_id, language_id, categories_name) Values ('" . $CatID ."', '" . $LangID . "', '" . $Name . "')");
           }
           
           $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                  '<MODE>' . $mode . '</MODE>' . "\n" .
	                  '<SQL_RES1>' . $res1 . '</SQL_RES1>' . "\n" .
	                  '<SQL_RES2>' . $res2 . '</SQL_RES2>' . "\n" .
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
		  
		  exit;
		  
		case 'categories_erase':
		
		  $CatID  = go_db_producing_input($_POST['catid']);
		  
		  if (isset($CatID))
		  { 
           $res1 = go_db_query("delete from " . DB_TBL_CATEGORIES . " where categories_id='" . $CatID . "'"); 
           $res2 = go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where categories_id='" . $CatID . "'"); 
           $res3 = go_db_query("delete from " . DB_TBL_CATEGORIES_DESCRIPTION . " where categories_id='" . $CatID . "'");
           
           $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                  '<SQL_RES1>' . $res1 . '</SQL_RES1>' . "\n" .
	                  '<SQL_RES2>' . $res2 . '</SQL_RES2>' . "\n" .
	                  '<SQL_RES2>' . $res3 . '</SQL_RES2>' . "\n" .
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
		  
		  exit;
		  
		case 'prod2cat_update':
		
		  $ProdID = go_db_producing_input($_POST['prodid']);
		  $CatID  = go_db_producing_input($_POST['catid']);
		  
		  if (isset($ProdID) && isset($CatID))
		  {
           
           $res = go_db_query("replace into " . DB_TBL_ITEMS_TO_CATEGORIES . " (items_id, categories_id) Values ('" . $ProdID ."', '" . $CatID . "')");
           
           $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                  '<SQL_RES>' . $res . '</SQL_RES>' . "\n" .
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
		  
		  exit;
		case 'prod2cat_erase':
		
		  $ProdID = go_db_producing_input($_POST['prodid']);
		  $CatID  = go_db_producing_input($_POST['catid']);
		  
		  if (isset($ProdID) && isset($CatID))
		  {
           
           $res = go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id='" . $ProdID ."' and categories_id='" . $CatID . "'");
           
           $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '0' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
	                  '<SQL_RES>' . $res . '</SQL_RES>' . "\n" .
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  
		  }
		  	else
		  {
			  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
	                  
	        echo $schema;
		  
		  }
		  
		  exit; 
		  
		case 'order_update':
        
        $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" . "\n";
        
        if ((isset($_POST['order_id'])) && (isset($_POST['status']))) 
        { 
          $oID = $_POST['order_id'];
          $status = $_POST['status'];
          $comments = go_db_producing_input($_POST['comments']);
          $cao_language = $_POST['cao_language'];     
          $check_status_query = go_db_query("select * from " . DB_TBL_ORDERS . " where orders_id = '" . go_db_input($oID) . "'");
          if ($check_status = go_db_fetch_array($check_status_query)) 
          {
            if ($check_status['orders_status'] != $status || $comments != '') 
            {
              go_db_query("update " . DB_TBL_ORDERS . " set orders_status = '" . go_db_input($status) . "', last_modified = now() where orders_id = '" . go_db_input($oID) . "'");
              $attendee_notified = '0';
              if ($_POST['notify'] == 'on') 
              { 
                if (isset($check_status['orders_language_id']) && $check_status['orders_language_id'] > 0 ) {
                  $bigware_language_query = go_db_query("select directory from " . DB_TBL_LANGUAGES . " where languages_id = '" . $check_status['orders_language_id'] . "'");
                  $bigware_language = go_db_fetch_array($bigware_language_query);
                  if ( strlen($bigware_language['directory']) > 0 ) {
                    $cao_language = $bigware_language['directory'];
                  }
                  $orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . $check_status['orders_language_id'] . "'");
                  if (go_db_num_rows($orders_status_query) == 0) {
                    $orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . $languages_id . "'");
                  }
                } else {
                  $orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . $languages_id . "'");
                }
                $orders_statuses = array();
                $orders_status_array = array();
                while ($orders_status = go_db_fetch_array($orders_status_query)) {
                  $orders_statuses[] = array('id' => $orders_status['orders_status_id'],
                                             'text' => $orders_status['orders_status_name']);
                  $orders_status_array[$orders_status['orders_status_id']] = $orders_status['orders_status_name'];
                } 
                if (file_exists(FOLDER_RELATIV_LANGUAGES . $cao_language . '/' . NAME_OF_FILE_ORDERS)) 
                {
                  include(FOLDER_RELATIV_LANGUAGES . $cao_language . '/' . NAME_OF_FILE_ORDERS);
                  $language = $cao_language;
                } else if (file_exists(FOLDER_RELATIV_LANGUAGES . $language . '/' . NAME_OF_FILE_ORDERS)) 
                {
                  include(FOLDER_RELATIV_LANGUAGES . $language . '/' . NAME_OF_FILE_ORDERS);
                }               
                if ($_POST['notify_comments'] == 'on') 
                {
                  $notify_comments = sprintf(EMAIL_TEXT_COMMENTS_UPDATE, $comments) . "\n\n";
                }
                $email = SHOP_NAME . "\n" . EMAIL_SEPARATOR . "\n" . EMAIL_TEXT_ORDER_NUMBER . ' ' . $oID . "\n" . EMAIL_TEXT_INVOICE_URL . ' ' . go_catalog_href_link(NAME_OF_FILE_CATALOG_MEMBER_HISTORY_INFO, 'order_id=' . $oID, 'SSL') . "\n" . EMAIL_TEXT_DATE_ORDERED . ' ' . go_date_long($check_status['date_purchased']) . "\n\n" . $notify_comments . sprintf(EMAIL_TEXT_STATUS_UPDATE, $orders_status_array[$status]);
                go_mail($check_status['attendees_name'], $check_status['attendees_email_address'], EMAIL_TEXT_SUBJECT, nl2br($email), SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS);
                $attendee_notified = '1';
              }
              go_db_query("insert into " . DB_TBL_ORDERS_STATUS_HISTORY . " (orders_id, orders_status_id, date_added, attendee_notified, comments) values ('" . go_db_input($oID) . "', '" . go_db_input($status) . "', now(), '" . $attendee_notified . "', '" . go_db_input($comments)  . "')");
              $schema .= '<STATUS>' . "\n" .
                         '<STATUS_DATA>' . "\n" .
                         '<ORDER_ID>' . $oID . '</ORDER_ID>' . "\n" .
                         '<ORDER_STATUS>' . $status . '</ORDER_STATUS>' . "\n" .
                         '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
                         '<CODE>' . '0' . '</CODE>' . "\n" .
	                      '<MESSAGE>' . 'OK' . '</MESSAGE>' . "\n" . 
                         '</STATUS_DATA>' . "\n" .
                         '</STATUS>' . "\n";
            } 
            else if ($check_status['orders_status'] == $status) 
            { 
              $schema .= '<STATUS>' . "\n" .
                         '<STATUS_DATA>' . "\n" .
                         '<ORDER_ID>' . $oID . '</ORDER_ID>' . "\n" .
                         '<ORDER_STATUS>' . $status . '</ORDER_STATUS>' . "\n" .
                         '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
                         '<CODE>' . '1' . '</CODE>' . "\n" .
	                      '<MESSAGE>' . 'NO STATUS CHANGE' . '</MESSAGE>' . "\n" . 
                         '</STATUS_DATA>' . "\n" .
                         '</STATUS>' . "\n";
            }
          } 
            else           
          { 
            $schema .= '<STATUS>' . "\n" .
                       '<STATUS_DATA>' . "\n" .
                       '<ORDER_ID>' . $oID . '</ORDER_ID>' . "\n" .
                       '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	     '<CODE>' . '2' . '</CODE>' . "\n" .
	                    '<MESSAGE>' . 'ORDER_ID NOT FOUND OR SET' . '</MESSAGE>' . "\n" . 
                       '</STATUS_DATA>' . "\n" .
                       '</STATUS>' . "\n";
          }
        } 
          else 
        {
          $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
	                  '<STATUS>' . "\n" .
	                  '<STATUS_DATA>' . "\n" .
	              	   '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
	              	   '<CODE>' . '99' . '</CODE>' . "\n" .
	                  '<MESSAGE>' . 'PARAMETER ERROR' . '</MESSAGE>' . "\n" . 
	                  '</STATUS_DATA>' . "\n" .
	                  '</STATUS>' . "\n\n";
        }
        echo $schema;
        exit;
		case 'version':
        
        $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
                  '<STATUS>' . "\n" .
                  '<STATUS_DATA>' . "\n" .
                  '<ACTION>' . $_POST['action'] . '</ACTION>' . "\n" .
                  '<CODE>' . '111' . '</CODE>' . "\n" .              
                  '<SCRIPT_VER>' . $version_nr . '</SCRIPT_VER>' . "\n" . 
                  '<SCRIPT_DATE>' . $version_datum . '</SCRIPT_DATE>' . "\n" . 
                  '</STATUS_DATA>' . "\n" .
                  '</STATUS>' . "\n\n";
        echo $schema;
        exit;      
		  
      default:
		  
		  $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
                  '<STATUS>' . "\n" .
                  '<STATUS_DATA>' . "\n" .
              	   '<CODE>' . '100' . '</CODE>' . "\n" .
                  '<MESSAGE>' . 'UNKNOWN ACTION PARAMETER' . '</MESSAGE>' . "\n" . 
                  '</STATUS_DATA>' . "\n" .
                  '</STATUS>' . "\n\n";
                  
        echo $schema;
        exit;
		  		  
    } 
  }
  	else
  {
$method = $_SERVER['REQUEST_METHOD'];    
    if (($_GET['action']) && ($method=='GET') && ($_GET['action']))
    {
      $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
                '<STATUS>' . "\n" .
                '<STATUS_DATA>' . "\n" .
                '<ACTION>' . $_GET['action'] . '</ACTION>' . "\n" .
                '<CODE>' . '111' . '</CODE>' . "\n" .              
                '<SCRIPT_VER>' . $version_nr . '</SCRIPT_VER>' . "\n" . 
                  '<SCRIPT_DATE>' . $version_datum . '</SCRIPT_DATE>' . "\n" . 
                  '</STATUS_DATA>' . "\n" .
                  '</STATUS>' . "\n\n";
      echo $schema;  
    }
    	else
    {
      $schema = '<?xml version="1.0" encoding="' . CHARSET . '"?>' . "\n" .
                '<STATUS>' . "\n" .
                '<STATUS_DATA>' . "\n" .
                '<CODE>' . '101' . '</CODE>' . "\n" .
                '<MESSAGE>' . 'METHOD NOT POST OR UNKNOWN PARAMETER' . '</MESSAGE>' . "\n" . 
                '</STATUS_DATA>' . "\n" .
                '</STATUS>' . "\n\n";
                  
      echo $schema;
    }
  }  
?>
