<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php  
  function go_set_banner_status($banners_id, $status) {
    if ($status == '1') {
      return go_db_query("update " . DB_TBL_BANNERS . " set status = '1', date_status_change = now(), date_scheduled = NULL where banners_id = '" . (int)$banners_id . "'");
    } elseif ($status == '0') {
      return go_db_query("update " . DB_TBL_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . (int)$banners_id . "'");
    } else {
      return -1;
    }
  }  
  function go_activate_banners() {
    $banners_query = go_db_query("select banners_id, date_scheduled from " . DB_TBL_BANNERS . " where date_scheduled != ''");
    if (go_db_num_rows($banners_query)) {
      while ($banners = go_db_fetch_array($banners_query)) {
        if (date('Y-m-d H:i:s') >= $banners['date_scheduled']) {
          go_set_banner_status($banners['banners_id'], '1');
        }
      }
    }
  }  
  function go_expire_banners() {
    $banners_query = go_db_query("select b.banners_id, b.expires_date, b.expires_impressions, sum(bh.banners_shown) as banners_shown from " . DB_TBL_BANNERS . " b, " . DB_TBL_BANNERS_HISTORY . " bh where b.status = '1' and b.banners_id = bh.banners_id group by b.banners_id");
    if (go_db_num_rows($banners_query)) {
      while ($banners = go_db_fetch_array($banners_query)) {
        if (go_not_null($banners['expires_date'])) {
          if (date('Y-m-d H:i:s') >= $banners['expires_date']) {
            go_set_banner_status($banners['banners_id'], '0');
          }
        } elseif (go_not_null($banners['expires_impressions'])) {
          if ( ($banners['expires_impressions'] > 0) && ($banners['banners_shown'] >= $banners['expires_impressions']) ) {
            go_set_banner_status($banners['banners_id'], '0');
          }
        }
      }
    }
  }  
  function go_display_banner($action, $identifier) {
    if ($action == 'dynamic') {
      $banners_query = go_db_query("select count(*) as count from " . DB_TBL_BANNERS . " where status = '1' and banners_group = '" . $identifier . "'");
      $banners = go_db_fetch_array($banners_query);
      if ($banners['count'] > 0) {
        $banner = go_random_select("select banners_id, banners_title, banners_picture, banners_html_text from " . DB_TBL_BANNERS . " where status = '1' and banners_group = '" . $identifier . "'");
      } else {
        return '<b>TEP ERROR! (go_display_banner(' . $action . ', ' . $identifier . ') -> No banners with group \'' . $identifier . '\' found!</b>';
      }
    } elseif ($action == 'static') {
      if (is_array($identifier)) {
        $banner = $identifier;
      } else {
        $banner_query = go_db_query("select banners_id, banners_title, banners_picture, banners_html_text from " . DB_TBL_BANNERS . " where status = '1' and banners_id = '" . (int)$identifier . "'");
        if (go_db_num_rows($banner_query)) {
          $banner = go_db_fetch_array($banner_query);
        } else {
          return '<b>TEP ERROR! (go_display_banner(' . $action . ', ' . $identifier . ') -> Banner with ID \'' . $identifier . '\' not found, or status inactive</b>';
        }
      }
    } else {
      return '<b>TEP ERROR! (go_display_banner(' . $action . ', ' . $identifier . ') -> Unknown $action parameter value - it must be either \'dynamic\' or \'static\'</b>';
    }
    if (go_not_null($banner['banners_html_text'])) {
      $banner_string = $banner['banners_html_text'];
    } else {
      $banner_string = '<a href="' . go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_63], 'action=banner&goto=' . $banner['banners_id']) . '" target="_blank">' . go_picture(FOLDER_RELATIV_PICTURES . $banner['banners_picture'], $banner['banners_title']) . '</a>';
    }
    go_update_banner_display_count($banner['banners_id']);
    return $banner_string;
  }  
  function go_banner_exists($action, $identifier) {
    if ($action == 'dynamic') {
      return go_random_select("select banners_id, banners_title, banners_picture, banners_html_text from " . DB_TBL_BANNERS . " where status = '1' and banners_group = '" . $identifier . "'");
    } elseif ($action == 'static') {
      $banner_query = go_db_query("select banners_id, banners_title, banners_picture, banners_html_text from " . DB_TBL_BANNERS . " where status = '1' and banners_id = '" . (int)$identifier . "'");
      return go_db_fetch_array($banner_query);
    } else {
      return false;
    }
  }  
  function go_update_banner_display_count($banner_id) {
    $banner_check_query = go_db_query("select count(*) as count from " . DB_TBL_BANNERS_HISTORY . " where banners_id = '" . (int)$banner_id . "' and date_format(banners_history_date, '%Y%m%d') = date_format(now(), '%Y%m%d')");
    $banner_check = go_db_fetch_array($banner_check_query);
    if ($banner_check['count'] > 0) {
      go_db_query("update " . DB_TBL_BANNERS_HISTORY . " set banners_shown = banners_shown + 1 where banners_id = '" . (int)$banner_id . "' and date_format(banners_history_date, '%Y%m%d') = date_format(now(), '%Y%m%d')");
    } else {
      go_db_query("insert into " . DB_TBL_BANNERS_HISTORY . " (banners_id, banners_shown, banners_history_date) values ('" . (int)$banner_id . "', 1, now())");
    }
  }  
  function go_update_banner_click_count($banner_id) {
    go_db_query("update " . DB_TBL_BANNERS_HISTORY . " set banners_clicked = banners_clicked + 1 where banners_id = '" . (int)$banner_id . "' and date_format(banners_history_date, '%Y%m%d') = date_format(now(), '%Y%m%d')");
  }
?>