<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################



*/
// set the level of error reporting
# error_reporting(E_ALL | E_WARNING);
error_reporting(E_ALL & ~E_NOTICE);  
# error_reporting(E_ALL);  

define('PAGE_PARSE_START_TIME', microtime()); 

function isohtmlspecialchars($str) { 
	return htmlspecialchars($str, ENT_COMPAT, 'ISO-8859-1'); 
} 

if (file_exists(dirname(__FILE__) . '/load_this_bigware_15.php')){
	if (filesize (dirname(__FILE__) . '/load_this_bigware_15.php') == 0){
		header('Location: setup'); 
	}
}

require(dirname(__FILE__) . '/load_this_bigware_15.php');
define('VERSION', 'Bigware Shop 2.3');

if (!ini_get('register_globals')){
	if(isset($_SESSION)) extract($_SESSION);
	if(isset($_COOKIE)) extract($_COOKIE);
	if(isset($_POST)) extract($_POST);
	if(isset($_GET)) extract($_GET);
} 
require(dirname(__FILE__) . '/stop_injections.php');

$request_type = (getenv('HTTPS') == 'on') ? 'SSL' : 'NONSSL'; 
if (!isset($PHP_SELF)) $PHP_SELF = $_SERVER['PHP_SELF'];
if ($request_type == 'NONSSL') {
	define('FOLDER_RELATIV_CATALOG', FOLDER_RELATIV_HTTP_CATALOG);
} else {
	define('FOLDER_RELATIV_CATALOG', FOLDER_RELATIV_HTTPS_CATALOG);
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'load_this_bigware_12.php'); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'load_this_bigware_18.php'); 
define('FRAME_WIDTH', 125);  
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_4']); 
go_db_connect() or die('Unable to connect to database server!'); 
$set_it_up_query = go_db_query('select set_it_up_key as cfgKey, set_it_up_value as cfgValue from ' . DB_TBL_SET_IT_UP);
while ($set_it_up = go_db_fetch_array($set_it_up_query)) {
	define($set_it_up['cfgKey'], $set_it_up['cfgValue']);
} 
if ( ('GZIP_COMPRESSION' == 'true') && ($ext_zlib_loaded = extension_loaded('zlib')) && (PHP_VERSION >= '4') ) {
	if (($ini_zlib_output_compression = (int)ini_get('zlib.output_compression')) < 1) {
		if (PHP_VERSION >= '4.0.4') {
			ob_start('ob_gzhandler');
		} else {
			include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS[CONFIG_NAME_FILE_FUNCTIONS][function_bigware_6]);
			ob_start();
			ob_implicit_flush();
		}
	} else {
		ini_set('zlib.output_compression_level', GZIP_LEVEL);
	}
} 
if ('SEARCH_ENGINE_FRIENDLY_URLS' == 'true') {
	if (strlen(getenv('PATH_INFO')) > 1) {
		$GET_array = array();
		$PHP_SELF = str_replace(getenv('PATH_INFO'), '', $PHP_SELF);
		$vars = explode('/', substr(getenv('PATH_INFO'), 1));
		for ($i=0, $n=sizeof($vars); $i<$n; $i++) {
			if (strpos($vars[$i], '[]')) {
				$GET_array[substr($vars[$i], 0, -2)][] = $vars[$i+1];
			} else {
				$_GET[$vars[$i]] = $vars[$i+1];
			}
			$i++;
		}
		if (sizeof($GET_array) > 0) {
			while (list($key, $value) = each($GET_array)) {
				$_GET[$key] = $value;
			}
		}
	}
}
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_12']);
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_10']); 
$cookie_domain = (($request_type == 'NONSSL') ? HTTP_COOKIE_DOMAIN : HTTPS_COOKIE_DOMAIN);
$cookie_path = (($request_type == 'NONSSL') ? HTTP_COOKIE_PATH : HTTPS_COOKIE_PATH); 
if ('USE_CACHE' == 'true') include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_2']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_19']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_13']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . 'class_bigware_21.php'); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_3']); 
if (!function_exists('session_start')) {
	define('PHP_SESSION_NAME', 'bigwareCsid');
	define('PHP_SESSION_PATH', $cookie_path);
	define('PHP_SESSION_DOMAIN', $cookie_domain);
	define('PHP_SESSION_SAVE_PATH', FOLDER_ABSOLUT_CATALOG . SESSION_WRITE_DIRECTORY);
	include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_17']);
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_9']); 
go_session_name('bigwareCsid');
go_session_save_path(FOLDER_ABSOLUT_CATALOG . SESSION_WRITE_DIRECTORY); 
if (function_exists('session_set_cookie_parameter')) {
	session_set_cookie_parameter(0, $cookie_path, $cookie_domain);
} elseif (function_exists('ini_set')) {
	ini_set('session.cookie_lifetime', '0');
	ini_set('session.cookie_path', $cookie_path);
	ini_set('session.cookie_domain', $cookie_domain);
} 
if (isset($_POST[go_session_name()])) {
	go_session_id($_POST[go_session_name()]);
} elseif ( ($request_type == 'SSL') && isset($_GET[go_session_name()]) ) {
	go_session_id($_GET[go_session_name()]);
} 
$session_started = false;
if (SESSION_FORCE_COOKIE_USE == 'True') {
	go_setcookie('cookie_test', 'please_accept_for_session', time()+60*60*24*30, $cookie_path, $cookie_domain);
	if (isset($_COOKIE['cookie_test'])) {
		go_session_start();
		$session_started = true;
	}
	//
} elseif (SESSION_BLOCK_SPIDERS == 'True') {
	$user_agent = strtolower(getenv('HTTP_USER_AGENT'));
	$spider_flag = false;
	if (go_not_null($user_agent)) {
		$spiders = file(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'spiders.txt');
		for ($i=0, $n=sizeof($spiders); $i<$n; $i++) {
			if (go_not_null($spiders[$i])) {
				if (is_integer(strpos($user_agent, trim($spiders[$i])))) {
					$spider_flag = true;
					break;
				}
			}
		}
	}
	if ($spider_flag == false) {
		go_session_start();
		$session_started = true;
	}
} else {
	go_session_start();
	$session_started = true;
} 
$SID = (defined('SID') ? SID : ''); 
if ( ($request_type == 'SSL') && (SESSION_CHECK_SSL_SESSION_ID == 'True') && (ENABLE_SSL == true) && ($session_started == true) ) {
	$ssl_session_id = getenv('SSL_SESSION_ID');
	if (!go_session_is_registered('SSL_SESSION_ID')) {
		$SESSION_SSL_ID = $ssl_session_id;
		go_session_register('SESSION_SSL_ID');
	}
	if ($SESSION_SSL_ID != $ssl_session_id) {
		go_session_destroy();
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_71]));
	}
} 
if (SESSION_CHECK_USER_AGENT == 'True') {
	$http_user_agent = getenv('HTTP_USER_AGENT');
	if (!go_session_is_registered('SESSION_USER_AGENT')) {
		$SESSION_USER_AGENT = $http_user_agent;
		go_session_register('SESSION_USER_AGENT');
	}
	if ($SESSION_USER_AGENT != $http_user_agent) {
		go_session_destroy();
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40]));
	}
} 
if (SESSION_CHECK_IP_ADDRESS == 'True') {
	$ip_address = go_get_ip_address();
	if (!go_session_is_registered('SESSION_IP_ADDRESS')) {
		$SESSION_IP_ADDRESS = $ip_address;
		go_session_register('SESSION_IP_ADDRESS');
	}
	if ($SESSION_IP_ADDRESS != $ip_address) {
		go_session_destroy();
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40]));
	}
} 
if (go_session_is_registered('cart') && is_object($cart)) { 
	if (PHP_VERSION < 4) {
		$broken_cart = $cart;
		$cart = new shoppingCart;
		$cart->unserialize($broken_cart);
	}
} else {
	go_session_register('cart');
	$cart = new shoppingCart;
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_5']);
$currencies = new currencies(); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_12']);
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_6']); 
if (!go_session_is_registered('language') || isset($_GET['language'])) {
	if (!go_session_is_registered('language')) {
		go_session_register('language');
		go_session_register('languages_id');
	}
	include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_10']);
	$lng = new language();
	if (isset($_GET['language']) && go_not_null($_GET['language'])) {
		$lng->set_language($_GET['language']);
	} else {
		if (STANDARDSPRACHE == 'browser'){    	
			$lng->get_browser_language();
		}
		elseif(STANDARDSPRACHE == 'english'){
			$lng->set_language('en');
		}
		elseif(STANDARDSPRACHE == 'german'){
			$lng->set_language('de');
		}
	}
	$language = $lng->language['directory'];
	$languages_id = $lng->language['id'];
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_LANGUAGES . $language . '.php');
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . 'pagadors_strftime.php');
# include the cache class
include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_3']);
$cache = new cache($languages_id);
# include the Ultimate SEO URLs cache file
include(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'load_this_bigware_14.php');
# Get the cache - no parameters will get all GLOBAL cache entries for this language
$cache->get_cache('GLOBAL');
if ( isset($_GET['cName']) && defined(urldecode($_GET['cName'])) ) {
	$bigPfad = str_replace( 'bigPfad=', '', constant(urldecode($_GET['cName'])) );
	$_GET['bigPfad'] = $bigPfad;
}
if (isset($_GET['pName']) && defined(urldecode($_GET['pName'])) ) {
	$pid = str_replace('items_id=', '', constant(urldecode($_GET['pName'])));
	$_GET['items_id'] = (int)$pid;
} 
if (!go_session_is_registered('currency') || isset($_GET['currency']) || ( (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') && (LANGUAGE_CURRENCY != $currency) ) ) {
	if (!go_session_is_registered('currency')) go_session_register('currency');
	if (isset($_GET['currency'])) {
		if (!$currency = go_currency_exists($_GET['currency'])) $currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
	} else {
		$currency = (USE_DEFAULT_LANGUAGE_CURRENCY == 'true') ? LANGUAGE_CURRENCY : DEFAULT_CURRENCY;
	}
}


if (go_session_is_registered('navigation')) {
	if (PHP_VERSION < 4) {
		$broken_navigation = $navigation;
		$navigation = new navigationHistory;
		$navigation->unserialize($broken_navigation);
	}
} else {
	go_session_register('navigation');
	$navigation = new navigationHistory;
}
$navigation->add_current_page(); 
if (isset($_POST['bin_onchange'])) { 
	if ($_POST['bin_onchange'] == '1'){
		unset($_GET['action']);
	}
}
if (isset($_GET['action'])) { 
	if ($session_started == false) {
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_9]));
	}
	if (SHOW_CART == 'true') {
		$goto =  $GLOBALS[CONFIG_NAME_FILE][main_bigware_69];
		$parameters = array('action', 'bigPfad', 'items_id', 'pid', 'cName', 'pName');
	} else {
		$goto = basename($PHP_SELF);
		if ($_GET['action'] == 'buy_now') {
			$parameters = array('action', 'pid', 'items_id', 'pName');
		} else {
			$parameters = array('action', 'pid');
		}
	}
	$cart_action = $_GET['action'];

	if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/affili_shop')) {
		require(FOLDER_ABSOLUT_CATALOG . 'modules/affili_shop/load_this/load_this_bigware_10.php');
	} 
	switch ($cart_action) { 
		case 'update_item' :
			$add_cart_array = '';
			for ($i=0, $n=sizeof($_POST['items_id']); $i<$n; $i++) { 
				if (in_array($_POST['items_id'][$i], (is_array($_POST['cart_delete']) ? $_POST['cart_delete'] : array()))) {
					$cart->remove($_POST['items_id'][$i]);
				} else {
					if (PHP_VERSION < 4) { 
						reset($_POST);
						while (list($key, $value) = each($_POST)) {
							if (is_array($value)) {
								while (list($key2, $value2) = each($value)) {
									if (preg_match ("/(.*)\]\[(.*)/", $key2, $var)) {
										$id2[$var[1]][$var[2]] = $value2;
									}
								}
							}
						}
						$characteristics = ($id2[$_POST['items_id'][$i]]) ? $id2[$_POST['items_id'][$i]] : '';
					} else {
						$characteristics = ($_POST['id'][$_POST['items_id'][$i]]) ? $_POST['id'][$_POST['items_id'][$i]] : '';
					}
					$add_cart_array = '';
					if (is_array($_POST['add_cart_variable_serialize'])){
						$add_cart_array = array_in_one_hidden_decode($_POST['add_cart_variable_serialize'][$i]);
					}
					// Loopthrough3
					$cart->add_cart($_POST['items_id'][$i], $_POST['cart_quantity'][$i], $characteristics, false,$_POST['cart_laenge'][$i],$_POST['cart_breite'][$i],$_POST['cart_immeter'][$i],$_POST['cart_inmeter_breite'][$i],$_POST['cart_price_option_comment'][$i],$add_cart_array);
				}
			}
			go_forward(go_href_link($goto, go_get_all_get_parameter($parameters)));
			break; 
		case 'add_item' : 
			if (isset($_POST['items_id']) && is_numeric($_POST['items_id'])) { 
				if (!(isset($_POST['laenge']))) {$_POST['laenge']=1000;}
				if (!(isset($_POST['breite']))) {$_POST['breite']=1000;}
				if (!(isset($_POST['immeter']))) {$_POST['immeter']=1000;}
				if (!(isset($_POST['inmeter_breite']))) {$_POST['inmeter_breite']=1000;}

				if (isset($_POST['cart_quantity'])) {
					$current_quantity = $_POST['cart_quantity'];
				}
				else {
					$current_quantity = $_POST['quantity'];}
				// Loopthrough2
				$cart->add_cart($_POST['items_id'], $cart->get_quantity(go_get_uprid($_POST['items_id'], $_POST['id']))+($current_quantity), $_POST['id'],true,$_POST['laenge'],$_POST['breite'],$_POST['immeter'],$_POST['inmeter_breite'],$_POST['price_option_comment'],$_POST['add_cart_array']);
			}
			go_forward(go_href_link($goto, go_get_all_get_parameter($parameters)));
			break; 
		case 'add_a_quickie' :  $quickie_query = go_db_query("select items_id from " . DB_TBL_ITEMS . " where items_model = '" . $_POST['quickie'] . "'");
					if (!go_db_num_rows($quickie_query)) {
						$quickie_query = go_db_query("select items_id from " . DB_TBL_ITEMS . " where items_model LIKE '%" . $_POST['quickie'] . "%'");
					}
					if (go_db_num_rows($quickie_query) != 1) {
						go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_3], 'keywords=' . $_POST['quickie'], 'NONSSL'));
					}
					$quickie = go_db_fetch_array($quickie_query);
					if (go_has_item_characteristics($quickie['items_id'])) {
						go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_34], 'items_id=' . $quickie['items_id'], 'NONSSL'));
					} else {
						$cart->add_cart($quickie['items_id'], 1, $_POST['id'],true,$_POST['laenge'],$_POST['breite'],$_POST['immeter'],$_POST['inmeter_breite'],$_POST['price_option_comment'],$_POST['add_cart_array']);
						go_forward(go_href_link($goto, go_get_all_get_parameter(array('action')), 'NONSSL'));
					}
					break; 
		case 'buy_now' :
					if (isset($_GET['items_id'])) {
						if (go_has_item_characteristics((int)$_GET['items_id'])) {
							go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_34], 'items_id=' . (int)$_GET['items_id']));
						} else {
							$cart->add_cart((int)$_GET['items_id'], $cart->get_quantity((int)$_GET['items_id'])+1);
						}
					}
					if ( (defined('SEO_URLS') && SEO_URLS == 'true') && (defined('SEO_URLS_TYPE') && SEO_URLS_TYPE == 'Rewrite') ){
						$bigPfad = go_get_item_path((int)$_GET['items_id']);
						$bigPfad_array = go_analysis_category_path($bigPfad);
						$bigPfad = implode('_', $bigPfad_array);
						go_forward(go_href_link($goto, 'bigPfad=' . $bigPfad . '&' . go_get_all_get_parameter($parameters)));
					} else {
						go_forward(go_href_link($goto, go_get_all_get_parameter($parameters)));
					}
					break;
		case 'notify' :
					if (go_session_is_registered('attendee_id')) {
						if (isset($_GET['items_id'])) {
							$notify = (int)$_GET['items_id'];
						} elseif (isset($_GET['notify'])) {
							$notify = $_GET['notify'];
						} elseif (isset($_POST['notify'])) {
							$notify = $_POST['notify'];
						} else {
							go_forward(go_href_link(basename($PHP_SELF), go_get_all_get_parameter(array('action', 'notify'))));
						}
						if (!is_array($notify)) $notify = array($notify);
						for ($i=0, $n=sizeof($notify); $i<$n; $i++) {
							$check_query = go_db_query("select count(*) as count from " . DB_TBL_ITEMS_INFORMS . " where items_id = '" . $notify[$i] . "' and attendees_id = '" . $attendee_id . "'");
							$check = go_db_fetch_array($check_query);
							if ($check['count'] < 1) {
								go_db_query("insert into " . DB_TBL_ITEMS_INFORMS . " (items_id, attendees_id, date_added) values ('" . $notify[$i] . "', '" . $attendee_id . "', now())");
							}
						}
						go_forward(go_href_link(basename($PHP_SELF), go_get_all_get_parameter(array('action', 'notify'))));
					} else {
						$navigation->set_snapshot();
						go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40], '', 'SSL'));
					}
					break;
		case 'notify_remove' :
					if (go_session_is_registered('attendee_id') && isset($_GET['items_id'])) {
						$check_query = go_db_query("select count(*) as count from " . DB_TBL_ITEMS_INFORMS . " where items_id = '" . (int)$_GET['items_id'] . "' and attendees_id = '" . $attendee_id . "'");
						$check = go_db_fetch_array($check_query);
						if ($check['count'] > 0) {
							go_db_query("delete from " . DB_TBL_ITEMS_INFORMS . " where items_id = '" . (int)$_GET['items_id'] . "' and attendees_id = '" . $attendee_id . "'");
						}
						go_forward(go_href_link(basename($PHP_SELF), go_get_all_get_parameter(array('action'))));
					} else {
						$navigation->set_snapshot();
						go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40], '', 'SSL'));
					}
					break;
		case 'cust_order' :
					if (go_session_is_registered('attendee_id') && isset($_GET['pid'])) {
						if (go_has_item_characteristics((int)$_GET['pid'])) {
							go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_34], 'items_id=' . (int)$_GET['pid']));
						} else {
							$cart->add_cart((int)$_GET['pid'], $cart->get_quantity((int)$_GET['pid'])+1);
						}
					}
					go_forward(go_href_link($goto, go_get_all_get_parameter($parameters)));
					break;
	}
} 
if (!go_session_is_registered('referral_id') || isset($_GET['ref'])) {
	if (!go_session_is_registered('referral_id') && !go_session_is_registered('attendee_id')) {
		go_session_register('referral_id');
	}
	if (isset($_GET['ref']) && go_not_null($_GET['ref'])) {
		$referral_id = $_GET['ref'];
	} else {
		$referral_id = '';
	}
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_14']);
go_update_whos_online(); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_8']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_13']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_20']); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_7']); 

if (isset($_GET['bigPfad'])) {
	$bigPfad = $_GET['bigPfad'];
} elseif (isset($_GET['items_id']) && !isset($_GET['producers_id'])) {
	$bigPfad = go_get_item_path((int)$_GET['items_id']);
} else {
	$bigPfad = '';
}
if (go_not_null($bigPfad)) {
	$bigPfad_array = go_analysis_category_path($bigPfad);
	$bigPfad = implode('_', $bigPfad_array);
	$current_category_id = $bigPfad_array[(sizeof($bigPfad_array)-1)];
} else {
	$current_category_id = 0;
} 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_2']);

//  $breadcrumb->add(HEADER_TITLE_TOP, HTTP_SERVER);

$breadcrumb = new breadcrumb;  
$breadcrumb->add(HEADER_TITLE_CATALOG, go_href_link($GLOBALS['CONFIG_NAME_FILE']['main_bigware_29']));

if (isset($bigPfad_array)) {

	if ($breadcrumb_galerie == 1){

		for ($i=0, $n=sizeof($bigPfad_array); $i<$n; $i++) {
			$categories_query = go_db_query("select categories_name from " . DB_TBL_GALERIE_CAT_DESCRIPTION . " where categories_id = '" . (int)$bigPfad_array[$i] . "' and language_id = '" . (int)$languages_id . "'");
			if (go_db_num_rows($categories_query) > 0) {
				$categories = go_db_fetch_array($categories_query);
				$breadcrumb->add($categories['categories_name'], go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_24], 'bigPfad=' . implode('_', array_slice($bigPfad_array, 0, ($i+1)))));
				$_title_list_galerie = $categories['categories_name'];
			} else {
				break;
			}
		}		
	}	
	else{
		for ($i=0, $n=sizeof($bigPfad_array); $i<$n; $i++) {
			$categories_query = go_db_query("select categories_name from " . DB_TBL_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$bigPfad_array[$i] . "' and language_id = '" . (int)$languages_id . "'");
			if (go_db_num_rows($categories_query) > 0) {
				$categories = go_db_fetch_array($categories_query);
				$breadcrumb->add($categories['categories_name'], go_href_link($GLOBALS['CONFIG_NAME_FILE'][main_bigware_29], 'bigPfad=' . implode('_', array_slice($bigPfad_array, 0, ($i+1)))));
			} else {
				break;
			}
		}  	
	}

} elseif (isset($_GET['producers_id'])) {
	$producers_query = go_db_query("select producers_name from " . DB_TBL_PRODUCERS . " where producers_id = '" . (int)$_GET['producers_id'] . "'");
	if (go_db_num_rows($producers_query)) {
		$producers = go_db_fetch_array($producers_query);
		$breadcrumb->add($producers['producers_name'], go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_29], 'producers_id=' . (int)$_GET['producers_id']));
	}
} 
if ($breadcrumb_galerie == 1){
	if (isset($_GET['galeries_id'])) {
		$galerie_name_query = go_db_query("select b.galeries_name from " . DB_TBL_GALERIE . " a, " . DB_TBL_GALERIE_DESCRIPTION . " b where a.galeries_id = '" . (int)$_GET['galeries_id'] . "' AND a.galeries_id = b.galeries_id  AND b.language_id = '" . (int)$languages_id . "'");
		if (go_db_num_rows($galerie_name_query)) {
			$galerie_name = go_db_fetch_array($galerie_name_query);
			$breadcrumb->add($galerie_name['galeries_name'], go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_23], 'bigPfad=' . $bigPfad . '&galeries_id=' . (int)$_GET['galeries_id']));
		}
	} 	
}
else{
	if (isset($_GET['items_id'])) {
		$model_query = go_db_query("select items_model from " . DB_TBL_ITEMS . " where items_id = '" . (int)$_GET['items_id'] . "'");
		if (go_db_num_rows($model_query)) {
			$model = go_db_fetch_array($model_query);
			$breadcrumb->add($model['items_model'], go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_34], 'bigPfad=' . $bigPfad . '&items_id=' . (int)$_GET['items_id']));
		}
	} 
}  


require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . $GLOBALS['CONFIG_NAME_FILE_CLASSES']['classes_bigware_11']);
$messageStack = new messageStack; 

define('WARN_INSTALL_EXISTENCE', 'true');
define('WARN_CONFIG_WRITEABLE', 'true');
define('WARN_SESSION_DIRECTORY_NOT_WRITEABLE', 'true');
define('WARN_SESSION_AUTO_START', 'true');
define('WARN_DOWNLOAD_DIRECTORY_NOT_READABLE', 'true');
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_LANGUAGES . $language . '/' . $GLOBALS['CONFIG_NAME_FILE']['main_bigware_40']);
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_LANGUAGES . $language . '/' . 'whos_online.php');  
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'load_this_bigware_16.php');
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_INCLUDES . 'load_this_bigware_17.php');
define('NAME_OF_FILE_INVOICE_STICKER', 'invoice_sticker.php'); 
define('NAME_OF_FILE_INVOICE_POSTCOPY', 'invoice_postcopy.php'); 
$logo_query = go_db_query("select logo_pfad, allg_metas from " . DB_TBL_ERW_EINSTELLUNGEN . " where id = '2'");
if (go_db_num_rows($logo_query)) {
	$logo = go_db_fetch_array($logo_query);
	$logotext_value = trim(preg_replace('/^.*content.*\"(.*)\".*$/i', '$1', $logo['allg_metas']));
	define('LOGO_PFAD', $logo['logo_pfad']);
	define('LOGO_TEXT', $logotext_value);
}
define('SECURITY_CODE_LENGTH', '10'); 
function create_coupon_code($salt="secret", $length = SECURITY_CODE_LENGTH) {
	$ccid = md5(uniqid("","salt"));
	$ccid .= md5(uniqid("","salt"));
	$ccid .= md5(uniqid("","salt"));
	$ccid .= md5(uniqid("","salt"));
	srand((double)microtime()*1000000); 
	$random_start = @rand(0, (128-$length));
	$good_result = 0;
	while ($good_result == 0) {
		$id1=substr($ccid, $random_start,$length);        
		$query = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_code = '" . $id1 . "'");    
		if (go_db_num_rows($query) == 0) $good_result = 1;
	}
	return $id1;
}  
function go_gv_member_update($attendee_id, $gv_id) {
	$attendee_gv_query = go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $attendee_id . "'");
	$coupon_gv_query = go_db_query("select coupon_amount from " . DB_TBL_COUPONS . " where coupon_id = '" . $gv_id . "'");
	$coupon_gv = go_db_fetch_array($coupon_gv_query);
	if (go_db_num_rows($attendee_gv_query) > 0) {
		$attendee_gv = go_db_fetch_array($attendee_gv_query);
		$new_gv_amount = $attendee_gv['amount'] + $coupon_gv['coupon_amount']; 
		$gv_query = go_db_query("update " . DB_TBL_COUPON_GV_ATTENDEE . " set amount = '" . $new_gv_amount . "' where attendee_id = '" . $attendee_id . "'"); 
	} else {
		$gv_query = go_db_query("insert into " . DB_TBL_COUPON_GV_ATTENDEE . " (attendee_id, amount) values ('" . $attendee_id . "', '" . $coupon_gv['coupon_amount'] . "')");
	}
}  
function go_get_tax_rate_from_desc($tax_desc) {
	$tax_query = go_db_query("select tax_rate from " . DB_TBL_TAX_RATES . " where tax_description = '" . $tax_desc . "'");
	$tax = go_db_fetch_array($tax_query);
	return $tax['tax_rate'];
}

$set_it_up_query = go_db_query('select set_it_up_key as cfgKey, set_it_up_value as cfgValue from phesis_poll_config');
while ($set_it_up = go_db_fetch_array($set_it_up_query)) {
	define($set_it_up['cfgKey'], $set_it_up['cfgValue']);
}
if( !function_exists( 'html_entity_decode' ) )
{
	function html_entity_decode( $given_html, $quote_style = ENT_QUOTES ) {
		$trans_table = array_flip(get_html_translation_table( HTML_SPECIALCHARS, $quote_style ));
		$trans_table["'"] = "'";
		return ( strtr( $given_html, $trans_table ) );
	}
}

require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_LANGUAGES . $language . '/other/buttons.php');
if (file_exists(FOLDER_RELATIV_TEMPLATES . 'config.tpl.php')){
	require_once(FOLDER_RELATIV_TEMPLATES . 'config.tpl.php');
}  
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_11']);
go_expire_specials(); 
require(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_FUNCTIONS . $GLOBALS['CONFIG_NAME_FILE_FUNCTIONS']['function_bigware_5']);
go_expire_featured(); 
?>
