<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  class authorizenet {
    var $code, $title, $description, $enabled; 
    function authorizenet() {
      global $order;
      $this->code = 'authorizenet';
      $this->title = CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_TITLE;
      $this->description = CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_DESCRIPTION; 
	  if ( go_get_payment_unallowed($this->code) ) {
	  	$this->enabled = ((CONSTITUENT_PAYMENT_AUTHORIZENET_STATUS == 'True') ? true : false);
	  } 
      $this->sort_order = CONSTITUENT_PAYMENT_AUTHORIZENET_SORT_ORDER;
      if ((int)CONSTITUENT_PAYMENT_AUTHORIZENET_ORDER_STATUS_ID > 0) {
        $this->order_status = CONSTITUENT_PAYMENT_AUTHORIZENET_ORDER_STATUS_ID;
      }
      if (is_object($order)) $this->update_status();
      $this->form_action_url = 'https://secure.authorize.net/gateway/transact.dll';
    }                    
function hmac ($key, $data)
{    
   $b = 64; 
   if (strlen($key) > $b) {
       $key = pack("H*",md5($key));
   }
   $key  = str_pad($key, $b, chr(0x00));
   $ipad = str_pad('', $b, chr(0x36));
   $opad = str_pad('', $b, chr(0x5c));
   $k_ipad = $key ^ $ipad ;
   $k_opad = $key ^ $opad;
   return md5($k_opad  . pack("H*",md5($k_ipad . $data)));
}   
function CalculateFP ($loginid, $txnkey, $amount, $sequence, $tstamp, $currency = "") {
  return ($this->hmac ($txnkey, $loginid . "^" . $sequence . "^" . $tstamp . "^" . $amount . "^" . $currency));
}  
function InsertFP ($loginid, $txnkey, $amount, $sequence, $currency = "") {
  $tstamp = time ();
  $fingerprint = $this->hmac ($txnkey, $loginid . "^" . $sequence . "^" . $tstamp . "^" . $amount . "^" . $currency);
  $str = go_fetch_hidden_field('x_fp_sequence', $sequence) .
         go_fetch_hidden_field('x_fp_timestamp', $tstamp) .
         go_fetch_hidden_field('x_fp_hash', $fingerprint);
  return $str;
}  
    function update_status() {
      global $order;
      if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_AUTHORIZENET_ZONE > 0) ) {
        $check_flag = false;
        $check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_AUTHORIZENET_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
        while ($check = go_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }
    function javascript_validation() {
      $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
            '    var cc_owner = document.payment_order_way.authorizenet_cc_owner.value;' . "\n" .
            '    var cc_number = document.payment_order_way.authorizenet_cc_number.value;' . "\n" .
            '    if (cc_owner == "" || cc_owner.length < ' . CC_OWNER_MIN_LENGTH . ') {' . "\n" .
            '      error_message = error_message + "' . CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_JS_CC_OWNER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
            '      error_message = error_message + "' . CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_JS_CC_NUMBER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n";
      return $js;
    }
    function selection() {
      global $order;
      for ($i=1; $i<13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => pagadors_strftime('%B',mktime(0,0,0,$i,1,2000)));
      }
      $today = getdate(); 
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => pagadors_strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => pagadors_strftime('%Y',mktime(0,0,0,1,1,$i)));
      }
      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'fields' => array(array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_OWNER,
                                                 'field' => go_fetch_inputfeld('authorizenet_cc_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
                                           array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_NUMBER,
                                                 'field' => go_fetch_inputfeld('authorizenet_cc_number')),
                                           array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_EXPIRES,
                                                 'field' => go_fetch_pull_down_menu('authorizenet_cc_expires_month', $expires_month) . '&nbsp;' . go_fetch_pull_down_menu('authorizenet_cc_expires_year', $expires_year))));
      return $selection;
    }
    function pre_confirmation_check() {
      global $_POST;
      include(FOLDER_RELATIV_CLASSES . $GLOBALS[CONFIG_NAME_FILE_CLASSES][classes_bigware_4]);
      $cc_validation = new cc_validation();
      $result = $cc_validation->validate($_POST['authorizenet_cc_number'], $_POST['authorizenet_cc_expires_month'], $_POST['authorizenet_cc_expires_year']);
      $error = '';
      switch ($result) {
        case -1:
          $error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->cc_number, 0, 4));
          break;
        case -2:
        case -3:
        case -4:
          $error = TEXT_CCVAL_ERROR_INVALID_DATE;
          break;
        case false:
          $error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
          break;
      }
      if ( ($result == false) || ($result < 1) ) {
        $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&authorizenet_cc_owner=' . urlencode($_POST['authorizenet_cc_owner']) . '&authorizenet_cc_expires_month=' . $_POST['authorizenet_cc_expires_month'] . '&authorizenet_cc_expires_year=' . $_POST['authorizenet_cc_expires_year'];
        go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], $payment_error_return, 'SSL', true, false));
      }
      $this->cc_card_type = $cc_validation->cc_type;
      $this->cc_card_number = $cc_validation->cc_number;
      $this->cc_expiry_month = $cc_validation->cc_expiry_month;
      $this->cc_expiry_year = $cc_validation->cc_expiry_year;
    }
    function confirmation() {
      global $_POST;
      $confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
                            'fields' => array(array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_OWNER,
                                                    'field' => $_POST['authorizenet_cc_owner']),
                                              array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_NUMBER,
                                                    'field' => substr($this->cc_card_number, 0, 4) . str_repeat('X', (strlen($this->cc_card_number) - 8)) . substr($this->cc_card_number, -4)),
                                              array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_CRCHANGE_CARD_EXPIRES,
                                                    'field' => pagadors_strftime('%B, %Y', mktime(0,0,0,$_POST['authorizenet_cc_expires_month'], 1, '20' . $_POST['authorizenet_cc_expires_year'])))));
      return $confirmation;
    }
    function process_button() {
      global $_SERVER, $order, $attendee_id;
      $sequence = rand(1, 1000);
      $process_button_string = go_fetch_hidden_field('x_Login', CONSTITUENT_PAYMENT_AUTHORIZENET_LOGIN) .
                               go_fetch_hidden_field('x_Card_Num', $this->cc_card_number) .
                               go_fetch_hidden_field('x_Exp_Date', $this->cc_expiry_month . substr($this->cc_expiry_year, -2)) .
                               go_fetch_hidden_field('x_Amount', number_format($order->info['total'], 2)) .
                               go_fetch_hidden_field('x_Relay_URL', go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_62], '', 'SSL', false)) .
                               go_fetch_hidden_field('x_Method', ((CONSTITUENT_PAYMENT_AUTHORIZENET_METHOD == 'Crchange Card') ? 'CC' : 'ECHECK')) .
                               go_fetch_hidden_field('x_Version', '3.0') .
                               go_fetch_hidden_field('x_Cust_ID', $attendee_id) .
                               go_fetch_hidden_field('x_Email_Customer', ((CONSTITUENT_PAYMENT_AUTHORIZENET_EMAIL_ATTENDEE == 'True') ? 'TRUE': 'FALSE')) .
                               go_fetch_hidden_field('x_first_name', $order->billing['firstname']) .
                               go_fetch_hidden_field('x_last_name', $order->billing['lastname']) .
                               go_fetch_hidden_field('x_address', $order->billing['street_address']) .
                               go_fetch_hidden_field('x_city', $order->billing['city']) .
                               go_fetch_hidden_field('x_state', $order->billing['state']) .
                               go_fetch_hidden_field('x_zip', $order->billing['postcode']) .
                               go_fetch_hidden_field('x_land', $order->billing['land']['title']) .
                               go_fetch_hidden_field('x_phone', $order->attendee['telephone']) .
                               go_fetch_hidden_field('x_email', $order->attendee['email_address']) .
                               go_fetch_hidden_field('x_ship_to_first_name', $order->delivery['firstname']) .
                               go_fetch_hidden_field('x_ship_to_last_name', $order->delivery['lastname']) .
                               go_fetch_hidden_field('x_ship_to_address', $order->delivery['street_address']) .
                               go_fetch_hidden_field('x_ship_to_city', $order->delivery['city']) .
                               go_fetch_hidden_field('x_ship_to_state', $order->delivery['state']) .
                               go_fetch_hidden_field('x_ship_to_zip', $order->delivery['postcode']) .
                               go_fetch_hidden_field('x_ship_to_land', $order->delivery['land']['title']) .
                               go_fetch_hidden_field('x_Customer_IP', $_SERVER['REMOTE_ADDR']) .
                               $this->InsertFP(CONSTITUENT_PAYMENT_AUTHORIZENET_LOGIN, CONSTITUENT_PAYMENT_AUTHORIZENET_TXNKEY, number_format($order->info['total'], 2), $sequence);
      if (CONSTITUENT_PAYMENT_AUTHORIZENET_TESTMODE == 'Test') $process_button_string .= go_fetch_hidden_field('x_Test_Request', 'TRUE');
      $process_button_string .= go_fetch_hidden_field(go_session_name(), go_session_id());
      return $process_button_string;
    }
    function before_process() {
      global $_POST;
      if ($_POST['x_response_code'] == '1') return;
      if ($_POST['x_response_code'] == '2') {
        go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_DECLINED_MESSAGE), 'SSL', true, false));
      } 
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_ERROR_MESSAGE), 'SSL', true, false));
    }
    function after_process() {
      return false;
    }
    function get_error() {
      global $_GET;
      $error = array('title' => CONSTITUENT_PAYMENT_AUTHORIZENET_TEXT_ERROR,
                     'error' => stripslashes(urldecode($_GET['error'])));
      return $error;
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_AUTHORIZENET_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function install() {
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('Enable Authorize.net Module', 'CONSTITUENT_PAYMENT_AUTHORIZENET_STATUS', 'True', 'Do you want to accept Authorize.net payments?', '6', '0', 'go_cfg_select_option(array(\'True\', \'False\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('Login Username', 'CONSTITUENT_PAYMENT_AUTHORIZENET_LOGIN', 'testing', 'The login username used for the Authorize.net service', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('Transaction Key', 'CONSTITUENT_PAYMENT_AUTHORIZENET_TXNKEY', 'Test', 'Transaction Key used for encrypting TP data', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('Transaction Mode', 'CONSTITUENT_PAYMENT_AUTHORIZENET_TESTMODE', 'Test', 'Transaction mode used for processing orders', '6', '0', 'go_cfg_select_option(array(\'Test\', \'Production\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('Transaction Method', 'CONSTITUENT_PAYMENT_AUTHORIZENET_METHOD', 'Crchange Card', 'Transaction method used for processing orders', '6', '0', 'go_cfg_select_option(array(\'Crchange Card\', \'eCheck\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('Customer Notifications', 'CONSTITUENT_PAYMENT_AUTHORIZENET_EMAIL_ATTENDEE', 'False', 'Should Authorize.Net e-mail a receipt to the attendee?', '6', '0', 'go_cfg_select_option(array(\'True\', \'False\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('Sort order of display.', 'CONSTITUENT_PAYMENT_AUTHORIZENET_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'CONSTITUENT_PAYMENT_AUTHORIZENET_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, use_function, date_added) values ('Set Order Status', 'CONSTITUENT_PAYMENT_AUTHORIZENET_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'go_cfg_pull_down_order_statuses(', 'go_get_order_status_name', now())");
    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
    function keys() {
      return array('CONSTITUENT_PAYMENT_AUTHORIZENET_STATUS', 'CONSTITUENT_PAYMENT_AUTHORIZENET_LOGIN', 'CONSTITUENT_PAYMENT_AUTHORIZENET_TXNKEY', 'CONSTITUENT_PAYMENT_AUTHORIZENET_TESTMODE', 'CONSTITUENT_PAYMENT_AUTHORIZENET_METHOD', 'CONSTITUENT_PAYMENT_AUTHORIZENET_EMAIL_ATTENDEE', 'CONSTITUENT_PAYMENT_AUTHORIZENET_ZONE', 'CONSTITUENT_PAYMENT_AUTHORIZENET_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_AUTHORIZENET_SORT_ORDER');
    }
  }
?>
