<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php  
  class ot_cod_fee {
    var $title, $output;
    function ot_cod_fee() {
      $this->code = 'ot_cod_fee';
      $this->title = CONSTITUENT_ORDER_TOTAL_COD_TITLE;
      $this->description = CONSTITUENT_ORDER_TOTAL_COD_DESCRIPTION;
      $this->enabled = ((CONSTITUENT_ORDER_TOTAL_COD_STATUS == 'true') ? true : false);
      $this->sort_order = CONSTITUENT_ORDER_TOTAL_COD_SORT_ORDER;
      $this->output = array();
    }
    function process() {
      global $order, $currencies, $cod_cost, $cod_land, $shipping;
      if (CONSTITUENT_ORDER_TOTAL_COD_STATUS == 'true') { 
        $cod_land = false; 
        if ($GLOBALS['payment'] == 'cod') { 
          if ($free_shipping='true') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_DP);
          if ($shipping['id'] == 'flat_flat') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_FLAT);
          if ($shipping['id'] == 'item_item') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_ITEM);
          if ($shipping['id'] == 'table_table') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_TABLE);
          if ($shipping['id'] == 'zones_zones') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_ZONES);
          if ($shipping['id'] == 'ap_ap') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_AP);
          if ($shipping['id'] == 'dp_dp') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_FEE_DP);
          if ($shipping['id'] == 'indvship_indvship') $cod_zones = preg_split("/[:,]/", CONSTITUENT_ORDER_TOTAL_COD_INDVSHIP);
            for ($i = 0; $i < count($cod_zones); $i++) {
            if ($cod_zones[$i] == $order->billing['land']['iso_code_2']) {
                  $cod_cost = $cod_zones[$i + 1];
                  $cod_land = true; 
                  break;
                } elseif ($cod_zones[$i] == '00') {
                  $cod_cost = $cod_zones[$i + 1];
                  $cod_land = true; 
                  break;
                } else { 
                }
              $i++;
            }
          } else { 
          }
        if ($cod_land) {
          if (CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS > 0) {
            $cod_tax = go_get_tax_rate(CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS, $order->billing['land']['id'], $order->billing['zone_id']);
            $cod_tax_description = go_get_tax_description(CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS, $order->billing['land']['id'], $order->billing['zone_id']);
            $order->info['tax'] += go_calculate_tax($cod_cost, $cod_tax);
            $order->info['tax_groups']["$cod_tax_description"] += go_calculate_tax($cod_cost, $cod_tax);
            $order->info['total'] += $cod_cost + go_calculate_tax($cod_cost, $cod_tax);
            $this->output[] = array('title' => $this->title . ':',
                                    'text' => $currencies->format(go_add_tax($cod_cost, $cod_tax), true, $order->info['currency'], $order->info['currency_value']),
                                    'value' => go_add_tax($cod_cost, $cod_tax));
            }
        } else {     
        }
      }
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_ORDER_TOTAL_COD_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function keys() {
      return array('CONSTITUENT_ORDER_TOTAL_COD_STATUS', 'CONSTITUENT_ORDER_TOTAL_COD_SORT_ORDER', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_FLAT', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ITEM', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_TABLE', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ZONES', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_AP', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_DP', 'CONSTITUENT_ORDER_TOTAL_COD_INDVSHIP', 'CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS');
    }
    function install() {
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_STATUS_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_STATUS', 'true', 'CONSTITUENT_ORDER_TOTAL_COD_STATUS_DESCRIPTION', '6', '0','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_SORT_ORDER_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_SORT_ORDER', '4', 'CONSTITUENT_ORDER_TOTAL_COD_SORT_ORDER_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_FLAT_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_FLAT', 'AT:3.00,DE:3.58,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_FLAT_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_ITEM_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ITEM', 'AT:3.00,DE:3.58,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ITEM_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_TABLE_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_TABLE', 'AT:3.00,DE:3.58,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_TABLE_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_ZONES_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ZONES', 'CA:4.50,US:3.00,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_ZONES_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_AP_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_AP', 'AT:3.63,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_AP_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_FEE_DP_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_DP', 'DE:3.58,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_FEE_DP_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_INDVSHIP_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_INDVSHIP', 'DE:3.58,00:9.99', 'CONSTITUENT_ORDER_TOTAL_COD_INDVSHIP_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS_TITEL', 'CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS', '0', 'CONSTITUENT_ORDER_TOTAL_COD_TAX_CLASS_DESCRIPTION', '6', '0', 'go_get_tax_class_title', 'go_cfg_pull_down_tax_classes(', now())");
    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>
