<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine groe 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
 class ot_coupon {
var $title, $output;
function ot_coupon() {
	$this->code = 'ot_coupon';
	$this->header = CONSTITUENT_ORDER_TOTAL_COUPON_HEADER;
	$this->title = CONSTITUENT_ORDER_TOTAL_COUPON_TITLE;
	$this->description = CONSTITUENT_ORDER_TOTAL_COUPON_DESCRIPTION;
	$this->user_prompt = '';
	$this->enabled = CONSTITUENT_ORDER_TOTAL_COUPON_STATUS;
	$this->sort_order = CONSTITUENT_ORDER_TOTAL_COUPON_SORT_ORDER;
	$this->include_shipping = CONSTITUENT_ORDER_TOTAL_COUPON_INC_SHIPPING;
	$this->include_tax = CONSTITUENT_ORDER_TOTAL_COUPON_INC_TAX;
	$this->calculate_tax = CONSTITUENT_ORDER_TOTAL_COUPON_CALC_TAX;
	$this->tax_class = CONSTITUENT_ORDER_TOTAL_COUPON_TAX_CLASS;
	$this->crchange_class = true;
	$this->output = array();
}
function process() {
global $PHP_SELF, $order, $currencies, $cc_id;
	$order_total=$this->get_order_total();
	$od_amount = $this->calculate_crchange($order_total);
	$tod_amount = 0.0; 
	$this->deduction = $od_amount;
	if ($this->calculate_tax != 'None') { 
		$tod_amount = $this->calculate_tax_deduction($order_total, $this->deduction, $this->calculate_tax);
	}
	if ($od_amount > 0) {
		
		$order->info['total'] = $order->info['total'] - $od_amount;
		$this->output[] = array('title' => $this->title . ':' . $this->coupon_code .':','text' => '<b>-' . $currencies->format($od_amount) . '</b>', 'value' => $od_amount); 
	}
	elseif($this->coupon_code != ""){
		$this->output[] = array('title' => CART_COUPON . '<a href="javascript:couponpopupWindow(\'' . go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_56], 'bigID=' . $cc_id) . '\')">' . CART_COUPON_INFO . '</a>','text' => ''); 
		}
}
function selection_test() {
	return false;
}
function pre_confirmation_check($order_total) {
global $attendee_id;
	return $this->calculate_crchange($order_total);
}
function use_crchange_amount() {
	return $output_string;
}
function crchange_selection() {
global $attendee_id, $currencies, $language, $couponjavascript;
	$selection_string = '';
	$selection_string .= '<tr>' . "\n";
	$selection_string .= ' <td width="10">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') .'</td>';
	$selection_string .= ' <td class="main">' . "\n";
	$picture_submit = '<input type="image" name="submit_redeem" onClick="submitFunction()" src="' . FOLDER_RELATIV_LANG_TEMPLATES . $language . '/picture/buttons/button_redeem.gif" border="0" alt="' . PICTURE_REDEEM_VOUCHER . '" title = "' . PICTURE_REDEEM_VOUCHER . '">';
	$selection_string .= TEXT_ENTER_COUPON_CODE . $couponjavascript . go_fetch_inputfeld('gv_redeem_code') . '</td>';
	$selection_string .= ' <td align="right">' . $picture_submit . '</td>';	
	$selection_string .= ' <td width="10">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>';
	$selection_string .= '</tr>' . "\n";
	return $selection_string;
}
function collect_posts() {
global $_POST, $attendee_id, $currencies, $cc_id;
	if ($_POST['gv_redeem_code']) { 
	$coupon_query=go_db_query("select coupon_id, coupon_amount, coupon_type, coupon_minimum_order,uses_per_coupon, uses_per_user, restrict_to_items,restrict_to_categories from " . DB_TBL_COUPONS . " where coupon_code='".$_POST['gv_redeem_code']."' and coupon_active='Y'");
	$coupon_result=go_db_fetch_array($coupon_query);
	if ($coupon_result['coupon_type'] != 'G') {
		if (go_db_num_rows($coupon_query)==0) {
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_NO_INVALID_REDEEM_COUPON), 'SSL'));
		}
		$date_query=go_db_query("select coupon_start_date from " . DB_TBL_COUPONS . " where coupon_start_date <= now() and coupon_code='".$_POST['gv_redeem_code']."'");
		if (go_db_num_rows($date_query)==0) {
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_INVALID_STARTDATE_COUPON), 'SSL'));
		}
		$date_query=go_db_query("select coupon_expire_date from " . DB_TBL_COUPONS . " where coupon_expire_date >= now() and coupon_code='".$_POST['gv_redeem_code']."'");
    if (go_db_num_rows($date_query)==0) {
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_INVALID_FINISDATE_COUPON), 'SSL'));
		}
		$coupon_count = go_db_query("select coupon_id from " . DB_TBL_COUPON_REDEEM_TRACK . " where coupon_id = '" . $coupon_result['coupon_id']."'");
		$coupon_count_attendee = go_db_query("select coupon_id from " . DB_TBL_COUPON_REDEEM_TRACK . " where coupon_id = '" . $coupon_result['coupon_id']."' and attendee_id = '" . $attendee_id . "'");
		if (go_db_num_rows($coupon_count)>=$coupon_result['uses_per_coupon'] && $coupon_result['uses_per_coupon'] > 0) {
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_INVALID_USES_COUPON . $coupon_result['uses_per_coupon'] . TIMES ), 'SSL'));
		}
		if (go_db_num_rows($coupon_count_attendee)>=$coupon_result['uses_per_user'] && $coupon_result['uses_per_user'] > 0) {
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_INVALID_USES_USER_COUPON . $coupon_result['uses_per_user'] . TIMES ), 'SSL'));
		}
		if ($coupon_result['coupon_type']=='S') {
			$coupon_amount = $order->info['shipping_cost'];
		} else {
			$coupon_amount = $currencies->format($coupon_result['coupon_amount']) . ' ';
		}
		if ($coupon_result['coupon_type']=='P') $coupon_amount = $coupon_result['coupon_amount'] . '% ';
		if ($coupon_result['coupon_minimum_order']>0) $coupon_amount .= 'on orders greater than ' . $coupon_result['coupon_minimum_order'];
		if (!go_session_is_registered('cc_id')) go_session_register('cc_id'); 
		$cc_id = $coupon_result['coupon_id'];  
	}
	if ($_POST['submit_redeem_coupon_x'] && !$_POST['gv_redeem_code']) go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_NO_REDEEM_CODE), 'SSL'));
	}
}
function calculate_crchange($amount) {
global $attendee_id, $order, $cc_id; 
	$od_amount = 0;
	if (isset($cc_id) ) {
		$coupon_query = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_id = '" . $cc_id . "'");
		if (go_db_num_rows($coupon_query) !=0 ) {
			$coupon_result = go_db_fetch_array($coupon_query);
			$this->coupon_code = $coupon_result['coupon_code'];
			$coupon_get = go_db_query("select coupon_amount, coupon_minimum_order, restrict_to_items, restrict_to_categories, coupon_type from " . DB_TBL_COUPONS ." where coupon_code = '". $coupon_result['coupon_code'] . "'");
			$get_result = go_db_fetch_array($coupon_get);
			$c_deduct = $get_result['coupon_amount'];
			if ($get_result['coupon_type']=='S') $c_deduct = $order->info['shipping_cost'];
			if ($get_result['coupon_minimum_order'] <= $this->get_order_total()) {
				if ($get_result['restrict_to_items'] || $get_result['restrict_to_categories']) {
					for ($i=0; $i<sizeof($order->items); $i++) {
						if ($get_result['restrict_to_items']) {
							$pr_ids = preg_split("/[,]/", $get_result['restrict_to_items']);
							for ($ii = 0; $ii < count($pr_ids); $ii++) {
								if ($pr_ids[$ii] == go_get_prid($order->items[$i]['id'])) {
									if ($get_result['coupon_type'] == 'P') {
											  
											$pr_c = $this->item_price($pr_ids[$ii]); 
											$pod_amount = round($pr_c*10)/10*$c_deduct/100;
											$od_amount = $od_amount + $pod_amount;
										} else {
											$od_amount = $c_deduct;
										}
									}
								}
							} else {
								$cat_ids = preg_split("/[,]/", $get_result['restrict_to_categories']);
								for ($i=0; $i<sizeof($order->items); $i++) {
									$my_path = go_get_item_path(go_get_prid($order->items[$i]['id']));
									$sub_cat_ids = preg_split("/[_]/", $my_path);
									for ($iii = 0; $iii < count($sub_cat_ids); $iii++) {
										for ($ii = 0; $ii < count($cat_ids); $ii++) {
											if ($sub_cat_ids[$iii] == $cat_ids[$ii]) {
												if ($get_result['coupon_type'] == 'P') {
													   
													$pr_c = $this->item_price(go_get_prid($order->items[$i]['id'])); 
													$pod_amount = round($pr_c*10)/10*$c_deduct/100;
													$od_amount = $od_amount + $pod_amount;
												} else {
													$od_amount = $c_deduct;
												}
											}
										}
									}
								}
							}
						}
					} else {
						if ($get_result['coupon_type'] !='P') {
							$od_amount = $c_deduct;
						} else {
							$od_amount = $amount * $get_result['coupon_amount'] / 100;
						}
					}
				}
			}
		if ($od_amount>$amount) $od_amount = $amount;
		}
	return $od_amount;
}
function calculate_tax_deduction($amount, $od_amount, $method) {
global $attendee_id, $order, $cc_id, $cart; 
	$coupon_query = go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_id = '" . $cc_id . "'");
	if (go_db_num_rows($coupon_query) !=0 ) {
		$coupon_result = go_db_fetch_array($coupon_query);
		$coupon_get = go_db_query("select coupon_amount, coupon_minimum_order, restrict_to_items, restrict_to_categories, coupon_type from " . DB_TBL_COUPONS . " where coupon_code = '". $coupon_result['coupon_code'] . "'");
		$get_result = go_db_fetch_array($coupon_get);
		if ($get_result['coupon_type'] != 'S') { 
			if ($get_result['restrict_to_items'] || $get_result['restrict_to_categories']) {         
				$items = $cart->get_items();
				$valid_item = false;
				for ($i=0; $i<sizeof($items); $i++) {
				$valid_item = false;
					$t_prid = go_get_prid($items[$i]['id']);
					$cc_query = go_db_query("select items_tax_class_id from " . DB_TBL_ITEMS . " where items_id = '" . $t_prid . "'");
					$cc_result = go_db_fetch_array($cc_query);
					if ($get_result['restrict_to_items']) {
						$pr_ids = preg_split("/[,]/", $get_result['restrict_to_items']);
						for ($p = 0; $p < sizeof($pr_ids); $p++) {
							if ($pr_ids[$p] == $t_prid) $valid_item = true;
						}
					}
					if ($get_result['restrict_to_categories']) {
						$cat_ids = preg_split("/[,]/", $get_result['restrict_to_categories']);
						for ($c = 0; $c < sizeof($cat_ids); $c++) {
							$cat_query = go_db_query("select items_id from items_to_categories where items_id = '" . $items_id . "' and categories_id = '" . $cat_ids[$i] . "'");
							if (go_db_num_rows($cat_query) !=0 ) $valid_item = true;
						}
					}
					if ($valid_item) {
						$price_excl_vat = $items[$i]['final_price'] * $items[$i]['quantity']; 
						$price_incl_vat = $this->item_price($t_prid); 
						$valid_array[] = array('item_id' => $t_prid, 'items_price' => $price_excl_vat, 'items_tax_class' => $cc_result['items_tax_class_id']);  
						$total_price += $price_excl_vat; 
					}
				}
				if (sizeof($valid_array) > 0) { 
					if ($get_result['coupon_type'] == 'P') {
						$ratio = $get_result['coupon_amount']/100;
					} else {
						$ratio = $od_amount / $total_price;
					}
					if ($get_result['coupon_type'] == 'S') $ratio = 1;
					if ($method=='Crchange Note') {
						$tax_rate = go_get_tax_rate($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
						$tax_desc = go_get_tax_description($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
						if ($get_result['coupon_type'] == 'P') {
							$tod_amount = $od_amount / (100 + $tax_rate)* $tax_rate;
						} else {
							$tod_amount = $order->info['tax_groups'][$tax_desc] * $od_amount/100;
						}
						$order->info['tax_groups'][$tax_desc] -= $tod_amount;
						$order->info['total'] -= $tod_amount; 
						$order->info['tax'] -= $tod_amount; 
					} else {
						for ($p=0; $p<sizeof($valid_array); $p++) {
							$tax_rate = go_get_tax_rate($valid_array[$p]['items_tax_class'], $order->delivery['land']['id'], $order->delivery['zone_id']);
							$tax_desc = go_get_tax_description($valid_array[$p]['items_tax_class'], $order->delivery['land']['id'], $order->delivery['zone_id']);
							if ($tax_rate > 0) { 
								$tod_amount = ($valid_array[$p]['items_price'] * $tax_rate)/100 * $ratio; 
								$order->info['tax_groups'][$tax_desc] -= ($valid_array[$p]['items_price'] * $tax_rate)/100 * $ratio;
								$order->info['total'] -= ($valid_array[$p]['items_price'] * $tax_rate)/100 * $ratio; 
								$order->info['tax'] -= ($valid_array[$p]['items_price'] * $tax_rate)/100 * $ratio; 
							}
						}
					}
				} 
			} else {
				if ($get_result['coupon_type'] =='F') {
					$tod_amount = 0;
					if ($method=='Crchange Note') {
						$tax_rate = go_get_tax_rate($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
						$tax_desc = go_get_tax_description($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
						$tod_amount = $od_amount / (100 + $tax_rate)* $tax_rate;
						$order->info['tax_groups'][$tax_desc] -= $tod_amount;
					} else { 
						reset($order->info['tax_groups']);
						while (list($key, $value) = each($order->info['tax_groups'])) {
							$ratio1 = $od_amount/($amount-$order->info['tax_groups'][$key]); 
							$tax_rate = go_get_tax_rate_from_desc($key);
							$net = $tax_rate * $order->info['tax_groups'][$key];
							if ($net>0) {
								$god_amount = $order->info['tax_groups'][$key] * $ratio1;
								$tod_amount += $god_amount;
								$order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
							}
						}
					}
					$order->info['total'] -= $tod_amount; 
					$order->info['tax'] -= $tod_amount; 
			}
			if ($get_result['coupon_type'] =='P') {
				$tod_amount=0;
				if ($method=='Crchange Note') {
					$tax_desc = go_get_tax_description($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
					$tod_amount = $order->info['tax_groups'][$tax_desc] * $od_amount/100;
					$order->info['tax_groups'][$tax_desc] -= $tod_amount;
				} else {
					reset($order->info['tax_groups']);
					while (list($key, $value) = each($order->info['tax_groups'])) {
						$god_amout=0;
						$tax_rate = go_get_tax_rate_from_desc($key);
						$net = $tax_rate * $order->info['tax_groups'][$key];
						if ($net>0) {
							$god_amount = $order->info['tax_groups'][$key] * $get_result['coupon_amount']/100;
							$tod_amount += $god_amount;
							$order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
						}
					}
				}
				$order->info['total'] -= $tod_amount; 
				$order->info['tax'] -= $tod_amount;
			}
		}
	}
}
return $tod_amount;
}
function update_crchange_member($i) {
	return false;
}
function apply_crchange() {
global $insert_id, $attendee_id, $REMOTE_ADDR, $cc_id; 
	if ($this->deduction !=0) {
		go_db_query("insert into " . DB_TBL_COUPON_REDEEM_TRACK . " (coupon_id, redeem_date, redeem_ip, attendee_id, order_id) values ('" . $cc_id . "', now(), '" . $REMOTE_ADDR . "', '" . $attendee_id . "', '" . $insert_id . "')");
	}
	go_session_unregister('cc_id');
}
function get_order_total() {
global $order, $cart, $attendee_id, $cc_id; 
	$order_total = $order->info['total']; 
	$items = $cart->get_items();
	for ($i=0; $i<sizeof($items); $i++) {
		$t_prid = go_get_prid($items[$i]['id']);
		$gv_query = go_db_query("select items_price, items_tax_class_id, items_model from " . DB_TBL_ITEMS . " where items_id = '" . $t_prid . "'");
		$gv_result = go_db_fetch_array($gv_query);
		if (preg_match('/^GIFT/', addslashes($gv_result['items_model']))) {
			$qty = $cart->get_quantity($t_prid);
			$items_tax = go_get_tax_rate($gv_result['items_tax_class_id']);
			if ($this->include_tax =='false') {
				$gv_amount = $gv_result['items_price'] * $qty;
			} else {
				$gv_amount = ($gv_result['items_price'] + go_calculate_tax($gv_result['items_price'],$items_tax)) * $qty;
			}
			$order_total=$order_total - $gv_amount;
		}
	}
	if ($this->include_tax == 'false') $order_total=$order_total-$order->info['tax'];
	if ($this->include_shipping == 'false') $order_total=$order_total-$order->info['shipping_cost'];   
	$coupon_query=go_db_query("select coupon_code from " . DB_TBL_COUPONS . " where coupon_id='".$cc_id."'");
	if (go_db_num_rows($coupon_query) !=0) {
		$coupon_result=go_db_fetch_array($coupon_query);
		$coupon_get=go_db_query("select coupon_amount, coupon_minimum_order,restrict_to_items,restrict_to_categories, coupon_type from " . DB_TBL_COUPONS . " where coupon_code='".$coupon_result['coupon_code']."'");
		$get_result=go_db_fetch_array($coupon_get);
		$in_cat = true;
		if ($get_result['restrict_to_categories']) {
			$cat_ids = preg_split("/[,]/", $get_result['restrict_to_categories']);
			$in_cat=false;
			for ($i = 0; $i < count($cat_ids); $i++) {
				if (is_array($this->contents)) {
					reset($this->contents);
					while (list($items_id, ) = each($this->contents)) {
						$cat_query = go_db_query("select items_id from items_to_categories where items_id = '" . $items_id . "' and categories_id = '" . $cat_ids[$i] . "'");
						if (go_db_num_rows($cat_query) !=0 ) {
							$in_cat = true;
							$total_price += $this->get_item_price($items_id);
						}
					}
				}
			}
		}
		$in_cart = true;
		if ($get_result['restrict_to_items']) {
			$pr_ids = preg_split("/[,]/", $get_result['restrict_to_items']);
			$in_cart=false;
			$items_array = $cart->get_items();
			for ($i = 0; $i < sizeof($pr_ids); $i++) {
				for ($ii = 1; $ii<=sizeof($items_array); $ii++) {
					if (go_get_prid($items_array[$ii-1]['id']) == $pr_ids[$i]) {
						$in_cart=true;
						$total_price += $this->get_item_price($items_array[$ii-1]['id']);
					}
				}
			}
			$order_total = $total_price;
		}
	}
return $order_total;
}
function get_item_price($item_id) {
global $cart, $order;
	$items_id = go_get_prid($item_id); 
	$qty = $cart->contents[$item_id]['qty'];
	$item_query = go_db_query("select items_id, items_price, items_tax_class_id, items_weight from " . DB_TBL_ITEMS . " where items_id='" . $item_id . "'");
	if ($item = go_db_fetch_array($item_query)) {
		$prid = $item['items_id'];
		$items_tax = go_get_tax_rate($item['items_tax_class_id']);
		$items_price = $item['items_price'];
		$specials_query = go_db_query("select specials_new_items_price from " . DB_TBL_SPECIALS . " where items_id = '" . $prid . "' and status = '1'");
		if (go_db_num_rows ($specials_query)) {
			$specials = go_db_fetch_array($specials_query);
			$items_price = $specials['specials_new_items_price'];
		}
		if ($this->include_tax == 'true') {
			$total_price += ($items_price + go_calculate_tax($items_price, $items_tax)) * $qty; 
		} else {
			$total_price += $items_price * $qty;
		} 
		if (isset($cart->contents[$item_id]['characteristics'])) {
			reset($cart->contents[$item_id]['characteristics']);
			while (list($option, $value) = each($cart->contents[$item_id]['characteristics'])) {
				$characteristic_price_query = go_db_query("select options_values_price, price_prefix from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_id = '" . $prid . "' and options_id = '" . $option . "' and options_values_id = '" . $value . "'");
				$characteristic_price = go_db_fetch_array($characteristic_price_query);
				if ($characteristic_price['price_prefix'] == '+') {
					if ($this->include_tax == 'true') {
						$total_price += $qty * ($characteristic_price['options_values_price'] + go_calculate_tax($characteristic_price['options_values_price'], $items_tax));
					} else {
						$total_price += $qty * ($characteristic_price['options_values_price']);
					}
				} else {
					if ($this->include_tax == 'true') {
						$total_price -= $qty * ($characteristic_price['options_values_price'] + go_calculate_tax($characteristic_price['options_values_price'], $items_tax));
					} else {
						$total_price -= $qty * ($characteristic_price['options_values_price']);
					}
				}
			}
		}
	}
	if ($this->include_shipping == 'true') {
		$total_price += $order->info['shipping_cost'];
	}
	return $total_price;
}  
function item_price($item_id) {
	$total_price = $this->get_item_price($item_id);
	if ($this->include_shipping == 'true') $total_price -= $order->info['shipping_cost'];
	return $total_price;
} 
function check() {
	if (!isset($this->check)) {
		$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_ORDER_TOTAL_COUPON_STATUS'");
		$this->check = go_db_num_rows($check_query);
	}
	return $this->check;
}
function keys() {
	return array('CONSTITUENT_ORDER_TOTAL_COUPON_STATUS', 'CONSTITUENT_ORDER_TOTAL_COUPON_SORT_ORDER', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_SHIPPING', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_TAX', 'CONSTITUENT_ORDER_TOTAL_COUPON_CALC_TAX', 'CONSTITUENT_ORDER_TOTAL_COUPON_TAX_CLASS');
}
function install() {
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_STATUS_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_STATUS', 'true', 'CONSTITUENT_ORDER_TOTAL_COUPON_STATUS_DESCRIPTION', '6', '1','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_SORT_ORDER_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_SORT_ORDER', '9', 'CONSTITUENT_ORDER_TOTAL_COUPON_SORT_ORDER_DESCRIPTION', '6', '2', now())");
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_INC_SHIPPING_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_SHIPPING_DESCRIPTION', '6', '5', 'go_cfg_select_option(array(\'true\', \'false\'), ', now())");
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_INC_TAX_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_TAX', 'true', 'CONSTITUENT_ORDER_TOTAL_COUPON_INC_TAX_DESCRIPTION', '6', '6','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_CALC_TAX_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_CALC_TAX', 'None', 'CONSTITUENT_ORDER_TOTAL_COUPON_CALC_TAX_DESCRIPTION', '6', '7','go_cfg_select_option(array(\'None\', \'Standard\', \'Crchange Note\'), ', now())");
	go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_COUPON_TAX_CLASS_TITEL', 'CONSTITUENT_ORDER_TOTAL_COUPON_TAX_CLASS', '0', 'CONSTITUENT_ORDER_TOTAL_COUPON_TAX_CLASS_DESCRIPTION', '6', '0', 'go_get_tax_class_title', 'go_cfg_pull_down_tax_classes(', now())");
}
function remove() {
	$keys = '';
	$keys_array = $this->keys();
	for ($i=0; $i<sizeof($keys_array); $i++) {
		$keys .= "'" . $keys_array[$i] . "',";
	}
	$keys = substr($keys, 0, -1);
	go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in (" . $keys . ")");
	}
}
?>
