<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine groe 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
 class ot_gv {
    var $title, $output;
    function ot_gv() {
      $this->code = 'ot_gv';
      $this->title = CONSTITUENT_ORDER_TOTAL_GV_TITLE;
      $this->header = CONSTITUENT_ORDER_TOTAL_GV_HEADER;
      $this->description = CONSTITUENT_ORDER_TOTAL_GV_DESCRIPTION;
      $this->user_prompt = CONSTITUENT_ORDER_TOTAL_GV_USER_PROMPT;
      $this->enabled = CONSTITUENT_ORDER_TOTAL_GV_STATUS;
      $this->sort_order = CONSTITUENT_ORDER_TOTAL_GV_SORT_ORDER;
      $this->include_shipping = CONSTITUENT_ORDER_TOTAL_GV_INC_SHIPPING;
      $this->include_tax = CONSTITUENT_ORDER_TOTAL_GV_INC_TAX;
      $this->calculate_tax = CONSTITUENT_ORDER_TOTAL_GV_CALC_TAX;
      $this->crchange_tax = CONSTITUENT_ORDER_TOTAL_GV_CRCHANGE_TAX;
      $this->tax_class  = CONSTITUENT_ORDER_TOTAL_GV_TAX_CLASS;
      $this->show_redeem_frame = CONSTITUENT_ORDER_TOTAL_GV_REDEEM_FRAME;
      $this->crchange_class = true;
      $this->checkbox = $this->user_prompt . '<input type="checkbox" onClick="submitFunction()" name="' . 'c' . $this->code . '">';
      $this->output = array();
    }
    function process() {
      global $order, $currencies, $cot_gv; 
       if (go_session_is_registered('cot_gv')) {
        $order_total = $this->get_order_total();
        $od_amount = $this->calculate_crchange($order_total);
        if ($this->calculate_tax != "None") {
          $tod_amount = $this->calculate_tax_deduction($order_total, $od_amount, $this->calculate_tax);
          $od_amount = $this->calculate_crchange($order_total);
        }
        $this->deduction = $od_amount;    
        $order->info['total'] = $order->info['total'] - $od_amount;
        if ($od_amount > 0) {
          $this->output[] = array('title' => $this->title . ':',
                           'text' => '<b>' . $currencies->format($od_amount) . '</b>',
                           'value' => $od_amount);
        }
      }
    }
    function selection_test() {
      global $attendee_id;
      if ($this->user_has_gv_member($attendee_id)) {
        return true;
      } else {
        return false;
      }
    }
  function pre_confirmation_check($order_total) {
		global $cot_gv, $order; 
			$od_amount = 0; 
		  if (go_session_is_registered('cot_gv')) {     
	      if ($this->include_tax == 'false') {
					$order_total = $order_total - $order->info['tax'];
				}
  	    if ($this->include_shipping == 'false') {
					$order_total = $order_total - $order->info['shipping_cost'];
				}
				$od_amount = $this->calculate_crchange($order_total);
				if ($this->calculate_tax != "None") {
					$tod_amount = $this->calculate_tax_deduction($order_total, $od_amount, $this->calculate_tax);
					$od_amount = $this->calculate_crchange($order_total)+$tod_amount;
				}
			}
		return $od_amount;
	} 
	 function use_crchange_amount() {
		global $cot_gv; 
      $cot_gv = false;
      if ($this->selection_test()) {
        $output_string .=  '    <td align="right" class="main">';
        $output_string .= '<b>' . $this->checkbox . '</b>' . '</td>' . "\n";
      }
      return $output_string;
    }
    function update_crchange_member($i) {
      global $order, $attendee_id, $insert_id, $REMOTE_ADDR;
      if (preg_match('/^GIFT/', addslashes($order->items[$i]['model']))) {
        $gv_order_amount = ($order->items[$i]['final_price'] * $order->items[$i]['qty']);
        if ($this->crchange_tax=='true') $gv_order_amount = $gv_order_amount * (100 + $order->items[$i]['tax']) / 100; 
        $gv_order_amount = $gv_order_amount * 100 / 100;
        if (CONSTITUENT_ORDER_TOTAL_GV_QUEUE == 'false') { 
          $gv_query=go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $attendee_id . "'");
          $attendee_gv = false;
          $total_gv_amount = 0;
          if ($gv_result = go_db_fetch_array($gv_query)) {
            $total_gv_amount = $gv_result['amount'];
            $attendee_gv = true;
          }
          $total_gv_amount = $total_gv_amount + $gv_order_amount;
          if ($attendee_gv) {
            $gv_update=go_db_query("update " . DB_TBL_COUPON_GV_ATTENDEE . " set amount = '" . $total_gv_amount . "' where attendee_id = '" . $attendee_id . "'");
          } else {
            $gv_insert=go_db_query("insert into " . DB_TBL_COUPON_GV_ATTENDEE . " (attendee_id, amount) values ('" . $attendee_id . "', '" . $total_gv_amount . "')");
          }
        } else { 
          $gv_insert=go_db_query("insert into " . DB_TBL_COUPON_GV_QUEUE . " (attendee_id, order_id, amount, date_created, ipaddr) values ('" . $attendee_id . "', '" . $insert_id . "', '" . $gv_order_amount . "', NOW(), '" . $REMOTE_ADDR . "')");
        }
      }
    }
    function crchange_selection() {
      global $attendee_id, $currencies, $language;
      $selection_string = '';
      $gv_query = go_db_query("select coupon_id from " . DB_TBL_COUPONS . " where coupon_type = 'G' and coupon_active='Y'");
      if (go_db_num_rows($gv_query)) {
        $selection_string .= '<tr>' . "\n";
        $selection_string .= '  <td width="10">' .  go_fetch_dividing_up('tranparentes.gif', '10', '1') .'</td>';
        $selection_string .= '  <td class="main">' . "\n";
        $picture_submit = '<input type="image" name="submit_redeem" onClick="submitFunction()" src="' . FOLDER_RELATIV_LANG_TEMPLATES . $language . '/picture/buttons/button_redeem.gif" border="0" alt="' . PICTURE_REDEEM_VOUCHER . '" title = "' . PICTURE_REDEEM_VOUCHER . '">';
		$selection_string .= TEXT_ENTER_GV_CODE . go_fetch_inputfeld('gv_redeem_code') . '</td>';
        $selection_string .= ' <td align="right">' . $picture_submit . '</td>';
        $selection_string .= '  <td width="10">' . go_fetch_dividing_up('tranparentes.gif', '10', '1') . '</td>';
        $selection_string .= '</tr>' . "\n";
      }
    return $selection_string;
    }
    function apply_crchange() {
      global $order, $attendee_id, $coupon_no, $cot_gv;
      if (go_session_is_registered('cot_gv')) {
        $gv_query = go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $attendee_id . "'");
        $gv_result = go_db_fetch_array($gv_query);
        $gv_payment_amount = $this->deduction;
        $gv_amount = $gv_result['amount'] - $gv_payment_amount;
        $gv_update = go_db_query("update " . DB_TBL_COUPON_GV_ATTENDEE . " set amount = '" . $gv_amount . "' where attendee_id = '" . $attendee_id . "'");
      }
      return $gv_payment_amount;
    }
    function collect_posts() {
      global $currencies, $_POST, $attendee_id, $coupon_no, $REMOTE_ADDR;
      if ($_POST['gv_redeem_code']) {
        $gv_query = go_db_query("select coupon_id, coupon_type, coupon_amount from " . DB_TBL_COUPONS . " where coupon_code = '" . $_POST['gv_redeem_code'] . "'");
        $gv_result = go_db_fetch_array($gv_query);
        if (go_db_num_rows($gv_query) != 0) {
          $redeem_query = go_db_query("select * from " . DB_TBL_COUPON_REDEEM_TRACK . " where coupon_id = '" . $gv_result['coupon_id'] . "'");
          if ( (go_db_num_rows($redeem_query) != 0) && ($gv_result['coupon_type'] == 'G') ) {
            go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_NO_INVALID_REDEEM_GV), 'SSL'));
          }
        }
        if ($gv_result['coupon_type'] == 'G') {
          $gv_amount = $gv_result['coupon_amount'];      
          $gv_amount_query=go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $attendee_id . "'");
          $attendee_gv = false;
          $total_gv_amount = $gv_amount;;
          if ($gv_amount_result = go_db_fetch_array($gv_amount_query)) {
            $total_gv_amount = $gv_amount_result['amount'] + $gv_amount;
            $attendee_gv = true;
          }
          $gv_update = go_db_query("update " . DB_TBL_COUPONS . " set coupon_active = 'N' where coupon_id = '" . $gv_result['coupon_id'] . "'");
          $gv_redeem = go_db_query("insert into  " . DB_TBL_COUPON_REDEEM_TRACK . " (coupon_id, attendee_id, redeem_date, redeem_ip) values ('" . $gv_result['coupon_id'] . "', '" . $attendee_id . "', now(),'" . $REMOTE_ADDR . "')");
          if ($attendee_gv) { 
            $gv_update = go_db_query("update " . DB_TBL_COUPON_GV_ATTENDEE . " set amount = '" . $total_gv_amount . "' where attendee_id = '" . $attendee_id . "'");
          } else { 
            $gv_insert = go_db_query("insert into " . DB_TBL_COUPON_GV_ATTENDEE . " (attendee_id, amount) values ('" . $attendee_id . "', '" . $total_gv_amount . "')");
          }
          go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_REDEEMED_AMOUNT. $currencies->format($gv_amount)), 'SSL'));
       }
     }
     if ($_POST['submit_redeem_x'] && $gv_result['coupon_type'] == 'G') go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'error_message=' . urlencode(ERROR_NO_REDEEM_CODE), 'SSL'));
   }
    function calculate_crchange($amount) {
      global $attendee_id, $order;
      $gv_query=go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $attendee_id . "'");
      $gv_result=go_db_fetch_array($gv_query);
      $gv_payment_amount = $gv_result['amount'];
      $gv_amount = $gv_payment_amount;
      $save_total_cost = $amount;
      $full_cost = $save_total_cost - $gv_payment_amount;
      if ($full_cost <= 0) {
        $full_cost = 0;
        $gv_payment_amount = $save_total_cost;
      }
      return go_round($gv_payment_amount,2);
    }
    function calculate_tax_deduction($amount, $od_amount, $method) {
      global $order;
      switch ($method) {
        case 'Standard':
        $ratio1 = go_round($od_amount / $amount,2);
        $tod_amount = 0;
        reset($order->info['tax_groups']);
        while (list($key, $value) = each($order->info['tax_groups'])) {
          $tax_rate = go_get_tax_rate_from_desc($key);
          $total_net += $tax_rate * $order->info['tax_groups'][$key];
        }
        if ($od_amount > $total_net) $od_amount = $total_net;
        reset($order->info['tax_groups']);
        while (list($key, $value) = each($order->info['tax_groups'])) {
          $tax_rate = go_get_tax_rate_from_desc($key);
          $net = $tax_rate * $order->info['tax_groups'][$key];
          if ($net > 0) {
            $god_amount = $order->info['tax_groups'][$key] * $ratio1;
            $tod_amount += $god_amount;
            $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
          }
        }
        $order->info['tax'] -= $tod_amount;
        $order->info['total'] -= $tod_amount;
        break;
        case 'Crchange Note':
          $tax_rate = go_get_tax_rate($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
          $tax_desc = go_get_tax_description($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
          $tod_amount = $this->deduction / (100 + $tax_rate)* $tax_rate;
          $order->info['tax_groups'][$tax_desc] -= $tod_amount; 
        break;
        default:
      }
      return $tod_amount;
    }
    function user_has_gv_member($c_id) {
      $gv_query = go_db_query("select amount from " . DB_TBL_COUPON_GV_ATTENDEE . " where attendee_id = '" . $c_id . "'");
      if ($gv_result = go_db_fetch_array($gv_query)) {
        if ($gv_result['amount']>0) {
          return true;
        }
      }
      return false;
    }
    function get_order_total() {
      global $order;
      $order_total = $order->info['total'];
      if ($this->include_tax == 'false') $order_total = $order_total - $order->info['tax'];
      if ($this->include_shipping == 'false') $order_total = $order_total - $order->info['shipping_cost'];
      return $order_total;
    }
    function check() {
      if (!isset($this->check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_ORDER_TOTAL_GV_STATUS'");
        $this->check = go_db_num_rows($check_query);
      }
      return $this->check;
    }
    function keys() {
      return array('CONSTITUENT_ORDER_TOTAL_GV_STATUS', 'CONSTITUENT_ORDER_TOTAL_GV_SORT_ORDER', 'CONSTITUENT_ORDER_TOTAL_GV_QUEUE', 'CONSTITUENT_ORDER_TOTAL_GV_INC_SHIPPING', 'CONSTITUENT_ORDER_TOTAL_GV_INC_TAX', 'CONSTITUENT_ORDER_TOTAL_GV_CALC_TAX', 'CONSTITUENT_ORDER_TOTAL_GV_TAX_CLASS', 'CONSTITUENT_ORDER_TOTAL_GV_CRCHANGE_TAX');
    }
    function install() {
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_STATUS_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_STATUS', 'true', 'CONSTITUENT_ORDER_TOTAL_GV_STATUS_DESCRIPTION', '6', '1','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_SORT_ORDER_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_SORT_ORDER', '740', 'CONSTITUENT_ORDER_TOTAL_GV_SORT_ORDER_DESCRIPTION', '6', '2', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_QUEUE_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_QUEUE', 'true', 'CONSTITUENT_ORDER_TOTAL_GV_QUEUE_DESCRIPTION', '6', '3','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_INC_SHIPPING_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_INC_SHIPPING', 'true', 'CONSTITUENT_ORDER_TOTAL_GV_INC_SHIPPING_DESCRIPTION', '6', '5', 'go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_INC_TAX_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_INC_TAX', 'true', 'CONSTITUENT_ORDER_TOTAL_GV_INC_TAX_DESCRIPTION', '6', '6','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_CALC_TAX_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_CALC_TAX', 'None', 'CONSTITUENT_ORDER_TOTAL_GV_CALC_TAX_DESCRIPTION', '6', '7','go_cfg_select_option(array(\'None\', \'Standard\', \'Crchange Note\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_TAX_CLASS_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_TAX_CLASS', '0', 'CONSTITUENT_ORDER_TOTAL_GV_TAX_CLASS_DESCRIPTION', '6', '0', 'go_get_tax_class_title', 'go_cfg_pull_down_tax_classes(', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function ,date_added) values ('CONSTITUENT_ORDER_TOTAL_GV_CRCHANGE_TAX_TITEL', 'CONSTITUENT_ORDER_TOTAL_GV_CRCHANGE_TAX', 'false', 'CONSTITUENT_ORDER_TOTAL_GV_CRCHANGE_TAX_DESCRIPTION', '6', '8','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>
