<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  class ot_tax {
    var $title, $output;
    function ot_tax() {
      $this->code = 'ot_tax';
      $this->title = CONSTITUENT_ORDER_TOTAL_TAX_TITLE;
      $this->description = CONSTITUENT_ORDER_TOTAL_TAX_DESCRIPTION;
      $this->enabled = ((CONSTITUENT_ORDER_TOTAL_TAX_STATUS == 'true') ? true : false);
      $this->sort_order = CONSTITUENT_ORDER_TOTAL_TAX_SORT_ORDER;
      $this->output = array();
    }
    function process() {
      global $order, $currencies;
      reset($order->info['tax_groups']);
      while (list($key, $value) = each($order->info['tax_groups'])) {
        if ($value > 0) {
          $this->output[] = array('title' => $key . ':',
                                  'text' => $currencies->format($value, true, $order->info['currency'], $order->info['currency_value']),
                                  'value' => $value);
        }
      }
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_ORDER_TOTAL_TAX_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function keys() {
      return array('CONSTITUENT_ORDER_TOTAL_TAX_STATUS', 'CONSTITUENT_ORDER_TOTAL_TAX_SORT_ORDER');
    }
    function install() {
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_ORDER_TOTAL_TAX_STATUS_TITEL', 'CONSTITUENT_ORDER_TOTAL_TAX_STATUS', 'true', 'CONSTITUENT_ORDER_TOTAL_TAX_STATUS_DESCRIPTION', '6', '1','go_cfg_select_option(array(\'true\', \'false\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_ORDER_TOTAL_TAX_SORT_ORDER_TITEL', 'CONSTITUENT_ORDER_TOTAL_TAX_SORT_ORDER', '3', 'CONSTITUENT_ORDER_TOTAL_TAX_SORT_ORDER_DESCRIPTION', '6', '2', now())");
    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>
