<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class banktransfer {
	var $code, $title, $description, $enabled; 
	function banktransfer() {
		global $order;
		$this->code = 'banktransfer';
		$this->title = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_TITLE;
		$this->description = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_DESCRIPTION;
		$this->sort_order = CONSTITUENT_PAYMENT_BANKTRANSFER_SORT_ORDER;
		$this->enabled = ((CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS == 'True') ? true : false);
		if ((int)CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID > 0) {
			$this->order_status = CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID;
		}
		if (is_object($order)) $this->update_status();
		if ($_POST['banktransfer_fax'] == "on")
			$this->email_footer = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_EMAIL_FOOTER;
	} 
	function update_status() {
		global $order;
		if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE > 0) ) {
			$check_flag = false;
			$check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
			while ($check = go_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		} 
		if ($this->enabled == true) {
			if ($order->content_type == 'virtual') {
				$this->enabled = true;
			}
		}
	}
	function javascript_validation() {
		$js = 'if (payment_value == "' . $this->code . '") {' . "\n" .
			'  var banktransfer_blz = document.payment_order_way.banktransfer_blz.value;' . "\n" .
			'  var banktransfer_number = document.payment_order_way.banktransfer_number.value;' . "\n" .
			'  var banktransfer_owner = document.payment_order_way.banktransfer_owner.value;' . "\n" .
			'  var banktransfer_fax = document.payment_order_way.banktransfer_fax.checked;' . "\n" .
			'  if (banktransfer_fax == false) {' . "\n" .
			'    if (banktransfer_blz == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_BLZ . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (banktransfer_number == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_NUMBER . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (banktransfer_owner == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_OWNER . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'  }' . "\n" .
			'}' . "\n";
			return $js;
		}
		function selection() {
			global $order, $_POST;
			$selection = array('id' => $this->code,
					'module' => $this->title,
					'fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_NOTE,
							'field' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_INFO),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
							'field' => go_fetch_inputfeld('banktransfer_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
							'field' => go_fetch_inputfeld('banktransfer_blz', '', 'size="8" maxlength="8"')),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
							'field' => go_fetch_inputfeld('banktransfer_number', '', 'size="16" maxlength="32"')),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
							'field' => go_fetch_inputfeld('banktransfer_bankname')),
						array('title' => '',
							'field' => go_fetch_hidden_field('recheckok', $_POST['recheckok']))
						));
			if (CONSTITUENT_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION =='true'){
				$selection['fields'][] = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_NOTE,
						'field' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_NOTE2 . '<a href="' . CONSTITUENT_PAYMENT_BANKTRANSFER_URL_NOTE . '" target="_blank"><b>' . CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_NOTE3 . '</b></a>' . CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_NOTE4);
				$selection['fields'][] = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX,
						'field' => go_fetch_checkbox_field('banktransfer_fax', 'on'));
			}
			return $selection;
		}
		function pre_confirmation_check(){
			global $_POST;
			global $banktransfer_number, $banktransfer_blz;
			if ($_POST['banktransfer_fax'] == false) {
				include(FOLDER_RELATIV_CLASSES . $GLOBALS[CONFIG_NAME_FILE_CLASSES][classes_bigware_1]);
				$banktransfer_validation = new AccountCheck;
				$banktransfer_result = $banktransfer_validation->CheckAccount($banktransfer_number, $banktransfer_blz);
				if ($banktransfer_result > 0 ||  $_POST['banktransfer_owner'] == '') {
					if ($_POST['banktransfer_owner'] == '') {
						$error = 'Name des Kontoinhabers fehlt!';
						$recheckok = '';
					} else {
						switch ($banktransfer_result) {
							case 1: 
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_1;
								$recheckok = 'true';
								break;
							case 2: 
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_2;
								$recheckok = 'true';
								break;
							case 5: 
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_5;
								$recheckok = '';
								break;
							case 8: 
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_8;
								$recheckok = '';
								break;
							case 9: 
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_9;
								$recheckok = '';
								break;
							default:
								$error = CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_4;
								$recheckok = 'true';
								break;
						}
					}
					if ($_POST['recheckok'] != 'true') {
						$payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&banktransfer_owner=' . urlencode($_POST['banktransfer_owner']) . '&banktransfer_number=' . urlencode($_POST['banktransfer_number']) . '&banktransfer_blz=' . urlencode($_POST['banktransfer_blz']) . '&banktransfer_bankname=' . urlencode($_POST['banktransfer_bankname']) . '&recheckok=' . $recheckok;
						go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], $payment_error_return, 'SSL', true, false));
					}
				}
				$this->banktransfer_owner = $_POST['banktransfer_owner'];
				$this->banktransfer_blz = $_POST['banktransfer_blz'];
				$this->banktransfer_number = $_POST['banktransfer_number'];
				$this->banktransfer_prz = $banktransfer_validation->PRZ;
				$this->banktransfer_status = $banktransfer_result;
				if ($banktransfer_validation->Bankname != '')
					$this->banktransfer_bankname = $banktransfer_validation->Bankname;
				else
					$this->banktransfer_bankname = $_POST['banktransfer_bankname'];
			}
		}
		function confirmation() {
			global $_POST, $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_blz, $banktransfer_number, $checkout_form_action, $checkout_form_submit;
			if (!$_POST['banktransfer_owner'] == '') {
				$confirmation = array('title' => $this->title,
						'fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
								'field' => $this->banktransfer_owner),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
								'field' => $this->banktransfer_blz),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
								'field' => $this->banktransfer_number),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
								'field' => $this->banktransfer_bankname)
							));
			}
			if ($_POST['banktransfer_fax'] == "on") {
				$confirmation = array('fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX)));
				$this->banktransfer_fax = "on";
			}
			return $confirmation;
		}
		function process_button() {
			global $_POST;
			$process_button_string = go_fetch_hidden_field('banktransfer_blz', $this->banktransfer_blz) .
				go_fetch_hidden_field('banktransfer_bankname', $this->banktransfer_bankname).
				go_fetch_hidden_field('banktransfer_number', $this->banktransfer_number) .
				go_fetch_hidden_field('banktransfer_owner', $this->banktransfer_owner) .
				go_fetch_hidden_field('banktransfer_status', $this->banktransfer_status) .
				go_fetch_hidden_field('banktransfer_prz', $this->banktransfer_prz) .
				go_fetch_hidden_field('banktransfer_fax', $this->banktransfer_fax);
			return $process_button_string;
		}
		function before_process() {
			return false;
		}
		function after_process() {
			global $insert_id, $_POST, $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_blz, $banktransfer_number, $banktransfer_status, $banktransfer_prz, $banktransfer_fax, $checkout_form_action, $checkout_form_submit;
			go_db_query("INSERT INTO banktransfer (orders_id, banktransfer_blz, banktransfer_bankname, banktransfer_number, banktransfer_owner, banktransfer_status, banktransfer_prz) VALUES ('" . $insert_id . "', '" . $_POST['banktransfer_blz'] . "', '" . $_POST['banktransfer_bankname'] . "', '" . $_POST['banktransfer_number'] . "', '" . $_POST['banktransfer_owner'] ."', '" . $_POST['banktransfer_status'] ."', '" . $_POST['banktransfer_prz'] ."')");
			if ($_POST['banktransfer_fax'])
				go_db_query("update banktransfer set banktransfer_fax = '" . $_POST['banktransfer_fax'] ."' where orders_id = '" . $insert_id . "'");
		}
		function get_error() {
			global $_GET;
			$error = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR,
					'error' => stripslashes(urldecode($_GET['error'])));
			return $error;
		}
		function check() {
			if (!isset($this->_check)) {
				$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS'");
				$this->_check = go_db_num_rows($check_query);
			}
			return $this->_check;
		}
		function install() {
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS', 'True', 'CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS_DESCRIPTION', '6', '1', 'go_cfg_select_option(array(\'True\', \'False\'), ', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SORT_ORDER_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SORT_ORDER', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SORT_ORDER_DESCRIPTION', '6', '0', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, use_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_cfg_pull_down_order_statuses(', 'go_get_order_status_name', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION', 'false', 'CONSTITUENT_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION_DESCRIPTION', '6', '2', 'go_cfg_select_option(array(\'true\', \'false\'), ', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_DATABASE_BLZ_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_DATABASE_BLZ', 'false', 'CONSTITUENT_PAYMENT_BANKTRANSFER_DATABASE_BLZ_DESCRIPTION', '6', '0', 'go_cfg_select_option(array(\'true\', \'false\'), ', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_URL_NOTE_TITEL', 'CONSTITUENT_PAYMENT_BANKTRANSFER_URL_NOTE', 'fax.html', 'CONSTITUENT_PAYMENT_BANKTRANSFER_URL_NOTE_DESCRIPTION', '6', '0', now())");
			go_db_query("CREATE TABLE IF NOT EXISTS banktransfer (orders_id int(11) NOT NULL default '0', banktransfer_owner varchar(64) default NULL, banktransfer_number varchar(24) default NULL, banktransfer_bankname varchar(64) default NULL, banktransfer_blz varchar(8) default NULL, banktransfer_status int(11) default NULL, banktransfer_prz char(2) default NULL, banktransfer_fax char(2) default NULL, KEY orders_id(orders_id))");
		}
		function remove() {
			go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
		}
		function keys() {
			return array('CONSTITUENT_PAYMENT_BANKTRANSFER_STATUS', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ZONE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SORT_ORDER', 'CONSTITUENT_PAYMENT_BANKTRANSFER_DATABASE_BLZ', 'CONSTITUENT_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION', 'CONSTITUENT_PAYMENT_BANKTRANSFER_URL_NOTE');
		}
	}
?>
