<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2012 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2012	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class banktransfer_sepa {
	var $code, $title, $description, $enabled; 
	function banktransfer_sepa() {
		global $order;
		$this->code = 'banktransfer_sepa';
		$this->title = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_TITLE;
		$this->description = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_DESCRIPTION;
		$this->sort_order = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_SORT_ORDER;
		$this->enabled = ((CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS == 'True') ? true : false);
		if ((int)CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID > 0) {
			$this->order_status = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID;
		}
		if (is_object($order)) $this->update_status();
		if ($_POST['banktransfer_sepa_fax'] == "on")
			$this->email_footer = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_EMAIL_FOOTER;
	} 
	function update_status() {
		global $order;
		if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE > 0) ) {
			$check_flag = false;
			$check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
			while ($check = go_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		} 
		if ($this->enabled == true) {
			if ($order->content_type == 'virtual') {
				$this->enabled = true;
			}
		}
	}
	function javascript_validation() {
		$js = 'if (payment_value == "' . $this->code . '") {' . "\n" .
			'  var banktransfer_sepa_iban = document.payment_order_way.banktransfer_sepa_iban.value;' . "\n" .
			'  var banktransfer_sepa_bic = document.payment_order_way.banktransfer_sepa_bic.value;' . "\n" .
			'  var banktransfer_sepa_owner = document.payment_order_way.banktransfer_sepa_owner.value;' . "\n" .
			'  var banktransfer_sepa_fax = document.payment_order_way.banktransfer_sepa_fax.checked;' . "\n" .
			'  if (banktransfer_sepa_fax == false) {' . "\n" .
			'    if (banktransfer_sepa_iban == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_SEPA_IBAN . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (banktransfer_sepa_bic == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_SEPA_BIC . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (banktransfer_sepa_owner == "") {' . "\n" .
			'      error_message = error_message + "' . JS_BANK_SEPA_OWNER . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'  }' . "\n" .
			'}' . "\n";
			return $js;
		}
		function selection() {
			global $order, $_POST;
			$selection = array('id' => $this->code,
					'module' => $this->title,
					'fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_NOTE,
							'field' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_INFO),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_OWNER,
							'field' => go_fetch_inputfeld('banktransfer_sepa_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_IBAN,
							'field' => go_fetch_inputfeld('banktransfer_sepa_iban', '', 'size="25" maxlength="34"')),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_BIC,
							'field' => go_fetch_inputfeld('banktransfer_sepa_bic', '', 'size="11" maxlength="11"')),
						array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_NAME,
							'field' => go_fetch_inputfeld('banktransfer_sepa_bankname')),
						array('title' => '',
							'field' => go_fetch_hidden_field('recheckok', $_POST['recheckok']))
						));
			if (CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_FAX_CONFIRMATION =='true'){
				$selection['fields'][] = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_NOTE,
						'field' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_NOTE2 . '<a href="' . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_URL_NOTE . '" target="_blank"><b>' . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_NOTE3 . '</b></a>' . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_NOTE4);
				$selection['fields'][] = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_FAX,
						'field' => go_fetch_checkbox_field('banktransfer_sepa_fax', 'on'));
			}
			return $selection;
		}
		function pre_confirmation_check(){
			global $_POST;
			global $banktransfer_sepa_owner, $banktransfer_sepa_iban, $banktransfer_sepa_bic, $banktransfer_sepa_bankname;
			$error = '';
			if ($_POST['banktransfer_sepa_fax'] == false) {
				if (!empty($banktransfer_sepa_owner) && !empty($banktransfer_sepa_iban)  && !empty($banktransfer_sepa_bic)) {
					require_once(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . 'php-iban.php');
					if (!verify_iban($banktransfer_sepa_iban)) {
						$error = CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_ERROR_1;
					}
				} 
				if (empty($banktransfer_sepa_owner)) {
					$error .= (empty($error) ? '' : '. ') . JS_BANK_SEPA_OWNER;
				}
				if (empty($banktransfer_sepa_iban)) {
					$error .= (empty($error) ? '' : '. ') . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_ERROR_9;
				}
				if (empty($banktransfer_sepa_bic) || preg_match('/^([a-zA-Z]){4}([a-zA-Z]){2}([0-9a-zA-Z]){2}([0-9a-zA-Z]{3})?$/', $banktransfer_sepa_bic)===0) {
					$error .= (empty($error) ? '' : '. ') . CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_ERROR_8;
				}
				if (!empty($error)) {
					$recheckok = false;
					$payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&banktransfer_sepa_owner=' . urlencode($banktransfer_sepa_owner) . '&banktransfer_sepa_iban=' . urlencode($banktransfer_sepa_iban) . '&banktransfer_sepa_bic=' . urlencode($banktransfer_sepa_bic) . '&banktransfer_sepa_bankname=' . urlencode($banktransfer_sepa_bankname) . '&recheckok=' . $recheckok;
					go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], $payment_error_return, 'SSL', true, false));
				}
				$this->banktransfer_sepa_bankname = $banktransfer_sepa_bankname;
				$this->banktransfer_sepa_owner    = $banktransfer_sepa_owner;
				$this->banktransfer_sepa_iban     = $banktransfer_sepa_iban;
				$this->banktransfer_sepa_bic      = $banktransfer_sepa_bic;
				$this->banktransfer_sepa_status   = 0;
			}
		}
		function confirmation() {
			global $_POST, $banktransfer_sepa_val, $banktransfer_sepa_owner, $banktransfer_sepa_bankname, $banktransfer_sepa_bic, $banktransfer_sepa_iban, $checkout_form_action, $checkout_form_submit;
			if (!$_POST['banktransfer_sepa_owner'] == '') {
				$confirmation = array('title' => $this->title,
						'fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_OWNER,
								'field' => $this->banktransfer_sepa_owner),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_IBAN,
								'field' => $this->banktransfer_sepa_iban),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_BIC,
								'field' => $this->banktransfer_sepa_bic),
							array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_NAME,
								'field' => $this->banktransfer_sepa_bankname)
							));
			}
			if ($_POST['banktransfer_sepa_fax'] == "on") {
				$confirmation = array('fields' => array(array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_FAX)));
				$this->banktransfer_sepa_fax = "on";
			}
			return $confirmation;
		}
		function process_button() {
			global $_POST;
			$process_button_string = go_fetch_hidden_field('banktransfer_sepa_bankname', $this->banktransfer_sepa_bankname).
				go_fetch_hidden_field('banktransfer_sepa_iban', $this->banktransfer_sepa_iban) .
				go_fetch_hidden_field('banktransfer_sepa_bic', $this->banktransfer_sepa_bic) .
				go_fetch_hidden_field('banktransfer_sepa_owner', $this->banktransfer_sepa_owner) .
				go_fetch_hidden_field('banktransfer_sepa_status', $this->banktransfer_sepa_status) .
				go_fetch_hidden_field('banktransfer_sepa_fax', $this->banktransfer_sepa_fax);
			return $process_button_string;
		}
		function before_process() {
			return false;
		}
		function after_process() {
			global $insert_id, $_POST, $banktransfer_sepa_val, $banktransfer_sepa_owner, $banktransfer_sepa_bankname, $banktransfer_sepa_iban, $banktransfer_sepa_bic, $banktransfer_sepa_status, $banktransfer_sepa_fax, $checkout_form_action, $checkout_form_submit;
			require_once(FOLDER_ABSOLUT_CATALOG . FOLDER_RELATIV_CLASSES . 'php-iban.php');
			go_db_query("INSERT INTO banktransfer_sepa (orders_id, banktransfer_sepa_bankname, banktransfer_sepa_owner, banktransfer_sepa_status, banktransfer_sepa_bic, banktransfer_sepa_iban) VALUES ('" . $insert_id . "', '" . $_POST['banktransfer_sepa_bankname'] . "', '" . $_POST['banktransfer_sepa_owner'] ."', '" . $_POST['banktransfer_sepa_status'] ."', '" . $_POST['banktransfer_sepa_bic'] . "', '" . iban_to_machine_format($_POST['banktransfer_sepa_iban']) . "')");
			if ($_POST['banktransfer_sepa_fax'])
				go_db_query("update banktransfer_sepa set banktransfer_sepa_fax = '" . $_POST['banktransfer_sepa_fax'] ."' where orders_id = '" . $insert_id . "'");
		}
		function get_error() {
			global $_GET;
			$error = array('title' => CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_TEXT_BANK_ERROR,
					'error' => stripslashes(urldecode($_GET['error'])));
			return $error;
		}
		function check() {
			if (!isset($this->_check)) {
				$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS'");
				$this->_check = go_db_num_rows($check_query);
			}
			return $this->_check;
		}
		function install() {
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS', 'True', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS_DESCRIPTION', '6', '1', 'go_cfg_select_option(array(\'True\', \'False\'), ', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_SORT_ORDER_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_SORT_ORDER', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_SORT_ORDER_DESCRIPTION', '6', '0', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, use_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID', '0', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_cfg_pull_down_order_statuses(', 'go_get_order_status_name', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_FAX_CONFIRMATION_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_FAX_CONFIRMATION', 'false', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_FAX_CONFIRMATION_DESCRIPTION', '6', '2', 'go_cfg_select_option(array(\'true\', \'false\'), ', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_URL_NOTE_TITLE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_URL_NOTE', 'fax.html', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_URL_NOTE_DESCRIPTION', '6', '0', now())");
			go_db_query("CREATE TABLE IF NOT EXISTS banktransfer_sepa (orders_id int(11) NOT NULL default '0', banktransfer_sepa_owner varchar(64) NOT NULL default '', banktransfer_sepa_bankname varchar(64) NOT NULL default '', banktransfer_sepa_iban varchar(34) NOT NULL default '', banktransfer_sepa_bic varchar(11) NOT NULL default '', banktransfer_sepa_status int(11) NOT NULL default '0', banktransfer_sepa_fax char(2) NOT NULL default '', KEY orders_id(orders_id))");
		}
		function remove() {
			go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
		}
		function keys() {
			return array('CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_STATUS', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ZONE', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_SORT_ORDER', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_FAX_CONFIRMATION', 'CONSTITUENT_PAYMENT_BANKTRANSFER_SEPA_URL_NOTE');
		}
	}
?>
