<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class cc {
	var $code, $title, $description, $enabled; 
	function cc() {
		global $order;
		$this->code = 'cc';
		$this->title = CONSTITUENT_PAYMENT_CC_TEXT_TITLE;
		$this->description = CONSTITUENT_PAYMENT_CC_TEXT_DESCRIPTION;
		$this->sort_order = CONSTITUENT_PAYMENT_CC_SORT_ORDER; 
		if ( go_get_payment_unallowed($this->code) ) {
			$this->enabled = ((CONSTITUENT_PAYMENT_CC_STATUS == 'True') ? true : false);
		} 
		if ((int)CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID > 0) {
			$this->order_status = CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID;
		}
		if (is_object($order)) $this->update_status();
	} 
	function update_status() {
		global $order;
		if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_CC_ZONE > 0) ) {
			$check_flag = false;
			$check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_CC_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
			while ($check = go_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		}
	}
	function javascript_validation() {
		$js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
			'    var cc_owner = document.payment_order_way.cc_owner.value;' . "\n" .
			'    var cc_number = document.payment_order_way.cc_number.value;' . "\n" .
			'    var cc_code = document.payment_order_way.cc_code.value;' . "\n" .
			'    if (cc_owner == "" || cc_owner.length < ' . CC_OWNER_MIN_LENGTH . ') {' . "\n" .
			'      error_message = error_message + "' . CONSTITUENT_PAYMENT_CC_TEXT_JS_CC_OWNER . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
			'      error_message = error_message + "' . CONSTITUENT_PAYMENT_CC_TEXT_JS_CC_NUMBER . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'    if (cc_code == "" || cc_code.length < 3) {' . "\n" .
			'      error_message = error_message + "' . CONSTITUENT_PAYMENT_CC_TEXT_JS_CC_CODE . '";' . "\n" .
			'      error = 1;' . "\n" .
			'    }' . "\n" .
			'  }' . "\n";
		return $js;
	}
	function selection() {
		global $order;
		for ($i=1; $i<13; $i++) {
			$expires_month[] = array('id' => sprintf('%02d', $i), 'text' => pagadors_strftime('%B',mktime(0,0,0,$i,1,2000)));
		}
		$today = getdate(); 
		for ($i=$today['year']; $i < $today['year']+10; $i++) {
			$expires_year[] = array('id' => pagadors_strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => pagadors_strftime('%Y',mktime(0,0,0,1,1,$i)));
		}
		$selection = array('id' => $this->code,
				'module' => $this->title,
				'fields' => array(array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_OWNER,
						'field' => go_fetch_inputfeld('cc_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
					array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_NUMBER,
						'field' => go_fetch_inputfeld('cc_number')),
					array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_CODE,
						'field' => go_fetch_inputfeld('cc_code')),
					array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_EXPIRES,
						'field' => go_fetch_pull_down_menu('cc_expires_month', $expires_month) . '&nbsp;' . go_fetch_pull_down_menu('cc_expires_year', $expires_year))));
		return $selection;
	}
	function pre_confirmation_check() {
		global $_POST;
		include(FOLDER_RELATIV_CLASSES . $GLOBALS[CONFIG_NAME_FILE_CLASSES][classes_bigware_4]);
		$cc_validation = new cc_validation();
		$result = $cc_validation->validate($_POST['cc_number'], $_POST['cc_expires_month'], $_POST['cc_expires_year']);
		$error = '';
		switch ($result) {
			case -1:
				$error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->cc_number, 0, 4));
				break;
			case -2:
			case -3:
			case -4:
				$error = TEXT_CCVAL_ERROR_INVALID_DATE;
				break;
			case false:
				$error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
				break;
		}
		if ( ($result == false) || ($result < 1) ) {
			$payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&cc_owner=' . urlencode($_POST['cc_owner']) . '&cc_expires_month=' . $_POST['cc_expires_month'] . '&cc_expires_year=' . $_POST['cc_expires_year'];
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], $payment_error_return, 'SSL', true, false));
		}
		$this->cc_card_type = $cc_validation->cc_type;
		$this->cc_card_number = $cc_validation->cc_number;
	}
	function confirmation() {
		global $_POST;
		$confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
				'fields' => array(array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_OWNER,
						'field' => $_POST['cc_owner']),
					array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_NUMBER,
						'field' => substr($this->cc_card_number, 0, 4) . str_repeat('X', (strlen($this->cc_card_number) - 8)) . substr($this->cc_card_number, -4)),
					array('title' => CONSTITUENT_PAYMENT_CC_TEXT_CRCHANGE_CARD_EXPIRES,
						'field' => pagadors_strftime('%B, %Y', mktime(0,0,0,$_POST['cc_expires_month'], 1, '20' . $_POST['cc_expires_year'])))));
		return $confirmation;
	}
	function process_button() {
		global $_POST;
		$process_button_string = go_fetch_hidden_field('cc_owner', $_POST['cc_owner']) .
			go_fetch_hidden_field('cc_expires', $_POST['cc_expires_month'] . $_POST['cc_expires_year']) .
			go_fetch_hidden_field('cc_type', $this->cc_card_type) .
			go_fetch_hidden_field('cc_number', $this->cc_card_number) .
			go_fetch_hidden_field('cc_code', $_POST['cc_code']);
		return $process_button_string;
	}
	function before_process() {
		global $_POST, $order;
		if ( (defined('CONSTITUENT_PAYMENT_CC_EMAIL')) && (go_validate_email(CONSTITUENT_PAYMENT_CC_EMAIL)) ) {
			$len = strlen($_POST['cc_number']);
			$this->cc_middle = substr($_POST['cc_number'], 4, ($len-8));
			$order->info['cc_number'] = substr($_POST['cc_number'], 0, 4) . str_repeat('X', (strlen($_POST['cc_number']) - 8)) . substr($_POST['cc_number'], -4);
		}
	}
	function after_process() {
		global $insert_id;
		if ( (defined('CONSTITUENT_PAYMENT_CC_EMAIL')) && (go_validate_email(CONSTITUENT_PAYMENT_CC_EMAIL)) ) {
			$message = 'Order #' . $insert_id . "\n\n" . 'Middle: ' . $this->cc_middle . "\n\n";

			go_mail('', CONSTITUENT_PAYMENT_CC_EMAIL, 'Extra Order Info: #' . $insert_id, $message, SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS);
		}
	}
	function get_error() {
		global $_GET;
		$error = array('title' => CONSTITUENT_PAYMENT_CC_TEXT_ERROR,
				'error' => stripslashes(urldecode($_GET['error'])));
		return $error;
	}
	function check() {
		if (!isset($this->_check)) {
			$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_CC_STATUS'");
			$this->_check = go_db_num_rows($check_query);
		}
		return $this->_check;
	}
	function install() {
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_CC_STATUS_TITEL', 'CONSTITUENT_PAYMENT_CC_STATUS', 'True', 'CONSTITUENT_PAYMENT_CC_STATUS_DESCRIPTION', '6', '0', '', 'go_cfg_select_option(array(\'True\', \'False\'),', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_CC_EMAIL_TITEL', 'CONSTITUENT_PAYMENT_CC_EMAIL', '', 'CONSTITUENT_PAYMENT_CC_EMAIL_DESCRIPTION', '6', '0', '', '', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_CC_SORT_ORDER_TITEL', 'CONSTITUENT_PAYMENT_CC_SORT_ORDER', '0', 'CONSTITUENT_PAYMENT_CC_SORT_ORDER_DESCRIPTION', '6', '0', '', '', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_CC_ZONE_TITEL', 'CONSTITUENT_PAYMENT_CC_ZONE', '0', 'CONSTITUENT_PAYMENT_CC_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID_TITEL', 'CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID', '0', 'CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_get_order_status_name', 'go_cfg_pull_down_order_statuses(', now())");


	}
	function remove() {
		go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
	}
	function keys() {
		return array('CONSTITUENT_PAYMENT_CC_STATUS', 'CONSTITUENT_PAYMENT_CC_EMAIL', 'CONSTITUENT_PAYMENT_CC_ZONE', 'CONSTITUENT_PAYMENT_CC_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_CC_SORT_ORDER');
	}
}
?>
