<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  class ipayment {
    var $code, $title, $description, $enabled; 
    function ipayment() {
      global $order;
      $this->code = 'ipayment';
      $this->title = CONSTITUENT_PAYMENT_IPAYMENT_TEXT_TITLE;
      $this->description = CONSTITUENT_PAYMENT_IPAYMENT_TEXT_DESCRIPTION;
      $this->sort_order = CONSTITUENT_PAYMENT_IPAYMENT_SORT_ORDER; 
	  if ( go_get_payment_unallowed($this->code) ) {
      	$this->enabled = ((CONSTITUENT_PAYMENT_IPAYMENT_STATUS == 'True') ? true : false);
      } 
      if ((int)CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID > 0) {
        $this->order_status = CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID;
      }
      if (is_object($order)) $this->update_status();
      $this->form_action_url = 'https://ipayment.de/merchant/' . CONSTITUENT_PAYMENT_IPAYMENT_ID . '/processor.php';
    } 
    function update_status() {
      global $order;
      if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_IPAYMENT_ZONE > 0) ) {
        $check_flag = false;
        $check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_IPAYMENT_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
        while ($check = go_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }
    function javascript_validation() {
      $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
            '    var cc_owner = document.payment_order_way.ipayment_cc_owner.value;' . "\n" .
            '    var cc_number = document.payment_order_way.ipayment_cc_number.value;' . "\n" .
            '    if (cc_owner == "" || cc_owner.length < ' . CC_OWNER_MIN_LENGTH . ') {' . "\n" .
            '      error_message = error_message + "' . CONSTITUENT_PAYMENT_IPAYMENT_TEXT_JS_CC_OWNER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '    if (cc_number == "" || cc_number.length < ' . CC_NUMBER_MIN_LENGTH . ') {' . "\n" .
            '      error_message = error_message + "' . CONSTITUENT_PAYMENT_IPAYMENT_TEXT_JS_CC_NUMBER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n";
      return $js;
    }
    function selection() {
      global $order;
      for ($i=1; $i < 13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => pagadors_strftime('%B',mktime(0,0,0,$i,1,2000)));
      }
      $today = getdate(); 
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => pagadors_strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => pagadors_strftime('%Y',mktime(0,0,0,1,1,$i)));
      }
      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'fields' => array(array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_OWNER,
                                                 'field' => go_fetch_inputfeld('ipayment_cc_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'])),
                                           array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_NUMBER,
                                                 'field' => go_fetch_inputfeld('ipayment_cc_number')),
                                           array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_EXPIRES,
                                                 'field' => go_fetch_pull_down_menu('ipayment_cc_expires_month', $expires_month) . '&nbsp;' . go_fetch_pull_down_menu('ipayment_cc_expires_year', $expires_year)),
                                           array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_CHECKNUMBER,
                                                 'field' => go_fetch_inputfeld('ipayment_cc_checkcode', '', 'size="4" maxlength="3"') . '&nbsp;<small>' . CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_CHECKNUMBER_LOCATION . '</small>')));
      return $selection;
    }
    function pre_confirmation_check() {
      global $_POST;
      include(FOLDER_RELATIV_CLASSES . $GLOBALS[CONFIG_NAME_FILE_CLASSES][classes_bigware_4]);
      $cc_validation = new cc_validation();
      $result = $cc_validation->validate($_POST['ipayment_cc_number'], $_POST['ipayment_cc_expires_month'], $_POST['ipayment_cc_expires_year']);
      $error = '';
      switch ($result) {
        case -1:
          $error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->cc_number, 0, 4));
          break;
        case -2:
        case -3:
        case -4:
          $error = TEXT_CCVAL_ERROR_INVALID_DATE;
          break;
        case false:
          $error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
          break;
      }
      if ( ($result == false) || ($result < 1) ) {
        $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&ipayment_cc_owner=' . urlencode($_POST['ipayment_cc_owner']) . '&ipayment_cc_expires_month=' . $_POST['ipayment_cc_expires_month'] . '&ipayment_cc_expires_year=' . $_POST['ipayment_cc_expires_year'] . '&ipayment_cc_checkcode=' . $_POST['ipayment_cc_checkcode'];
        go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], $payment_error_return, 'SSL', true, false));
      }
      $this->cc_card_type = $cc_validation->cc_type;
      $this->cc_card_number = $cc_validation->cc_number;
      $this->cc_expiry_month = $cc_validation->cc_expiry_month;
      $this->cc_expiry_year = $cc_validation->cc_expiry_year;
    }
    function confirmation() {
      global $_POST;
      $confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
                            'fields' => array(array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_OWNER,
                                                    'field' => $_POST['ipayment_cc_owner']),
                                              array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_NUMBER,
                                                    'field' => substr($this->cc_card_number, 0, 4) . str_repeat('X', (strlen($this->cc_card_number) - 8)) . substr($this->cc_card_number, -4)),
                                              array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_EXPIRES,
                                                    'field' => pagadors_strftime('%B, %Y', mktime(0,0,0,$_POST['ipayment_cc_expires_month'], 1, '20' . $_POST['ipayment_cc_expires_year'])))));
      if (go_not_null($_POST['ipayment_cc_checkcode'])) {
        $confirmation['fields'][] = array('title' => CONSTITUENT_PAYMENT_IPAYMENT_TEXT_CRCHANGE_CARD_CHECKNUMBER,
                                          'field' => $_POST['ipayment_cc_checkcode']);
      }
      return $confirmation;
    }
    function process_button() {
      global $_POST, $order, $currencies, $currency;
      switch (CONSTITUENT_PAYMENT_IPAYMENT_CURRENCY) {
        case 'Always EUR':
          $trx_currency = 'EUR';
          break;
        case 'Always USD':
          $trx_currency = 'USD';
          break;
        case 'Either EUR or USD, else EUR':
          if ( ($currency == 'EUR') || ($currency == 'USD') ) {
            $trx_currency = $currency;
          } else {
            $trx_currency = 'EUR';
          }
          break;
        case 'Either EUR or USD, else USD':
          if ( ($currency == 'EUR') || ($currency == 'USD') ) {
            $trx_currency = $currency;
          } else {
            $trx_currency = 'USD';
          }
          break;
      }
      $process_button_string = go_fetch_hidden_field('silent', '1') .
                               go_fetch_hidden_field('trx_paymenttyp', 'cc') .
                               go_fetch_hidden_field('trxuser_id', CONSTITUENT_PAYMENT_IPAYMENT_USER_ID) .
                               go_fetch_hidden_field('trxpassword', CONSTITUENT_PAYMENT_IPAYMENT_PASSWORD) .
                               go_fetch_hidden_field('item_name', SHOP_NAME) .
                               go_fetch_hidden_field('trx_currency', $trx_currency) .
                               go_fetch_hidden_field('trx_amount', number_format($order->info['total'] * 100 * $currencies->get_value($trx_currency), 0, '','')) .
                               go_fetch_hidden_field('cc_expdate_month', $_POST['ipayment_cc_expires_month']) .
                               go_fetch_hidden_field('cc_expdate_year', $_POST['ipayment_cc_expires_year']) .
                               go_fetch_hidden_field('cc_number', $_POST['ipayment_cc_number']) .
                               go_fetch_hidden_field('cc_checkcode', $_POST['ipayment_cc_checkcode']) .
                               go_fetch_hidden_field('addr_name', $_POST['ipayment_cc_owner']) .
                               go_fetch_hidden_field('addr_email', $order->attendee['email_address']) .
                               go_fetch_hidden_field('redirect_url', go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_62], '', 'SSL', true)) .
                               go_fetch_hidden_field('silent_error_url', go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], 'payment_error=' . $this->code . '&ipayment_cc_owner=' . urlencode($_POST['ipayment_cc_owner']), 'SSL', true));
      return $process_button_string;
    }
    function before_process() {
      return false;
    }
    function after_process() {
      return false;
    }
    function get_error() {
      global $_GET;
      $error = array('title' => IPAYMENT_ERROR_HEADING,
                     'error' => ((isset($_GET['error'])) ? stripslashes(urldecode($_GET['error'])) : IPAYMENT_ERROR_MESSAGE));
      return $error;
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_IPAYMENT_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function install() {

			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_STATUS_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_STATUS', 'True', 'CONSTITUENT_PAYMENT_IPAYMENT_STATUS_DESCRIPTION', '6', '1', '', 'go_cfg_select_option(array(\'True\', \'False\'),', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_ID_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_ID', '99999', 'CONSTITUENT_PAYMENT_IPAYMENT_ID_DESCRIPTION', '6', '2', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_USER_ID_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_USER_ID', '99999', 'CONSTITUENT_PAYMENT_IPAYMENT_USER_ID_DESCRIPTION', '6', '3', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_PASSWORD_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_PASSWORD', '0', 'CONSTITUENT_PAYMENT_IPAYMENT_PASSWORD_DESCRIPTION', '6', '4', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_CURRENCY_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_CURRENCY', 'Either EUR or USD, else EUR', 'CONSTITUENT_PAYMENT_IPAYMENT_CURRENCY_DESCRIPTION', '6', '5', '', 'go_cfg_select_option(array(\'Always EUR\', \'Always USD\', \'Either EUR or USD, else EUR\', \'Either EUR or USD, else USD\'),', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_SORT_ORDER_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_SORT_ORDER', '0', 'CONSTITUENT_PAYMENT_IPAYMENT_SORT_ORDER_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_ZONE_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_ZONE', '0', 'CONSTITUENT_PAYMENT_IPAYMENT_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID_TITEL', 'CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID', '0', 'CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_get_order_status_name', 'go_cfg_pull_down_order_statuses(', now())");


    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
    function keys() {
      return array('CONSTITUENT_PAYMENT_IPAYMENT_STATUS', 'CONSTITUENT_PAYMENT_IPAYMENT_ID', 'CONSTITUENT_PAYMENT_IPAYMENT_USER_ID', 'CONSTITUENT_PAYMENT_IPAYMENT_PASSWORD', 'CONSTITUENT_PAYMENT_IPAYMENT_CURRENCY', 'CONSTITUENT_PAYMENT_IPAYMENT_ZONE', 'CONSTITUENT_PAYMENT_IPAYMENT_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_IPAYMENT_SORT_ORDER');
    }
  }
?>
