<?php
/*
  $Id: moneybookers.php,v 1.38 2003/01/28 12:00:00 gbunte_ Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2002 osCommerce

  Released under the GNU General Public License
*/

  class moneybookers {
    var $code, $title, $description, $enabled;
// class constructor
    function moneybookers() {
      global $order;

      $this->code = 'moneybookers';
      $this->title = MODULE_PAYMENT_MONEYBOOKERS_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_MONEYBOOKERS_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_MONEYBOOKERS_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_MONEYBOOKERS_STATUS == 'True') ? true : false);
      
      if ((int)MODULE_PAYMENT_MONEYBOOKERS_ORDER_STATUS_ID > 0) {
      $this->order_status = MODULE_PAYMENT_MONEYBOOKERS_ORDER_STATUS_ID;
      }

      $my_actionurl = 'https://www.moneybookers.com/app/payment.pl';
      if  (strlen(MODULE_PAYMENT_MONEYBOOKERS_REFID) <= '5') {$my_actionurl = $my_actionurl . '?rid=129305' ;}
      else {$my_actionurl = $my_actionurl . '?rid=' . MODULE_PAYMENT_MONEYBOOKERS_REFID ;}
       
      $this->form_action_url = $my_actionurl;
      }

// class methods
    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title);
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return false;
    }

    function process_button() {
      global $order, $currencies, $currency;

      if (MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE == 'Selected Language') {
        $my_language = 'EN';
      } else {
        $my_language = MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE;
      }

      if (MODULE_PAYMENT_MONEYBOOKERS_CURRENCY == 'Selected Currency') {
        $my_currency = $currency;
      } else {
        $my_currency = substr(MODULE_PAYMENT_MONEYBOOKERS_CURRENCY, 5);
      }
      if (!in_array($my_currency, array('EUR', 'USD', 'GBP', 'HKD', 'SGD', 'JPY', 'CAD', 'AUD', 'CHF', 'DKK', 'SEK', 'NOK', 'ILS', 'MYR', 'NZD', 'TWD', 'THB', 'CZK', 'HUF', 'SKK', 'ISK', 'INR'))) {
        $my_currency = 'EUR';
      }

$process_button_string = go_fetch_hidden_field('pay_to_email', MODULE_PAYMENT_MONEYBOOKERS_ID) .
                               go_fetch_hidden_field('language', $my_language) .
                               go_fetch_hidden_field('amount', number_format($order->info['total'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency))) .
                               go_fetch_hidden_field('currency', $my_currency) .
                               go_fetch_hidden_field('detail1_description', STORE_NAME) .
                               go_fetch_hidden_field('detail1_text', 'Order - ' . date('d. M Y - H:i')) .
                               go_fetch_hidden_field('firstname', $order->billing['firstname']) .
                               go_fetch_hidden_field('lastname', $order->billing['lastname'] ) .
                               go_fetch_hidden_field('address', $order->billing['street_address']) .
                               go_fetch_hidden_field('postal_code', $order->billing['postcode']) .
                               go_fetch_hidden_field('city', $order->billing['city']) .
                               go_fetch_hidden_field('country', $order->billing['country']['moneybookers']) .
                               go_fetch_hidden_field('pay_from_email', $order->customer['email_address']) .
                               go_fetch_hidden_field('return', go_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
                               go_fetch_hidden_field('cancel_return', go_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));

      return $process_button_string;
    }

    function before_process() {
      return false;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'MODULE_PAYMENT_MONEYBOOKERS_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_STATUS_TITLE', 'MODULE_PAYMENT_MONEYBOOKERS_STATUS', 'True', 'MODULE_PAYMENT_MONEYBOOKERS_STATUS_DESC', '6', '3', 'go_cfg_select_option(array(\'True\', \'False\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_ID_TITLE', 'MODULE_PAYMENT_MONEYBOOKERS_ID', '', 'MODULE_PAYMENT_MONEYBOOKERS_ID_DESC', '6', '4', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_REFID_TITLE', 'MODULE_PAYMENT_MONEYBOOKERS_REFID', '', 'MODULE_PAYMENT_MONEYBOOKERS_REFID_DESC', '6', '7', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_SORT_ORDER', 'MODULE_PAYMENT_MONEYBOOKERS_SORT_ORDER', '0', 'MODULE_PAYMENT_MONEYBOOKERS_SORT_ORDER_DESC', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_CURRENCY_TITLE', 'MODULE_PAYMENT_MONEYBOOKERS_CURRENCY', 'Selected Currency', 'MODULE_PAYMENT_MONEYBOOKERS_CURRENCY_DESC', '6', '5', 'go_cfg_select_option(array(\'Selected Currency\',\'EUR\', \'USD\', \'GBP\', \'HKD\', \'SGD\', \'JPY\', \'CAD\', \'AUD\', \'CHF\', \'DKK\', \'SEK\', \'NOK\', \'ILS\', \'MYR\', \'NZD\', \'TWD\', \'THB\', \'CZK\', \'HUF\', \'SKK\', \'ISK\', \'INR\'), ', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE_TITLE', 'MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE', 'Selected Language', 'MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE_DESC', '6', '6', 'go_cfg_select_option(array(\'Selected Language\',\'EN\', \'DE\', \'ES\', \'FR\'), ', now())");
    }

    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_MONEYBOOKERS_STATUS', 'MODULE_PAYMENT_MONEYBOOKERS_ID', 'MODULE_PAYMENT_MONEYBOOKERS_REFID', 'MODULE_PAYMENT_MONEYBOOKERS_LANGUAGE', 'MODULE_PAYMENT_MONEYBOOKERS_CURRENCY', 'MODULE_PAYMENT_MONEYBOOKERS_SORT_ORDER');
    }
  }
?>
