<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class paypal {
	var $code, $title, $description, $enabled; 
	function paypal() {
		global $order;
		$this->code = 'paypal';
		$this->title = CONSTITUENT_PAYMENT_PAYPAL_TEXT_TITLE;
		$this->description = CONSTITUENT_PAYMENT_PAYPAL_TEXT_DESCRIPTION;
		$this->sort_order = CONSTITUENT_PAYMENT_PAYPAL_SORT_ORDER; 
		$this->email_footer = MODULE_PAYMENT_PAYPAL_TEXT_EMAIL_FOOTER;
		if ( go_get_payment_unallowed($this->code) ) {
			$this->enabled = ((CONSTITUENT_PAYMENT_PAYPAL_STATUS == 'True') ? true : false);
		} 
		if ((int)CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID > 0) {
			$this->order_status = CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID;
		}
		if (is_object($order)) $this->update_status();
	} 
	function update_status() {
		global $order;
		if ( ($this->enabled == true) && ((int)CONSTITUENT_PAYMENT_PAYPAL_ZONE > 0) ) {
			$check_flag = false;
			$check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_PAYMENT_PAYPAL_ZONE . "' and zone_land_id = '" . $order->billing['land']['id'] . "' order by zone_id");
			while ($check = go_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		}

		# ORDER MINIMUM VALUE
		if ( ($this->enabled == true) && ($order->info['total'] > 0) &&  ((int)CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE > 0) && ((int)$order->info['total'] < (int)CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE) ) {
			$this->enabled = false;
		}

	}
	function javascript_validation() {
		return false;
	}
	function selection() {
		return array('id' => $this->code,
				'module' => $this->title);
	}
	function pre_confirmation_check() {
		return false;
	}
	function confirmation() {
		return array('title' => CONSTITUENT_PAYMENT_PAYPAL_TEXT_DESCRIPTION);
	}
	function process_button() {
		global $order, $currencies, $currency, $languages_id;

		# ORDER MINIMUM VALUE
		if (($order->info['total'] > 0) &&  ((int)CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE > 0) && ($order->info['total'] < (int)CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE) ) {
			$this->enabled = false;
			return "Paypal not allowed.";
		}

		$query_lang_code = go_db_query("select code from ".DB_TBL_LANGUAGES." where languages_id='".$languages_id."'");
		if (go_db_num_rows($query_lang_code)!=0) {
			$lang_code=go_db_result($query_lang_code, 0, 'code');
		} else {
			$lang_code="DE";
		}

		if (CONSTITUENT_PAYMENT_PAYPAL_CURRENCY == 'Selected Currency') {
			$my_currency = $currency;
		} else {
			$my_currency = substr(CONSTITUENT_PAYMENT_PAYPAL_CURRENCY, 5);
		}

		if (!in_array($my_currency, array('CAD', 'EUR', 'GBP', 'JPY', 'USD', 'CHF'))) {
			$my_currency = 'USD';
		}

		$this->form_action_url = 'https://www.paypal.com/cgi-bin/webscr';

		$this->get_variables = http_build_query(array(
			'cmd'           => '_xclick',
			'business'      => CONSTITUENT_PAYMENT_PAYPAL_ID,
			'lc'            => $lang_code,
			'amount'        => number_format(($order->info['total'] - $order->info['shipping_cost']) * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency)),
			'shipping'      => number_format($order->info['shipping_cost'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency)),
			'currency_code' => $my_currency,
			'notify_url'    => go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_20], '', 'SSL'),
			'return'        => go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_20], '', 'SSL'),
			'cancel_return' => go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], '', 'SSL'))
		,'', '&');

		return '';
	}
	function http_build_query( $formdata, $numeric_prefix = null, $key = null ) {
		$res = array();
		foreach ((array)$formdata as $k=>$v) {
			$tmp_key = urlencode(is_int($k) ? $numeric_prefix.$k : $k);
			if ($key) $tmp_key = $key.'['.$tmp_key.']';
			if ( is_array($v) || is_object($v) ) {
				$res[] = http_build_query($v, null, $tmp_key);
			} else {
				$res[] = $tmp_key."=".urlencode($v);
			}
		}
		$separator = ini_get('arg_separator.output');
		return implode($separator, $res);
	}
	function before_process() {
		return false;
	}
	function after_process() {
		return false;
	}
	function output_error() {
		return false;
	}
	function check() {
		if (!isset($this->_check)) {
			$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_PAYMENT_PAYPAL_STATUS'");
			$this->_check = go_db_num_rows($check_query);
		}
		return $this->_check;
	}
	function install() {
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_STATUS_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_STATUS', 'True', 'CONSTITUENT_PAYMENT_PAYPAL_STATUS_DESCRIPTION', '6', '3', '', 'go_cfg_select_option(array(\'True\', \'False\'),', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_ID_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_ID', 'you@yourbusiness.com', 'CONSTITUENT_PAYMENT_PAYPAL_ID_DESCRIPTION', '6', '4', '', '', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_CURRENCY_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_CURRENCY', 'Selected Currency', 'CONSTITUENT_PAYMENT_PAYPAL_CURRENCY_DESCRIPTION', '6', '6', '', 'go_cfg_select_option(array(\'Selected Currency\',\'Only USD\',\'Only CAD\',\'Only EUR\',\'Only GBP\',\'Only JPY\',\'Only CHF\'),', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_SORT_ORDER_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_SORT_ORDER', '0', 'CONSTITUENT_PAYMENT_PAYPAL_SORT_ORDER_DESCRIPTION', '6', '0', '', '', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_ZONE_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_ZONE', '0', 'CONSTITUENT_PAYMENT_PAYPAL_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID', '0', 'CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_get_order_status_name', 'go_cfg_pull_down_order_statuses(', now())");
		go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE_TITEL', 'CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE', '0', 'CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE_DESCRIPTION', '6', '7', '', '', now())");
	}
	function remove() {
		go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
	}
	function keys() {
		return array('CONSTITUENT_PAYMENT_PAYPAL_STATUS', 'CONSTITUENT_PAYMENT_PAYPAL_ID', 'CONSTITUENT_PAYMENT_PAYPAL_CURRENCY', 'CONSTITUENT_PAYMENT_PAYPAL_ZONE', 'CONSTITUENT_PAYMENT_PAYPAL_ORDER_STATUS_ID', 'CONSTITUENT_PAYMENT_PAYPAL_MINIMUM_VALUE', 'CONSTITUENT_PAYMENT_PAYPAL_SORT_ORDER');
	}
}
?>
