<?php
/**
 *
 *
 * @version Sofortberweisung 1.5  18.04.2007
 * @author Henri Schmidhuber  info@in-solution.de
 * @copyright 2006 - 2007 Henri Schmidhuber
 * @link http://www.in-solution.de
 * @link http://www.oscommerce.com
 * @link http://www.sofort-ueberweisung.de
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 ***********************************************************************************
 * this file contains code based on:
 * (c) 2000 - 2001 The Exchange Project
 * (c) 2001 - 2006 osCommerce, Open Source E-Commerce Solutions
 * Released under the GNU General Public License
 ***********************************************************************************
 *
 */

  class sofortueberweisungredirect {
    var $code, $title, $description, $enabled;

// class constructor
    function sofortueberweisungredirect() {
      global $order;

      $this->code = 'sofortueberweisungredirect';
      $this->title = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS == 'True') ? true : false);


      if (is_object($order)) $this->update_status();

      $this->email_footer = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_EMAIL_FOOTER;
      $this->text_redirect = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_REDIRECT;
      $this->form_action_url = 'https://www.sofort-ueberweisung.de/payment.php';
    }

// class methods
    function update_status() {
      global $order, $cart, $cartID;
      // We need the cartID
		  if (!go_session_is_registered('cartID')) go_session_register('cartID');
		  if (empty($cart->cartID)) $cart->cartID = $cart->generate_cart_id();
		  $cartID = $cart->cartID;
      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE > 0) ) {
        $check_flag = false;
        $check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE . "' and zone_land_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = go_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title,
                   'fields' => array(array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION_CHECKOUT_PAYMENT)));
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION_CHECKOUT_CONFIRMATION);
    }

    function process_button() {
     global $order, $cart, $attendees_id, $insert_id, $messageStack, $breadcrumb, $currencies,$cart, $PHP_SELF, $language, $cartID;
      // Fix for osC Bug
      // $order->info['total'] is in 'before_process' String without Tax
      // so it has to be set here
      $_SESSION['sofortueberweisung_total'] = number_format($order->info['total'] * $currencies->get_value('EUR'), 2, '.','');

      $parameter= array();
		  $parameter['kdnr']	= MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR;  // Reprsentiert Ihre Kundennummer bei der Sofortberweisung
		  $parameter['projekt'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT;  // Die verantwortliche Projektnummer bei der Sofortberweisung, zu der die Zahlung gehrt
      $parameter['betrag'] = $_SESSION['sofortueberweisung_total'];  // Beziffert den Zahlungsbetrag, der an Sie bermittelt werden soll
      $vzweck1 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_V_ZWECK_1);
      $vzweck2 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_V_ZWECK_2);

      $vzweck1 = str_replace('{{order_date}}', pagadors_strftime(DATE_FORMAT_SHORT), $vzweck1);
      $vzweck2 = str_replace('{{order_date}}', pagadors_strftime(DATE_FORMAT_SHORT), $vzweck2);

      $vzweck1 = str_replace('{{attendees_id}}', $attendees_id, $vzweck1);
      $vzweck2 = str_replace('{{attendees_id}}', $attendees_id, $vzweck2);

      $vzweck1 = str_replace('{{attendees_name}}', $order->attendees['firstname'] . ' ' . $order->attendees['lastname'], $vzweck1);
      $vzweck2 = str_replace('{{attendees_name}}', $order->attendees['firstname'] . ' ' . $order->attendees['lastname'], $vzweck2);

      $vzweck1 = str_replace('{{attendees_company}}', $order->attendees['company'], $vzweck1);
      $vzweck2 = str_replace('{{attendees_company}}', $order->attendees['company'], $vzweck2);

      $vzweck1 = str_replace('{{attendees_email}}', $order->attendees['email_address'], $vzweck1);
      $vzweck2 = str_replace('{{attendees_email}}', $order->attendees['email_address'], $vzweck2);

      // Krzen auf 27 Zeichen
      $vzweck1 = substr($vzweck1, 0, 27);
      $vzweck2 = substr($vzweck2, 0, 27);

      $parameter['v_zweck_1'] = go_output_string($vzweck1);  // Definieren Sie hier Ihre Verwendungszwecke
      $parameter['v_zweck_2'] = go_output_string($vzweck2);  // Definieren Sie hier Ihre Verwendungszwecke

		  $parameter['kunden_var_0'] = go_output_string($insert_id);  // Eindeutige Identifikation der Zahlung, z.B. Session ID oder Auftragsnummer.
		  $parameter['kunden_var_1'] = go_output_string($attendees_id);
		  $parameter['kunden_var_2'] = go_output_string(go_session_id());
		  $parameter['kunden_var_3'] = go_output_string($cart->cartID);
      $parameter['kunden_var_4'] = '';
      $parameter['kunden_var_5'] = '';
		  // $parameter['Partner'] = '';

		 	if (strlen(MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT) > 0) {
        $tmparray = array(
          $parameter['betrag'],
          $parameter['v_zweck_1'],
          $parameter['v_zweck_2'],
          '', // von_konto_inhaber
          '', // von_konto_nr
          '', // von_konto_blz
          $parameter['kunden_var_0'],
          $parameter['kunden_var_1'],
          $parameter['kunden_var_2'],
          $parameter['kunden_var_3'],
          $parameter['kunden_var_4'],
          $parameter['kunden_var_5'],
          MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT);
		   $parameter['key'] = md5(implode("|", $tmparray));
		  }
		  $process_button_string = '';
      foreach ($parameter as $key => $value) {
        $process_button_string .= go_fetch_hidden_field($key, $value). "\n";
      }
      return $process_button_string;
    }

    function before_process() {
      global $HTTP_GET_VARS, $order, $currencies;
      $md5var4 = md5($HTTP_GET_VARS['sovar3'] . MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT);
      // Statusupdate nur wenn keine Cartnderung vorgenommen
      // Valid returns are i.e. 13.12 or 13,12 changes sometimes
      if ($md5var4 == $HTTP_GET_VARS['sovar4'] && (int)MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID > 0
          && ($HTTP_GET_VARS['betrag'] == number_format($_SESSION['sofortueberweisung_total'], 2, ',', '') || $HTTP_GET_VARS['betrag'] == number_format($_SESSION['sofortueberweisung_total'], 2, '.', '') ) ) {
        $this->order_status = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID;
        $order->info['order_status'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID;
      } else {
        $order->info['comments'] .= "\n" . MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_CHECK_ERROR . '\n' . $HTTP_GET_VARS['betrag'] .'!=' . $_SESSION['sofortueberweisung_total'] ;
      }
      if (MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS == 'True') {
        $order->info['comments'] .= "\n" . serialize($_REQUEST);
      }

      return false;
    }

    function after_process() {
       return false;
    }

    function get_error() {
      global $HTTP_GET_VARS;

      $error = array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_ERROR_HEADING,
                     'error' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_ERROR_MESSAGE);

      return $error;
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {

       // Update Configuration Key Length 64 is too short
      go_db_query('ALTER TABLE ' . DB_TBL_SET_IT_UP . ' CHANGE set_it_up_key set_it_up_key VARCHAR( 255 ) NOT NULL');
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS', 'True', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS_DESCRIPTION', '6', '1', 'go_cfg_select_option(array(\'True\', \'False\'), ', now());");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR', '10000', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR_DESCRIPTION', '6', '1', now());");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT', '500000', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT_DESCRIPTION', '6', '1', now());");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT', 'abcdef', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT_DESCRIPTION', '6', '1', now());");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT', '123456', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT_DESCRIPTION', '6', '1', now());");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER', '0', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER_DESCRIPTION', '6', '0', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE', '0', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE_DESCRIPTION', '6', '2', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID', '0', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID_DESCRIPTION', '6', '0', 'go_cfg_pull_down_order_statuses(', 'go_get_order_status_name', now())");
      go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_DETAILS_TITLE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS', 'False', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_DETAILS_DESCRIPTION', '6', '2', 'go_cfg_select_option(array(\'True\', \'False\'), ', now());");
    }

    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT','MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS');
    }
  }
?>
