<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  class dp {
    var $code, $title, $description, $icon, $enabled, $num_dp; 
    function dp() {
      global $order;
      $this->code = 'dp';
      $this->title = CONSTITUENT_SHIPPING_DP_TEXT_TITLE;
      $this->description = CONSTITUENT_SHIPPING_DP_TEXT_DESCRIPTION;
      $this->sort_order = CONSTITUENT_SHIPPING_DP_SORT_ORDER;
      $this->icon = FOLDER_RELATIV_ICONS . 'shipping_dp.gif';
      $this->tax_class = CONSTITUENT_SHIPPING_DP_TAX_CLASS;
      $this->enabled = ((CONSTITUENT_SHIPPING_DP_STATUS == 'True') ? true : false);
      if ( ($this->enabled == true) && ((int)CONSTITUENT_SHIPPING_DP_ZONE > 0) ) {
        $check_flag = false;
        $check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_SHIPPING_DP_ZONE . "' and zone_land_id = '" . $order->delivery['land']['id'] . "' order by zone_id");
        while ($check = go_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }
        if ($check_flag == false) {
          $this->enabled = false;
        }
      } 
      $this->num_dp = 6;
    } 
    function quote($method = '') {
      global $_POST, $order, $shipping_weight, $shipping_num_frames;
      $dest_land = $order->delivery['land']['iso_code_2'];
      $dest_zone = 0;
      $error = false;
      for ($i=1; $i<=$this->num_dp; $i++) {
        $lands_table = constant('CONSTITUENT_SHIPPING_DP_LANDS_' . $i);
        $land_zones = preg_split("/[,]/", $lands_table);
        if (in_array($dest_land, $land_zones)) {
          $dest_zone = $i;
          break;
        }
      }
      if ($dest_zone == 0) {
        $error = true;
      } else {
        $shipping = -1;
        $dp_cost = constant('CONSTITUENT_SHIPPING_DP_COST_' . $i);
        $dp_table = preg_split("/[:,]/" , $dp_cost);
        for ($i=0; $i<sizeof($dp_table); $i+=2) {
          if ($shipping_weight <= $dp_table[$i]) {
            $shipping = $dp_table[$i+1];
            $shipping_method = CONSTITUENT_SHIPPING_DP_TEXT_WAY . ' ' . $dest_land . ': ';
            break;
          }
        }
        if ($shipping == -1) {
          $shipping_cost = 0;
          $shipping_method = CONSTITUENT_SHIPPING_DP_UNDEFINED_RATE;
        } else {
          $shipping_cost = ($shipping + CONSTITUENT_SHIPPING_DP_HANDLING);
        }
      }
      $this->quotes = array('id' => $this->code,
                            'module' => CONSTITUENT_SHIPPING_DP_TEXT_TITLE,
                            'methods' => array(array('id' => $this->code,
                                                     'title' => $shipping_method . ' (' . $shipping_num_frames . ' x ' . $shipping_weight . ' ' . CONSTITUENT_SHIPPING_DP_TEXT_UNITS .')',
                                                     'cost' => $shipping_cost * $shipping_num_frames)));
      if ($this->tax_class > 0) {
        $this->quotes['tax'] = go_get_tax_rate($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
      }
      if (go_not_null($this->icon)) $this->quotes['icon'] = go_picture($this->icon, $this->title);
      if ($error == true) $this->quotes['error'] = CONSTITUENT_SHIPPING_DP_INVALID_ZONE;
      return $this->quotes;
    }
    function check() {
      if (!isset($this->_check)) {
        $check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_SHIPPING_DP_STATUS'");
        $this->_check = go_db_num_rows($check_query);
      }
      return $this->_check;
    }
    function install() {
	
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_STATUS_TITEL', 'CONSTITUENT_SHIPPING_DP_STATUS', 'True', 'CONSTITUENT_SHIPPING_DP_STATUS_DESCRIPTION', '6', '0', '', 'go_cfg_select_option(array(\'True\', \'False\'),', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_HANDLING_TITEL', 'CONSTITUENT_SHIPPING_DP_HANDLING', '0', 'CONSTITUENT_SHIPPING_DP_HANDLING_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_TAX_CLASS_TITEL', 'CONSTITUENT_SHIPPING_DP_TAX_CLASS', '0', 'CONSTITUENT_SHIPPING_DP_TAX_CLASS_DESCRIPTION', '6', '0', 'go_get_tax_class_title', 'go_cfg_pull_down_tax_classes(', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_ZONE_TITEL', 'CONSTITUENT_SHIPPING_DP_ZONE', '0', 'CONSTITUENT_SHIPPING_DP_ZONE_DESCRIPTION', '6', '0', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_SORT_ORDER_TITEL', 'CONSTITUENT_SHIPPING_DP_SORT_ORDER', '0', 'CONSTITUENT_SHIPPING_DP_SORT_ORDER_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_1_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_1', 'AD,AT,BE,CZ,DK,FO,FI,FR,GR,GL,IE,IT,LI,LU,MC,NL,PL,PT,SM,SK,SE,CH,VA,GB,SP', 'CONSTITUENT_SHIPPING_DP_LANDS_1_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_1_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_1', '5:16.50,10:20.50,20:28.50', 'CONSTITUENT_SHIPPING_DP_COST_1_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_2_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_2', 'AL,AM,AZ,BY,BA,BG,HR,CY,GE,GI,HU,IS,KZ,LT,MK,MT,MD,NO,SI,UA,TR,YU,RU,RO,LV,EE', 'CONSTITUENT_SHIPPING_DP_LANDS_2_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_2_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_2', '5:25.00,10:35.00,20:45.00', 'CONSTITUENT_SHIPPING_DP_COST_2_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_3_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_3', 'DZ,BH,CA,EG,IR,IQ,IL,JO,KW,LB,LY,OM,SA,SY,US,AE,YE,MA,QA,TN,PM', 'CONSTITUENT_SHIPPING_DP_LANDS_3_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_3_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_3', '5:29.00,10:39.00,20:59.00', 'CONSTITUENT_SHIPPING_DP_COST_3_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_4_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_4', 'AF,AS,AO,AI,AG,AR,AW,AU,BS,BD,BB,BZ,BJ,BM,BT,BO,BW,BR,IO,BN,BF,BI,KH,CM,CV,KY,CF,TD,CL,CN,CC,CO,KM,CG,CR,CI,CU,DM,DO,EC,SV,ER,ET,FK,FJ,GF,PF,GA,GM,GH,GD,GP,GT,GN,GW,GY,HT,HN,HK,IN,ID,JM,JP,KE,KI,KG,KP,KR,LA,LS', 'CONSTITUENT_SHIPPING_DP_LANDS_4_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_4_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_4', '5:35.00,10:50.00,20:80.00', 'CONSTITUENT_SHIPPING_DP_COST_4_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_5_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_5', 'MO,MG,MW,MY,MV,ML,MQ,MR,MU,MX,MN,MS,MZ,MM,NA,NR,NP,AN,NC,NZ,NI,NE,NG,PK,PA,PG,PY,PE,PH,PN,RE,KN,LC,VC,SN,SC,SL,SO,LK,SR,SZ,ZA,SG,TG,TH,TZ,TT,TO,TM,TV,VN,WF,VE,UG,UZ,UY,ST,SH,SD,TW,GQ,LR,DJ,CG,RW,ZM,ZW', 'CONSTITUENT_SHIPPING_DP_LANDS_5_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_5_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_5', '5:35.00,10:50.00,20:80.00', 'CONSTITUENT_SHIPPING_DP_COST_5_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_LANDS_6_TITEL', 'CONSTITUENT_SHIPPING_DP_LANDS_6', 'DE', 'CONSTITUENT_SHIPPING_DP_LANDS_6_DESCRIPTION', '6', '0', '', '', now())");
			go_db_query("insert into " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) values ('CONSTITUENT_SHIPPING_DP_COST_6_TITEL', 'CONSTITUENT_SHIPPING_DP_COST_6', '5:6.70,10:9.70,20:13.00', 'CONSTITUENT_SHIPPING_DP_COST_6_DESCRIPTION', '6', '0', '', '', now())");


    }
    function remove() {
      go_db_query("delete from " . DB_TBL_SET_IT_UP . " where set_it_up_key in ('" . implode("', '", $this->keys()) . "')");
    }
    
    function keys() {
      $keys = array('CONSTITUENT_SHIPPING_DP_STATUS', 'CONSTITUENT_SHIPPING_DP_HANDLING', 'CONSTITUENT_SHIPPING_DP_TAX_CLASS', 'CONSTITUENT_SHIPPING_DP_ZONE', 'CONSTITUENT_SHIPPING_DP_SORT_ORDER');
      for ($i = 1; $i <= $this->num_dp; $i ++) {
        $keys[count($keys)] = 'CONSTITUENT_SHIPPING_DP_LANDS_' . $i;
        $keys[count($keys)] = 'CONSTITUENT_SHIPPING_DP_COST_' . $i;
      }
      return $keys;
    }
  }
?>
