<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class indvship {
	var $code, $title, $description, $max_preis, $icon, $enabled; 
	function indvship() {
		global $order;
		$this->code = 'indvship';
		$this->title = CONSTITUENT_SHIPPING_INDVSHIP_TEXT_TITLE;
		$this->description = CONSTITUENT_SHIPPING_INDVSHIP_TEXT_DESCRIPTION;
		$this->sort_order = CONSTITUENT_SHIPPING_INDVSHIP_SORT_ORDER;
		$this->max_preis = CONSTITUENT_SHIPPING_INDVSHIP_MAX_PREIS;
		$this->icon = '';
		$this->tax_class = CONSTITUENT_SHIPPING_INDVSHIP_TAX_CLASS;
		$this->enabled = ((CONSTITUENT_SHIPPING_INDVSHIP_STATUS == 'True') ? true : false); 
		//$this->enabled = CONSTITUENT_SHIPPING_INDVSHIP_STATUS;
		if ( ($this->enabled == true) && ((int)CONSTITUENT_SHIPPING_INDVSHIP_ZONE > 0) ) {
			$check_flag = false;
			$check_query = go_db_query("select zone_id from " . DB_TBL_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . CONSTITUENT_SHIPPING_INDVSHIP_ZONE . "' and zone_land_id = '" . $order->delivery['land']['id'] . "' order by zone_id");
			while ($check = go_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->delivery['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) {
				$this->enabled = false;
			}
		}
	} 
	function quote($method = '') {
		global $order, $cart;
		$shiptotal = $cart->get_shiptotal();
		$this->quotes = array('id' => $this->code,
				'module' => CONSTITUENT_SHIPPING_INDVSHIP_TEXT_TITLE,
				'methods' => array(array('id' => $this->code,
						'title' => CONSTITUENT_SHIPPING_INDVSHIP_TEXT_WAY,
						'cost' => $shiptotal)));
		if ($this->tax_class > 0) {
			$this->quotes['tax'] = go_get_tax_rate($this->tax_class, $order->delivery['land']['id'], $order->delivery['zone_id']);
		}
		if (go_not_null($this->icon)) $this->quotes['icon'] = go_picture($this->icon, $this->title);
		return $this->quotes;
	}
	function check() {
		if (!isset($this->_check)) {
			$check_query = go_db_query("select set_it_up_value from " . DB_TBL_SET_IT_UP . " where set_it_up_key = 'CONSTITUENT_SHIPPING_INDVSHIP_STATUS'");
			$this->_check = go_db_num_rows($check_query);
		}
		return $this->_check;
	}
	function install() {
		go_db_query("INSERT INTO " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) VALUES ('CONSTITUENT_SHIPPING_INDVSHIP_STATUS_TITEL', 'CONSTITUENT_SHIPPING_INDVSHIP_STATUS', 'True', 'CONSTITUENT_SHIPPING_INDVSHIP_STATUS_DESCRIPTION', '6', '0', '', 'go_cfg_select_option(array(\'True\', \'False\'),', now())");
		go_db_query("INSERT INTO " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) VALUES ('CONSTITUENT_SHIPPING_INDVSHIP_TAX_CLASS_TITEL', 'CONSTITUENT_SHIPPING_INDVSHIP_TAX_CLASS', '0', 'CONSTITUENT_SHIPPING_INDVSHIP_TAX_CLASS_DESCRIPTION', '6', '0', 'go_get_tax_class_title', 'go_cfg_pull_down_tax_classes(', now())");
		go_db_query("INSERT INTO " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) VALUES ('CONSTITUENT_SHIPPING_INDVSHIP_ZONE_TITEL', 'CONSTITUENT_SHIPPING_INDVSHIP_ZONE', '0', 'CONSTITUENT_SHIPPING_INDVSHIP_ZONE_DESCRIPTION', '6', '0', 'go_get_zone_class_title', 'go_cfg_pull_down_zone_classes(', now())");
		go_db_query("INSERT INTO " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) VALUES ('CONSTITUENT_SHIPPING_INDVSHIP_SORT_ORDER_TITEL', 'CONSTITUENT_SHIPPING_INDVSHIP_SORT_ORDER', '0', 'CONSTITUENT_SHIPPING_INDVSHIP_SORT_ORDER_DESCRIPTION', '6', '0', '', '', now())");
		go_db_query("INSERT INTO " . DB_TBL_SET_IT_UP . " (set_it_up_title, set_it_up_key, set_it_up_value, set_it_up_description, set_it_up_group_id, sort_order, use_function, set_function, date_added) VALUES ('CONSTITUENT_SHIPPING_INDVSHIP_MAX_PREIS_TITEL', 'CONSTITUENT_SHIPPING_INDVSHIP_MAX_PREIS', '20', 'CONSTITUENT_SHIPPING_INDVSHIP_MAX_PREIS_DESCRIPTION', '6', '0', '', '', now())");
		if (go_db_num_rows(go_db_query("SHOW TABLES LIKE 'shipping_range_groups'"))==0) 
			go_db_query("CREATE TABLE shipping_range_groups (id INT UNSIGNED NOT NULL AUTO_INCREMENT, description VARCHAR(60) NOT NULL DEFAULT '', PRIMARY KEY (id))");
		if (go_db_num_rows(go_db_query("SHOW TABLES LIKE 'shipping_range_groups'"))==0) 
			go_db_query("CREATE TABLE shipping_range (group_id INT UNSIGNED NOT NULL, quantity INT UNSIGNED NOT NULL, delivery_price DECIMAL(15,4) NOT NULL, PRIMARY KEY (group_id, quantity))");
		if (go_db_num_rows(go_db_query("SHOW COLUMNS FROM items LIKE 'shipping_range_group_id'"))==0)
			go_db_query("ALTER TABLE items ADD shipping_range_group_id INT UNSIGNED DEFAULT '0'");
	}

	function remove() {
		go_db_query("DELETE FROM " . DB_TBL_SET_IT_UP . " WHERE set_it_up_key IN ('" . implode("', '", $this->keys()) . "')");
	}

	function keys() {
		return array('CONSTITUENT_SHIPPING_INDVSHIP_STATUS', 'CONSTITUENT_SHIPPING_INDVSHIP_TAX_CLASS', 'CONSTITUENT_SHIPPING_INDVSHIP_ZONE', 'CONSTITUENT_SHIPPING_INDVSHIP_SORT_ORDER', 'CONSTITUENT_SHIPPING_INDVSHIP_MAX_PREIS');
	}
}
?>
