<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################

Captcha f�r Bigware 2.1 by Ede & Tigerstyle


*/
?>
<?php
require('load_this/load_this_bigware_10.php'); 
require(FOLDER_RELATIV_LANGUAGES . $language . '/' . $GLOBALS[CONFIG_NAME_FILE][main_bigware_11]);
$process = false;

//Captcha by Ede & Tigerstyle
	$sql=go_db_query('SELECT * FROM captcha_settings');
	$row=go_db_fetch_array($sql); 
	$captcha_enable_11 = $row['captcha_enable_11'];
	
if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
	$process = true;
	if (MEMBER_GENDER == 'true') {
		if (isset($_POST['gender'])) {
			$gender = go_db_producing_input($_POST['gender']);
		} else {
			$gender = false;
		}
	}
	$firstname = go_db_producing_input($_POST['firstname']);
	$lastname = go_db_producing_input($_POST['lastname']);
	if (MEMBER_DOB == 'true') $dob = go_db_producing_input($_POST['dob']);
	$email_address = go_db_producing_input($_POST['email_address']);
	if (MEMBER_COMPANY == 'true') $company = go_db_producing_input($_POST['company']); 
	if (MEMBER_PIVA == 'true')$piva = go_db_producing_input($_POST['piva']);
	if (MEMBER_CF == 'true') $cf = go_db_producing_input($_POST['cf']); 
	$street_address = go_db_producing_input($_POST['street_address']);
	$street_address2 = go_db_producing_input($_POST['street_address2']);
	if (MEMBER_SUBURB == 'true') $suburb = go_db_producing_input($_POST['suburb']);
	$postcode = go_db_producing_input($_POST['postcode']);
	$city = go_db_producing_input($_POST['city']);
	if (MEMBER_STATE == 'true') {
		$state = go_db_producing_input($_POST['state']);
		if (isset($_POST['zone_id'])) {
			$zone_id = go_db_producing_input($_POST['zone_id']);
		} else {
			$zone_id = false;
		}
	}
	$land = go_db_producing_input($_POST['land']);
	$iso = go_db_producing_input($_POST['land']);//ISO
	$telephone = go_db_producing_input($_POST['telephone']);
	$fax = go_db_producing_input($_POST['fax']);
	if (isset($_POST['newsletter'])) {
		$newsletter = go_db_producing_input($_POST['newsletter']);
	} else {
		$newsletter = false;
	}
	$password = go_db_producing_input($_POST['password']);
	$confirmation = go_db_producing_input($_POST['confirmation']);
	$error = false;
	if ((MEMBER_GENDER == 'true')&&(MEMBER_GENDER_REQ == 'true')) {
		if ( ($gender != 'm') && ($gender != 'f') ) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_GENDER_ERROR);
		}
	}
	if (strlen($firstname) < TYPE_IN_FIRST_NAME_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_FIRST_NAME_ERROR);
	}
	if (strlen($lastname) < TYPE_IN_LAST_NAME_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_LAST_NAME_ERROR);
	}
	if ((MEMBER_DOB == 'true')&&(MEMBER_DOB_REQ == 'true')) {
		if (checkdate(substr(go_date_raw($dob), 4, 2), substr(go_date_raw($dob), 6, 2), substr(go_date_raw($dob), 0, 4)) == false) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_DATE_OF_BIRTH_ERROR);
		}
	}
	if (strlen($email_address) < TYPE_IN_EMAIL_ADDRESS_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_EMAIL_ADDRESS_ERROR);
	} elseif (go_validate_email($email_address) == false) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_EMAIL_ADDRESS_CHECK_ERROR);
	} else {
		$check_email_query = go_db_query("select count(*) as total from " . DB_TBL_ATTENDEES . " where attendees_email_address = '" . go_db_input($email_address) . "'");
		$check_email = go_db_fetch_array($check_email_query);
		if ($check_email['total'] > 0) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_EMAIL_ADDRESS_ERROR_EXISTS);
		}
	} 
	if (MEMBER_PIVA == 'true'){
		if (($piva == "") && (MEMBER_PIVA_REQ == 'true')) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_PIVA_ERROR);
		}else{
			$isocheck = array("AT"=> "AT", "BE"=> "BE", "DE"=> "DE", "DK"=> "DK", "EL"=> "EL", "ES"=> "ES", "FI"=> "FI", "FR"=> "FR", "GB"=> "GB", "IT"=> "IT");
			if ($iso=$isocheck[$iso]){ 
				$check=go_iso_check($iso,$piva);
				if ($check == '1'){
					$error = true;
					$messageStack->add('create_member', TYPE_IN_PIVA_ERROR);
				}elseif ($check == '2'){
					$error = true;
					$messageStack->add('create_member', TYPE_IN_VIES_ERROR);
				}         
			}
		}
	} 
	if ($language == 'italian'){                            
		if (MEMBER_CF == 'true') {
			if (($cf == "") && (MEMBER_CF_REQ == 'true')) {
				$error = true;
				$messageStack->add('create_member', TYPE_IN_CF_ERROR);
			} else if ((strlen($cf) != 16) && ($cf != "")) {
				$error = true;
				$messageStack->add('create_member', TYPE_IN_CF_ERROR);
			} else if (strlen($cf) == 16) {
				$cf = strtoupper($cf);
				if( ! preg_match("/^[A-Z0-9]+$/", $cf) ){
					$error = true;
					$messageStack->add('create_member', TYPE_IN_CF_ERROR);
				} else { 
					$s = 0;
					for( $i = 1; $i <= 13; $i += 2 ){
						$c = $cf[$i];
						if( '0' <= $c && $c <= '9' )
							$s += ord($c) - ord('0');
						else
							$s += ord($c) - ord('A');
					}
					for( $i = 0; $i <= 14; $i += 2 ){
						$c = $cf[$i];
						switch( $c ){
							case '0':  $s += 1;  break;
							case '1':  $s += 0;  break;
							case '2':  $s += 5;  break;
							case '3':  $s += 7;  break;
							case '4':  $s += 9;  break;
							case '5':  $s += 13;  break;
							case '6':  $s += 15;  break;
							case '7':  $s += 17;  break;
							case '8':  $s += 19;  break;
							case '9':  $s += 21;  break;
							case 'A':  $s += 1;  break;
							case 'B':  $s += 0;  break;
							case 'C':  $s += 5;  break;
							case 'D':  $s += 7;  break;
							case 'E':  $s += 9;  break;
							case 'F':  $s += 13;  break;
							case 'G':  $s += 15;  break;
							case 'H':  $s += 17;  break;
							case 'I':  $s += 19;  break;
							case 'J':  $s += 21;  break;
							case 'K':  $s += 2;  break;
							case 'L':  $s += 4;  break;
							case 'M':  $s += 18;  break;
							case 'N':  $s += 20;  break;
							case 'O':  $s += 11;  break;
							case 'P':  $s += 3;  break;
							case 'Q':  $s += 6;  break;
							case 'R':  $s += 8;  break;
							case 'S':  $s += 12;  break;
							case 'T':  $s += 14;  break;
							case 'U':  $s += 16;  break;
							case 'V':  $s += 10;  break;
							case 'W':  $s += 22;  break;
							case 'X':  $s += 25;  break;
							case 'Y':  $s += 24;  break;
							case 'Z':  $s += 23;  break;
						}
					}
					if( chr($s%26 + ord('A')) != $cf[15] ){
						$error = true;
						$messageStack->add('create_member', TYPE_IN_CF_ERROR);
					}
				}
			}
		}
	}
	else {
		if (MEMBER_CF == 'true') {	
			if (($cf == "") && (MEMBER_CF_REQ == 'true')) {
				$error = true;
				$messageStack->add('create_member', TYPE_IN_CF_ERROR);
			}
		}
	} 
	if (strlen($street_address) < TYPE_IN_STREET_ADDRESS_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_STREET_ADDRESS_ERROR);
	}
	if (strlen($postcode) < TYPE_IN_POSTCODE_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_POST_CODE_ERROR);
	}
	if (strlen($city) < TYPE_IN_CITY_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_CITY_ERROR);
	}


	if (is_numeric($land) == false) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_LAND_ERROR);
	}          
	if ((MEMBER_STATE == 'true')&&(MEMBER_STATE_REQ == 'true')) {
		$zone_id = 0;
		$check_query = go_db_query("select count(*) as total from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "'");
		$check = go_db_fetch_array($check_query);
		$entry_state_has_zones = ($check['total'] > 0);
		if ($entry_state_has_zones == true) {
			$zone_query = go_db_query("select distinct zone_id from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "' and (zone_name like '" . go_db_input($state) . "%' or zone_code like '%" . go_db_input($state) . "%')");
			if (go_db_num_rows($zone_query) == 1) {
				$zone = go_db_fetch_array($zone_query);
				$zone_id = $zone['zone_id'];
			} else {
				$error = true;
				$messageStack->add('create_member', TYPE_IN_STATE_ERROR_SELECT);
			}
		} else {
			if (strlen($state) < TYPE_IN_STATE_MIN_LENGTH) {
				$error = true;
				$messageStack->add('create_member', TYPE_IN_STATE_ERROR);
			}
		}
	}
	if (strlen($telephone) < TYPE_IN_TELEPHONE_MIN_LENGTH) {
		$error = true;
		$messageStack->add('create_member', TYPE_IN_TELEPHONE_NUMBER_ERROR);
	}
	
	if (MEMBER == 'false'){
		if (strlen($password) < TYPE_IN_PASSWORD_MIN_LENGTH) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_PASSWORD_ERROR);
		} elseif ($password != $confirmation) {
			$error = true;
			$messageStack->add('create_member', TYPE_IN_PASSWORD_ERROR_NOT_MATCHING);
		}
	}
//captcha test, sets error message and error flag
	if ($captcha_enable_11 == "ja") {
	if( empty($captcha_code) || empty($_POST['captcha_code']) || go_urlsafe_b64encode(go_CAP_RC4($_POST['captcha_code'])) != $captcha_code ) {
      $error = true;
      $messageStack->add('create_member', CAPTCHA_INVALID_TEXT );
    }
	}
	//END
//Captcha by Ede & Tigerstyle
if ($captcha_enable_11 == "ja") {
// captcha unregister here not needed anymore
      if ( go_session_is_registered('captcha_code') ) {
        go_session_unregister('captcha_code');
      }
      }
//END      
	if ($error == false) {
		$sql_data_array = array('attendees_firstname' => $firstname,
				'attendees_lastname' => $lastname,
				'attendees_email_address' => $email_address,
				'attendees_telephone' => $telephone,
				'attendees_fax' => $fax,
				'attendees_newsletter' => $newsletter,
				'attendees_password' => go_encrypt_password($password));
		if (MEMBER_GENDER == 'true') $sql_data_array['attendees_gender'] = $gender;
		if (MEMBER_DOB == 'true') $sql_data_array['attendees_dob'] = go_date_raw($dob);
		go_db_carry(DB_TBL_ATTENDEES, $sql_data_array);
		$attendee_id = go_db_insert_id();
		$sql_data_array = array('attendees_id' => $attendee_id,
				'entry_firstname' => $firstname,
				'entry_lastname' => $lastname,
				'entry_street_address' => $street_address,
				'entry_street_address2' => $street_address2,
				'entry_postcode' => $postcode,
				'entry_city' => $city,
				'entry_land_id' => $land);
		if (MEMBER_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
		if (MEMBER_COMPANY == 'true') $sql_data_array['entry_company'] = $company; 
		$sql_data_array['entry_piva'] = $piva;
		if (MEMBER_CF == 'true') $sql_data_array['entry_cf'] = $cf; 
		if (MEMBER_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
		if (MEMBER_STATE == 'true') {
			if ($zone_id > 0) {
				$sql_data_array['entry_zone_id'] = $zone_id;
				$sql_data_array['entry_state'] = '';
			} else {
				$sql_data_array['entry_zone_id'] = '0';
				$sql_data_array['entry_state'] = $state;
			}
		}
		go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array);
		$address_id = go_db_insert_id();
		go_db_query("update " . DB_TBL_ATTENDEES . " set attendees_default_address_id = '" . (int)$address_id . "' where attendees_id = '" . (int)$attendee_id . "'");
		go_db_query("insert into " . DB_TBL_ATTENDEES_INFO . " (attendees_info_id, attendees_info_number_of_logons, attendees_info_date_member_created) values ('" . (int)$attendee_id . "', '0', now())");

		$name = $firstname . ' ' . $lastname;
		if (MEMBER_GENDER == 'true') {
			if ($gender == 'm') {
				$email_text = sprintf(EMAIL_GREET_MR, $lastname);
			} else {
				$email_text = sprintf(EMAIL_GREET_MS, $lastname);
			}
		} else {
			$email_text = sprintf(EMAIL_GREET_NONE, $firstname);
		}
		$email_text .= EMAIL_WELCOME . EMAIL_TEXT . EMAIL_CONTACT . EMAIL_WARNING;
		go_mail($name, $email_address, EMAIL_SUBJECT, $email_text, SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS);
		$former_email_text .= FORMER_EMAIL_WELCOME . '<br><br>' . FORMER_EMAIL_TEXT . '<br><br>' . $company .'<br>' . $firstname . ' ' . $lastname . '<br>' . $street_address. '<br>' . $street_address2. '<br>' . $postcode . ' ' . $city . '<br><br>' . FORMER_EMAIL_EMAIL . $email_address . '<br><br>'. FORMER_EMAIL_TELEPHONE . $telephone . '<br>' . FORMER_EMAIL_FAX . $fax . '<br><br>'. EMAIL_WARNING;
#$former_email_text .= FORMER_EMAIL_WELCOME . FORMER_EMAIL_TEXT . EMAIL_WARNING;
		go_mail(SHOP_OWNER, SHOP_OWNER_EMAIL_ADDRESS, FORMER_EMAIL_SUBJECT, nl2br($former_email_text), $name, $email_address, '');                   
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_13], '', 'SSL'));
	}
}

  //Captcha by Ede & Tigerstyle	
   else {

    $_POST['email'] = "";
    $_POST['name'] = "";
    $_POST['captcha_code'] = "";

  }
//END
   
//Captcha by Ede & Tigerstyle
if ($captcha_enable_11 == "ja") {
// captcha generate a new captcha image and code, encoded and encrypt, register the code with session for testing $_POST
  $captcha_code = go_captcha_image();
    go_session_register('captcha_code');
  }
  //END
$breadcrumb->add(NAVBAR_TITLE, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_11], '', 'SSL'));
$content = $GLOBALS[CONFIG_SHOW_FILE][main_bigware_11];
$javascript = $GLOBALS[CONFIG_NAME_FILE][form_check_js];
require(FOLDER_RELATIV_TEMPLATES . TEMPLATENAME_MAIN_PAGE);
require(FOLDER_RELATIV_INCLUDES . 'load_this_bigware_3.php');
?>
