<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_this_bigware_10.php');
  if (!go_session_is_registered('attendee_id')) {
    $navigation->set_snapshot();
    go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40], '', 'SSL'));
  } 
  require(FOLDER_RELATIV_LANGUAGES . $language . '/' . $GLOBALS[CONFIG_NAME_FILE][main_bigware_16]);
  if (isset($_GET['action']) && ($_GET['action'] == 'deleteconfirm') && isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    go_db_query("delete from " . DB_TBL_DIRECTORY_TO_ADDRESS . " where directory_to_address_id = '" . (int)$_GET['delete'] . "' and attendees_id = '" . (int)$attendee_id . "'");
    $messageStack->add_session('addressbook', SUCCESS_DIRECTORY_TO_ADDRESS_TYPE_IN_DELETED, 'success');
    go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
  } 
  $process = false;
  if (isset($_POST['action']) && (($_POST['action'] == 'process') || ($_POST['action'] == 'update'))) {
    $process = true;
    $error = false;
    if (MEMBER_GENDER == 'true') $gender = go_db_producing_input($_POST['gender']);
    if (MEMBER_COMPANY == 'true') $company = go_db_producing_input($_POST['company']);
    if (MEMBER_PIVA == 'true') $piva = go_db_producing_input($_POST['piva']);
    if (MEMBER_CF == 'true') $cf = go_db_producing_input($_POST['cf']);
        
    $firstname = go_db_producing_input($_POST['firstname']);
    $lastname = go_db_producing_input($_POST['lastname']);
    $street_address = go_db_producing_input($_POST['street_address']);
    $street_address2 = go_db_producing_input($_POST['street_address2']);
    if (MEMBER_SUBURB == 'true') $suburb = go_db_producing_input($_POST['suburb']);
    $postcode = go_db_producing_input($_POST['postcode']);
    $city = go_db_producing_input($_POST['city']);
    $land = go_db_producing_input($_POST['land']);
    if (MEMBER_STATE == 'true') {
      if (isset($_POST['zone_id'])) {
        $zone_id = go_db_producing_input($_POST['zone_id']);
      } else {
        $zone_id = false;
      }
      $state = go_db_producing_input($_POST['state']);
    }
    if (MEMBER_GENDER == 'true') {
      if ( ($gender != 'm') && ($gender != 'f') ) {
        $error = true;
        $messageStack->add('addressbook', TYPE_IN_GENDER_ERROR);
      }
    } 
       if ($language == 'italian'){
       if (MEMBER_PIVA == 'true'){
         if (($piva == "") && (MEMBER_PIVA_REQ == 'true')) {
           $error = true;
              $messageStack->add('addressbook', TYPE_IN_PIVA_ERROR);
         } else if ((strlen($piva) != 11) && ($piva != ""))  {
        $error = true;
        $messageStack->add('addressbook', TYPE_IN_PIVA_ERROR);
      } else if (strlen($piva) == 11) {
           if( ! preg_match("/^[0-9]+$/", $piva) ) {
             $error = true;
             $messageStack->add('addressbook', TYPE_IN_PIVA_ERROR);
        } else {
             $s = 0;
                for( $i = 0; $i <= 9; $i += 2 ) $s += ord($piva[$i]) - ord('0');
                for( $i = 1; $i <= 9; $i += 2 ) {
                  $c = 2*( ord($piva[$i]) - ord('0') );
                  if( $c > 9 ) $c = $c - 9;
                  $s += $c;
             }
             if( ( 10 - $s%10 )%10 != ord($piva[10]) - ord('0') ) {
            $error = true;
            $messageStack->add('addressbook', TYPE_IN_PIVA_ERROR);
          }
           }
         }    
       }
       if (MEMBER_CF == 'true') {
         if (($cf == "") && (MEMBER_CF_REQ == 'true')) {
           $error = true;
              $messageStack->add('addressbook', TYPE_IN_CF_ERROR);
         } else if ((strlen($cf) != 16) && ($cf != "")) {
           $error = true;
              $messageStack->add('addressbook', TYPE_IN_CF_ERROR);
         } else if (strlen($cf) == 16) {
              $cf = strtoupper($cf);
              if( ! preg_match("/^[A-Z0-9]+$/", $cf) ){
                $error = true;
                $messageStack->add('addressbook', TYPE_IN_CF_ERROR);
           } else { 
                $s = 0;
                for( $i = 1; $i <= 13; $i += 2 ){
                  $c = $cf[$i];
                  if( '0' <= $c && $c <= '9' )
                       $s += ord($c) - ord('0');
                  else
                       $s += ord($c) - ord('A');
                }
                for( $i = 0; $i <= 14; $i += 2 ){
                  $c = $cf[$i];
                  switch( $c ){
                    case '0':  $s += 1;  break;
                    case '1':  $s += 0;  break;
                    case '2':  $s += 5;  break;
                    case '3':  $s += 7;  break;
                    case '4':  $s += 9;  break;
                    case '5':  $s += 13;  break;
                    case '6':  $s += 15;  break;
                    case '7':  $s += 17;  break;
                    case '8':  $s += 19;  break;
                    case '9':  $s += 21;  break;
                    case 'A':  $s += 1;  break;
                    case 'B':  $s += 0;  break;
                    case 'C':  $s += 5;  break;
                    case 'D':  $s += 7;  break;
                    case 'E':  $s += 9;  break;
                    case 'F':  $s += 13;  break;
                    case 'G':  $s += 15;  break;
                    case 'H':  $s += 17;  break;
                    case 'I':  $s += 19;  break;
                    case 'J':  $s += 21;  break;
                    case 'K':  $s += 2;  break;
                    case 'L':  $s += 4;  break;
                    case 'M':  $s += 18;  break;
                    case 'N':  $s += 20;  break;
                    case 'O':  $s += 11;  break;
                    case 'P':  $s += 3;  break;
                    case 'Q':  $s += 6;  break;
                    case 'R':  $s += 8;  break;
                    case 'S':  $s += 12;  break;
                    case 'T':  $s += 14;  break;
                    case 'U':  $s += 16;  break;
                    case 'V':  $s += 10;  break;
                    case 'W':  $s += 22;  break;
                    case 'X':  $s += 25;  break;
                    case 'Y':  $s += 24;  break;
                    case 'Z':  $s += 23;  break;
                  }
             }
             if( chr($s%26 + ord('A')) != $cf[15] ){
                  $error = true;
                  $messageStack->add('addressbook', TYPE_IN_CF_ERROR);
                }
           }
         }
    } 
       } elseif ($languagae != 'italian') {
       if (MEMBER_PIVA == 'true') {
         if (($piva == "") && (MEMBER_PIVA_REQ == 'true')) {
           $error = true;
              $messageStack->add('create_member', TYPE_IN_PIVA_ERROR);
         }
              }
              } 
    if (strlen($firstname) < TYPE_IN_FIRST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_FIRST_NAME_ERROR);
    }
    if (strlen($lastname) < TYPE_IN_LAST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_LAST_NAME_ERROR);
    }
    if (strlen($street_address) < TYPE_IN_STREET_ADDRESS_MIN_LENGTH) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_STREET_ADDRESS_ERROR);
    }
    if (strlen($postcode) < TYPE_IN_POSTCODE_MIN_LENGTH) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_POST_CODE_ERROR);
    }
    if (strlen($city) < TYPE_IN_CITY_MIN_LENGTH) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_CITY_ERROR);
    }
    if (!is_numeric($land)) {
      $error = true;
      $messageStack->add('addressbook', TYPE_IN_LAND_ERROR);
    }
    if (MEMBER_STATE == 'true') {
      $zone_id = 0;
      $check_query = go_db_query("select count(*) as total from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "'");
      $check = go_db_fetch_array($check_query);
      $entry_state_has_zones = ($check['total'] > 0);
      if ($entry_state_has_zones == true) {
        $zone_query = go_db_query("select distinct zone_id from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "' and (zone_name like '" . go_db_input($state) . "%' or zone_code like '%" . go_db_input($state) . "%')");
        if (go_db_num_rows($zone_query) == 1) {
          $zone = go_db_fetch_array($zone_query);
          $zone_id = $zone['zone_id'];
        } else {
          $error = true;
          $messageStack->add('addressbook', TYPE_IN_STATE_ERROR_SELECT);
        }
      } else {
        if (strlen($state) < TYPE_IN_STATE_MIN_LENGTH) {
          $error = true;
          $messageStack->add('addressbook', TYPE_IN_STATE_ERROR);
        }
      }
    }
    if ($error == false) {
      $sql_data_array = array('entry_firstname' => $firstname,
                              'entry_lastname' => $lastname,
                              'entry_street_address' => $street_address,
                              'entry_street_address2' => $street_address2,
                              'entry_postcode' => $postcode,
                              'entry_city' => $city,
                              'entry_land_id' => (int)$land);
      if (MEMBER_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
      if (MEMBER_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
      if (MEMBER_PIVA == 'true') $sql_data_array['entry_piva'] = $piva;
      if (MEMBER_CF == 'true') $sql_data_array['entry_cf'] = $cf;
      if (MEMBER_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
      if (MEMBER_STATE == 'true') {
        if ($zone_id > 0) {
          $sql_data_array['entry_zone_id'] = (int)$zone_id;
          $sql_data_array['entry_state'] = '';
        } else {
          $sql_data_array['entry_zone_id'] = '0';
          $sql_data_array['entry_state'] = $state;
        }
      }
      if ($_POST['action'] == 'update') {
        go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array, 'update', "directory_to_address_id = '" . (int)$_GET['change'] . "' and attendees_id ='" . (int)$attendee_id . "'"); 
        if ( (isset($_POST['primary']) && ($_POST['primary'] == 'on')) || ($_GET['change'] == $attendee_default_address_id) ) {
          $attendee_first_name = $firstname;
          $attendee_land_id = $land_id;
          $attendee_zone_id = (($zone_id > 0) ? (int)$zone_id : '0');
          $attendee_default_address_id = (int)$_GET['change'];
          $sql_data_array = array('attendees_firstname' => $firstname,
                                  'attendees_lastname' => $lastname,
                                  'attendees_default_address_id' => (int)$_GET['change']);
          if (MEMBER_GENDER == 'true') $sql_data_array['attendees_gender'] = $gender;
          go_db_carry(DB_TBL_ATTENDEES, $sql_data_array, 'update', "attendees_id = '" . (int)$attendee_id . "'");
        }
      } else {
        $sql_data_array['attendees_id'] = (int)$attendee_id;
        go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array);
        $new_directory_to_address_id = go_db_insert_id(); 
        if (isset($_POST['primary']) && ($_POST['primary'] == 'on')) {
          $attendee_first_name = $firstname;
          $attendee_land_id = $land_id;
          $attendee_zone_id = (($zone_id > 0) ? (int)$zone_id : '0');
          if (isset($_POST['primary']) && ($_POST['primary'] == 'on')) $attendee_default_address_id = $new_directory_to_address_id;
          $sql_data_array = array('attendees_firstname' => $firstname,
                                  'attendees_lastname' => $lastname);
          if (MEMBER_GENDER == 'true') $sql_data_array['attendees_gender'] = $gender;
          if (isset($_POST['primary']) && ($_POST['primary'] == 'on')) $sql_data_array['attendees_default_address_id'] = $new_directory_to_address_id;
          go_db_carry(DB_TBL_ATTENDEES, $sql_data_array, 'update', "attendees_id = '" . (int)$attendee_id . "'");
        }
      }
      $messageStack->add_session('addressbook', SUCCESS_DIRECTORY_TO_ADDRESS_TYPE_IN_UPDATED, 'success');
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
    }
  }
  if (isset($_GET['change']) && is_numeric($_GET['change'])) { 
    $entry_query = go_db_query("select entry_gender, entry_company, entry_piva, entry_cf, entry_firstname, entry_lastname, entry_street_address, entry_street_address2, entry_suburb, entry_postcode, entry_city, entry_state, entry_zone_id, entry_land_id from " . DB_TBL_DIRECTORY_TO_ADDRESS . " where attendees_id = '" . (int)$attendee_id . "' and directory_to_address_id = '" . (int)$_GET['change'] . "'");
    if (!go_db_num_rows($entry_query)) {
      $messageStack->add_session('addressbook', ERROR_NONEXISTING_DIRECTORY_TO_ADDRESS_ENTRY);
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
    }
    $entry = go_db_fetch_array($entry_query);
  } elseif (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    if ($_GET['delete'] == $attendee_default_address_id) {
      $messageStack->add_session('addressbook', WARNING_PRIMARY_ADDRESS_DELETION, 'warning');
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
    } else {
      $check_query = go_db_query("select count(*) as total from " . DB_TBL_DIRECTORY_TO_ADDRESS . " where directory_to_address_id = '" . (int)$_GET['delete'] . "' and attendees_id = '" . (int)$attendee_id . "'");
      $check = go_db_fetch_array($check_query);
      if ($check['total'] < 1) {
        $messageStack->add_session('addressbook', ERROR_NONEXISTING_DIRECTORY_TO_ADDRESS_ENTRY);
        go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
      }
    }
  } else {
    $entry = array();
  }
  if (!isset($_GET['delete']) && !isset($_GET['change'])) {
    if (go_count_attendee_directory_to_address_entries() >= MAX_DIRECTORY_TO_ADDRESS_ENTRIES) {
      $messageStack->add_session('addressbook', ERROR_DIRECTORY_TO_ADDRESS_FULL);
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
    }
  }
  $breadcrumb->add(NAVBAR_TITLE_1, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_42], '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_15], '', 'SSL'));
  if (isset($_GET['change']) && is_numeric($_GET['change'])) {
    $breadcrumb->add(NAVBAR_TITLE_MODIFY_ENTRY, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_16], 'change=' . $_GET['change'], 'SSL'));
  } elseif (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $breadcrumb->add(NAVBAR_TITLE_DELETE_ENTRY, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_16], 'delete=' . $_GET['delete'], 'SSL'));
  } else {
    $breadcrumb->add(NAVBAR_TITLE_ADD_ENTRY, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_16], '', 'SSL'));
  }
  $content = $GLOBALS[CONFIG_SHOW_FILE][main_bigware_16];
  $javascript = $content . '.js.php';
  require(FOLDER_RELATIV_TEMPLATES . TEMPLATENAME_MAIN_PAGE);
  require(FOLDER_RELATIV_INCLUDES . 'load_this_bigware_3.php');
?>
