<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
  require('load_this/load_this_bigware_10.php');
  if (!go_session_is_registered('attendee_id')) {
    $navigation->set_snapshot();
    go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40], '', 'SSL'));
  } 
  require(FOLDER_RELATIV_LANGUAGES . $language . '/' . $GLOBALS[CONFIG_NAME_FILE][main_bigware_43]);
  if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    if (MEMBER_GENDER == 'true') $gender = go_db_producing_input($_POST['gender']);
    $firstname = go_db_producing_input($_POST['firstname']);
    $lastname = go_db_producing_input($_POST['lastname']);
    if (MEMBER_DOB == 'true') $dob = go_db_producing_input($_POST['dob']);
    $email_address = go_db_producing_input($_POST['email_address']);
    $telephone = go_db_producing_input($_POST['telephone']);
    $fax = go_db_producing_input($_POST['fax']);
    if (MEMBER_CF == 'true') $cf = go_db_producing_input($_POST['cf']);
    $error = false;
    if (MEMBER_GENDER == 'true') {
      if ( ($gender != 'm') && ($gender != 'f') ) {
        $error = true;
        $messageStack->add('member_change', TYPE_IN_GENDER_ERROR);
      }
    } 
              if ($language == 'italian'){
       if (MEMBER_CF == 'true') {
         if (($cf == "") && (MEMBER_CF_REQ == 'true')) {
           $error = true;
              $messageStack->add('member_change', TYPE_IN_CF_ERROR);
         } else if ((strlen($cf) != 16) && ($cf != "")) {
           $error = true;
              $messageStack->add('member_change', TYPE_IN_CF_ERROR);
         } else if (strlen($cf) == 16) {
              $cf = strtoupper($cf);
              if( ! preg_match("/^[A-Z0-9]+$/", $cf) ){
                $error = true;
                $messageStack->add('member_change', TYPE_IN_CF_ERROR);
           } else { 
                $s = 0;
                for( $i = 1; $i <= 13; $i += 2 ){
                  $c = $cf[$i];
                  if( '0' <= $c && $c <= '9' )
                       $s += ord($c) - ord('0');
                  else
                       $s += ord($c) - ord('A');
                }
                for( $i = 0; $i <= 14; $i += 2 ){
                  $c = $cf[$i];
                  switch( $c ){
                    case '0':  $s += 1;  break;
                    case '1':  $s += 0;  break;
                    case '2':  $s += 5;  break;
                    case '3':  $s += 7;  break;
                    case '4':  $s += 9;  break;
                    case '5':  $s += 13;  break;
                    case '6':  $s += 15;  break;
                    case '7':  $s += 17;  break;
                    case '8':  $s += 19;  break;
                    case '9':  $s += 21;  break;
                    case 'A':  $s += 1;  break;
                    case 'B':  $s += 0;  break;
                    case 'C':  $s += 5;  break;
                    case 'D':  $s += 7;  break;
                    case 'E':  $s += 9;  break;
                    case 'F':  $s += 13;  break;
                    case 'G':  $s += 15;  break;
                    case 'H':  $s += 17;  break;
                    case 'I':  $s += 19;  break;
                    case 'J':  $s += 21;  break;
                    case 'K':  $s += 2;  break;
                    case 'L':  $s += 4;  break;
                    case 'M':  $s += 18;  break;
                    case 'N':  $s += 20;  break;
                    case 'O':  $s += 11;  break;
                    case 'P':  $s += 3;  break;
                    case 'Q':  $s += 6;  break;
                    case 'R':  $s += 8;  break;
                    case 'S':  $s += 12;  break;
                    case 'T':  $s += 14;  break;
                    case 'U':  $s += 16;  break;
                    case 'V':  $s += 10;  break;
                    case 'W':  $s += 22;  break;
                    case 'X':  $s += 25;  break;
                    case 'Y':  $s += 24;  break;
                    case 'Z':  $s += 23;  break;
                  }
             }
             if( chr($s%26 + ord('A')) != $cf[15] ){
                  $error = true;
                  $messageStack->add('member_change', TYPE_IN_CF_ERROR);
                }
           }
         }
    } 
       }
    if (strlen($firstname) < TYPE_IN_FIRST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_FIRST_NAME_ERROR);
    }
    if (strlen($lastname) < TYPE_IN_LAST_NAME_MIN_LENGTH) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_LAST_NAME_ERROR);
    }
    if (MEMBER_DOB == 'true') {
      if (!checkdate(substr(go_date_raw($dob), 4, 2), substr(go_date_raw($dob), 6, 2), substr(go_date_raw($dob), 0, 4))) {
        $error = true;
        $messageStack->add('member_change', TYPE_IN_DATE_OF_BIRTH_ERROR);
      }
    }
    if (strlen($email_address) < TYPE_IN_EMAIL_ADDRESS_MIN_LENGTH) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_EMAIL_ADDRESS_ERROR);
    }
    if (!go_validate_email($email_address)) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_EMAIL_ADDRESS_CHECK_ERROR);
    } 
    $check_email_query = go_db_query("select count(*) as total from " . DB_TBL_ATTENDEES . " where attendees_email_address = '" . go_db_input($email_address) . "' and attendees_id != '" . go_db_input($attendee_id) . "' and guest_flag != '1'");  
    $check_email = go_db_fetch_array($check_email_query);
    if ($check_email['total'] > 0) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_EMAIL_ADDRESS_ERROR_EXISTS);
    }
    if (strlen($telephone) < TYPE_IN_TELEPHONE_MIN_LENGTH) {
      $error = true;
      $messageStack->add('member_change', TYPE_IN_TELEPHONE_NUMBER_ERROR);
    }
    if ($error == false) {
      $sql_data_array = array('attendees_firstname' => $firstname,
                              'attendees_lastname' => $lastname,
                              'attendees_email_address' => $email_address,
                              'attendees_telephone' => $telephone,
                              'attendees_fax' => $fax);
      if (MEMBER_GENDER == 'true') $sql_data_array['attendees_gender'] = $gender;
      if (MEMBER_DOB == 'true') $sql_data_array['attendees_dob'] = go_date_raw($dob); 
    if (!$guest_member) $sql_data_array['guest_flag'] = '0';	
    go_db_query("update " . DB_TBL_ATTENDEES . " set attendees_email_address = '@_" . $email_address . "' where attendees_email_address = '" . $email_address . "' and guest_flag = '1'");
    go_db_query("update " . DB_TBL_ATTENDEES . " set attendees_lastname = '@_" . $lastname . "' where attendees_email_address = '@_" . $email_address . "'"); 
      go_db_carry(DB_TBL_ATTENDEES, $sql_data_array, 'update', "attendees_id = '" . (int)$attendee_id . "'");
      go_db_query("update " . DB_TBL_ATTENDEES_INFO . " set attendees_info_date_member_last_modified = now() where attendees_info_id = '" . (int)$attendee_id . "'");
      $sql_data_array = array('entry_firstname' => $firstname,
                              'entry_lastname' => $lastname); 
     if (MEMBER_CF == 'true') $sql_data_array['entry_cf'] = $cf;
     $sql_data_array['entry_gender'] = $gender; 
      go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array, 'update', "attendees_id = '" . (int)$attendee_id . "' and directory_to_address_id = '" . (int)$attendee_default_address_id . "'"); 
      $attendee_first_name = $firstname;
      $messageStack->add_session('member', SUCCESS_MEMBER_UPDATED, 'success');
      go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_42], '', 'SSL'));
    }
  } 
  $member_query = go_db_query("select c.attendees_gender, c.attendees_firstname, c.attendees_lastname, c.attendees_dob, c.attendees_email_address, c.attendees_telephone, c.attendees_fax , a.entry_cf from ((" . DB_TBL_ATTENDEES . " c) left join " . DB_TBL_DIRECTORY_TO_ADDRESS . " a on c.attendees_default_address_id = a.directory_to_address_id) where a.attendees_id = c.attendees_id and c.attendees_id = '" . (int)$attendee_id . "'");
  $member = go_db_fetch_array($member_query);
  $breadcrumb->add(NAVBAR_TITLE_1, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_42], '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_43], '', 'SSL'));
  $content = $GLOBALS[CONFIG_SHOW_FILE][main_bigware_43];
  $javascript = $GLOBALS[CONFIG_NAME_FILE][form_check_js];
  require(FOLDER_RELATIV_TEMPLATES . TEMPLATENAME_MAIN_PAGE); 
  
  require(FOLDER_RELATIV_INCLUDES . 'load_this_bigware_3.php');   
?>
