<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
require('load_this/load_this_bigware_10.php'); 
if (!go_session_is_registered('attendee_id')) {
	$navigation->set_snapshot();
	go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_40], '', 'SSL'));
} 
if ($cart->count_contents() < 1) {
	go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_69]));
} 
require(FOLDER_RELATIV_LANGUAGES . $language . '/' . $GLOBALS[CONFIG_NAME_FILE][main_bigware_50]);
$error = false;
$process = false;
if (isset($_POST['action']) && ($_POST['action'] == 'submit')) { 
	if (go_not_null($_POST['firstname']) && go_not_null($_POST['lastname']) && go_not_null($_POST['street_address'])) {
		$process = true;
		if (MEMBER_GENDER == 'true') $gender = go_db_producing_input($_POST['gender']);
		if (MEMBER_COMPANY == 'true') $company = go_db_producing_input($_POST['company']);
		$firstname = go_db_producing_input($_POST['firstname']);
		$lastname = go_db_producing_input($_POST['lastname']);
		$street_address = go_db_producing_input($_POST['street_address']);
		$street_address2 = go_db_producing_input($_POST['street_address2']);
		if (MEMBER_SUBURB == 'true') $suburb = go_db_producing_input($_POST['suburb']);
		$postcode = go_db_producing_input($_POST['postcode']);
		$city = go_db_producing_input($_POST['city']);
		$land = go_db_producing_input($_POST['land']);
		if (MEMBER_STATE == 'true') {
			if (isset($_POST['zone_id'])) {
				$zone_id = go_db_producing_input($_POST['zone_id']);
			} else {
				$zone_id = false;
			}
			$state = go_db_producing_input($_POST['state']);
		}
		if (MEMBER_GENDER == 'true') {
			if ( ($gender != 'm') && ($gender != 'f') ) {
				$error = true;
				$messageStack->add('checkout_address', TYPE_IN_GENDER_ERROR);
			}
		}
		if (strlen($firstname) < TYPE_IN_FIRST_NAME_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_FIRST_NAME_ERROR);
		}
		if (strlen($lastname) < TYPE_IN_LAST_NAME_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_LAST_NAME_ERROR);
		}
		if (strlen($street_address) < TYPE_IN_STREET_ADDRESS_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_STREET_ADDRESS_ERROR);
		}
		if (strlen($postcode) < TYPE_IN_POSTCODE_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_POST_CODE_ERROR);
		}
		if (strlen($city) < TYPE_IN_CITY_MIN_LENGTH) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_CITY_ERROR);
		}
		if (MEMBER_STATE == 'true') {
			$zone_id = 0;
			$check_query = go_db_query("select count(*) as total from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "'");
			$check = go_db_fetch_array($check_query);
			$entry_state_has_zones = ($check['total'] > 0);
			if ($entry_state_has_zones == true) {
				$zone_query = go_db_query("select distinct zone_id from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "' and (zone_name like '" . go_db_input($state) . "%' or zone_code like '%" . go_db_input($state) . "%')");
				if (go_db_num_rows($zone_query) == 1) {
					$zone = go_db_fetch_array($zone_query);
					$zone_id = $zone['zone_id'];
				} else {
					$error = true;
					$messageStack->add('checkout_address', TYPE_IN_STATE_ERROR_SELECT);
				}
			} else {
				if (strlen($state) < TYPE_IN_STATE_MIN_LENGTH) {
					$error = true;
					$messageStack->add('checkout_address', TYPE_IN_STATE_ERROR);
				}
			}
		}
		if ( (is_numeric($land) == false) || ($land < 1) ) {
			$error = true;
			$messageStack->add('checkout_address', TYPE_IN_LAND_ERROR);
		}
		if ($error == false) {
			$sql_data_array = array('attendees_id' => $attendee_id,
					'entry_firstname' => $firstname,
					'entry_lastname' => $lastname,
					'entry_street_address' => $street_address,
					'entry_street_address2' => $street_address2,
					'entry_postcode' => $postcode,
					'entry_city' => $city,
					'entry_land_id' => $land);
			if (MEMBER_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;
			if (MEMBER_COMPANY == 'true') $sql_data_array['entry_company'] = $company;
			if (MEMBER_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;
			if (MEMBER_STATE == 'true') {
				if ($zone_id > 0) {
					$sql_data_array['entry_zone_id'] = $zone_id;
					$sql_data_array['entry_state'] = '';
				} else {
					$sql_data_array['entry_zone_id'] = '0';
					$sql_data_array['entry_state'] = $state;
				}
			}
			if (!go_session_is_registered('billto')) go_session_register('billto');
			go_db_carry(DB_TBL_DIRECTORY_TO_ADDRESS, $sql_data_array);
			$billto = go_db_insert_id();
			if (go_session_is_registered('payment')) go_session_unregister('payment');
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], '', 'SSL'));
		} 
	} elseif (isset($_POST['address'])) {
		$reset_payment = false;
		if (go_session_is_registered('billto')) {
			if ($billto != $_POST['address']) {
				if (go_session_is_registered('payment')) {
					$reset_payment = true;
				}
			}
		} else {
			go_session_register('billto');
		}
		$billto = $_POST['address'];
		$check_address_query = go_db_query("select count(*) as total from " . DB_TBL_DIRECTORY_TO_ADDRESS . " where attendees_id = '" . $attendee_id . "' and directory_to_address_id = '" . $billto . "'");
		$check_address = go_db_fetch_array($check_address_query);
		if ($check_address['total'] == '1') {
			if ($reset_payment == true) go_session_unregister('payment');
			go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], '', 'SSL'));
		} else {
			go_session_unregister('billto');
		} 
	} else {
		if (!go_session_is_registered('billto')) go_session_register('billto');
		$billto = $attendee_default_address_id;
		go_forward(go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], '', 'SSL'));
	}
} 
if (!go_session_is_registered('billto')) {
	$billto = $attendee_default_address_id;
}
$breadcrumb->add(NAVBAR_TITLE_1, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_51], '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2, go_href_link($GLOBALS[CONFIG_NAME_FILE][main_bigware_50], '', 'SSL'));
$addresses_count = go_count_attendee_directory_to_address_entries();
$content = $GLOBALS[CONFIG_SHOW_FILE][main_bigware_50];
$javascript = $content . '.js.php';
require(FOLDER_RELATIV_TEMPLATES . TEMPLATENAME_MAIN_PAGE);
require(FOLDER_RELATIV_INCLUDES . 'load_this_bigware_3.php');
?>
