<?php
/*
###################################################################################
  Bigwares eigenstndigen Modulen, optimiert fr den Bigware Shop 2.3
  Release Datum: 23.08.2015

  Urheber: Dirk Pagador
  Nutzungsrecht und Lizenzierungsrecht: (c) 2007 Bigware LTD
  http://www.bigware.de
  
  Die eigenstndigen Software - Module ( Erweiterungen ), vertrieben von der Bigware 
  LTD und optimiet fr den Bigware Shop 2.3, sind nicht Bestandteil der Gnu/GPL Lizenz 
  des Bigware Shop 2.3. 

	Die Gnu/GPL Lizenz des Bigware Shop 2.3, fr die diese Module optimiert wurden, 
	steht nicht im Widerspruch zu der folgenden unabhngigen Lizenzvereinbarung 
	der Module. In der Gnu/GPL Lizenz findet sich dazu folgender Passus: "Wenn 
	identifizierbare Teile des Werkes nicht von dem Programm abgeleitet sind und 
	vernnftigerweise als unabhngige und eigenstndige Werke fr sich selbst zu 
	betrachten sind, dann gilt diese Lizenz und ihre Bedingungen nicht fr die 
	betroffenen Teile, wenn Sie diese als eigenstndige Werke weitergeben." Exakt 
	dies ist bei allen Modulen, vertrieben von der Bigware LTD und optimiert fr 
	den Bigware Shop 2.3, der Fall. Nach bestimmten Anpassungen ist jedes Modul 
	auch fr andere Shops einsetzbar.

	Diese Lizenz findet ausschlielich Anwendung auf den Programmcode fr alle 
	eigenstndigen Module, optimiert fr den Bigware Shop 2.3, die in Deutschland 
	von der Bigware LTD vertriebenen werden und jedwede dazugehrigen frei 
	kopierbaren Dateien, Angaben und Materialen. Bitte lesen Sie die folgenden 
	Bestimmungen sorgfltig durch, bevor Sie eigenstndige Module, optimiert fr 
	den Bigware Shop 2.3, installieren und benutzen. Sofern Sie mit einem 
	bevollmchtigten Vertreter der Bigware LTD ("Bigware LTD") nicht schriftlich 
	eine anders lautende Vereinbarung abgeschlossen haben, erklren Sie durch die 
	Installation dieser Kopie von Bigwares eigenstndigen Modulen, optimiert 
	fr den Bigware Shop 2.3, Ihr Einverstndnis mit den Bestimmungen der vorliegenden 
	Lizenzvereinbarung. Der Zugang zu Bigwares eigenstndigen Modulen, optimiert 
	fr den Bigware Shop 2.3, Standard-Software-Features ist mit allen registrierten 
	Kopien von Bigwares eigenstndigen Modulen, optimiert fr den Bigware Shop 2.3, 
	mglich. Mit Kopien von Bigwares eigenstndigen Modulen, optimiert fr den Bigware 
	Shop 2.0, ist der Zugang zu zustzlichen Pro-Software-Features von Bigwares 
	eigenstndigen Modulen, optimiert fr den Bigware Shop 2.3, mglich. Eine vollstndige 
	Beschreibung der Standard- und der Pro-Features von Bigwares eigenstndigen Modulen, 
	optimiert fr den Bigware Shop 2.3, ist unter 
	
	http://www.bigware.de/lizenz_module_zum_bigware_shop_2_0.php 
	
	abrufbar.

  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
require ( dirname(dirname(__FILE__)).'/language/'.$language.'.php');			
 echo '</td></tr><tr><td class="main" valign="top">'.TEXT_BASIC_PRICING.'</td><td class="main" >';
$unit_pricing_options = array(
	"none"=>array('none'),
	"Weight"=>array("100g","1kg"),
	"NetWeight"=>array("100g","1kg"),
	"Volume"=>array("100ml","1l"),
	"Size"=>array("qm","qmm"),
	"Length"=>array("mm","cm","m") //,"lfdm","ULfdm"
);
$_t = array_combine (array_keys( $unit_pricing_options ) , array (TEXT_NONE, TEXT_WEIGHT,TEXT_NET_WEIGHT,TEXT_VOLUME, TEXT_SIZE,TEXT_LENGTH));
$_t['prompt'] = TEXT_ENTER_DIMENSION;
$_t['empty_price'] = TEXT_EMPTY_PRICE;							
$unit_price_label = (empty($pInfo->unit_price_option ) || $pInfo->unit_price_option == 'none')? '' : number_format($pInfo->items_price/$pInfo->unit_price_factor,2).	"/ ";					
echo go_fetch_dividing_up('tranparentes.gif', '24', '15'). '&nbsp;<span id="unit_pricing_label" ><img src="picture/icon_arrow_right.gif" /><span>'.$unit_price_label.'</span></span>';
echo '<select name="unit_price_option" >';
$pat0 = '<optgroup label="%s"  data-dimension="%s">';
$pat1 = '<option value="%s" %s >%s</option>';
if (empty( $pInfo->unit_price_option)) $pInfo->unit_price_option = 'none';
foreach ($unit_pricing_options as $k=>$v){
	if ($k != 'none' ) printf($pat0,$_t[$k], $k);
	foreach ($v as $v1){
		$_selected = ( $v1 == $pInfo->unit_price_option)?  "selected":'';
		$_title = empty($_t[$v1])? $v1:$_t[$v1];
		printf($pat1, $v1,$_selected, $_title);
	}
}
echo "</select>";
echo '<textarea id="translation" disabled="disabled" style="display:none;">'. json_encode( $_t ).'</textarea>';
echo "</td></tr>";
 echo  go_fetch_hidden_field("unit_price_factor",$pInfo->unit_price_factor);

?>
<script src="http://code.jquery.com/jquery-1.11.0.min.js"></script>	
<script type="text/javascript" language="JavaScript">
	$(function(){
		var _t = $.parseJSON($('textarea#translation').text());
		var unit_pricing ={
			target:null,
                              input :null,
                              label:null,	  
                              type:null,
                		input_label:null,	  
                              unit_price_factor:null,
                              unit_price_option:null,
                		units:{'100g':'g','100ml':'ml','1kg':'kg','1l':'l'},
                              ratio:{'100g':100,'100ml':100},
                              init:function(){
                                 this.target = $('select[name="unit_price_option"]').on('change',$.proxy(this.onOptionChange,this));
                                 this.price = $('input[name="items_price"]').val();
                                 this.unit_price_option = this.target.val();
                                 this.unit_price_factor = $('input[name="unit_price_factor"]').val();
                                 this.label = this.target.prev().on('click','img',$.proxy(this.reinput,this));
                                 $('input[name="items_price"]').on('change',$.proxy(this.onPriceChange,this));
                                 this.prompt = _t.prompt;
                                 this.refresh();
                              },	  	  
			onOptionChange : function( event){
				if (event.currentTarget.value == 'none' || !this.price ){
					this.label.hide();
					this.target.data('input','').val('none');
					this.type = 'none';
                                 		this.price = $('input[name="items_price"]').val();
					if (!this.price) alert(_t['empty_price']);
					return;
				}
				this.input = null;
				this.onPrompt();
			},
			reinput:function(event){
                                 	this.price = $('input[name="items_price"]').val();
				this.input = "";
				this.onPrompt();
			},
			onPrompt:function(){
				var 
				unit_option =  this.target.val() ,
				default_input = this.target.data('input')||'';
	                              this.type = this.target.find('option:selected').parent('optgroup').data('dimension');
	                              this.input_label =  this.target.find('option:selected').parent('optgroup').prop('label');
				switch (this.type){
					case 'Weight':
						default_input = default_input || $('input[name="items_weight"]').val();
					break;
				}
			      	if (  isNaN(this.input) || ! this.input) {
			      		 this.input = prompt(  this.prompt.replace('%s', this.input_label) + " (" + ( this.units[unit_option]||unit_option )+"):",default_input);
			      	}	 
				   if (!this.input ||  parseFloat(this.input) == 0 || isNaN(this.input) ){
					this.target.val(this.unit_price_option);
				   }else {
				   	 this.unit_price_option =  unit_option; 
				   	 this.target.data('input', this.input);
					this.unit_price_factor = this.input/( this.ratio[this.unit_price_option] || 1);
					this.refresh();
				  }
			
			},
			onPriceChange:function(event){
                                 	this.price = event.currentTarget.value;
                                 	this.refresh();
			},
			refresh:function(){
				if (this.unit_price_option == 'none'){
					this.label.hide();
				}else{
					this.label.show().find('span').text( ( this.price / this.unit_price_factor).toFixed(2).toLocaleString() + ' / '  );
					$('input[name="unit_price_factor"]').val(this.unit_price_factor);
				}
			}			
		};
		unit_pricing.init();
	});
</script>