<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015

  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse
  Community, die bei Problemen weiterhelfen kann.

  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.

  Hilfe erhalten Sie im Forum auf www.bigware.de

  -----------------------------------------------------------------------

 ##################################################################################




*/
?>
<?php
  if (function_exists('mysqli_set_charset') === false) {
  	function mysqli_set_charset($charset, $link_identifier = null)
  	{
  		if ($link_identifier == null) {
  			return mysqli_query('SET CHARACTER SET "'.$charset.'"');
  		} else {
  			return mysqli_query($link_identifier, 'SET CHARACTER SET "'.$charset.'"');
  		}
  	}
  }
  function bigware_db_connect($server = DB_SERVER, $username = DB_SERVER_USERNAME, $password = DB_SERVER_PASSWORD, $database = DB_DATABASE) {
  	global $$link;
  	if (USE_PCONNECT == 'true') {
  		$$link = mysqli_pconnect($server, $username, $password);
  	} else {
  		$$link = mysqli_connect($server, $username, $password);
  	}
  	if ($$link) {
  		if (defined(DB_CHARSET)) mysqli_set_charset(DB_CHARSET, $$link);
  		mysqli_select_db($$link, $database);
  	}
  	return $$link;
  }
  function bigware_db_select_db($database) {
      global $$link;
      return mysqli_select_db($$link, $database);
  }
  function bigware_db_close() {
  	global $$link;
  	return mysqli_close($$link);
  }
  function bigware_db_error($query, $errno, $error) {
  	die('<font color="#000000"><b>' . $errno . ' - ' . $error . '<br><br>' . $query . '<br><br><small><font color="#ff0000">[TEP STOP]</font></small><br><br></b></font>');
  }
  function bigware_db_query($query) {
  	global $$link, $logger;
          if(!$$link)
          {
              bigware_db_connect();
          }
  	if (defined('SHOP_DB_TRANSACTIONS') && (SHOP_DB_TRANSACTIONS == 'true')) {
  		if (!is_object($logger)) $logger = new logger;
  		$logger->write($query, 'QUERY');
  	}
  	$result = mysqli_query($$link, $query) or bigware_db_error($query, mysqli_errno(), mysqli_error($$link));
  	if (defined('SHOP_DB_TRANSACTIONS') && (SHOP_DB_TRANSACTIONS == 'true')) {
  		if (mysqli_error($$link)) $logger->write(mysqli_error(), 'ERROR');
  	}
  	return $result;
  }
  function bigware_db_carry($table, $data, $action = 'insert', $parameters = '') {
  	reset($data);
  	if ($action == 'insert') {
  		$query = 'insert into ' . $table . ' (';
  		while (list($columns, ) = each($data)) {
  			$query .= $columns . ', ';
  		}
  		$query = substr($query, 0, -2) . ') values (';
  		reset($data);
  		while (list(, $value) = each($data)) {
  			switch ((string)$value) {
  				case 'now()':
  					$query .= 'now(), ';
  				break;
  				case 'null':
  					$query .= 'null, ';
  				break;
  				default:
  					$query .= '\'' . bigware_db_input($value) . '\', ';
  				break;
  			}
  		}
  		$query = substr($query, 0, -2) . ')';
  	} elseif ($action == 'update') {
  		$query = 'update ' . $table . ' set ';
  		while (list($columns, $value) = each($data)) {
  			switch ((string)$value) {
  				case 'now()':
  				$query .= $columns . ' = now(), ';
  				break;
  				case 'null':
  				$query .= $columns .= ' = null, ';
  				break;
  				default:
  				$query .= $columns . ' = \'' . bigware_db_input($value) . '\', ';
  				break;
  			}
  		}
  		$query = substr($query, 0, -2) . ' where ' . $parameters;
  	}
  	return bigware_db_query($query);
  }
  function mysqli_table_exists($table) {
  	global $$link, $logger;
  	$query = "SELECT 1 FROM `$table` LIMIT 0";
  	if (defined('SHOP_DB_TRANSACTIONS') && (SHOP_DB_TRANSACTIONS == 'true')) {
  		if (!is_object($logger)) $logger = new logger;
  		$logger->write($query, 'QUERY');
  	}
  	$exists = @mysqli_query($query, $$link); // Fehler werden nicht ausgegeben;
  	if ($exists) return true;
  	return false;
  }
  function bigware_db_fetch_array($db_query) {
  	return $db_query?mysqli_fetch_array($db_query):null;
  }
  function bigware_db_num_rows($db_query) {
  	return mysqli_num_rows($db_query);
  }
  function bigware_db_numrows($db_query) {
      return mysqli_num_rows($db_query);
  }
  function bigware_db_data_seek($db_query, $row_number) {
  	return mysqli_data_seek($db_query, $row_number);
  }
  function bigware_db_insert_id() {
    global $$link;
  	return mysqli_insert_id($$link);
  }
  function bigware_db_free_result($db_query) {
  	return mysqli_free_result($db_query);
  }
  function bigware_db_fetch_fields($db_query) {
  	return mysqli_fetch_field($db_query);
  }
  function bigware_db_field_name($db_query, $count) {
  	return mysqli_field_name($db_query, $count);
  }
  function bigware_db_mysqli_num_fields($db_query) {
  	return mysqli_num_fields($db_query);
  }
  function bigware_db_affected_rows($link) {
  	return mysqli_affected_rows($link);
  }
  function bigware_db_fetch_object($db_query) {
  	return mysqli_fetch_object($db_query);
  }
  function bigware_db_fetch_row($db_query) {
  	return mysqli_fetch_row($db_query);
  }
  function bigware_db_real_escape_string($db_query) {
  	return mysqli_real_escape_string($db_query);
  }

  if (!function_exists('mysqli_result')) {

      function mysqli_result($res, $row = 0, $col = 0) {
          $numrows = mysqli_num_rows($res);
          if ($numrows && $row <= ($numrows - 1) && $row >= 0) {
              mysqli_data_seek($res, $row);
              $resrow = (is_numeric($col)) ? mysqli_fetch_row($res) : mysqli_fetch_assoc($res);
              if (isset($resrow[$col])) {
                  return $resrow[$col];
              }
          }
          return false;
      }

  }

  function bigware_db_result($db_query, $row = 0, $col = 0) {
  	return mysqli_result($db_query, $row, $col);
  }
  function bigware_db_output($string) {
  	return isohtmlspecialchars($string);
  }
  function bigware_db_input($string) {
  	return addslashes($string);
  }
  function bigware_db_producing_input($string) {
      global $$link;
  	if (is_string($string)) {
  		return trim(mysqli_real_escape_string($$link, stripslashes($string)));
  	} elseif (is_array($string)) {
  		reset($string);
  		while (list($key, $value) = each($string)) {
  			$string[$key] = bigware_db_producing_input($value);
  		}
  		return $string;
  	} else {
  		return $string;
  	}
  }
  function mysqli_result($res,$row=0,$col=0){
      $numrows = mysqli_num_rows($res);
      if ($numrows && $row <= ($numrows-1) && $row >=0){
          mysqli_data_seek($res,$row);
          $resrow = (is_numeric($col)) ? mysqli_fetch_row($res) : mysqli_fetch_assoc($res);
          if (isset($resrow[$col])){
              return $resrow[$col];
          }
      }
      return false;
  }

  function bigware_db_test_create_db_permission($database) {
    global $db_error;
    global $$link;
    $db_created = false;
    $db_error = false;
    if (!$database) {
      $db_error = 'No Database selected.';
      return false;
    }
    if (!$db_error) {
      if (!@bigware_db_select_db($database)) {
        $db_created = true;
        if (!@bigware_db_query('create database ' . $database)) {
          $db_error = mysqli_error($$link);
        }
      } else {
        $db_error = mysqli_error($$link);
      }
      if (!$db_error) {
        if (@bigware_db_select_db($database)) {
          if (@bigware_db_query('create table temp ( temp_id int(5) )')) {
            if (@bigware_db_query('drop table temp')) {
              if ($db_created) {
                if (@bigware_db_query('drop database ' . $database)) {
                } else {
                  $db_error = mysqli_error($$link);
                }
              }
            } else {
              $db_error = mysqli_error($$link);
            }
          } else {
            $db_error = mysqli_error($$link);
          }
        } else {
          $db_error = mysqli_error($$link);
        }
      }
    }
    if ($db_error) {
      return false;
    } else {
      return true;
    }
  }
  function bigware_db_test_connection($database) {
    global $db_error;
    global $$link;
    $db_error = false;
    if (!$db_error) {
      if (!@bigware_db_select_db($database)) {
        $db_error = mysqli_error();
      } else {
        if (!@bigware_db_query('select count(*) from set_it_up')) {
          $db_error = mysqli_error($$link);
        }
      }
    }
    if ($db_error) {
      return false;
    } else {
      return true;
    }
  }
  function bigware_db_install($database, $sql_file) {
    global $db_error;
    global $$link;
    $db_error = false;
    if (!@bigware_db_select_db($database)) {
      if (@bigware_db_query('create database ' . $database)) {
        bigware_db_select_db($database);
      } else {
        $db_error = mysqli_error($$link);
      }
    }
    if (!$db_error) {
      if (file_exists($sql_file)) {
        $fd = fopen($sql_file, 'rb');
        $restore_query = fread($fd, filesize($sql_file));
        fclose($fd);
      } else {
        $db_error = 'SQL file does not exist: ' . $sql_file;
        return false;
      }
      $sql_array = array();
      $sql_length = strlen($restore_query);
      $pos = strpos($restore_query, ';');
      for ($i=$pos; $i<$sql_length; $i++) {
        if ($restore_query[0] == '#') {
          $restore_query = ltrim(substr($restore_query, strpos($restore_query, "\n")));
          $sql_length = strlen($restore_query);
          $i = strpos($restore_query, ';')-1;
          continue;
        }
        if ($restore_query[($i+1)] == "\n") {
          for ($j=($i+2); $j<$sql_length; $j++) {
            if (trim($restore_query[$j]) != '') {
              $next = substr($restore_query, $j, 6);
              if ($next[0] == '#') {
                for ($k=$j; $k<$sql_length; $k++) {
                  if ($restore_query[$k] == "\n") break;
                }
                $query = substr($restore_query, 0, $i+1);
                $restore_query = substr($restore_query, $k);
                $restore_query = $query . $restore_query;
                $sql_length = strlen($restore_query);
                $i = strpos($restore_query, ';')-1;
                continue 2;
              }
              break;
            }
          }
          if ($next == '') {
            $next = 'insert';
          }
          if ( (preg_match('/create/i', $next)) || (preg_match('/insert/i', $next)) || (preg_match('/drop t/i', $next)) ) {
            $next = '';
            $sql_array[] = substr($restore_query, 0, $i);
            $restore_query = ltrim(substr($restore_query, $i+1));
            $sql_length = strlen($restore_query);
            $i = strpos($restore_query, ';')-1;
          }
        }
      }
      bigware_db_query("drop table if exists directory_to_address, form_of_address, banners, banners_history, categories, categories_description, set_it_up, set_it_up_group, counter, counter_history, lands, currencies, attendees, attendees_basket, attendees_basket_characteristics, attendees_info, languages, producers, producers_info, orders, orders_items, orders_status, orders_status_history, orders_items_characteristics, orders_items_download, items, items_characteristics, items_characteristics_download, prodcts_description, items_options, items_options_values, items_options_values_to_items_options, items_to_categories, reviews, reviews_description, sessions, specials, tax_class, tax_rates, geo_zones, whos_online, zones, zones_to_geo_zones");
      for ($i=0; $i<sizeof($sql_array); $i++) {
        bigware_db_query($sql_array[$i]);
      }
    } else {
      return false;
    }
  }
?>
