<?php
/*
Copyright: Dirk Pagador 
Website: www.pagador.de
*/

class pagadors_png_font_class_reflection {
	var $font = './font.ttf'; //default font. directory relative to script directory.
	var $msg = ""; // default text to display.
	var $size = 15; 
	var $rot = 0; // rotation in degrees.
	var $pad = 0; // padding.
	var $transparent = 1; // transparency set to on "1".
	var $shadow = 1; // shadow set to on "1".
	var $red = 0; // black text...
	var $grn = 0;
	var $blu = 0;
	var $bg_red = 255; // on white background.
	var $bg_grn = 255;
	var $bg_blu = 255;
	var $shadow_red = 200; // with gray shadow.
	var $shadow_grn = 200;
	var $shadow_blu = 200;
	var $refl = 1;
	var $refl_height = 0.99;
	var $refl_min_trans = 50;
	var $refl_max_trans = 100;
	var $pic_extra_height = 1;
	var $pic_extra_width = 1;
	var $font_down_extra_pix = 0; 
	var $font_right_extra_pix = 0; 
	var $shadow_down_pix = 2; 
	var $shadow_right_pix = 2; 
	var $font_refl_resample_methode = 1; 
	var $shadow_to_refl = 0;


	function draw_the_font() {
		$width = 0;
		$height = 0;
		$offset_x = 0;
		$offset_y = 0;
		$bounds = array();
		$image = "";
	
		// determine font height.
		$bounds = ImageTTFBBox($this->size, $this->rot, $this->font, "W");
		if ($this->rot < 0) {
			$font_height = abs($bounds[7]-$bounds[1]);		
		} else if ($this->rot > 0) {
			$font_height = abs($bounds[1]-$bounds[7]);
		} else {
			$font_height = abs($bounds[7]-$bounds[1]);
		}

		$search = array("", "", "", "", "", "", "", "$", 
										"euro", "eur", "_eu_", "EURO", "EUR", "_EU_", "Euro", "Eur", "_Eu_");
		$replace = array("&#196;", "&#214;", "&#220;", "&#228;", "&#246;", "&#252;", "&#8364;", "&#36;", 
											"&#8364;", "&#8364;", "&#8364;", "&#8364;", "&#8364;", "&#8364;", "&#8364;", "&#8364;", "&#8364;");
		$the_text = str_replace($search, $replace, $this->msg);

		// determine bounding box.
		$bounds = ImageTTFBBox($this->size, $this->rot, $this->font, $the_text);
		if ($this->rot < 0) {
			$width = abs($bounds[4]-$bounds[0]);
			$height = abs($bounds[3]-$bounds[7]);
			$offset_y = $font_height;
			$offset_x = 0;
			
		} else if ($this->rot > 0) {
			$width = abs($bounds[2]-$bounds[6]);
			$height = abs($bounds[1]-$bounds[5]);
			$offset_y = abs($bounds[7]-$bounds[5])+$font_height;
			$offset_x = abs($bounds[0]-$bounds[6]);
			
		} else {
			$width = abs($bounds[4]-$bounds[6]);
			$height = abs($bounds[7]-$bounds[1]);
			$offset_y = $font_height;
			$offset_x = 0;
		}

		$image = imagecreatetruecolor($width+($this->pad*2)+$this->pic_extra_width ,$height+($this->pad*2)+$this->pic_extra_height);
		$foreground = ImageColorAllocate($image, $this->red, $this->grn, $this->blu);
		if ($this->shadow == 1) {
			$shadow = ImageColorAllocate($image, $this->shadow_red, $this->shadow_grn, $this->shadow_blu);
		}

		if ($this->transparent){
			imagealphablending($image, false);
			$transparent = imagecolorallocatealpha($image, 0, 0, 0, 127);
			imagefill($image, 0, 0, $transparent);
			imagesavealpha($image,true);	
		}
		
		// render it.
		if ($this->shadow == 1) { 
			ImageTTFText($image, $this->size, $this->rot, (($offset_x+$this->pad)+($this->font_right_extra_pix))+($this->shadow_right_pix), (($offset_y+$this->pad)+($this->font_down_extra_pix))+($this->shadow_down_pix), $shadow, $this->font, $the_text);
		}
		ImageTTFText($image, $this->size, $this->rot, (($offset_x+$this->pad)+($this->font_right_extra_pix)), (($offset_y+$this->pad)+($this->font_down_extra_pix)), $foreground, $this->font, $the_text); 

		if ($this->refl == 1) {

			$red = $this->bg_red;
			$green = $this->bg_grn;
			$blue = $this->bg_blu;		
			$press = $this->font_refl_resample_methode;

			if (isset($this->refl_resampled_methode) &&  $this->refl_resampled_methode== 1) {
				$reflection_height = $height+($this->pad*2)+$this->pic_extra_height;
			
				//	Calculate the height of the output image
				if ($reflection_height < 1){
					//	The output height is a percentage
					$new_height = ($height+($this->pad*2)+$this->pic_extra_height) * $reflection_height;
					$new_y_pos_font = ($offset_y+$this->pad) * $reflection_height;
				}
				else{
					//	The output height is a fixed pixel value
					$new_height = $reflection_height;
					$new_y_pos_font = $reflection_height-(($this->pad*2)+1)-2; 
				}
				$reflection_height_press = $this->refl_height;
				//	Calculate the height of the output image
				if ($reflection_height_press < 1){
					//	The output height is a percentage
					$new_height_press = ($height+($this->pad*2)+$this->pic_extra_height) * $reflection_height_press;
				}
				else{
					//	The output height is a fixed pixel value
					$new_height_press = $reflection_height;
				}
			}else{
				$reflection_height = $this->refl_height;
				//	Calculate the height of the output image
				if ($reflection_height < 1){
					//	The output height is a percentage
					$new_height = ($height+($this->pad*2)+$this->pic_extra_height) * $reflection_height;
					$new_y_pos_font = ($offset_y+$this->pad) * $reflection_height;
				}
				else{
					//	The output height is a fixed pixel value
					$new_height = $reflection_height;
					$new_y_pos_font = $reflection_height-(($this->pad*2)+1)-2; 
				}
			}

			//////////////// scheiben schneiden /////////////////////////////
			// zum drauf malen:
			
			$underlay = imagecreatetruecolor($width+($this->pad*2)+$this->pic_extra_width,$new_height);		
			if ($this->transparent){
				//ImageColorTransparent($underlay, $underlay_background);
				imagealphablending($underlay, false);
				$transparent_underlay = imagecolorallocatealpha($underlay, 0, 0, 0, 127);
				imagefill($underlay, 0, 0, $transparent_underlay);
				imagesavealpha($underlay,true);	
			}
			// Was soll die hchste Tranzparenz sein? "127" = maximal
			$trans = $this->refl_max_trans;		
			// Was soll die niedrigste Tranzparenz sein? "0" = minimal
			$trans_min = $this->refl_min_trans;
			// erhht sich pro Scheibe um $trans_steps. Hchste Tranzparenz geteilt (/) durch die Hhe des Bildes gleich (=) steps
			$trans_steps = ($trans-$trans_min) / $new_height;
			$a = array($this->bg_red, $this->bg_grn, $this->bg_blu);
			$arg1 = '2';
			// die schleife fr die Scheiben
			for ($i = 1; $i <= $new_height; $i++) {
			// mach eine scheibe mit 1 pixel von insgesamt $new_height pixel von unten nach oben
				$output = imagecreatetruecolor($width+($this->pad*2)+$this->pic_extra_width,1);			
				if ($this->transparent){
					imagealphablending($output, false);
					$transparent_refl = imagecolorallocatealpha($output, 0, 0, 0, 127);
					imagefill($output, 0, 0, $transparent_refl);
					imagesavealpha($output,true);	
				}
				if ($this->shadow_to_refl == 1) {
					if ($this->shadow == 1) {
						$shadow = imagecolorallocatealpha($output, $this->shadow_red, $this->shadow_grn, $this->shadow_blu, $trans);
						ImageTTFText($output, $this->size, $this->rot, (($offset_x+$this->pad)+($this->font_right_extra_pix))+($this->shadow_right_pix), (((($new_y_pos_font+$this->pad))+($this->font_down_extra_pix))+($this->shadow_down_pix))-$i, $shadow, $this->font, $the_text);
					} 
				}
				$foreground = imagecolorallocatealpha($output, $this->red, $this->grn, $this->blu, $trans);
				ImageTTFText($output, $this->size, $this->rot, (($offset_x+$this->pad)+($this->font_right_extra_pix)), (($new_y_pos_font+$this->pad)+($this->font_down_extra_pix))-$i, $foreground, $this->font, $the_text);
				imagecopy($underlay, $output, 0, $i, 0, 0, $width+($this->pad*2)+$this->pic_extra_width, imagesy($output));
				$trans = $trans - $trans_steps;				
			}
		
			///////////////// scheiben schneiden ende ///////////////////////////
			
			$buffer = imagecreatetruecolor($width+($this->pad*2)+$this->pic_extra_width,$new_height);	
			if ($this->transparent){
				imagealphablending($buffer, false);
				$transparent_buffer = imagecolorallocatealpha($buffer, 0, 0, 0, 127);
				imagefill($buffer, 0, 0, $transparent_buffer);
				imagesavealpha($buffer,true);	
			}

		
		
			//	Rotieren und Spiegeln (strip flip method)
		    for ($y = 0; $y < $new_height; $y++) 
		    {
		       imagecopy($buffer, $underlay, 0, $y, 0, $new_height - $y - 1, $width+($this->pad*2)+$this->pic_extra_width, 1);  
		    }
		
		
			$output = $buffer;

			// beide zusammenfhren
			if ($press == 1) {	  
		  	$merged_output = imagecreate($width+($this->pad*2)+$this->pic_extra_width, $new_height_press + $height+($this->pad*2)+$this->pic_extra_height);
			}else{
				$merged_output = imagecreate($width+($this->pad*2)+$this->pic_extra_width, $new_height + $height+($this->pad*2)+$this->pic_extra_height);
			}
			$merged_output_background = ImageColorAllocate($merged_output, $this->bg_red, $this->bg_grn, $this->bg_blu);
			if ($this->transparent) ImageColorTransparent($merged_output, $merged_output_background);

		
		  //  Copy the source image
		  imagecopy($merged_output, $image, 0, 0, 0, 0, $width+($this->pad*2)+$this->pic_extra_width, $height+($this->pad*2)+$this->pic_extra_height);
		  
		  //  Copy our new reflection
		  if ($press == 1) {	  
		  	imagecopyresampled ( $merged_output , $output , 0 , $height+($this->pad*2)+$this->pic_extra_height , 0 , 0 , $width+($this->pad*2)+$this->pic_extra_width , $new_height_press , $width+($this->pad*2)+$this->pic_extra_width , $height+($this->pad*2)+$this->pic_extra_height );		  
		  }else{
		  	imagecopy($merged_output, $output, 0, $height+($this->pad*2)+$this->pic_extra_height, 0, 0, $width+($this->pad*2)+$this->pic_extra_width, imagesy($output));
			}
		  
		  //  Replace the output with this new version
		  $image = $merged_output;
		
		}

		// output PNG object.
		header("Content-type: image/png");	
		imagePNG($image);
		
	} // function draw
} // class textPNG
?>
