<?php
/***************************************************************************
 *							admin_mods.php
 *							--------------
 *	begin				: June, 2004
 *	copyright			: Marc Ferran (c) 2004
 *	email				: phpmix at pobox.com
 *	module				: mx_modsdb
 *	file contents		: ModsDB Management.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 ***************************************************************************/

// ======================================================
//			[ ADMINCP COMMON INITIALIZATION ]
// ======================================================

//
// Add our entry to the Administration Control Panel...
//
if( !empty($setmodules) )
{
	$module['ModsDB']['Mods_Database'] = 'modules/mx_modsdb/admin/' . @basename(__FILE__);
	return;
}

//
// Setup basic portal stuff...
//
define('IN_PORTAL', true);
$mx_root_path = '../../../';
$module_root_path = '../';

//
// Security and page header...
//
require($mx_root_path . 'extension.inc');
require($mx_root_path . 'admin/pagestart.'.$phpEx);

//
// Include common module stuff...
//
require($module_root_path . 'includes/common.'.$phpEx);

//
// Send page header...
//
include_once($mx_root_path . 'admin/page_header_admin.'.$phpEx);

$icon_download = $module_root_path . 'templates/images/icon_download.gif';


// ======================================================
//			[ MAIN PROCESS ]
// ======================================================

//
// Check to see what mode we should operate in.
//
if( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = '';
}

//
// Select main mode
//
if( isset($HTTP_POST_VARS['add']) || isset($HTTP_GET_VARS['add']) )
{
	//
	// Admin has selected to add a Mod.
	//
	$template->set_filenames(array(
		'body' => 'admin/modsdb_edit_body.tpl')
	);
	$filename_list = "";
	$s_hidden_fields = '<input type="hidden" name="mode" value="savenew" />';
	$template->assign_vars(array(
		'L_MODS_TITLE'		=> $lang['Mods_title'],
		'L_MODS_TEXT'		=> $lang['Mods_explain'],
		'L_MOD_NAME'		=> $lang['Mods_name'],
		'L_MOD_VERSION'		=> $lang['Mod_version'],
		'L_MODS_CONFIG'		=> $lang['Mods_config'],
		'L_MOD_DESC'		=> $lang['Mod_description'],
		'L_MOD_URL'			=> $lang['Mod_url'],
		'L_MOD_AUTHOR'		=> $lang['Mod_author'],
		'L_MOD_DOWNLOAD'	=> $lang['Mod_download'],
		'L_SUBMIT'			=> $lang['Submit'],
		'L_RESET'			=> $lang['Reset'],

		'S_MODS_ACTION'		=> append_sid("admin_mods.$phpEx"), 
		'S_HIDDEN_FIELDS'	=> $s_hidden_fields, 
		'S_FILENAME_OPTIONS' => $filename_list)
	);
	$template->pparse('body');
}
else if ( $mode != '' )
{
	switch( $mode )
	{
		case 'delete':
			//
			// Admin has selected to delete a Mod.
			//
			$mod_id = ( !empty($HTTP_POST_VARS['id']) ) ? $HTTP_POST_VARS['id'] : $HTTP_GET_VARS['id'];
			$sql = 'DELETE FROM '.MODSDB_ITEMS_TABLE.' WHERE mod_id = '.$mod_id;
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, "Couldn't delete Mod", "", __LINE__, __FILE__, $sql);
			}
			$message = $lang['Mod_del_success'] .
				'<br /><br />' .
				sprintf($lang['Click_return_modadmin'], '<a href="'.append_sid("admin_mods.$phpEx").'">', '</a>') .
				'<br /><br />' .
				sprintf($lang['Click_return_admin_index'], '<a href="'.append_sid("index.$phpEx?pane=right").'">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
			break;

		case 'edit':
			//
			// Admin has selected to edit a Mod.
			//
			$mod_id = ( !empty($HTTP_POST_VARS['id']) ) ? $HTTP_POST_VARS['id'] : $HTTP_GET_VARS['id'];
			$sql = 'SELECT * FROM '.MODSDB_ITEMS_TABLE.' WHERE mod_id = '.$mod_id;
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not obtain Mods information', "", __LINE__, __FILE__, $sql);
			}
			$mods_data = $db->sql_fetchrow($result);
			$filename_list = '';

			$template->set_filenames(array(
				'body' => 'admin/modsdb_edit_body.tpl')
			);
			$s_hidden_fields = '<input type="hidden" name="mode" value="save" /><input type="hidden" name="mod_id" value="'.$mod_id.'" />';

			$template->assign_vars(array(
				'MOD_TITLE'			=> $mods_data['mod_title'],
				'MOD_VERSION'		=> $mods_data['mod_version'],
				'MOD_DESC'			=> $mods_data['mod_description'],
				'MOD_URL'			=> $mods_data['mod_url'],
				'MOD_AUTHOR'		=> $mods_data['mod_author'],
				'MOD_DOWNLOAD'		=> $mods_data['mod_download'],

				'L_MODS_TITLE'		=> $lang['Mods_title'],
				'L_MODS_TEXT'		=> $lang['Mods_explain'],
				'L_MODS_CONFIG'		=> $lang['Mods_config'],
				'L_MOD_NAME'		=> $lang['Mods_name'],
				'L_MOD_VERSION'		=> $lang['Mod_version'],
				'L_MOD_DESC'		=> $lang['Mod_description'],
				'L_MOD_URL'			=> $lang['Mod_url'],
				'L_MOD_AUTHOR'		=> $lang['Mod_author'],
				'L_MOD_DOWNLOAD'	=> $lang['Mod_download'],
				'L_SUBMIT'			=> $lang['Submit'],
				'L_RESET'			=> $lang['Reset'],

				'S_MODS_ACTION'		=> append_sid("admin_mods.$phpEx"),
				'S_HIDDEN_FIELDS'	=> $s_hidden_fields, 
				'S_FILENAME_OPTIONS' => $filename_list) 
			);
			$template->pparse('body');
			break;

		case "save":
			//
			// Admin has submitted changes while editing a Mod.
			//

			//
			// Get the submitted data, being careful to ensure that we only
			// accept the data we are looking for.
			//
			$mod_title = ( isset($HTTP_POST_VARS['mod_title']) ) ? $HTTP_POST_VARS['mod_title'] : $HTTP_GET_VARS['mod_title'];
			$mod_version = ( isset($HTTP_POST_VARS['mod_version']) ) ? $HTTP_POST_VARS['mod_version'] : $HTTP_GET_VARS['mod_version'];
			$mod_description = ( isset($HTTP_POST_VARS['mod_desc']) ) ? $HTTP_POST_VARS['mod_desc'] : $HTTP_GET_VARS['mod_desc'];
			$mod_url = ( isset($HTTP_POST_VARS['mod_url']) ) ? $HTTP_POST_VARS['mod_url'] : $HTTP_GET_VARS['mod_url'];
			$mod_id = ( isset($HTTP_POST_VARS['mod_id']) ) ? intval($HTTP_POST_VARS['mod_id']) : intval($HTTP_GET_VARS['mod_id']);
			$mod_author = ( isset($HTTP_POST_VARS['mod_author']) ) ? $HTTP_POST_VARS['mod_author'] : $HTTP_GET_VARS['mod_author'];
			$mod_download = ( isset($HTTP_POST_VARS['mod_download']) ) ? $HTTP_POST_VARS['mod_download'] : $HTTP_GET_VARS['mod_download'];
			
			if ($mod_title == '' || $mod_version == '')
			{
				message_die(MESSAGE, $lang['Fields_empty']);
			}

			$sql = 'UPDATE '.MODSDB_ITEMS_TABLE."
				SET mod_title = '" . str_replace("\'", "''", $mod_title) . "', mod_version = '" . str_replace("\'", "''", $mod_version) . "', mod_description = '" . str_replace("\'", "''", $mod_description) . "', mod_url = '" . str_replace("\'", "''", $mod_url) . "', mod_author = '" . str_replace("\'", "''", $mod_author) . "', mod_download = '" . str_replace("\'", "''", $mod_download) . "'
				WHERE mod_id = $mod_id";
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, "Couldn't update Mods info", "", __LINE__, __FILE__, $sql);
			}

			$message = $lang['Mod_edit_success'] .
				'<br /><br />' .
				sprintf($lang['Click_return_modadmin'], '<a href="'.append_sid("admin_mods.$phpEx").'">', '</a>') .
				'<br /><br />' .
				sprintf($lang['Click_return_admin_index'], '<a href="'.append_sid("index.$phpEx?pane=right").'">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
			break;

		case "savenew":
			$mod_title = ( isset($HTTP_POST_VARS['mod_title']) ) ? $HTTP_POST_VARS['mod_title'] : $HTTP_GET_VARS['mod_title'];
			$mod_version = ( isset($HTTP_POST_VARS['mod_version']) ) ? $HTTP_POST_VARS['mod_version'] : $HTTP_GET_VARS['mod_version'];
			$mod_description = ( isset($HTTP_POST_VARS['mod_desc']) ) ? $HTTP_POST_VARS['mod_desc'] : $HTTP_GET_VARS['mod_desc'];
			$mod_url = ( isset($HTTP_POST_VARS['mod_url']) ) ? $HTTP_POST_VARS['mod_url'] : $HTTP_GET_VARS['mod_url'];
			$mod_author = ( isset($HTTP_POST_VARS['mod_author']) ) ? $HTTP_POST_VARS['mod_author'] : $HTTP_GET_VARS['mod_author'];
			$mod_download = ( isset($HTTP_POST_VARS['mod_download']) ) ? $HTTP_POST_VARS['mod_download'] : $HTTP_GET_VARS['mod_download'];

			// If no code was entered complain ...
			if( $mod_title == '' || $mod_version == '' )
			{
				message_die(MESSAGE, $lang['Fields_empty']);
			}

			//
			// Save the data to the mods table.
			//
			$sql = 'INSERT INTO '.MODSDB_ITEMS_TABLE." (mod_title, mod_version, mod_description, mod_url, mod_author, mod_download)
				VALUES ('" . str_replace("\'", "''", $mod_title) . "', '" . str_replace("\'", "''", $mod_version) . "', '" . str_replace("\'", "''", $mod_description) . "', '" . str_replace("\'", "''", $mod_url) . "', '" . str_replace("\'", "''", $mod_author) . "', '" . str_replace("\'", "''", $mod_download) . "')";
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, "Couldn't insert new Mod", "", __LINE__, __FILE__, $sql);
			}

			$message = $lang['Mod_add_success'] .
				'<br /><br />' .
				sprintf($lang['Click_return_modadmin'], '<a href="'.append_sid("admin_mods.$phpEx").'">', '</a>') .
				'<br /><br />' .
				sprintf($lang['Click_return_admin_index'], '<a href="'.append_sid("index.$phpEx?pane=right").'">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
			break;
	}
}
else
{
	$sql = 'SELECT * FROM '.MODSDB_ITEMS_TABLE.' ORDER BY mod_title';
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain mods from database", "", __LINE__, __FILE__, $sql);
	}
	$mods = $db->sql_fetchrowset($result);

	$template->set_filenames(array(
		'body' => 'admin/modsdb_list_body.tpl')
	);
	$template->assign_vars(array(
		'L_ACTION'			=> $lang['Action'],
		'L_MODS_TITLE'		=> $lang['Mods_title'],
		'L_MODS_TEXT'		=> $lang['Mods_explain'],
		'L_DELETE'			=> $lang['Delete'],
		'L_EDIT'			=> $lang['Edit'],
		'L_MOD_ADD'			=> $lang['Mod_add'],
		'L_MOD_ID'			=> $lang['Mod_id'],
		'L_MOD_TITLE'		=> $lang['Mod_title'],
		'L_MOD_VERSION'		=> $lang['Mod_version'],
		'L_MOD_DESC'		=> $lang['Mod_description'],
		'L_MOD_URL'			=> $lang['Mod_url'],
		'L_MOD_AUTHOR'		=> $lang['Mod_author'],
		'L_MOD_DOWNLOAD'	=> $lang['Mod_download'],		
		'S_HIDDEN_FIELDS'	=> $s_hidden_fields, 
		'S_MODS_ACTION'		=> append_sid("admin_mods.$phpEx"))
	);
	for( $i = 0; $i < count($mods); $i++ )
	{
		$mod_id = $mods[$i]['mod_id'];
		$mod_img = ( $mods[$i]['mod_url'] ) ? '<a href="' . $mods[$i]['mod_url'] . '" target="_userwww"><img src="../' . $phpbb_root_path.$images['icon_www'] . '" alt="' . $lang['Visit_mod_website'] . '" title="' . $lang['Visit_mod_website'] . '" border="0" /></a>' : '';
		$mod_dl_img = ( $mods[$i]['mod_download'] ) ? '<a href="' . $mods[$i]['mod_download'] . '" target="_blank"><img src="' . $icon_download . '" alt="' . $lang['Visit_mod_website'] . '" title="' . $lang['Visit_mod_website'] . '" border="0" /></a>' : '';

		$template->assign_block_vars('mods', array(
			'ROW_COLOR'		=> "#" . ( (!($i % 2)) ? $theme['td_color1'] : $theme['td_color2'] ),
			'ROW_CLASS'		=> ( (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'] ),
			'MOD_ID'		=> $mod_id,
			'MOD_TITLE'		=> $mods[$i]['mod_title'],
			'MOD_VERSION'	=> $mods[$i]['mod_version'],
			'MOD_DESC'		=> $mods[$i]['mod_description'],
			'MOD_URL'		=> $mods[$i]['mod_url'],
			'MOD_AUTHOR'	=> $mods[$i]['mod_author'],
			'MOD_DOWNLOAD'	=> $mod_dl_img,
			'MOD_IMG'		=> $mod_img,
			'U_MOD_EDIT'	=> append_sid("admin_mods.$phpEx?mode=edit&amp;id=$mod_id"),
			'U_MOD_DELETE'	=> append_sid("admin_mods.$phpEx?mode=delete&amp;id=$mod_id"))
		);
	}
	$template->pparse('body');
}

include($mx_root_path . 'admin/page_footer_admin.'.$phpEx);

?>