<?php
/***************************************************************************
 *							mods.php
 *							--------
 *	begin				: June, 2004
 *	copyright			: Marc Ferran (c) 2004
 *	email				: phpmix at pobox.com
 *	module				: mx_modsdb
 *	file contents		: ModsDB (Block).
 *
 *	Note: Based on Mods Database Mod v0.1.3 by Stefan2k1 (www.phpbb2.de)
 *
 ***************************************************************************/

/***************************************************************************
 *                                         				                                
 *   This program is free software; you can redistribute it and/or modify  	
 *   it under the terms of the GNU General Public License as published by  
 *   the Free Software Foundation; either version 2 of the License, or	    	
 *   (at your option) any later version.
 *
 ***************************************************************************/

// --------------------------------------------------------------------------------
// Block Initialization
// --------------------------------------------------------------------------------

$block_title = 'ModsDB';

$page_id = intval($_GET['page']);
if( !function_exists('read_block_config') || !is_numeric($page_id) )
{
	message_die(GENERAL_ERROR, "This script should be executed as Portal Block.", 'mx_modsdb');
}
$u_portal_page = $mx_root_path."index.$phpEx?page=$page_id";

//
// Include common module stuff...
//
include_once($module_root_path . 'includes/common.' . $phpEx);

//
// Read block Configuration
//
$block_config  = read_block_config($block_id);
$block_size = ( isset($block_size) && !empty($block_size) ? $block_size : '100%' );
$icon_download = $module_root_path . 'templates/images/icon_download.gif';


// --------------------------------------------------------------------------------
// Block Procedure
// --------------------------------------------------------------------------------

//
// Obtain Mods
//
$sql = 'SELECT * FROM '.MODSDB_ITEMS_TABLE.' ORDER BY mod_title';
if( (!$result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Couldn't retrieve Mods data", "", __LINE__, __FILE__, $sql);
}
$mods = $db->sql_fetchrowset($result);


//
// This is the template used to render this block.
//
$template->set_filenames(array(
	'modsdb_body' => 'modsdb_list.tpl')
);

for( $i = 0; $i < count($mods); $i++ )
{
	$mod_img = ( $mods[$i]['mod_url'] ) ? '<a href="' . $mods[$i]['mod_url'] . '" target="_userwww"><img src="' . PHPBB_URL.$images['icon_www'] . '" alt="' . $lang['Visit_mod_website'] . '" title="' . $lang['Visit_mod_website'] . '" border="0" /></a>' : '';
	$mod_dl_img = ( $mods[$i]['mod_download'] ) ? '<a href="' . $mods[$i]['mod_download'] . '" target="_userwww"><img src="' . $icon_download . '" alt="' . $lang['Visit_mod_website'] . '" title="' . $lang['Visit_mod_website'] . '" border="0" /></a>' : '';

	$template->assign_block_vars('mods', array(
		'ROW_COLOR'		=> "#". ( (!($i % 2)) ? $theme['td_color1'] : $theme['td_color2'] ),
		'ROW_CLASS'		=>		( (!($i % 2)) ? $theme['td_class1'] : $theme['td_class2'] ),
		'MOD_ID'		=> $mods[$i]['mod_id'],
		'MOD_TITLE'		=> $mods[$i]['mod_title'],
		'MOD_VERSION'	=> $mods[$i]['mod_version'],
		'MOD_DESC'		=> $mods[$i]['mod_description'],
		'MOD_URL'		=> $mods[$i]['mod_url'],
		'MOD_URL_IMG'	=> $mod_img,
		'MOD_AUTHOR'	=> $mods[$i]['mod_author'],
		'MOD_DOWNLOAD'	=> $mod_dl_img,
		'MOD_IMG'		=> $mod_img)
	);
}

//
// Setup common template vars and display the block.
//
$template->assign_vars(array(
	'L_MODS_TITLE'		=> $lang['Mods_title'],
	'L_MODS_EXPLAIN'	=> $lang['Mods_explain'],
	'L_MOD_TITLE'		=> $lang['Mod_title'],
	'L_MOD_VERSION'		=> $lang['Mod_version'],
	'L_MOD_DESC'		=> $lang['Mod_description'],
	'L_MOD_URL'			=> $lang['Mod_url'],
	'L_MOD_AUTHOR'		=> $lang['Mod_author'],
	'L_MOD_DOWNLOAD'	=> $lang['Mod_download'],
	'U_MODS'			=> append_sid($u_portal_page),
	'L_MODS'			=> $lang['Mods'])
);	
$template->pparse('modsdb_body');

?>