<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.controller' );

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0.2
 */
class LyftenBloggieControllerUpdate extends LyftenBloggieController
{
	function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * Logic to upload a Theme
	 **/
	function doinstall()
	{
		require_once(JPATH_COMPONENT.DS.'libraries'.DS.'installer.php');
		$class 	= new LBInstaller();
		$msg 	= JText::_('THEME INSTALL WAS SUCCESSFULL');
		
		$class->setPackage();
		
		if(!$class->check()) {
			$msg = $class->getError();
		}
	
		if(!$class->install()) {
			$msg = $class->getError();
		}

		$this->setRedirect('index.php?option=com_lyftenbloggie&view=update', $msg);
	}
	
	/**
	 * Logic to publish
	 */
	function update()
	{

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		$upgrade 	= JRequest::getVar( 'upgrade', array(0), 'post', 'array' );
		$msg 		= JText::_( 'UPDATE INSTALLED');

		if (!is_array( $upgrade ) || count( $upgrade ) < 1) {
			$msg = '';
			JError::raiseWarning(500, JText::_( 'SELECT ITEM PUBLISH' ) );
		} else {

			$model = $this->getModel('update');

			if(!$model->update($upgrade[0], 1)) {
				$msg 	= $model->getError();
			}

			$cache = &JFactory::getCache('com_lyftenbloggie');
			$cache->clean();
		}

		$this->setRedirect( 'index.php?option=com_lyftenbloggie&view=update', $msg );
	}
	
	function cancel()
	{
		$this->setRedirect("index.php?option=com_lyftenbloggie&view=update");
	}
}