<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0.2
 */
class LBInstaller
{
	var $_db;
	var $_error;
	var $_tmp_path;
	var $_package;
	var $_package_location;
	var $_unpack_location;
	var $_extension_type;
	var $_extension_dir;
	var $_extension_name;
	var $_xml;
	var $_xml_filename;
	var $_install_root;
	var $_tags;
	
	
	function LBInstaller()
	{
		// Build the appropriate paths
		$config 			=& JFactory::getConfig();
		$this->_tmp_path 	= $config->getValue('config.tmp_path');
		$this->_error   	 = null;
		$this->_data     	= array();
		$this->_tags     	= array();
		$this->_db 			= &JFactory::getDBO();
	}
	
	
	function _findXML()
	{
		$files = JFolder::files($this->_unpack_location, '\.xml$', 1, true);
		$types = array('plugin', 'theme');
		
		if (count($files) > 0)
		{
			foreach ($files as $file)
			{
				$xmlDoc = & JFactory::getXMLParser();
				$xmlDoc->resolveErrors(true);

				if (!$xmlDoc->loadXML($file, false, true)){
					unset ($xmlDoc);
					continue;
				}
				
				$root = & $xmlDoc->documentElement;
				if (!is_object($root) || ($root->getTagName() != "install")){
					unset($xmlDoc);
					continue;
				}

				$type = $root->getAttribute('type');

				if(!in_array($type,$types)) {
					unset($xmlDoc);
					continue;
				}
				
				unset ($xmlDoc);
				return $file;
			}
			
			return false;
		}
		else {
			return false;
		}
	}
	
	
	function _clean_name($name)
	{
		$name = strtolower($name);
        $name = str_replace('-', '_', $name);
        $name = str_replace(' ', '_', $name);
        Jfile::makeSafe($name);
        
        return $name;
	}
	
	
	function _is_installed($name, $type)
	{
		switch ($type)
		{
			case 'plugin':
				$table = "#__bloggies_sideitems";
				break;
				
			case 'theme':
                $table = "#__bloggies_themes";
				break;
		}
		
		$query = "SELECT id FROM $table WHERE name = '$name' LIMIT 1";
		       $this->_db->setQuery($query);
		       $id = (int) $this->_db->loadResult();
		       
		if($id) {
			return true;
		}
		return false;
	}
	
	
	function _moveFiles()
	{
        $e = false;

		foreach ($this->_xml->document->files[0]->children() AS $element)
		{
			$path = $element->data();
			
			if($element->name() == 'folder') {
				$from = $this->_unpack_location.DS.$path;
				$to   = $this->_install_root.$path;

				if(!JFolder::exists($from)) {
					$this->setError('Directory Does not Exists: '.$from);
					return false;
				}
				
				if (!(JFolder::copy($from, $to))) {
					$this->setError('Installer: '.JText::sprintf('FAILED TO COPY FOLDER TO', $from, $to));
					return false;
				}
			}else{
			
				$from = $this->_unpack_location.DS.$path;
				$to   = $this->_install_root.$path;
						
				if(!file_exists($from) && !stristr($from, 'index.html')) {
					$e = true;
					$this->setError(JText::_('INSTALLER ERROR8').$from);
					return false;
				}
					
				if(file_exists($to) && !stristr($path, 'index.html')) {
					$e = true;
					$this->setError(JText::_('INSTALLER ERROR8').$to);
					return false;
				}
					
				if(!JFolder::exists(dirname($to))) {
					$e = (!JFolder::create(dirname($to)));
				}
					
				if(!JFile::move($from, $to)) {
					$this->setError(JText::_('INSTALLER ERROR8').$to);
					$e = true;
				}
			}
		}

		if($e) {
			$this->setError(JText::_('INSTALLER ERROR7'));
		}
		else {
			// copy the xml file
			JFile::copy($this->_xml_filename, $this->_install_root.DS.$this->_get_tag('name').'.xml');
		}
		
		return $e;
	}
	
	
	function _installSQL()
	{
		$e       = false;
		
		if(!in_array('install', $this->_tags)) {
			return $e;
		}
		
		foreach ($this->_xml->document->install[0]->children() AS $query)
		{
			$q = $query->data();
			
			if(!$q) {
				continue;
			}
			
			$this->_db->setQuery($q);
			$this->_db->query();
			$error = $this->_db->getErrorMsg();
			
			if($error) {
				$e = true;
				$this->setError($error);
				continue;
			}
		}
		
		return $e;
	}
	
	
	function _uninstallSQL($type, &$row)
	{
		if(!in_array('uninstall', $this->_tags)) {
			return true;
		}
		
		// loop through queries
		foreach ($this->_xml->document->uninstall[0]->children() AS $query)
		{
			$q = $query->data();
			
			if(!$q) {
				continue;
			}
			
			$this->_db->setQuery($q);
			$this->_db->query();
			
			if($this->_db->getErrorMsg()) {
			    $this->setError($this->_db->getErrorMsg());
			    return false;
		    }
		}
		
		return true;
	}
	
	
	function _custom_uninstall($type, &$row)
	{
		if(!in_array('uninstallfile', $this->_tags)) {
			return true;
		}
		
		switch ($type)
		{
			case 'plugin':
				$path = JPATH_COMPONENT_SITE.DS.'addons'.DS.'plugins'.DS.$row->name.DS;
				break;
				
			case 'theme':
                $path = JPATH_COMPONENT_SITE.DS.'addons'.DS.'themes'.DS.$row->name.DS;
				break;
		}
		
		$custom = $this->_xml->document->uninstallfile[0];
		$custom = $custom->data();

		if(file_exists($path.$custom) && $custom != '') {
			require_once($path.$custom);
		}
		
		return true;
	}
	
	
	function _load_extension($id, $type)
	{
		switch ($type)
		{
			case 'plugin':
				$table = "#__bloggies_sideitems";
				break;
				
			case 'theme':
                $table = "#__bloggies_themes";
				break;
		}
		
		$query = "SELECT * FROM $table WHERE id = '$id'";
		       $this->_db->setQuery($query);
		       $row = $this->_db->loadObject();
		       
		return $row;
	}
	
	
	function _load_tags()
	{
		$tags = $this->_xml->document->children();
		
		foreach ($tags AS $tag)
		{
			$this->_tags[] = strtolower( $tag->name() );
		}
	}
	
	
	function _check_tags()
	{
		if(!in_array('name', $this->_tags)) {
			$this->setError(JText::_('INSTALLER ERROR9'));
			return false;
		}
		if(!in_array('files', $this->_tags)) {
			$this->setError(JText::_('INSTALLER ERROR11'));
			return false;
		}
		if($this->_extension_type == 'panel' || $this->_extension_type == 'process') {
			if(!in_array('position', $this->_tags)) {
			    $this->setError(JText::_('INSTALLER ERROR12'));
			    return false;
		    }
		}
		return true;
	}
	
	
	function _get_tag($name)
	{
		if(in_array($name, $this->_tags)) {
			$tag = $this->_xml->document->$name;
			return $tag[0]->data();
		}
		
		return "";
	}
	
	function _check_plugin()
	{
		$data = array();
		$query = "SELECT * FROM #__bloggies_sideitems ORDER BY id ASC";
		       $this->_db->setQuery($query);
		       $tmp_data = $this->_db->loadObjectList();
		       
		if(!is_array($tmp_data)) { $tmp_data = array(); }

		foreach ($tmp_data AS $tmp)
		{
			if(!array_key_exists($tmp->name, $data)) {
				$data[$tmp->name] = array();
			}
			
			$data[$tmp->name][] = $tmp->name;
		}
		
		foreach ($this->_xml->document->files[0]->children() AS $file)
		{
			$f = $file->data();
			$s = $file->attributes('section');

			if(!$s) { continue; }
			
			if(DS == '/') {
				$f = str_replace('\\', DS, $f);
			}
			else {
				$f = str_replace('/', DS, $f);
			}
			
			$f = explode($s.DS, $f);
			$f = $f[1];

			if(array_key_exists($s, $data)) {
				if(!is_array($data[$s])) {
					$data[$s] = array();
				}
				if(in_array($f, $data[$s])) {
					return $s." => ".$f;
				}
			}
		}
		
		return true;
	}
		
	function _register_plugin()
	{
		$name           = $this->_db->Quote($this->_get_tag('name'));
		$title          = $this->_db->Quote($this->_get_tag('title'));
		$author         = $this->_db->Quote($this->_get_tag('author'));
		$custom_title   = $this->_db->Quote($this->_get_tag('custom_title'));
		$html        	= $this->_db->Quote($this->_get_tag('html'));
		$type      		= $this->_db->Quote($this->_get_tag('type'));
		$order			= $this->getNextOrder('#__bloggies_sideitems');
	
		$query = "INSERT INTO #__bloggies_sideitems VALUES(NULL, $name, $title, $author, $custom_title, $html, "
		       . "\n '0', $type, $order)";
		       $this->_db->setQuery($query);
		       $this->_db->query();
		       
		if($this->_db->getErrorMsg()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}       

		return true;
	}
	
	/**
	 * Returns the ordering value to place a new item last in its group
	 *
	 * @access public
	 * @param string query WHERE clause for selecting MAX(ordering).
	 */
	function getNextOrder ( $table='', $where='' )
	{
		if(!$table) return;

		$query = 'SELECT MAX(ordering)' .
				' FROM ' . $table .
				($where ? ' WHERE '.$where : '');

		$this->_db->setQuery( $query );
		$maxord = $this->_db->loadResult();

		if ($this->_db->getErrorNum())
		{
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return $maxord + 1;
	}
	
	function _register_theme()
	{
		$name           = $this->_db->Quote($this->_get_tag('name'));
		$title          = $this->_db->Quote($this->_get_tag('title'));
		$author         = $this->_db->Quote($this->_get_tag('author'));
		$email          = $this->_db->Quote($this->_get_tag('email'));
		$website        = $this->_db->Quote($this->_get_tag('website'));
		$version        = $this->_db->Quote($this->_get_tag('version'));
		$license        = $this->_db->Quote($this->_get_tag('license'));
		$copyright      = $this->_db->Quote($this->_get_tag('copyright'));
		$date           = $this->_db->Quote($this->_get_tag('date'));
        $now            = $this->_db->Quote(time());

		$query = "INSERT INTO #__bloggies_themes VALUES(NULL, $name, $title, '0', $author,"
		       . "\n $email, $website, $version, $license, $copyright,"
		       . "\n $date, '')";
		       $this->_db->setQuery($query);
		       $this->_db->query();
		       
		if($this->_db->getErrorMsg()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		return true; 
	}
	
	
	function _unregister_extension($id, $type)
	{
		switch ($type)
		{
			case 'plugin':
				$table = "#__bloggies_sideitems";
				break;
				
			case 'theme':
                $table = "#__bloggies_themes";
				break;
		}
		
		$query = "DELETE FROM $table WHERE id = '$id'";
		       $this->_db->setQuery($query);
		       $this->_db->query();
		       
		if($this->_db->getErrorMsg()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}       
		       
		return true;       
	}
	
	
	function _remove_data($type, &$row)
	{
		jimport('joomla.filesystem.file');
		
		if(!in_array('files', $this->_tags)) {
			return true;
		}
		
		if($type == "theme" || $type == "plugin") {
			$path = JPATH_COMPONENT_SITE.DS.'addons'.DS.$type.'s'.DS.$row->name;
			
			if(!JFolder::delete($path)) {
				$this->setError(JText::_('UNINSTALL ERROR2'));
				return false;
			}
		}
		return true;
	}
	
	function _clean_temp()
	{
		JFolder::delete($this->_unpack_location);
		JFile::delete($this->_package_location);
	}
	
	function setError($msg = null)
	{
		if(!$msg) { return false; }
		$this->_error 		= $msg;
	}
	
	function getError()
	{
		return $this->_error;
	}
	
	function setPackage($install_package = 'install_package')
	{
		$this->_package = JRequest::getVar($install_package, null, 'files', 'array' );

		if(is_null($this->_package)) {
			$this->setError(JText::_('INSTALLER ERROR2'));
			return false;
		}
		return true;
	}
	
	function check($install_package = 'install_package')
	{
		if (!(bool) ini_get('file_uploads')) {
			$this->setError(JText::_('INSTALLER ERROR1'));
			return false;
		}
		
		if (!extension_loaded('zlib')) {
			$this->setError(JText::_('INSTALLER ERROR3'));
			return false;
		}
		
		if ( $this->_package['error'] ){
			$this->setError(JText::_('INSTALLER ERROR4'));
			return false;
		}
		
		return true;
	}
	
	function install()
	{
		jimport('joomla.filesystem.file');
		
		if(!class_exists('JArchive')) {
			jimport('joomla.filesystem.archive');
		}
		
		if(!class_exists('JInstallerHelper')) {
			jimport('joomla.installer.helper');
		}
		
		// upload the package
		JFile::upload($this->_package['tmp_name'], $this->_tmp_path.DS.$this->_package['name']);
		
		// unpack it
		$tmpdir                  = uniqid('install_');
		$this->_unpack_location  = JPath::clean($this->_tmp_path.DS.$tmpdir);
		$this->_package_location = JPath::clean($this->_tmp_path.DS.$this->_package['name']);
		
		$result = JArchive::extract( $this->_package_location, $this->_unpack_location );
		
		if ($result === false) {
			$this->setError(JText::_('INSTALLER ERROR5'));
			$this->_clean_temp();
			return false;
		}
		
		$dirList = array_merge(JFolder::files($this->_unpack_location, ''), JFolder::folders($this->_unpack_location, ''));
		
		if (count($dirList) == 1)
		{
			if (JFolder::exists($this->_unpack_location.DS.$dirList[0])) {
				$this->_unpack_location = JPath::clean($this->_unpack_location.DS.$dirList[0]);
			}
		}
		
		if ($type = JInstallerHelper::detectType($this->_unpack_location)) {
			$this->_extension_type = $type;
		} 
		else {
			$this->setError(JText::_('INSTALLER ERROR6'));
			return false;
			$this->_clean_temp();
		}
		
		// read the xml file
		$this->_xml_filename = $this->_findXML();

		if(!$this->_xml_filename) {
			$this->setError(JText::_('INSTALLER ERROR6'));
			$this->_clean_temp();
			return false;
		}
		
		$this->_xml = new JSimpleXML();
		$this->_xml->loadFile($this->_xml_filename);

		// load tags
		$this->_load_tags();
		
		// check tags
		if(!$this->_check_tags()) {
			$this->_clean_temp();
			return false;
		}
		
		$this->_extension_name = $this->_xml->document->name[0]->data();
		
		// clean name
        $this->_extension_dir = $this->_clean_name($this->_extension_name);
        
        // check if already installed?
        if($this->_is_installed($this->_extension_name, $this->_extension_type)) {
        	$this->_clean_temp();
        	$this->setError(JText::_('INSTALLER ERROR13'));
        	return false;
        }

        // check plugin
        if($type == 'plugin') {
        	$f = $this->_check_plugin();
        	
        	if($f !== true) {
        		$this->_clean_temp();
        	    $this->setError(JText::_('INSTALLER ERROR14').$f);
        	    return false;
        	}
        }
        
		switch ($this->_extension_type)
		{
			case 'plugin':
				$this->_install_root = JPATH_COMPONENT_SITE.DS.'addons'.DS.'plugins'.DS.$this->_extension_dir.DS;
				break;
				
			case 'theme':
				$this->_install_root = JPATH_COMPONENT_SITE.DS.'addons'.DS.'themes'.DS.$this->_extension_dir.DS;
				break;
		}
	
		// move all files
		$error = $this->_moveFiles();
		
		if($error) {
			$this->setError(JText::_('INSTALLER ERROR7'));
			$this->_clean_temp();
			return false;
		}
		
		// run queries
		$error = $this->_installSQL();
		
		if($error) {
			$this->_clean_temp();
			return false;
		}
		
		// register extension
		switch ($this->_extension_type)
		{
			case 'plugin':
				$success = $this->_register_plugin();
				break;
				
			case 'theme':
				$success = $this->_register_theme();
				break;
		}
		
		if(!$success) {
			$this->_clean_temp();
			return false;
		}
		
		$this->_clean_temp();
		return true;
	}
	
	
	function uninstall($id, $type)
	{	
		$id      = (int)$id;
        
		// check id & type
		if(!$id || !$type) {
			$this->setError(JText::_('UNINSTALL ERROR1'));
			return false;
		}
		
		// load the extension info
		$row = $this->_load_extension($id, $type);
		
		if(!$row) {
			$this->setError(JText::_('UNINSTALL ERROR1'));
			return false;
		}
		
		// load xml file
		switch ($type)
		{
			case 'plugin':
				$this->_xml_filename = JPATH_COMPONENT_SITE.DS.'addons'.DS.'plugins'.DS.$row->name.DS.$row->name.".xml";
				break;
				
			case 'theme':
                $this->_xml_filename = JPATH_COMPONENT_SITE.DS.'addons'.DS.'themes'.DS.$row->name.DS.$row->name.".xml";
				break;
		}
		
		// check if file exists
		if(!file_exists($this->_xml_filename)) {
			$this->setError(JText::_('UNINSTALL ERROR3'));
			return false;
		}
		
		// parse xml file
		$this->_xml = new JSimpleXML();
		$this->_xml->loadFile($this->_xml_filename);
		
		// load tags
		$this->_load_tags();
		
		// run uninstall queries
		$success = $this->_uninstallSQL($type, $row);
		
		if(!$success) {
			return false;
		}
		
		// run custom uninstall script
		$this->_custom_uninstall($type, $row);

		// remove data
		$this->_remove_data($type, $row);
		
		// remove install entry
		$this->_unregister_extension($id, $type);
		
		return true;
	}
	
	//Download update
	function download($package)
	{
		if ( ! preg_match('!^(http|https|ftp)://!i', $package) && file_exists($package) ) //Local file or remote?
			return $package; //must be a local file..

		//WARNING: The file is not automatically deleted, The script must unlink() the file.
		if ( ! $package )
			return $this->setError(JText::_('Invalid URL Provided'));

		$download_file = $this->_tmp_path.DS.$package;
		
		//Create temporary file
		if ( empty($dir) )
			$dir = JPATH_ROOT.DS.'tmp';
		$download_file = basename($package);
		if ( empty($download_file) )
			$download_file = time();

		$download_file = $dir.DS.$download_file;
		touch($download_file);
		
		//Set Error file not created
		if ( ! $download_file )
			return $this->setError(JText::_('Could not create Temporary file'));

		$handle = @fopen($download_file, 'wb');
		if ( ! $handle )
			return $this->setError(JText::_('Could not create Temporary file'));

		//Get Package
		$objFetchSite 	= new LB_Http();
		$response		= $objFetchSite->get($package, array('timeout' => 60));

		if ( $response['error'] ) {
			fclose($handle);
			unlink($download_file);
			return $this->setError($response['error']);
		}

		if ( $response['response']['code'] != '200' ){
			fclose($handle);
			unlink($download_file);
			return $this->setError(trim($response['response']['message']));
		}

		fwrite($handle, $response['body']);
		fclose($handle);

		return $download_file;
	}
}
?>