<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

class RSSFunction
{
	/**
	 * Method to get feed
	 **/
	function getRSSFeed(&$rssurl)
	{
		if (!@ini_get('safe_mode')) set_time_limit(180);

		$rss	= RSSFunction::_ReadURL($rssurl);
		
		if (!preg_match("/<\?xml.*?encoding\s*=\s*[\"'](.*?)[\"'].*?\?>/is", $rss, $matches)) {
			if(preg_match("/<\?xml(\s).*?\?>/is", $rss, $matches)) {
				$rss = preg_replace("/<\?xml[\s](.*?)\?>/is", '<?xml $1 encoding="iso-8859-1"?>', $rss);
			}
		}

		if (!$rss) {
			return array();
		}else{
			$items	= RSSFunction::_ParseRSS($rssurl,$rss,'10');
	    }

		return $items;
	}
	
	/**
	 * Method to get feed
	 **/
	function getXMLFeed(&$rssurl)
	{
		if (!@ini_get('safe_mode')) set_time_limit(180);

		$rss	= RSSFunction::_ReadURL($rssurl);
		
		if (!preg_match("/<\?xml.*?encoding\s*=\s*[\"'](.*?)[\"'].*?\?>/is", $rss, $matches)) {
			if(preg_match("/<\?xml(\s).*?\?>/is", $rss, $matches)) {
				$rss = preg_replace("/<\?xml[\s](.*?)\?>/is", '<?xml $1 encoding="iso-8859-1"?>', $rss);
			}
		}

		if (!$rss) {
			return array();
		}else{
			$items	= RSSFunction::_ParseXML($rss);
	    }

		return $items;
	}
	
	/**
	 * Method to get retrieve feed
	 **/	
	function _ReadURL($uri) {
		if( !ini_get('safe_mode') ){
			set_time_limit(0);
		}
	    if ( function_exists('curl_init') ){
	        $handle = curl_init();

	        curl_setopt ($handle, CURLOPT_URL, $uri);
	        curl_setopt ($handle, CURLOPT_MAXREDIRS,5);

	        if (!@ini_get('safe_mode'))
				curl_setopt ($handle, CURLOPT_FOLLOWLOCATION ,1);
				
	        curl_setopt ($handle, CURLOPT_CONNECTTIMEOUT, 10);
	        curl_setopt ($handle, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt ($handle, CURLOPT_TIMEOUT, 100);
	        $buffer = curl_exec($handle);

	        curl_close($handle);
	        return $buffer;
			
	    } else  if ( ini_get('allow_url_fopen') ) {
		
	        $fp = @fopen( $uri, 'r' );
	        if ( !$fp )
	            return false;
	     	stream_set_timeout($fp, 20);
	        $linea = '';
	        while( $remote_read = fread($fp, 4096) )
	            $linea .= $remote_read;
	   		$info = stream_get_meta_data($fp);
	        fclose($fp);
	    	if ($info['timed_out'])
	    	   return false;
	        return $linea;
	    } else {
	       return false;
	    }
	}
	
	/**
	 * return an array of the feed
	 **/
	function _ParseRSS($rssurl,$rss,$nrfeeds){

	    require_once( JPATH_COMPONENT.DS.'libraries'.DS.'magpierss'.DS.'rss_fetch.inc');

	    if (!class_exists("MagpieRSS")) return;

		$resp = new MagpieRSS( $rss, 'ISO-8859-1',null, true );

	    // if RSS parsed unsuccessfully try again
	    if ( !$resp or $resp->ERROR) {
	        return RSSFunction::_ParseRSS($rssurl,$rss,$nrfeeds);
	    }
		
	    return $resp->items;
	}
	
	/**
	 * return an array of the feed
	 **/
	function _ParseXML($rss)
	{
		$parser = xml_parser_create();
	    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	    xml_parse_into_struct($parser, $rss, $vals, $index);
	    xml_parser_free($parser);

	    $items=array();
	    $ary=&$items;
	    foreach ($vals as $r) {
	        $t=$r['tag'];
	        if ($r['type']=='open') {
	            if (isset($ary[$t])) {
	                if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
	                $cv=&$ary[$t][count($ary[$t])-1];
	            } else $cv=&$ary[$t];
	            if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
	            $cv=array();
	            $cv['_p']=&$ary;
	            $ary=&$cv;

	        } elseif ($r['type']=='complete') {
	            if (isset($ary[$t])) { // same as open
	                if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());
	                $cv=&$ary[$t][count($ary[$t])-1];
	            } else $cv=&$ary[$t];
	            if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}
	            $cv=(isset($r['value']) ? $r['value'] : '');

	        } elseif ($r['type']=='close') {
	            $ary=&$ary['_p'];
	        }
	    }    
	    
	    RSSFunction::_delRecursion($items);
		return $items;
	}
	
	/**
	 * Remove recursion in result array
	 **/
	function _delRecursion(&$ary) {
	    foreach ($ary as $k=>$v) {
	        if ($k==='_p') unset($ary[$k]);
	        elseif (is_array($ary[$k])) RSSFunction::_delRecursion($ary[$k]);
	    }
	}
}