<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelAuthor extends JModel
{

	var $_author = null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();
		
		global $mainframe;

		$params				= & JComponentHelper::getParams('com_lyftenbloggie');
		$this->_adminLevel 	= $params->get('adminLevel', '0');
	
		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->_id	 = (int)$array[0];
	}
	
	/**
	 * Overridden get method to get properties from the author
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadAuthor()) {
			if(isset($this->_author->$property)) {
				return $this->_author->$property;
			}
		}
		return $default;
	}

	/**
	 * Method to get author data
	 **/
	function &getAuthor()
	{
		if ($this->_loadAuthor())
		{

		}
		else  $this->_initAuthor();

		return $this->_author;
	}

	/**
	 * Method to load author data
	 **/
	function _loadAuthor()
	{
		// Lets load the author if it doesn't already exist
		if (empty($this->_author))
		{
			$query = 'SELECT a.*, u.name'
					. ' FROM #__bloggies_authors as a'
					. ' LEFT JOIN #__users AS u ON u.id = a.user_id'	
					. ' WHERE a.user_id = '.$this->_id
					;
			$this->_db->setQuery($query);
			$this->_author = $this->_db->loadObject();

			return (boolean) $this->_author;
		}
		return true;
	}
	
	/**
	 * Method to get a list of Joomla Users
	 **/
	function getUsers()
	{
		$query = 'SELECT u.name, u.id'
				. ' FROM #__users as u'
				. ' LEFT OUTER JOIN #__bloggies_authors AS a ON a.user_id = u.id'
				;
		$this->_db->setQuery($query);
	
		$users[] 	= JHTML::_('select.option', '0', ' - '.JText::_('SELECT USER').' - ', 'id', 'name');
		$users 		= array_merge($users, $this->_db->loadObjectList());
		$users 		= JHTML::_('select.genericlist',  $users, 'user_id', 'class="inputbox" size="1"', 'id', 'name', $this->_author->id);	

		return $users;
	}

	/**
	 * Method to initialise the author data
	 **/
	function _initAuthor()
	{
		// Lets load the author if it doesn't already exist
		if (empty($this->_author))
		{
			$query = 'SELECT u.id, u.name, u.gid'
					. ' FROM #__users as u'	
					. ' WHERE u.id = '.$this->_id
					;
			$this->_db->setQuery($query);
			$user = $this->_db->loadObject();

			$author = new stdClass();
			$author->id					= 0;
			$author->user_id			= (isset($user->id)) ? $user->id : 0;
			$author->name				= (isset($user->name)) ? $user->name : null;
			$author->admin				= (isset($user->gid) && $this->_adminLevel == $user->gid) ? 1 : 0;
			$author->about				= null;
			$author->permissions		= null;
			$author->avatar				= null;
			$author->attribs			= null;
			$author->published			= 1;
			$this->_author				= $author;
			return (boolean) $this->_author;
		}
		return true;
	}

	/**
	 * Method to store the author
	 **/
	function store($data)
	{
		$author  =& $this->getTable('authors', 'Table');

		// bind it to the table
		if (!$author->bind($data)) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}

		if (isset( $_FILES['avatar']) && !$_FILES['avatar']['error'] && isset($data['user_id']) )
		{
			//Get the blog author helper
			require_once( JPATH_COMPONENT.DS.'helper.php' );
			$author->avatar = BlogAuthor::createAvatar($_FILES['avatar']['tmp_name'], $data['user_id']."_avatar.jpg", '', $_FILES['avatar']['name']);
		}

		// Get permisson variables from the request
		$permissions	= JRequest::getVar( 'permission', null, 'post', 'array' );		
		
		// Build parameter INI string
		if (is_array($permissions))
		{
			$txt = array ();
			foreach ($permissions as $k => $v) {
				$txt[] = "$k=$v";
			}
			$author->permissions = implode("\n", $txt);
			unset($txt);
		}

		// Get parameter variables from the request
		$attribs			= JRequest::getVar( 'params', null, 'post', 'array' );		
	
		// Build parameter INI string
		if (is_array($attribs))
		{
			$txt = array ();
			foreach ($attribs as $k => $v) {
				$txt[] = "$k=$v";
			}
			$author->attribs = implode("\n", $txt);
			unset($txt);
		}

		// Make sure the data is valid
		if (!$author->check()) {
			$this->setError($author->getError());
			return false;
		}

		// Store it in the db
		if (!$author->store()) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}
		
		$this->_author	=& $author;
		
		return true;
	}
}
?>