<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelAuthors extends JModel
{
	var $_data 			= array();
	var $_total 		= 0;
	var $_pagination 	= null;
	var $_id 			= null;
	var $_authorLevel 	= null;
	var $_adminLevel 	= null;
	var $_filter_type 	= null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();

		global $mainframe, $option;

		$params			= & JComponentHelper::getParams('com_lyftenbloggie');
		$limit			= $mainframe->getUserStateFromRequest( $option.'.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart 	= $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );

		$this->setState('limit', 		$limit);
		$this->setState('limitstart', 	$limitstart);
		
		
		$this->_authorLevel = $params->get('authorLevel', '0');
		$this->_adminLevel 	= $params->get('adminLevel', '0');
		$this->_filter_type = $mainframe->getUserStateFromRequest( $option.'.authors.filter_type', 'filter_type', '', 'string' );
			
		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->_id	 = (int)$array[0];
	}

	/**
	 * Method to set the Tag identifier
	 **/
	function setId($id)
	{
		// Set id and wipe data
		$this->_id	 = $id;
		$this->_data = array();
	}

	/**
	 * Method to get authors data
	 **/
	function getData()
	{
		global $mainframe, $option;

		// Lets load the authors if it doesn't already exist
		if (empty($this->_data))
		{
			$query = $this->_buildQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}


		return $this->_data;
	}

	/**
	 * Method to get the total nr of the authors
	 **/
	function getTotal()
	{
		// Lets load the authors if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}

	/**
	 * Method to get a pagination object for the authors
	 **/
	function getPagination()
	{
		// Lets load the authors if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	/**
	 * Method to build the query for the authors
	 **/
	function _buildQuery()
	{
		// Get the WHERE and ORDER BY clauses for the query
		$where		= $this->_buildContentWhere();
		$orderby	= $this->_buildContentOrderBy();

		$query = 'SELECT u.*, COUNT(p.created_by) AS npost, a.published, a.user_id, a.permissions'
					. ' FROM #__users AS u'
					. ' LEFT JOIN #__bloggies_entries AS p ON p.created_by = u.id'		
					. ' LEFT JOIN #__bloggies_authors AS a ON a.user_id = u.id'		
					. $where
					. ' GROUP BY u.id'
					. $orderby
					;
		return $query;
	}

	/**
	 * Method to build the orderby clause of the query for the authors
	 **/
	function _buildContentOrderBy()
	{
		global $mainframe, $option;

		$filter_order		= $mainframe->getUserStateFromRequest( $option.'.authors.filter_order', 		'filter_order', 	'u.name', 'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $option.'.authors.filter_order_Dir',	'filter_order_Dir',	'', 'word' );

		$orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir;

		return $orderby;
	}

	/**
	 * Method to build the where clause of the query for the authors
	 **/
	function _buildContentWhere()
	{
		global $mainframe, $option;
		
		$search 			= $mainframe->getUserStateFromRequest( $option.'.authors.search', 'search', '', 'string' );
		$search 			= $this->_db->getEscaped( trim(JString::strtolower( $search ) ) );

		$where = array();
		if ( $this->_filter_type ) {
			if ( $this->_filter_type == 1 ) {
				$where[] = 'u.gid = \''.$this->_authorLevel.'\' OR a.admin = 0';
			}elseIf ($this->_filter_type == 2 ) {
				$where[] = 'u.gid = \''.$this->_adminLevel.'\' OR a.admin = 1';
			}
		}elseIf( $this->_authorLevel ){
			$where[] = 'u.gid = \''.$this->_authorLevel.'\' OR u.gid = \''.$this->_adminLevel.'\' OR a.admin = 0 OR a.admin = 1';
		}

		if ($search) {
			$where[] = 'LOWER(u.name) LIKE '.$this->_db->Quote( '%'.$this->_db->getEscaped( $search, true ).'%', false );
		}

		$where 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );

		return $where;
	}
	
	/**
	 * Method to (un)publish
	 **/
	function publish($cid = array(), $publish = 1)
	{
		$user 	=& JFactory::getUser();

		if (count( $cid ))
		{
			$cids = implode( ',', $cid );

			$query = 'UPDATE #__bloggies_authors'
				. ' SET published = ' . (int) $publish
				. ' WHERE user_id IN ('. $cids .')'
			;
			$this->_db->setQuery( $query );
			if (!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}
		return true;
	}

	/**
	 * Method to remove
	 **/
	function reset($cid = array())
	{
		$result = false;

		if (count( $cid ))
		{
			$cids = implode( ',', $cid );
			$query = 'DELETE FROM #__bloggies_authors'
					. ' WHERE user_id IN ('. $cids .')'
					;

			$this->_db->setQuery( $query );

			if(!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}

		return true;
	}
}
?>