<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelBookmark extends JModel
{

	var $_bookmark = null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();

		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}

	/**
	 * Method to set the identifier
	 **/
	function setId($id)
	{
		// Set bookmark id and wipe data
		$this->_id	    	= $id;
		$this->_bookmark	= null;
	}
	
	/**
	 * Overridden get method to get properties from the bookmark
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadBookmark()) {
			if(isset($this->_bookmark->$property)) {
				return $this->_bookmark->$property;
			}
		}
		return $default;
	}

	/**
	 * Method to get bookmark data
	 **/
	function &getBookmark()
	{
		if ($this->_loadBookmark())
		{

		}
		else  $this->_initBookmark();

		return $this->_bookmark;
	}

	/**
	 * Method to load bookmark data
	 **/
	function _loadBookmark()
	{
		// Lets load the bookmark if it doesn't already exist
		if (empty($this->_bookmark))
		{
			$query = 'SELECT *'
					. ' FROM #__bloggies_bookmarks'
					. ' WHERE id = '.$this->_id
					;
			$this->_db->setQuery($query);
			$this->_bookmark = $this->_db->loadObject();

			return (boolean) $this->_bookmark;
		}
		return true;
	}

	/**
	 * Method to initialise the bookmark data
	 **/
	function _initBookmark()
	{
		// Lets load the bookmark if it doesn't already exist
		if (empty($this->_bookmark))
		{
			$bookmark = new stdClass();
			$bookmark->id					= 0;
			$bookmark->website				= null;
			$bookmark->html					= null;
			$bookmark->type					= null;
			$bookmark->published			= 1;
			$this->_bookmark				= $bookmark;
			return (boolean) $this->_bookmark;
		}
		return true;
	}

	/**
	 * Method to store the bookmark
	 **/
	function store($data)
	{
		$bookmark  =& $this->getTable('Bookmarks', 'Table');

		// bind it to the table
		if (!$bookmark->bind($data)) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}

		if (!$bookmark->id) {
			$bookmark->ordering = $bookmark->getNextOrder();
		}
		
		// Make sure the data is valid
		if (!$bookmark->check()) {
			$this->setError($bookmark->getError());
			return false;
		}

		// Store it in the db
		if (!$bookmark->store()) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}
		
		$this->_bookmark	=& $bookmark;
		
		return true;
	}
}
?>