<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelComment extends JModel
{

	var $_comment = null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();
		
		global $mainframe, $option;

		$limit		= $mainframe->getUserStateFromRequest( $option.'.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart = $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}

	/**
	 * Method to set the identifier
	 **/
	function setId($id)
	{
		// Set comment id and wipe data
		$this->_id	    	= $id;
		$this->_comment	= null;
	}
	
	/**
	 * Overridden get method to get properties from the comment
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadComment()) {
			if(isset($this->_comment->$property)) {
				return $this->_comment->$property;
			}
		}
		return $default;
	}

	/**
	 * Method to get comment data
	 **/
	function &getComment()
	{
		if ($this->_loadComment())
		{

		}
		else  $this->_initComment();

		return $this->_comment;
	}

	/**
	 * Method to load comment data
	 **/
	function _loadComment()
	{
		// Lets load the comment if it doesn't already exist
		if (empty($this->_comment))
		{
			$query = 'SELECT c.*, COUNT(r.comment_id) AS reports, u.name AS commenter, e.title AS entryname'
					. ' FROM #__bloggies_comments AS c'
					. ' LEFT JOIN #__bloggies_entries AS e ON e.id = c.entry_id'
					. ' LEFT JOIN #__bloggies_reports AS r ON r.comment_id = c.id'					
					. ' LEFT JOIN #__users AS u ON u.id = c.user_id'					
					. ' WHERE c.id = '.$this->_id
					. ' GROUP BY r.date'
					;
			$this->_db->setQuery($query);
			$this->_comment = $this->_db->loadObject();

			return (boolean) $this->_comment;
		}
		return true;
	}

	/**
	 * Method to initialise the comment data
	 **/
	function _initComment()
	{
		// Lets load the comment if it doesn't already exist
		if (empty($this->_comment))
		{
			return false;
		}
		return true;
	}

	/**
	 * Method to store the comment
	 **/
	function store($data)
	{
		$comment  =& $this->getTable('comments', 'Table');

		// bind it to the table
		if (!$comment->bind($data)) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}

		$comment->author_url 	= $this->_db->getEscaped($comment->author_url, true );
		
		if (!$comment->id) {
			$comment->ordering = $comment->getNextOrder();
		}
		
		// Make sure the data is valid
		if (!$comment->check()) {
			$this->setError($comment->getError());
			return false;
		}

		// Store it in the db
		if (!$comment->store()) {
			$this->setError(500, $this->_db->getErrorMsg() );
			return false;
		}
		
		$this->_comment	=& $comment;
		
		return true;
	}
	
	/**
	 * Method to get comments data
	 **/
	function getReports()
	{
		// Lets load the comments if it doesn't already exist
		if (empty($this->_data))
		{
			$query = $this->_buildQuery();
			$reports = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}

		return $reports;
	}

	/**
	 * Method to get the total nr of the comments
	 **/
	function getTotal()
	{
		// Lets load the comments if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}

	/**
	 * Method to get a pagination object for the comments
	 **/
	function getPagination()
	{
		// Lets load the comments if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $pagination;
	}

	/**
	 * Method to build the query for the comments
	 **/
	function _buildQuery()
	{
		$query = 'SELECT r.*, u.name AS reporter'
					. ' FROM #__bloggies_reports AS r'
					. ' LEFT JOIN #__users AS u ON u.id = r.user_id'				
					. ' WHERE comment_id = '.$this->_comment->id
					. ' ORDER BY r.date'
					;
		return $query;
	}
	
	/**
	 * Method to remove a report
	 **/
	function delreport($cid = array())
	{
		if (count( $cid ))
		{
			$cids = implode( ',', $cid );
			$query = 'DELETE FROM #__bloggies_reports'
					. ' WHERE id IN ('. $cids .')'
					;

			$this->_db->setQuery( $query );

			if(!$this->_db->query()) {
				return $this->_db->getErrorMsg();
			}
		}

		return JText::_('Report_Deleted');
	}
}
?>