<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.model' );

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelConfig extends JModel
{
	var $_params;
	/**
	 * Constructor
	 */
	function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * Method to store the entry
	 **/
	function store($data)
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
				
		$table =& JTable::getInstance('component');
		if (!$table->loadByOption( 'com_lyftenbloggie' ))
		{
			JError::raiseWarning( 500, 'Not a valid component' );
			return false;
		}
		
		// Get PostingControl and add it to the parameter variables in the request
		$PostingControl		= JRequest::getVar( 'PostingControl', null, 'post', 'array' );		

		if (is_array($PostingControl))
		{
			$data['params']['PostingControl'] = implode(",", $PostingControl);
		}
		
		// Get PublishControl and add it to the parameter variables in the request
		$PublishControl		= JRequest::getVar( 'PublishControl', null, 'post', 'array' );		
		if (is_array($PublishControl))
		{
			$data['params']['PublishControl'] = implode(",", $PublishControl);
		}
		
		$table->bind( $data );

		// pre-save checks
		if (!$table->check()) {
			JError::raiseWarning( 500, $table->getError() );
			return false;
		}

		// save the changes
		if (!$table->store()) {
			JError::raiseWarning( 500, $table->getError() );
			return false;
		}
		
		return true;
	}
}