<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelEntry extends JModel
{

	var $_entry	 		= null;
	var $_id 			= null;
	var $_sections 		= null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();

		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		JArrayHelper::toInteger($cid, array(0));
		$this->setId($cid[0]);
	}

	/**
	 * Method to set the identifier
	 **/
	function setId($id)
	{
		// Set entry id and wipe data
		$this->_id	    = $id;
		$this->_entry	= null;
	}
	
	/**
	 * Overridden get method to get properties from the entry
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadEntry()) {
			if(isset($this->_entry->$property)) {
				return $this->_entry->$property;
			}
		}
		return $default;
	}

	/**
	 * Method to get entry data
	 **/
	function &getEntry()
	{		
		if ($this->_loadEntry())
		{		
			$query = 'SELECT name'
					. ' FROM #__users'
					. ' WHERE id = '. (int) $this->_entry->created_by
					;
			$this->_db->setQuery($query);
			$this->_entry->creator = $this->_db->loadResult();

			//reduce unneeded query
			if ($this->_entry->created_by == $this->_entry->modified_by) {
				$this->_entry->modifier = $this->_entry->creator;
			} else {
				$query = 'SELECT name'
						. ' FROM #__users'
						. ' WHERE id = '. (int) $this->_entry->modified_by
						;
				$this->_db->setQuery($query);
				$this->_entry->modifier = $this->_db->loadResult();
			}
			
		}
		else  $this->_initEntry();

		return $this->_entry;
	}

	/**
	 * Method to get hits
	 **/
	function gethits($id)
	{
		$query = 'SELECT hits FROM #__bloggies_entries WHERE blog_id = '.(int)$id;
		$this->_db->setQuery($query);
		$hits = $this->_db->loadResult();
		
		return $hits;
	}
	
	/**
	 * Method to load entry data
	 **/
	function _loadEntry()
	{
		// Lets load the entry if it doesn't already exist
		if (empty($this->_entry))
		{
			$query = 'SELECT *'
					. ' FROM #__bloggies_entries'
					. ' WHERE id = '.$this->_id
					;
			$this->_db->setQuery($query);
			$this->_entry = $this->_db->loadObject();
			
			return (boolean) $this->_entry;
		}
		return true;
	}

	/**
	 * Method to initialise the entry data
	 **/
	function _initEntry()
	{
		// Lets load the entry if it doesn't already exist
		if (empty($this->_entry))
		{
			$createdate = & JFactory::getDate();
			$nullDate	= $this->_db->getNullDate();
			
			$entry = new stdClass();

			$this->_entry					= & JTable::getInstance('entries', 'Table');
			$this->_entry->version 			= 0;
			$this->_entry->state 			= 1;
			$this->_entry->ordering 		= 0;
			$this->_entry->hits		 		= 0;
			$this->_entry->publish_up 		= $createdate->toUnix();
			$this->_entry->publish_down 	= JText::_('NEVER');
			$this->_entry->created 			= $createdate->toUnix();
			$this->_entry->modified 		= $nullDate;
			return (boolean) $this->_entry;
		}
		return true;
	}

	/**
	 * Method to checkin/unlock the entry
	 **/
	function checkin()
	{
		if ($this->_id)
		{
			$entry = & JTable::getInstance('entries', 'Table');
			return $entry->checkin($this->_id);
		}
		return false;
	}

	/**
	 * Method to checkout/lock the entry
	 **/
	function checkout($uid = null)
	{
		if ($this->_id)
		{
			// Make sure we have a user id to checkout the group with
			if (is_null($uid)) {
				$user	=& JFactory::getUser();
				$uid	= $user->get('id');
			}
			// Lets get to it and checkout the thing...
			$entry = & JTable::getInstance('entries', 'Table');
			return $entry->checkout($uid, $this->_id);
		}
		return false;
	}

	/**
	 * Tests if the entry is checked out
	 **/
	function isCheckedOut( $uid=0 )
	{
		if ($this->_loadEntry())
		{
			if ($uid) {
				return ($this->_entry->checked_out && $this->_entry->checked_out != $uid);
			} else {
				return $this->_entry->checked_out;
			}
		} elseif ($this->_id < 1) {
			return false;
		} else {
			JError::raiseWarning( 0, 'UNABLE LOAD DATA');
			return false;
		}
	}

	/**
	 * Method to store the entry
	 **/
	function store($data)
	{
		global $mainframe;
		
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
				
		$row 		= & JTable::getInstance('entries', 'Table');
		$user		=& JFactory::getUser();
		$details	= JRequest::getVar( 'details', array(), 'post', 'array');
		$nullDate	= $this->_db->getNullDate();
		$cparams 	= & JComponentHelper::getParams('com_lyftenbloggie');
		
		// bind it to the table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// sanitise fields
		$row->id 			= (int) $row->id;

		// Are we saving from an item edit?
		if ($row->id) {
			$datenow =& JFactory::getDate();
			$row->modified 		= $datenow->toMySQL();
			$row->modified_by 	= $user->get('id');
		}

		$row->created_by 	= $row->created_by ? $row->created_by : $user->get('id');

		if ($row->created && strlen(trim( $row->created )) <= 10) {
			$row->created 	.= ' 00:00:00';
		}

		$config =& JFactory::getConfig();
		$tzoffset = $config->getValue('config.offset');
		$date =& JFactory::getDate($row->created, $tzoffset);
		$row->created = $date->toMySQL();

		// Get a state and parameter variables from the request
		$row->state	= JRequest::getVar( 'state', 0, '', 'int' );
		$params		= JRequest::getVar( 'params', null, 'post', 'array' );		
		
		// Build parameter INI string
		if (is_array($params))
		{
			$txt = array ();
			foreach ($params as $k => $v) {
				$txt[] = "$k=$v";
			}
			$row->attribs = implode("\n", $txt);
		}

		// Get metadata string
		$metadata = JRequest::getVar( 'meta', null, 'post', 'array');
		if (is_array($metadata))
		{
			$txt = array();
			foreach ($metadata as $k => $v) {
				if ($k == 'description') {
					$row->metadesc = $v;
				} elseif ($k == 'keywords') {
					$row->metakey = $v;
				} else {
					$txt[] = "$k=$v";
				}
			}
			$row->metadata = implode("\n", $txt);
		}

		// Add new Tags
		$tags 		= JRequest::getVar( 'tagname');
		$newTags 	= explode(",", $tags);
		$newTagIDs	= array();
		unset($tags);

		foreach($newTags as $tag)
		{
			$query = 'SELECT t.id FROM #__bloggies_tags AS t WHERE t.name = \''.$tag.'\'';
			$this->_db->setQuery($query);
			if(!$this->_db->loadResult())
			{
				echo 'not found';
				$tagTbl  			=& $this->getTable('tags', 'Table');
				$tagData			= array();
				$tagData['name'] 	= $tag;
				$tagData['slug'] 	= JFilterOutput::stringURLSafe($tag);
				
				// bind it to the table
				if (!$tagTbl->bind($tagData)) {
					$this->setError( $this->_db->getErrorMsg() );
					return false;
				}
				// Store it in the db
				if (!$tagTbl->store()) {
					$this->setError( $this->_db->getErrorMsg() );
					return false;
				}
				$newTagIDs[] = $this->_db->insertId();
			}
		}

		// Get a Tag variables from the request
		$tags 		= JRequest::getVar( 'tag', array(), 'post', 'array');
		
		if(!empty($newTagIDs))
			$tags 	= array_merge($tags, $newTagIDs);
			
		$query = 'DELETE FROM #__bloggies_relations WHERE entry = '.$row->id;
		$this->_db->setQuery($query);
		$this->_db->query();

		foreach($tags as $tag)
		{
			$query = 'INSERT INTO #__bloggies_relations (`entry`, `tag`) VALUES('.$row->id.', '.$tag.')';
			$this->_db->setQuery($query);
			$this->_db->query();
		}
		
		// Prepare the entry for saving to the database
		require_once( JPATH_COMPONENT.DS.'helper.php' );
		EntryHelper::saveEntryPrep( $row );

		// Make sure the data is valid
		if (!$row->check()) {
			JError::raiseError( 500, $this->_db->stderr() );
			return false;
		}

		// Increment the entry version number
		$row->version++;
		
		// Get trackback string
		$trackbacks = $data['trackbacks'];

		if ($trackbacks and $trackbacks != "") {
		
			include_once JPATH_COMPONENT_SITE.DS.'helpers'.DS.'ping.php';

			// Bind the trackback link
			$slug 			= $row->id.':'.$row->alias;
			$archive 		= JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d');
			$row->pinged = BlogPing::doTrackback($trackbacks, $row, $archive, $slug);

		}

		// Ping Update services
		if ($cparams->get('useUpdateServices')) {
		
			include_once JPATH_COMPONENT_SITE.DS.'helpers'.DS.'ping.php';
			$services	= $cparams->get('updateServices');
			BlogPing::pingUpdate($services);
		}

		//Add details to entry
		$row->bind($details);

		// Store the entry to the database
		if (!$row->store()) {
			JError::raiseError( 500, $this->_db->stderr() );
			return false;
		}
		
		// Check the article and update item order
		$row->checkin();
		
		$this->_entry	=& $row;
		
		return true;
	}

	/**
	 * Method to reset hits
	 **/
	function resetHits($id)
	{
		$row  =& $this->getTable('entries', 'Table');
		$row->load($id);
		$row->hits = 0;
		$row->store();
		$row->checkin();
		return $row->id;
	}
	
	/**
	 * Method to get all Categories
	 **/
	function getCategories()
	{
		if(!$this->_entry->catid)
		{
			$query = 'SELECT id' .
					' FROM #__bloggies_categories' .
					' WHERE `default` = 1';
			$this->_db->setQuery($query);
			$this->_entry->catid = $this->_db->loadResult();
		}

		$query = 'SELECT id, title' .
				' FROM #__bloggies_categories' .
				' ORDER BY ordering';
		$this->_db->setQuery($query);

		$category[] 	= JHTML::_('select.option', '-1', ' - '.JText::_('SELECT CATEGORY').' - ', 'id', 'title');
		$category[] 	= JHTML::_('select.option', '0', JText::_('UNCATEGORISED'), 'id', 'title');
		$categories 	= array_merge($category, $this->_db->loadObjectList());
		$categories 	= JHTML::_('select.genericlist',  $categories, 'catid', 'class="inputbox" size="1"', 'id', 'title', intval($this->_entry->catid));	
		
		return $categories;
	}

	/**
	 * Method to get all Sections and Categories
	 **/	
	function getTagsList(){

		$alltags 	= $this->gettags();
		$used 		= $this->getusedtags($this->_entry->id);

		if(!is_array($used)){
			$used = array();
		}

		$tags = '';
		$n = count($alltags);
		for( $i = 0, $n; $i < $n; $i++ ){
			$tag = $alltags[$i];
			$tags .=  '<li><label><input id="tag[]" name="tag[]" type="checkbox" value="'.$tag->id.'"' . (in_array($tag->id, $used) ? 'checked="checked"' : '') . ' />'.$tag->name.'</label></li>';
		}

		return $tags;
	}
	
	/**
	 * Method to get all Sections and Categories
	 **/	
	function getTags(){
		$query = 'SELECT *'
				.' FROM #__bloggies_tags';
		$this->_db->setQuery($query);
		$tags = $this->_db->loadObjectList();
		return $tags;
	}
	
	/**
	 * Method to get all Sections and Categories
	 **/	
	function getUsedTags($id){
		
		$used = '';
		$query = 'SELECT DISTINCT tag'
				.' FROM #__bloggies_relations'
				.' WHERE entry='.$id;
		$this->_db->setQuery($query);
		$used = $this->_db->loadResultArray();
		return $used;
	}
}
?>