<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.model' );

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelSettings extends JModel
{
	var $_params;
	/**
	 * Constructor
	 */
	function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * Method to store the entry
	 **/
	function store($data)
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
				
		$table =& JTable::getInstance('component');
		if (!$table->loadByOption( 'com_lyftenbloggie' ))
		{
			JError::raiseWarning( 500, 'Not a valid component' );
			return false;
		}
		
		// Get PostingControl and add it to the parameter variables in the request
		$PostingControl		= JRequest::getVar( 'PostingControl', null, 'post', 'array' );		

		if (is_array($PostingControl))
		{
			$data['params']['PostingControl'] = implode(",", $PostingControl);
		}
		
		// Get PublishControl and add it to the parameter variables in the request
		$PublishControl		= JRequest::getVar( 'PublishControl', null, 'post', 'array' );		
		if (is_array($PublishControl))
		{
			$data['params']['PublishControl'] = implode(",", $PublishControl);
		}
		
		$table->bind( $data );

		// pre-save checks
		if (!$table->check()) {
			JError::raiseWarning( 500, $table->getError() );
			return false;
		}

		// save the changes
		if (!$table->store()) {
			JError::raiseWarning( 500, $table->getError() );
			return false;
		}
		
		return true;
	}
	
	/**
	 * Method to perform needed maintenance
	 **/
	function databaseOptimise()
	{
		global $mainframe;

		$msg = JText::_('DATABASE OPTIMISED');
				
		$this->_db->setQuery("SHOW TABLES FROM `" . $mainframe->getCfg('db') . "`" );
		$tables = $this->_db->loadResultArray();

		if(is_array($tables)) {
			$this->_db->setQuery("OPTIMIZE TABLE `" . implode("` , `",$tables) . "`;" );
			if (!$this->_db->query()) {
				$msg = $this->_db->getErrorMsg();
				$this->setError($this->_db->getErrorMsg());
			}
		}else{
			$msg = JText::_('UNABLE TO FIND TABLE TO OPTIMISED');
		}
	
		return $msg;
	}
	
	/**
	* Build the select list for access level
	**/
	function getAccesslevels()
	{
		$db =& JFactory::getDBO();
		
		$query = "SELECT g.id AS value, g.name AS text"
		. " FROM #__core_acl_aro_groups AS g"
		. " WHERE LOWER(g.name) NOT IN ('public backend','public frontend','users','root')"
		;
		$db->setQuery( $query );
		if(!$groups = $db->loadObjectList())
		{
			$query = 'SELECT id AS value, name AS text'
			. ' FROM #__groups'
			. ' WHERE LOWER(name) <> \'public\''
			. ' ORDER BY id'
			;
			$db->setQuery( $query );
			$groups = $db->loadObjectList();
		}

		$authors[] = JHTML::_('select.option', '0', JText::_( 'ASSIGNED' ) );
		$access = array_merge( $authors, $groups );

		return $access;
	}
}