<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieModelTag extends JModel
{

	var $_tag = null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();

		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}

	/**
	 * Method to set the identifier
	 **/
	function setId($id)
	{
		// Set tag id and wipe data
		$this->_id	    = $id;
		$this->_tag	= null;
	}
	
	/**
	 * Overridden get method to get properties from the tag
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadTag()) {
			if(isset($this->_tag->$property)) {
				return $this->_tag->$property;
			}
		}
		return $default;
	}

	/**
	 * Method to get tag data
	 **/
	function &getTag()
	{
		if ($this->_loadTag())
		{

		}
		else  $this->_initTag();

		return $this->_tag;
	}


	/**
	 * Method to load tag data
	 **/
	function _loadTag()
	{
		// Lets load the tag if it doesn't already exist
		if (empty($this->_tag))
		{
			$query = 'SELECT *'
					. ' FROM #__bloggies_tags'
					. ' WHERE id = '.$this->_id
					;
			$this->_db->setQuery($query);
			$this->_tag = $this->_db->loadObject();

			return (boolean) $this->_tag;
		}
		return true;
	}

	/**
	 * Method to initialise the tag data
	 **/
	function _initTag()
	{
		// Lets load the tag if it doesn't already exist
		if (empty($this->_tag))
		{
			$tag = new stdClass();
			$tag->id					= 0;
			$tag->name					= null;
			$tag->slug					= null;
			$this->_tag				= $tag;
			return (boolean) $this->_tag;
		}
		return true;
	}

	/**
	 * Method to store the tag
	 **/
	function store($data)
	{
		$tag  =& $this->getTable('tags', 'Table');

		// bind it to the table
		if (!$tag->bind($data)) {
			$this->setError( $this->_db->getErrorMsg() );
			return false;
		}
		// Make sure the data is valid
		if (!$tag->check()) {
			$this->setError($tag->getError() );
			return false;
		}

		// Store it in the db
		if (!$tag->store()) {
			$this->setError( $this->_db->getErrorMsg() );
			return false;
		}
		
		$this->_tag	=& $tag;

		return true;
	}
}
?>