<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class TableCategories extends JTable
{
	var $id 				= null;
	var $title 				= '';
	var $default 			= 0;
	var $slug	 			= '';
	var $text	 			= '';
	var $published			= null;
	var $checked_out 		= 0;
	var $checked_out_time	= '';
	var $ordering 			= null;

	function __construct(& $db) {
		parent::__construct('#__bloggies_categories', 'id', $db);
	}
	
	// overloaded check function
	function check()
	{
		// Not typed in a category name?
		if (trim( $this->title ) == '') {
			$this->_error = JText::_( 'ADD CATEGORY NAME' );
			JError::raiseWarning('SOME_ERROR_CODE', $this->_error );
			return false;
		}

		$slug = JFilterOutput::stringURLSafe($this->title);

		if(empty($this->slug) || $this->slug === $slug ) {
			$this->slug = $slug;
		}

		/** check for existing name with same parent category*/
		$query = 'SELECT id'
				.' FROM #__bloggies_categories'
				.' WHERE title = '.$this->_db->Quote($this->title)
				;
		$this->_db->setQuery($query);

		$xid = intval($this->_db->loadResult());
		if ($xid && $xid != intval($this->id)) {
			JError::raiseWarning('SOME_ERROR_CODE', JText::sprintf('CATEGORY NAME ALREADY EXIST', $this->title));
			return false;
		}

		return true;
	}
}
?>