<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class LyftenBloggieViewAuthor extends JView {

	function display($tpl = null)
	{
		global $mainframe;

		//Load behaviors
		jimport('joomla.html.pane');
		JHTML::_('behavior.modal', 'a.modal');

		//initialise variables
		$document	= & JFactory::getDocument();
		$user 		= & JFactory::getUser();
		$tabs 		= & JPane::getInstance('tabs');

		//get vars
		$cid 		= JRequest::getVar( 'cid' );

		//add css to document
		$document->addStyleSheet('components/com_lyftenbloggie/assets/css/style.css');
		$document->addScript('components/com_lyftenbloggie/assets/js/help.js');	

		//create the toolbar
		if ( $cid ) {
			JToolBarHelper::title( JText::_( 'EDIT AUTHOR' ), 'lbauthor' );

		} else {
			JToolBarHelper::title( JText::_( 'NEW AUTHOR' ), 'lbauthor' );
		}
		JToolBarHelper::save();
		JToolBarHelper::apply();
		JToolBarHelper::divider();
		JToolBarHelper::cancel();
		JToolBarHelper::spacer();

		//Get data from the model
		$model		= & $this->getModel();
		$row     	= & $this->get( 'Author' );
		$users     	= (!$row->id)?$this->get( 'Users' ):'';

		//clean data
		JFilterOutput::objectHTMLSafe( $row, ENT_QUOTES, 'about' );
		
		//Get Params
		$permissions 	= new JParameter( $row->permissions );
		$params 		= new JParameter( $row->attribs );

		JHTML::_('behavior.tooltip');

		//assign vars to view
		$this->assignRef('permissions'  , $permissions);
		$this->assignRef('params'      	, $params);
		$this->assignRef('users'      	, $users);
		$this->assignRef('row'      	, $row);
		$this->assignRef('tabs'			, $tabs);

		parent::display($tpl);
	}
}
?>