<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieViewAuthors extends JView {

	function display($tpl = null)
	{
		global $mainframe, $option;

		//initialise variables
		$db  			= & JFactory::getDBO();
		$document		= & JFactory::getDocument();
		$params			= & JComponentHelper::getParams('com_lyftenbloggie');
	
		JHTML::_('behavior.tooltip');

		//get vars
		$filter_order		= $mainframe->getUserStateFromRequest( $option.'.authors.filter_order', 	'filter_order', 	'u.name', 	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $option.'.authors.filter_order_Dir',	'filter_order_Dir',	'', 		'word' );
		$filter_type 		= $mainframe->getUserStateFromRequest( $option.'.authors.filter_type', 		'filter_type', 		'', 		'string' );
		$search 			= $mainframe->getUserStateFromRequest( $option.'.authors.search', 			'search', 			'', 		'string' );
		$search 			= $db->getEscaped( trim(JString::strtolower( $search ) ) );

		//add css and submenu to document
		$document->addStyleSheet('components/com_lyftenbloggie/assets/css/style.css');

		//create the toolbar
		JToolBarHelper::title( JText::_( 'AUTHORS' ), 'lbauthors' );
		JToolBarHelper::addNew();
		JToolBarHelper::divider();
		JToolBarHelper::publishList();
		JToolBarHelper::unpublishList();
		JToolBarHelper::divider();
		JToolBarHelper::deleteList('', 'reset', JText::_('RESET SETTINGS'));
		JToolBarHelper::spacer();

		//Get data from the model
		$rows      	= & $this->get( 'Data');
		$pageNav 	= & $this->get( 'Pagination' );

		$lists['adminLevel'] 	= $params->get('adminLevel', '0');

		//publish type filter
		$types[] = JHTML::_('select.option',  0, '- '. JText::_( 'SELECT TYPE' ) .' -');
		$types[] = JHTML::_('select.option',  1, JText::_( 'AUTHORS' ) );
		$types[] = JHTML::_('select.option',  2, JText::_( 'ADMINS' ) );
		$lists['type'] = JHTML::_('select.genericlist',   $types, 'filter_type', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', "$filter_type" );

		// search filter
		$lists['search']= $search;

		// table ordering
		$lists['order_Dir'] = $filter_order_Dir;
		$lists['order'] = $filter_order;

		$ordering = ($lists['order'] == 'a.name');

		//assign data to template
		$this->assignRef('lists'      	, $lists);
		$this->assignRef('rows'      	, $rows);
		$this->assignRef('pageNav' 		, $pageNav);
		$this->assignRef('ordering'		, $ordering);
		$this->assignRef('user'			, $user);

		parent::display($tpl);
	}
}
?>